<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_dyeing_list = new stock_dyeing_list();

// Run the page
$stock_dyeing_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_dyeing_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_dyeing->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_dyeinglist = currentForm = new ew.Form("fstock_dyeinglist", "list");
fstock_dyeinglist.formKeyCountName = '<?php echo $stock_dyeing_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_dyeinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_dyeinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_dyeinglist.lists["x_product"] = <?php echo $stock_dyeing_list->product->Lookup->toClientList() ?>;
fstock_dyeinglist.lists["x_product"].options = <?php echo JsonEncode($stock_dyeing_list->product->lookupOptions()) ?>;
fstock_dyeinglist.lists["x_godown"] = <?php echo $stock_dyeing_list->godown->Lookup->toClientList() ?>;
fstock_dyeinglist.lists["x_godown"].options = <?php echo JsonEncode($stock_dyeing_list->godown->lookupOptions()) ?>;
fstock_dyeinglist.lists["x_packing_type"] = <?php echo $stock_dyeing_list->packing_type->Lookup->toClientList() ?>;
fstock_dyeinglist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_dyeing_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_dyeinglistsrch = currentSearchForm = new ew.Form("fstock_dyeinglistsrch");

// Filters
fstock_dyeinglistsrch.filterList = <?php echo $stock_dyeing_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_dyeinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_dyeing->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_dyeing_list->TotalRecs > 0 && $stock_dyeing_list->ExportOptions->visible()) { ?>
<?php $stock_dyeing_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_dyeing_list->ImportOptions->visible()) { ?>
<?php $stock_dyeing_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_dyeing_list->SearchOptions->visible()) { ?>
<?php $stock_dyeing_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_dyeing_list->FilterOptions->visible()) { ?>
<?php $stock_dyeing_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_dyeing_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_dyeing->isExport() && !$stock_dyeing->CurrentAction) { ?>
<form name="fstock_dyeinglistsrch" id="fstock_dyeinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_dyeing_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_dyeinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_dyeing">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_dyeing_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_dyeing_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_dyeing_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_dyeing_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_dyeing_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_dyeing_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_dyeing_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_dyeing_list->showPageHeader(); ?>
<?php
$stock_dyeing_list->showMessage();
?>
<?php if ($stock_dyeing_list->TotalRecs > 0 || $stock_dyeing->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_dyeing_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_dyeing">
<?php if (!$stock_dyeing->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_dyeing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_dyeing_list->Pager)) $stock_dyeing_list->Pager = new PrevNextPager($stock_dyeing_list->StartRec, $stock_dyeing_list->DisplayRecs, $stock_dyeing_list->TotalRecs, $stock_dyeing_list->AutoHidePager) ?>
<?php if ($stock_dyeing_list->Pager->RecordCount > 0 && $stock_dyeing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_dyeing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_dyeing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_dyeing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_dyeing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_dyeing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_dyeing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_dyeing_list->TotalRecs > 0 && (!$stock_dyeing_list->AutoHidePageSizeSelector || $stock_dyeing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_dyeing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_dyeing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_dyeing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_dyeing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_dyeing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_dyeing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_dyeing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_dyeing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_dyeinglist" id="fstock_dyeinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_dyeing_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_dyeing_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_dyeing">
<div id="gmp_stock_dyeing" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_dyeing_list->TotalRecs > 0 || $stock_dyeing->isGridEdit()) { ?>
<table id="tbl_stock_dyeinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_dyeing_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_dyeing_list->renderListOptions();

// Render list options (header, left)
$stock_dyeing_list->ListOptions->render("header", "left");
?>
<?php if ($stock_dyeing->product->Visible) { // product ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_dyeing->product->headerCellClass() ?>"><div id="elh_stock_dyeing_product" class="stock_dyeing_product"><div class="ew-table-header-caption"><?php echo $stock_dyeing->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_dyeing->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->product) ?>',2);"><div id="elh_stock_dyeing_product" class="stock_dyeing_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->product_code->Visible) { // product_code ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_dyeing->product_code->headerCellClass() ?>"><div id="elh_stock_dyeing_product_code" class="stock_dyeing_product_code"><div class="ew-table-header-caption"><?php echo $stock_dyeing->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_dyeing->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->product_code) ?>',2);"><div id="elh_stock_dyeing_product_code" class="stock_dyeing_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->godown->Visible) { // godown ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_dyeing->godown->headerCellClass() ?>"><div id="elh_stock_dyeing_godown" class="stock_dyeing_godown"><div class="ew-table-header-caption"><?php echo $stock_dyeing->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_dyeing->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->godown) ?>',2);"><div id="elh_stock_dyeing_godown" class="stock_dyeing_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->IN->Visible) { // IN ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_dyeing->IN->headerCellClass() ?>"><div id="elh_stock_dyeing_IN" class="stock_dyeing_IN"><div class="ew-table-header-caption"><?php echo $stock_dyeing->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_dyeing->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->IN) ?>',2);"><div id="elh_stock_dyeing_IN" class="stock_dyeing_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->OUT->Visible) { // OUT ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_dyeing->OUT->headerCellClass() ?>"><div id="elh_stock_dyeing_OUT" class="stock_dyeing_OUT"><div class="ew-table-header-caption"><?php echo $stock_dyeing->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_dyeing->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->OUT) ?>',2);"><div id="elh_stock_dyeing_OUT" class="stock_dyeing_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->packets->Visible) { // packets ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_dyeing->packets->headerCellClass() ?>"><div id="elh_stock_dyeing_packets" class="stock_dyeing_packets"><div class="ew-table-header-caption"><?php echo $stock_dyeing->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_dyeing->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->packets) ?>',2);"><div id="elh_stock_dyeing_packets" class="stock_dyeing_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_dyeing->packing_type->headerCellClass() ?>"><div id="elh_stock_dyeing_packing_type" class="stock_dyeing_packing_type"><div class="ew-table-header-caption"><?php echo $stock_dyeing->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_dyeing->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->packing_type) ?>',2);"><div id="elh_stock_dyeing_packing_type" class="stock_dyeing_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_dyeing->lot_no->headerCellClass() ?>"><div id="elh_stock_dyeing_lot_no" class="stock_dyeing_lot_no"><div class="ew-table-header-caption"><?php echo $stock_dyeing->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_dyeing->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->lot_no) ?>',2);"><div id="elh_stock_dyeing_lot_no" class="stock_dyeing_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_dyeing->tmp_lot->headerCellClass() ?>"><div id="elh_stock_dyeing_tmp_lot" class="stock_dyeing_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_dyeing->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_dyeing->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->tmp_lot) ?>',2);"><div id="elh_stock_dyeing_tmp_lot" class="stock_dyeing_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_dyeing->url->Visible) { // url ?>
	<?php if ($stock_dyeing->sortUrl($stock_dyeing->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_dyeing->url->headerCellClass() ?>"><div id="elh_stock_dyeing_url" class="stock_dyeing_url"><div class="ew-table-header-caption"><?php echo $stock_dyeing->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_dyeing->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_dyeing->SortUrl($stock_dyeing->url) ?>',2);"><div id="elh_stock_dyeing_url" class="stock_dyeing_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_dyeing->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_dyeing->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_dyeing->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_dyeing_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_dyeing->ExportAll && $stock_dyeing->isExport()) {
	$stock_dyeing_list->StopRec = $stock_dyeing_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_dyeing_list->TotalRecs > $stock_dyeing_list->StartRec + $stock_dyeing_list->DisplayRecs - 1)
		$stock_dyeing_list->StopRec = $stock_dyeing_list->StartRec + $stock_dyeing_list->DisplayRecs - 1;
	else
		$stock_dyeing_list->StopRec = $stock_dyeing_list->TotalRecs;
}
$stock_dyeing_list->RecCnt = $stock_dyeing_list->StartRec - 1;
if ($stock_dyeing_list->Recordset && !$stock_dyeing_list->Recordset->EOF) {
	$stock_dyeing_list->Recordset->moveFirst();
	$selectLimit = $stock_dyeing_list->UseSelectLimit;
	if (!$selectLimit && $stock_dyeing_list->StartRec > 1)
		$stock_dyeing_list->Recordset->move($stock_dyeing_list->StartRec - 1);
} elseif (!$stock_dyeing->AllowAddDeleteRow && $stock_dyeing_list->StopRec == 0) {
	$stock_dyeing_list->StopRec = $stock_dyeing->GridAddRowCount;
}

// Initialize aggregate
$stock_dyeing->RowType = ROWTYPE_AGGREGATEINIT;
$stock_dyeing->resetAttributes();
$stock_dyeing_list->renderRow();
while ($stock_dyeing_list->RecCnt < $stock_dyeing_list->StopRec) {
	$stock_dyeing_list->RecCnt++;
	if ($stock_dyeing_list->RecCnt >= $stock_dyeing_list->StartRec) {
		$stock_dyeing_list->RowCnt++;

		// Set up key count
		$stock_dyeing_list->KeyCount = $stock_dyeing_list->RowIndex;

		// Init row class and style
		$stock_dyeing->resetAttributes();
		$stock_dyeing->CssClass = "";
		if ($stock_dyeing->isGridAdd()) {
		} else {
			$stock_dyeing_list->loadRowValues($stock_dyeing_list->Recordset); // Load row values
		}
		$stock_dyeing->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_dyeing->RowAttrs = array_merge($stock_dyeing->RowAttrs, array('data-rowindex'=>$stock_dyeing_list->RowCnt, 'id'=>'r' . $stock_dyeing_list->RowCnt . '_stock_dyeing', 'data-rowtype'=>$stock_dyeing->RowType));

		// Render row
		$stock_dyeing_list->renderRow();

		// Render list options
		$stock_dyeing_list->renderListOptions();
?>
	<tr<?php echo $stock_dyeing->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_dyeing_list->ListOptions->render("body", "left", $stock_dyeing_list->RowCnt);
?>
	<?php if ($stock_dyeing->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_dyeing->product->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_product" class="stock_dyeing_product">
<span<?php echo $stock_dyeing->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_dyeing->product->getViewValue())) && $stock_dyeing->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_dyeing->product->linkAttributes() ?>><?php echo $stock_dyeing->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_dyeing->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_dyeing->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_product_code" class="stock_dyeing_product_code">
<span<?php echo $stock_dyeing->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_dyeing->product_code->getViewValue())) && $stock_dyeing->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_dyeing->product_code->linkAttributes() ?>><?php echo $stock_dyeing->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_dyeing->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_dyeing->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_godown" class="stock_dyeing_godown">
<span<?php echo $stock_dyeing->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_dyeing->godown->getViewValue())) && $stock_dyeing->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_dyeing->godown->linkAttributes() ?>><?php echo $stock_dyeing->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_dyeing->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_dyeing->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_IN" class="stock_dyeing_IN">
<span<?php echo $stock_dyeing->IN->viewAttributes() ?>>
<?php echo $stock_dyeing->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_dyeing->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_OUT" class="stock_dyeing_OUT">
<span<?php echo $stock_dyeing->OUT->viewAttributes() ?>>
<?php echo $stock_dyeing->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_dyeing->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_packets" class="stock_dyeing_packets">
<span<?php echo $stock_dyeing->packets->viewAttributes() ?>>
<?php echo $stock_dyeing->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_dyeing->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_packing_type" class="stock_dyeing_packing_type">
<span<?php echo $stock_dyeing->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_dyeing->packing_type->getViewValue())) && $stock_dyeing->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_dyeing->packing_type->linkAttributes() ?>><?php echo $stock_dyeing->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_dyeing->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_dyeing->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_lot_no" class="stock_dyeing_lot_no">
<span<?php echo $stock_dyeing->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_dyeing->lot_no->getViewValue())) && $stock_dyeing->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_dyeing->lot_no->linkAttributes() ?>><?php echo $stock_dyeing->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_dyeing->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_dyeing->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_tmp_lot" class="stock_dyeing_tmp_lot">
<span<?php echo $stock_dyeing->tmp_lot->viewAttributes() ?>>
<?php echo $stock_dyeing->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_dyeing->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_dyeing->url->cellAttributes() ?>>
<span id="el<?php echo $stock_dyeing_list->RowCnt ?>_stock_dyeing_url" class="stock_dyeing_url">
<span<?php echo $stock_dyeing->url->viewAttributes() ?>>
<?php echo $stock_dyeing->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_dyeing_list->ListOptions->render("body", "right", $stock_dyeing_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_dyeing->isGridAdd())
		$stock_dyeing_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_dyeing->RowType = ROWTYPE_AGGREGATE;
$stock_dyeing->resetAttributes();
$stock_dyeing_list->renderRow();
?>
<?php if ($stock_dyeing_list->TotalRecs > 0 && !$stock_dyeing->isGridAdd() && !$stock_dyeing->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_dyeing_list->renderListOptions();

// Render list options (footer, left)
$stock_dyeing_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_dyeing->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_dyeing->product->footerCellClass() ?>"><span id="elf_stock_dyeing_product" class="stock_dyeing_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_dyeing->product_code->footerCellClass() ?>"><span id="elf_stock_dyeing_product_code" class="stock_dyeing_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_dyeing->godown->footerCellClass() ?>"><span id="elf_stock_dyeing_godown" class="stock_dyeing_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_dyeing->IN->footerCellClass() ?>"><span id="elf_stock_dyeing_IN" class="stock_dyeing_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_dyeing->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_dyeing->OUT->footerCellClass() ?>"><span id="elf_stock_dyeing_OUT" class="stock_dyeing_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_dyeing->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_dyeing->packets->footerCellClass() ?>"><span id="elf_stock_dyeing_packets" class="stock_dyeing_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_dyeing->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_dyeing->packing_type->footerCellClass() ?>"><span id="elf_stock_dyeing_packing_type" class="stock_dyeing_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_dyeing->lot_no->footerCellClass() ?>"><span id="elf_stock_dyeing_lot_no" class="stock_dyeing_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_dyeing->tmp_lot->footerCellClass() ?>"><span id="elf_stock_dyeing_tmp_lot" class="stock_dyeing_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_dyeing->url->Visible) { // url ?>
		<td data-name="url" class="<?php echo $stock_dyeing->url->footerCellClass() ?>"><span id="elf_stock_dyeing_url" class="stock_dyeing_url">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_dyeing_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_dyeing->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_dyeing_list->Recordset)
	$stock_dyeing_list->Recordset->Close();
?>
<?php if (!$stock_dyeing->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_dyeing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_dyeing_list->Pager)) $stock_dyeing_list->Pager = new PrevNextPager($stock_dyeing_list->StartRec, $stock_dyeing_list->DisplayRecs, $stock_dyeing_list->TotalRecs, $stock_dyeing_list->AutoHidePager) ?>
<?php if ($stock_dyeing_list->Pager->RecordCount > 0 && $stock_dyeing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_dyeing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_dyeing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_dyeing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_dyeing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_dyeing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_dyeing_list->pageUrl() ?>start=<?php echo $stock_dyeing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_dyeing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_dyeing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_dyeing_list->TotalRecs > 0 && (!$stock_dyeing_list->AutoHidePageSizeSelector || $stock_dyeing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_dyeing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_dyeing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_dyeing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_dyeing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_dyeing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_dyeing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_dyeing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_dyeing_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_dyeing_list->TotalRecs == 0 && !$stock_dyeing->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_dyeing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_dyeing_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_dyeing->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_dyeing->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_dyeing", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_dyeing_list->terminate();
?>