<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_emp_hs_pending_list = new stock_emp_hs_pending_list();

// Run the page
$stock_emp_hs_pending_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_emp_hs_pending_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_emp_hs_pendinglist = currentForm = new ew.Form("fstock_emp_hs_pendinglist", "list");
fstock_emp_hs_pendinglist.formKeyCountName = '<?php echo $stock_emp_hs_pending_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_emp_hs_pendinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_emp_hs_pendinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_emp_hs_pendinglist.lists["x_jc_no"] = <?php echo $stock_emp_hs_pending_list->jc_no->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_jc_no"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->jc_no->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.lists["x_emp_id"] = <?php echo $stock_emp_hs_pending_list->emp_id->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_emp_id"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->emp_id->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.lists["x_rid"] = <?php echo $stock_emp_hs_pending_list->rid->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_rid"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->rid->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.lists["x_OUT"] = <?php echo $stock_emp_hs_pending_list->OUT->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_OUT"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->OUT->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.lists["x_item"] = <?php echo $stock_emp_hs_pending_list->item->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_item"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->item->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_emp_hs_pendinglist.lists["x_IN"] = <?php echo $stock_emp_hs_pending_list->IN->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_IN"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->IN->lookupOptions()) ?>;
fstock_emp_hs_pendinglist.lists["x_godown"] = <?php echo $stock_emp_hs_pending_list->godown->Lookup->toClientList() ?>;
fstock_emp_hs_pendinglist.lists["x_godown"].options = <?php echo JsonEncode($stock_emp_hs_pending_list->godown->lookupOptions()) ?>;

// Form object for search
var fstock_emp_hs_pendinglistsrch = currentSearchForm = new ew.Form("fstock_emp_hs_pendinglistsrch");

// Filters
fstock_emp_hs_pendinglistsrch.filterList = <?php echo $stock_emp_hs_pending_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_emp_hs_pendinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_emp_hs_pending_list->TotalRecs > 0 && $stock_emp_hs_pending_list->ExportOptions->visible()) { ?>
<?php $stock_emp_hs_pending_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->ImportOptions->visible()) { ?>
<?php $stock_emp_hs_pending_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->SearchOptions->visible()) { ?>
<?php $stock_emp_hs_pending_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->FilterOptions->visible()) { ?>
<?php $stock_emp_hs_pending_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_emp_hs_pending_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_emp_hs_pending->isExport() && !$stock_emp_hs_pending->CurrentAction) { ?>
<form name="fstock_emp_hs_pendinglistsrch" id="fstock_emp_hs_pendinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_emp_hs_pending_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_emp_hs_pendinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_emp_hs_pending">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_emp_hs_pending_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_emp_hs_pending_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_emp_hs_pending_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_emp_hs_pending_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_emp_hs_pending_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_emp_hs_pending_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_emp_hs_pending_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_emp_hs_pending_list->showPageHeader(); ?>
<?php
$stock_emp_hs_pending_list->showMessage();
?>
<?php if ($stock_emp_hs_pending_list->TotalRecs > 0 || $stock_emp_hs_pending->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_emp_hs_pending_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_emp_hs_pending">
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_emp_hs_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_emp_hs_pending_list->Pager)) $stock_emp_hs_pending_list->Pager = new PrevNextPager($stock_emp_hs_pending_list->StartRec, $stock_emp_hs_pending_list->DisplayRecs, $stock_emp_hs_pending_list->TotalRecs, $stock_emp_hs_pending_list->AutoHidePager) ?>
<?php if ($stock_emp_hs_pending_list->Pager->RecordCount > 0 && $stock_emp_hs_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_emp_hs_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->TotalRecs > 0 && (!$stock_emp_hs_pending_list->AutoHidePageSizeSelector || $stock_emp_hs_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_emp_hs_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_emp_hs_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_emp_hs_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_emp_hs_pendinglist" id="fstock_emp_hs_pendinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_emp_hs_pending_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_emp_hs_pending_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_emp_hs_pending">
<div id="gmp_stock_emp_hs_pending" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_emp_hs_pending_list->TotalRecs > 0 || $stock_emp_hs_pending->isGridEdit()) { ?>
<table id="tbl_stock_emp_hs_pendinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_emp_hs_pending_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_emp_hs_pending_list->renderListOptions();

// Render list options (header, left)
$stock_emp_hs_pending_list->ListOptions->render("header", "left");
?>
<?php if ($stock_emp_hs_pending->jc_no->Visible) { // jc_no ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $stock_emp_hs_pending->jc_no->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_jc_no" class="stock_emp_hs_pending_jc_no"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $stock_emp_hs_pending->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->jc_no) ?>',2);"><div id="elh_stock_emp_hs_pending_jc_no" class="stock_emp_hs_pending_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->emp_id->Visible) { // emp_id ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $stock_emp_hs_pending->emp_id->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_emp_id" class="stock_emp_hs_pending_emp_id"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $stock_emp_hs_pending->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->emp_id) ?>',2);"><div id="elh_stock_emp_hs_pending_emp_id" class="stock_emp_hs_pending_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->rid->Visible) { // rid ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_emp_hs_pending->rid->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_rid" class="stock_emp_hs_pending_rid"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_emp_hs_pending->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->rid) ?>',2);"><div id="elh_stock_emp_hs_pending_rid" class="stock_emp_hs_pending_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->OUT->Visible) { // OUT ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_emp_hs_pending->OUT->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_OUT" class="stock_emp_hs_pending_OUT"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_emp_hs_pending->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->OUT) ?>',2);"><div id="elh_stock_emp_hs_pending_OUT" class="stock_emp_hs_pending_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->item->Visible) { // item ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->item) == "") { ?>
		<th data-name="item" class="<?php echo $stock_emp_hs_pending->item->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_item" class="stock_emp_hs_pending_item"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $stock_emp_hs_pending->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->item) ?>',2);"><div id="elh_stock_emp_hs_pending_item" class="stock_emp_hs_pending_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->IN->Visible) { // IN ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_emp_hs_pending->IN->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_IN" class="stock_emp_hs_pending_IN"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_emp_hs_pending->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->IN) ?>',2);"><div id="elh_stock_emp_hs_pending_IN" class="stock_emp_hs_pending_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->Balance->Visible) { // Balance ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_emp_hs_pending->Balance->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_Balance" class="stock_emp_hs_pending_Balance"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_emp_hs_pending->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->Balance) ?>',2);"><div id="elh_stock_emp_hs_pending_Balance" class="stock_emp_hs_pending_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->Shortage->Visible) { // Shortage ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->Shortage) == "") { ?>
		<th data-name="Shortage" class="<?php echo $stock_emp_hs_pending->Shortage->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_Shortage" class="stock_emp_hs_pending_Shortage"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->Shortage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Shortage" class="<?php echo $stock_emp_hs_pending->Shortage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->Shortage) ?>',2);"><div id="elh_stock_emp_hs_pending_Shortage" class="stock_emp_hs_pending_Shortage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->Shortage->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->Shortage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->Shortage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_emp_hs_pending->godown->Visible) { // godown ?>
	<?php if ($stock_emp_hs_pending->sortUrl($stock_emp_hs_pending->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_emp_hs_pending->godown->headerCellClass() ?>"><div id="elh_stock_emp_hs_pending_godown" class="stock_emp_hs_pending_godown"><div class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_emp_hs_pending->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_emp_hs_pending->SortUrl($stock_emp_hs_pending->godown) ?>',2);"><div id="elh_stock_emp_hs_pending_godown" class="stock_emp_hs_pending_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_emp_hs_pending->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_emp_hs_pending->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_emp_hs_pending->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_emp_hs_pending_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_emp_hs_pending->ExportAll && $stock_emp_hs_pending->isExport()) {
	$stock_emp_hs_pending_list->StopRec = $stock_emp_hs_pending_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_emp_hs_pending_list->TotalRecs > $stock_emp_hs_pending_list->StartRec + $stock_emp_hs_pending_list->DisplayRecs - 1)
		$stock_emp_hs_pending_list->StopRec = $stock_emp_hs_pending_list->StartRec + $stock_emp_hs_pending_list->DisplayRecs - 1;
	else
		$stock_emp_hs_pending_list->StopRec = $stock_emp_hs_pending_list->TotalRecs;
}
$stock_emp_hs_pending_list->RecCnt = $stock_emp_hs_pending_list->StartRec - 1;
if ($stock_emp_hs_pending_list->Recordset && !$stock_emp_hs_pending_list->Recordset->EOF) {
	$stock_emp_hs_pending_list->Recordset->moveFirst();
	$selectLimit = $stock_emp_hs_pending_list->UseSelectLimit;
	if (!$selectLimit && $stock_emp_hs_pending_list->StartRec > 1)
		$stock_emp_hs_pending_list->Recordset->move($stock_emp_hs_pending_list->StartRec - 1);
} elseif (!$stock_emp_hs_pending->AllowAddDeleteRow && $stock_emp_hs_pending_list->StopRec == 0) {
	$stock_emp_hs_pending_list->StopRec = $stock_emp_hs_pending->GridAddRowCount;
}

// Initialize aggregate
$stock_emp_hs_pending->RowType = ROWTYPE_AGGREGATEINIT;
$stock_emp_hs_pending->resetAttributes();
$stock_emp_hs_pending_list->renderRow();
while ($stock_emp_hs_pending_list->RecCnt < $stock_emp_hs_pending_list->StopRec) {
	$stock_emp_hs_pending_list->RecCnt++;
	if ($stock_emp_hs_pending_list->RecCnt >= $stock_emp_hs_pending_list->StartRec) {
		$stock_emp_hs_pending_list->RowCnt++;

		// Set up key count
		$stock_emp_hs_pending_list->KeyCount = $stock_emp_hs_pending_list->RowIndex;

		// Init row class and style
		$stock_emp_hs_pending->resetAttributes();
		$stock_emp_hs_pending->CssClass = "";
		if ($stock_emp_hs_pending->isGridAdd()) {
		} else {
			$stock_emp_hs_pending_list->loadRowValues($stock_emp_hs_pending_list->Recordset); // Load row values
		}
		$stock_emp_hs_pending->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_emp_hs_pending->RowAttrs = array_merge($stock_emp_hs_pending->RowAttrs, array('data-rowindex'=>$stock_emp_hs_pending_list->RowCnt, 'id'=>'r' . $stock_emp_hs_pending_list->RowCnt . '_stock_emp_hs_pending', 'data-rowtype'=>$stock_emp_hs_pending->RowType));

		// Render row
		$stock_emp_hs_pending_list->renderRow();

		// Render list options
		$stock_emp_hs_pending_list->renderListOptions();
?>
	<tr<?php echo $stock_emp_hs_pending->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_emp_hs_pending_list->ListOptions->render("body", "left", $stock_emp_hs_pending_list->RowCnt);
?>
	<?php if ($stock_emp_hs_pending->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $stock_emp_hs_pending->jc_no->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_jc_no" class="stock_emp_hs_pending_jc_no">
<span<?php echo $stock_emp_hs_pending->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->jc_no->getViewValue())) && $stock_emp_hs_pending->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->jc_no->linkAttributes() ?>><?php echo $stock_emp_hs_pending->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $stock_emp_hs_pending->emp_id->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_emp_id" class="stock_emp_hs_pending_emp_id">
<span<?php echo $stock_emp_hs_pending->emp_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->emp_id->getViewValue())) && $stock_emp_hs_pending->emp_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->emp_id->linkAttributes() ?>><?php echo $stock_emp_hs_pending->emp_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->emp_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_emp_hs_pending->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_rid" class="stock_emp_hs_pending_rid">
<span<?php echo $stock_emp_hs_pending->rid->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->rid->getViewValue())) && $stock_emp_hs_pending->rid->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->rid->linkAttributes() ?>><?php echo $stock_emp_hs_pending->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_emp_hs_pending->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_OUT" class="stock_emp_hs_pending_OUT">
<span<?php echo $stock_emp_hs_pending->OUT->viewAttributes() ?>>
<?php echo $stock_emp_hs_pending->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->item->Visible) { // item ?>
		<td data-name="item"<?php echo $stock_emp_hs_pending->item->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_item" class="stock_emp_hs_pending_item">
<span<?php echo $stock_emp_hs_pending->item->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->item->getViewValue())) && $stock_emp_hs_pending->item->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->item->linkAttributes() ?>><?php echo $stock_emp_hs_pending->item->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_emp_hs_pending->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_IN" class="stock_emp_hs_pending_IN">
<span<?php echo $stock_emp_hs_pending->IN->viewAttributes() ?>>
<?php echo $stock_emp_hs_pending->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_emp_hs_pending->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_Balance" class="stock_emp_hs_pending_Balance">
<span<?php echo $stock_emp_hs_pending->Balance->viewAttributes() ?>>
<?php echo $stock_emp_hs_pending->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->Shortage->Visible) { // Shortage ?>
		<td data-name="Shortage"<?php echo $stock_emp_hs_pending->Shortage->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_Shortage" class="stock_emp_hs_pending_Shortage">
<span<?php echo $stock_emp_hs_pending->Shortage->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->Shortage->getViewValue())) && $stock_emp_hs_pending->Shortage->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->Shortage->linkAttributes() ?>><?php echo $stock_emp_hs_pending->Shortage->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->Shortage->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_emp_hs_pending->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_emp_hs_pending->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_emp_hs_pending_list->RowCnt ?>_stock_emp_hs_pending_godown" class="stock_emp_hs_pending_godown">
<span<?php echo $stock_emp_hs_pending->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_emp_hs_pending->godown->getViewValue())) && $stock_emp_hs_pending->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_emp_hs_pending->godown->linkAttributes() ?>><?php echo $stock_emp_hs_pending->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_emp_hs_pending->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_emp_hs_pending_list->ListOptions->render("body", "right", $stock_emp_hs_pending_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_emp_hs_pending->isGridAdd())
		$stock_emp_hs_pending_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_emp_hs_pending->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_emp_hs_pending_list->Recordset)
	$stock_emp_hs_pending_list->Recordset->Close();
?>
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_emp_hs_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_emp_hs_pending_list->Pager)) $stock_emp_hs_pending_list->Pager = new PrevNextPager($stock_emp_hs_pending_list->StartRec, $stock_emp_hs_pending_list->DisplayRecs, $stock_emp_hs_pending_list->TotalRecs, $stock_emp_hs_pending_list->AutoHidePager) ?>
<?php if ($stock_emp_hs_pending_list->Pager->RecordCount > 0 && $stock_emp_hs_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_emp_hs_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_emp_hs_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_emp_hs_pending_list->pageUrl() ?>start=<?php echo $stock_emp_hs_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_emp_hs_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_emp_hs_pending_list->TotalRecs > 0 && (!$stock_emp_hs_pending_list->AutoHidePageSizeSelector || $stock_emp_hs_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_emp_hs_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_emp_hs_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_emp_hs_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_emp_hs_pending_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_emp_hs_pending_list->TotalRecs == 0 && !$stock_emp_hs_pending->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_emp_hs_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_emp_hs_pending_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_emp_hs_pending->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_emp_hs_pending", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_emp_hs_pending_list->terminate();
?>