<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_godown_fp_list = new stock_godown_fp_list();

// Run the page
$stock_godown_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_godown_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_godown_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_godown_fplist = currentForm = new ew.Form("fstock_godown_fplist", "list");
fstock_godown_fplist.formKeyCountName = '<?php echo $stock_godown_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_godown_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_godown_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_godown_fplist.lists["x_product"] = <?php echo $stock_godown_fp_list->product->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_product"].options = <?php echo JsonEncode($stock_godown_fp_list->product->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_ref"] = <?php echo $stock_godown_fp_list->ref->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_ref"].options = <?php echo JsonEncode($stock_godown_fp_list->ref->lookupOptions()) ?>;
fstock_godown_fplist.autoSuggests["x_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_godown_fplist.lists["x_rid"] = <?php echo $stock_godown_fp_list->rid->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_rid"].options = <?php echo JsonEncode($stock_godown_fp_list->rid->lookupOptions()) ?>;
fstock_godown_fplist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_godown_fplist.lists["x_IN"] = <?php echo $stock_godown_fp_list->IN->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_IN"].options = <?php echo JsonEncode($stock_godown_fp_list->IN->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_OUT"] = <?php echo $stock_godown_fp_list->OUT->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_OUT"].options = <?php echo JsonEncode($stock_godown_fp_list->OUT->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_packets"] = <?php echo $stock_godown_fp_list->packets->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_packets"].options = <?php echo JsonEncode($stock_godown_fp_list->packets->lookupOptions()) ?>;
fstock_godown_fplist.autoSuggests["x_packets"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_godown_fplist.lists["x_packing_type"] = <?php echo $stock_godown_fp_list->packing_type->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_godown_fp_list->packing_type->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_godown"] = <?php echo $stock_godown_fp_list->godown->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_godown"].options = <?php echo JsonEncode($stock_godown_fp_list->godown->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_issue_to"] = <?php echo $stock_godown_fp_list->issue_to->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_issue_to"].options = <?php echo JsonEncode($stock_godown_fp_list->issue_to->lookupOptions()) ?>;
fstock_godown_fplist.lists["x_operator"] = <?php echo $stock_godown_fp_list->operator->Lookup->toClientList() ?>;
fstock_godown_fplist.lists["x_operator"].options = <?php echo JsonEncode($stock_godown_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fstock_godown_fplistsrch = currentSearchForm = new ew.Form("fstock_godown_fplistsrch");

// Filters
fstock_godown_fplistsrch.filterList = <?php echo $stock_godown_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_godown_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_godown_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_godown_fp_list->TotalRecs > 0 && $stock_godown_fp_list->ExportOptions->visible()) { ?>
<?php $stock_godown_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_fp_list->ImportOptions->visible()) { ?>
<?php $stock_godown_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_fp_list->SearchOptions->visible()) { ?>
<?php $stock_godown_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_fp_list->FilterOptions->visible()) { ?>
<?php $stock_godown_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_godown_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_godown_fp->isExport() && !$stock_godown_fp->CurrentAction) { ?>
<form name="fstock_godown_fplistsrch" id="fstock_godown_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_godown_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_godown_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_godown_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_godown_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_godown_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_godown_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_godown_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_godown_fp_list->showPageHeader(); ?>
<?php
$stock_godown_fp_list->showMessage();
?>
<?php if ($stock_godown_fp_list->TotalRecs > 0 || $stock_godown_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_godown_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_godown_fp">
<?php if (!$stock_godown_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_godown_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_fp_list->Pager)) $stock_godown_fp_list->Pager = new PrevNextPager($stock_godown_fp_list->StartRec, $stock_godown_fp_list->DisplayRecs, $stock_godown_fp_list->TotalRecs, $stock_godown_fp_list->AutoHidePager) ?>
<?php if ($stock_godown_fp_list->Pager->RecordCount > 0 && $stock_godown_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_fp_list->TotalRecs > 0 && (!$stock_godown_fp_list->AutoHidePageSizeSelector || $stock_godown_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_godown_fplist" id="fstock_godown_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_godown_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_godown_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_godown_fp">
<div id="gmp_stock_godown_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_godown_fp_list->TotalRecs > 0 || $stock_godown_fp->isGridEdit()) { ?>
<table id="tbl_stock_godown_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_godown_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_godown_fp_list->renderListOptions();

// Render list options (header, left)
$stock_godown_fp_list->ListOptions->render("header", "left");
?>
<?php if ($stock_godown_fp->product->Visible) { // product ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_godown_fp->product->headerCellClass() ?>"><div id="elh_stock_godown_fp_product" class="stock_godown_fp_product"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_godown_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->product) ?>',2);"><div id="elh_stock_godown_fp_product" class="stock_godown_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->ref->Visible) { // ref ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $stock_godown_fp->ref->headerCellClass() ?>"><div id="elh_stock_godown_fp_ref" class="stock_godown_fp_ref"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $stock_godown_fp->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->ref) ?>',2);"><div id="elh_stock_godown_fp_ref" class="stock_godown_fp_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->rid->Visible) { // rid ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_godown_fp->rid->headerCellClass() ?>"><div id="elh_stock_godown_fp_rid" class="stock_godown_fp_rid"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_godown_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->rid) ?>',2);"><div id="elh_stock_godown_fp_rid" class="stock_godown_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->IN->Visible) { // IN ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_godown_fp->IN->headerCellClass() ?>"><div id="elh_stock_godown_fp_IN" class="stock_godown_fp_IN"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_godown_fp->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->IN) ?>',2);"><div id="elh_stock_godown_fp_IN" class="stock_godown_fp_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->OUT->Visible) { // OUT ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_fp->OUT->headerCellClass() ?>"><div id="elh_stock_godown_fp_OUT" class="stock_godown_fp_OUT"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_fp->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->OUT) ?>',2);"><div id="elh_stock_godown_fp_OUT" class="stock_godown_fp_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->Balance->Visible) { // Balance ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_godown_fp->Balance->headerCellClass() ?>"><div id="elh_stock_godown_fp_Balance" class="stock_godown_fp_Balance"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_godown_fp->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->Balance) ?>',2);"><div id="elh_stock_godown_fp_Balance" class="stock_godown_fp_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->packets->Visible) { // packets ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_godown_fp->packets->headerCellClass() ?>"><div id="elh_stock_godown_fp_packets" class="stock_godown_fp_packets"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_godown_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->packets) ?>',2);"><div id="elh_stock_godown_fp_packets" class="stock_godown_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_fp->packing_type->headerCellClass() ?>"><div id="elh_stock_godown_fp_packing_type" class="stock_godown_fp_packing_type"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_fp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->packing_type) ?>',2);"><div id="elh_stock_godown_fp_packing_type" class="stock_godown_fp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->godown->Visible) { // godown ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_godown_fp->godown->headerCellClass() ?>"><div id="elh_stock_godown_fp_godown" class="stock_godown_fp_godown"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_godown_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->godown) ?>',2);"><div id="elh_stock_godown_fp_godown" class="stock_godown_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->issue_to->Visible) { // issue_to ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $stock_godown_fp->issue_to->headerCellClass() ?>"><div id="elh_stock_godown_fp_issue_to" class="stock_godown_fp_issue_to"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $stock_godown_fp->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->issue_to) ?>',2);"><div id="elh_stock_godown_fp_issue_to" class="stock_godown_fp_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->dated->Visible) { // dated ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_godown_fp->dated->headerCellClass() ?>"><div id="elh_stock_godown_fp_dated" class="stock_godown_fp_dated"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_godown_fp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->dated) ?>',2);"><div id="elh_stock_godown_fp_dated" class="stock_godown_fp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->operator->Visible) { // operator ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $stock_godown_fp->operator->headerCellClass() ?>"><div id="elh_stock_godown_fp_operator" class="stock_godown_fp_operator"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $stock_godown_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->operator) ?>',2);"><div id="elh_stock_godown_fp_operator" class="stock_godown_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_fp->remarks->Visible) { // remarks ?>
	<?php if ($stock_godown_fp->sortUrl($stock_godown_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $stock_godown_fp->remarks->headerCellClass() ?>"><div id="elh_stock_godown_fp_remarks" class="stock_godown_fp_remarks"><div class="ew-table-header-caption"><?php echo $stock_godown_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $stock_godown_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_fp->SortUrl($stock_godown_fp->remarks) ?>',2);"><div id="elh_stock_godown_fp_remarks" class="stock_godown_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_godown_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_godown_fp->ExportAll && $stock_godown_fp->isExport()) {
	$stock_godown_fp_list->StopRec = $stock_godown_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_godown_fp_list->TotalRecs > $stock_godown_fp_list->StartRec + $stock_godown_fp_list->DisplayRecs - 1)
		$stock_godown_fp_list->StopRec = $stock_godown_fp_list->StartRec + $stock_godown_fp_list->DisplayRecs - 1;
	else
		$stock_godown_fp_list->StopRec = $stock_godown_fp_list->TotalRecs;
}
$stock_godown_fp_list->RecCnt = $stock_godown_fp_list->StartRec - 1;
if ($stock_godown_fp_list->Recordset && !$stock_godown_fp_list->Recordset->EOF) {
	$stock_godown_fp_list->Recordset->moveFirst();
	$selectLimit = $stock_godown_fp_list->UseSelectLimit;
	if (!$selectLimit && $stock_godown_fp_list->StartRec > 1)
		$stock_godown_fp_list->Recordset->move($stock_godown_fp_list->StartRec - 1);
} elseif (!$stock_godown_fp->AllowAddDeleteRow && $stock_godown_fp_list->StopRec == 0) {
	$stock_godown_fp_list->StopRec = $stock_godown_fp->GridAddRowCount;
}

// Initialize aggregate
$stock_godown_fp->RowType = ROWTYPE_AGGREGATEINIT;
$stock_godown_fp->resetAttributes();
$stock_godown_fp_list->renderRow();
while ($stock_godown_fp_list->RecCnt < $stock_godown_fp_list->StopRec) {
	$stock_godown_fp_list->RecCnt++;
	if ($stock_godown_fp_list->RecCnt >= $stock_godown_fp_list->StartRec) {
		$stock_godown_fp_list->RowCnt++;

		// Set up key count
		$stock_godown_fp_list->KeyCount = $stock_godown_fp_list->RowIndex;

		// Init row class and style
		$stock_godown_fp->resetAttributes();
		$stock_godown_fp->CssClass = "";
		if ($stock_godown_fp->isGridAdd()) {
		} else {
			$stock_godown_fp_list->loadRowValues($stock_godown_fp_list->Recordset); // Load row values
		}
		$stock_godown_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_godown_fp->RowAttrs = array_merge($stock_godown_fp->RowAttrs, array('data-rowindex'=>$stock_godown_fp_list->RowCnt, 'id'=>'r' . $stock_godown_fp_list->RowCnt . '_stock_godown_fp', 'data-rowtype'=>$stock_godown_fp->RowType));

		// Render row
		$stock_godown_fp_list->renderRow();

		// Render list options
		$stock_godown_fp_list->renderListOptions();
?>
	<tr<?php echo $stock_godown_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_godown_fp_list->ListOptions->render("body", "left", $stock_godown_fp_list->RowCnt);
?>
	<?php if ($stock_godown_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_godown_fp->product->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_product" class="stock_godown_fp_product">
<span<?php echo $stock_godown_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->product->getViewValue())) && $stock_godown_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->product->linkAttributes() ?>><?php echo $stock_godown_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $stock_godown_fp->ref->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_ref" class="stock_godown_fp_ref">
<span<?php echo $stock_godown_fp->ref->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->ref->getViewValue())) && $stock_godown_fp->ref->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->ref->linkAttributes() ?>><?php echo $stock_godown_fp->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_godown_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_rid" class="stock_godown_fp_rid">
<span<?php echo $stock_godown_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->rid->getViewValue())) && $stock_godown_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->rid->linkAttributes() ?>><?php echo $stock_godown_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_godown_fp->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_IN" class="stock_godown_fp_IN">
<span<?php echo $stock_godown_fp->IN->viewAttributes() ?>>
<?php echo $stock_godown_fp->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_godown_fp->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_OUT" class="stock_godown_fp_OUT">
<span<?php echo $stock_godown_fp->OUT->viewAttributes() ?>>
<?php echo $stock_godown_fp->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_godown_fp->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_Balance" class="stock_godown_fp_Balance">
<span<?php echo $stock_godown_fp->Balance->viewAttributes() ?>>
<?php echo $stock_godown_fp->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_godown_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_packets" class="stock_godown_fp_packets">
<span<?php echo $stock_godown_fp->packets->viewAttributes() ?>>
<?php echo $stock_godown_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_godown_fp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_packing_type" class="stock_godown_fp_packing_type">
<span<?php echo $stock_godown_fp->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->packing_type->getViewValue())) && $stock_godown_fp->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->packing_type->linkAttributes() ?>><?php echo $stock_godown_fp->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_godown_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_godown" class="stock_godown_fp_godown">
<span<?php echo $stock_godown_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->godown->getViewValue())) && $stock_godown_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->godown->linkAttributes() ?>><?php echo $stock_godown_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $stock_godown_fp->issue_to->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_issue_to" class="stock_godown_fp_issue_to">
<span<?php echo $stock_godown_fp->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_fp->issue_to->getViewValue())) && $stock_godown_fp->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_fp->issue_to->linkAttributes() ?>><?php echo $stock_godown_fp->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_fp->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_godown_fp->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_dated" class="stock_godown_fp_dated">
<span<?php echo $stock_godown_fp->dated->viewAttributes() ?>>
<?php echo $stock_godown_fp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $stock_godown_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_operator" class="stock_godown_fp_operator">
<span<?php echo $stock_godown_fp->operator->viewAttributes() ?>>
<?php echo $stock_godown_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $stock_godown_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_fp_list->RowCnt ?>_stock_godown_fp_remarks" class="stock_godown_fp_remarks">
<span<?php echo $stock_godown_fp->remarks->viewAttributes() ?>>
<?php echo $stock_godown_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_godown_fp_list->ListOptions->render("body", "right", $stock_godown_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_godown_fp->isGridAdd())
		$stock_godown_fp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_godown_fp->RowType = ROWTYPE_AGGREGATE;
$stock_godown_fp->resetAttributes();
$stock_godown_fp_list->renderRow();
?>
<?php if ($stock_godown_fp_list->TotalRecs > 0 && !$stock_godown_fp->isGridAdd() && !$stock_godown_fp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_godown_fp_list->renderListOptions();

// Render list options (footer, left)
$stock_godown_fp_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_godown_fp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_godown_fp->product->footerCellClass() ?>"><span id="elf_stock_godown_fp_product" class="stock_godown_fp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $stock_godown_fp->ref->footerCellClass() ?>"><span id="elf_stock_godown_fp_ref" class="stock_godown_fp_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $stock_godown_fp->rid->footerCellClass() ?>"><span id="elf_stock_godown_fp_rid" class="stock_godown_fp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_godown_fp->IN->footerCellClass() ?>"><span id="elf_stock_godown_fp_IN" class="stock_godown_fp_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_fp->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_godown_fp->OUT->footerCellClass() ?>"><span id="elf_stock_godown_fp_OUT" class="stock_godown_fp_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_fp->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_godown_fp->Balance->footerCellClass() ?>"><span id="elf_stock_godown_fp_Balance" class="stock_godown_fp_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_fp->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_godown_fp->packets->footerCellClass() ?>"><span id="elf_stock_godown_fp_packets" class="stock_godown_fp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_godown_fp->packing_type->footerCellClass() ?>"><span id="elf_stock_godown_fp_packing_type" class="stock_godown_fp_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_godown_fp->godown->footerCellClass() ?>"><span id="elf_stock_godown_fp_godown" class="stock_godown_fp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $stock_godown_fp->issue_to->footerCellClass() ?>"><span id="elf_stock_godown_fp_issue_to" class="stock_godown_fp_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_godown_fp->dated->footerCellClass() ?>"><span id="elf_stock_godown_fp_dated" class="stock_godown_fp_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $stock_godown_fp->operator->footerCellClass() ?>"><span id="elf_stock_godown_fp_operator" class="stock_godown_fp_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $stock_godown_fp->remarks->footerCellClass() ?>"><span id="elf_stock_godown_fp_remarks" class="stock_godown_fp_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_godown_fp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_godown_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_godown_fp_list->Recordset)
	$stock_godown_fp_list->Recordset->Close();
?>
<?php if (!$stock_godown_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_godown_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_fp_list->Pager)) $stock_godown_fp_list->Pager = new PrevNextPager($stock_godown_fp_list->StartRec, $stock_godown_fp_list->DisplayRecs, $stock_godown_fp_list->TotalRecs, $stock_godown_fp_list->AutoHidePager) ?>
<?php if ($stock_godown_fp_list->Pager->RecordCount > 0 && $stock_godown_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_fp_list->pageUrl() ?>start=<?php echo $stock_godown_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_fp_list->TotalRecs > 0 && (!$stock_godown_fp_list->AutoHidePageSizeSelector || $stock_godown_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_godown_fp_list->TotalRecs == 0 && !$stock_godown_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_godown_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_godown_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_godown_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_godown_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_godown_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_godown_fp_list->terminate();
?>