<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_godown_hs_list = new stock_godown_hs_list();

// Run the page
$stock_godown_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_godown_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_godown_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_godown_hslist = currentForm = new ew.Form("fstock_godown_hslist", "list");
fstock_godown_hslist.formKeyCountName = '<?php echo $stock_godown_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_godown_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_godown_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_godown_hslist.lists["x_ref"] = <?php echo $stock_godown_hs_list->ref->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_ref"].options = <?php echo JsonEncode($stock_godown_hs_list->ref->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_item_code"] = <?php echo $stock_godown_hs_list->item_code->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_item_code"].options = <?php echo JsonEncode($stock_godown_hs_list->item_code->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_jc_quantity"] = <?php echo $stock_godown_hs_list->jc_quantity->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_jc_quantity"].options = <?php echo JsonEncode($stock_godown_hs_list->jc_quantity->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_IN"] = <?php echo $stock_godown_hs_list->IN->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_IN"].options = <?php echo JsonEncode($stock_godown_hs_list->IN->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_OUT"] = <?php echo $stock_godown_hs_list->OUT->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_OUT"].options = <?php echo JsonEncode($stock_godown_hs_list->OUT->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_godown"] = <?php echo $stock_godown_hs_list->godown->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_godown"].options = <?php echo JsonEncode($stock_godown_hs_list->godown->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_issue_to"] = <?php echo $stock_godown_hs_list->issue_to->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_issue_to"].options = <?php echo JsonEncode($stock_godown_hs_list->issue_to->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_packing_type"] = <?php echo $stock_godown_hs_list->packing_type->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_godown_hs_list->packing_type->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_packets"] = <?php echo $stock_godown_hs_list->packets->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_packets"].options = <?php echo JsonEncode($stock_godown_hs_list->packets->lookupOptions()) ?>;
fstock_godown_hslist.lists["x_operator"] = <?php echo $stock_godown_hs_list->operator->Lookup->toClientList() ?>;
fstock_godown_hslist.lists["x_operator"].options = <?php echo JsonEncode($stock_godown_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fstock_godown_hslistsrch = currentSearchForm = new ew.Form("fstock_godown_hslistsrch");

// Filters
fstock_godown_hslistsrch.filterList = <?php echo $stock_godown_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_godown_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_godown_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_godown_hs_list->TotalRecs > 0 && $stock_godown_hs_list->ExportOptions->visible()) { ?>
<?php $stock_godown_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_hs_list->ImportOptions->visible()) { ?>
<?php $stock_godown_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_hs_list->SearchOptions->visible()) { ?>
<?php $stock_godown_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_hs_list->FilterOptions->visible()) { ?>
<?php $stock_godown_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_godown_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_godown_hs->isExport() && !$stock_godown_hs->CurrentAction) { ?>
<form name="fstock_godown_hslistsrch" id="fstock_godown_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_godown_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_godown_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_godown_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_godown_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_godown_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_godown_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_godown_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_godown_hs_list->showPageHeader(); ?>
<?php
$stock_godown_hs_list->showMessage();
?>
<?php if ($stock_godown_hs_list->TotalRecs > 0 || $stock_godown_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_godown_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_godown_hs">
<?php if (!$stock_godown_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_godown_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_hs_list->Pager)) $stock_godown_hs_list->Pager = new PrevNextPager($stock_godown_hs_list->StartRec, $stock_godown_hs_list->DisplayRecs, $stock_godown_hs_list->TotalRecs, $stock_godown_hs_list->AutoHidePager) ?>
<?php if ($stock_godown_hs_list->Pager->RecordCount > 0 && $stock_godown_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_hs_list->TotalRecs > 0 && (!$stock_godown_hs_list->AutoHidePageSizeSelector || $stock_godown_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_godown_hslist" id="fstock_godown_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_godown_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_godown_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_godown_hs">
<div id="gmp_stock_godown_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_godown_hs_list->TotalRecs > 0 || $stock_godown_hs->isGridEdit()) { ?>
<table id="tbl_stock_godown_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_godown_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_godown_hs_list->renderListOptions();

// Render list options (header, left)
$stock_godown_hs_list->ListOptions->render("header", "left");
?>
<?php if ($stock_godown_hs->ref->Visible) { // ref ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $stock_godown_hs->ref->headerCellClass() ?>"><div id="elh_stock_godown_hs_ref" class="stock_godown_hs_ref"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $stock_godown_hs->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->ref) ?>',2);"><div id="elh_stock_godown_hs_ref" class="stock_godown_hs_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->item_code->Visible) { // item_code ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->item_code) == "") { ?>
		<th data-name="item_code" class="<?php echo $stock_godown_hs->item_code->headerCellClass() ?>"><div id="elh_stock_godown_hs_item_code" class="stock_godown_hs_item_code"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->item_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item_code" class="<?php echo $stock_godown_hs->item_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->item_code) ?>',2);"><div id="elh_stock_godown_hs_item_code" class="stock_godown_hs_item_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->item_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->item_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->item_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->count_received->Visible) { // count_received ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->count_received) == "") { ?>
		<th data-name="count_received" class="<?php echo $stock_godown_hs->count_received->headerCellClass() ?>"><div id="elh_stock_godown_hs_count_received" class="stock_godown_hs_count_received"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->count_received->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count_received" class="<?php echo $stock_godown_hs->count_received->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->count_received) ?>',2);"><div id="elh_stock_godown_hs_count_received" class="stock_godown_hs_count_received">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->count_received->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->count_received->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->count_received->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->jc_quantity->Visible) { // jc_quantity ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->jc_quantity) == "") { ?>
		<th data-name="jc_quantity" class="<?php echo $stock_godown_hs->jc_quantity->headerCellClass() ?>"><div id="elh_stock_godown_hs_jc_quantity" class="stock_godown_hs_jc_quantity"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->jc_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_quantity" class="<?php echo $stock_godown_hs->jc_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->jc_quantity) ?>',2);"><div id="elh_stock_godown_hs_jc_quantity" class="stock_godown_hs_jc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->jc_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->jc_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->jc_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->IN->Visible) { // IN ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_godown_hs->IN->headerCellClass() ?>"><div id="elh_stock_godown_hs_IN" class="stock_godown_hs_IN"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_godown_hs->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->IN) ?>',2);"><div id="elh_stock_godown_hs_IN" class="stock_godown_hs_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->OUT->Visible) { // OUT ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_hs->OUT->headerCellClass() ?>"><div id="elh_stock_godown_hs_OUT" class="stock_godown_hs_OUT"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_hs->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->OUT) ?>',2);"><div id="elh_stock_godown_hs_OUT" class="stock_godown_hs_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->Balance->Visible) { // Balance ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_godown_hs->Balance->headerCellClass() ?>"><div id="elh_stock_godown_hs_Balance" class="stock_godown_hs_Balance"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_godown_hs->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->Balance) ?>',2);"><div id="elh_stock_godown_hs_Balance" class="stock_godown_hs_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->godown->Visible) { // godown ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_godown_hs->godown->headerCellClass() ?>"><div id="elh_stock_godown_hs_godown" class="stock_godown_hs_godown"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_godown_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->godown) ?>',2);"><div id="elh_stock_godown_hs_godown" class="stock_godown_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->issue_to->Visible) { // issue_to ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $stock_godown_hs->issue_to->headerCellClass() ?>"><div id="elh_stock_godown_hs_issue_to" class="stock_godown_hs_issue_to"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $stock_godown_hs->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->issue_to) ?>',2);"><div id="elh_stock_godown_hs_issue_to" class="stock_godown_hs_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_hs->packing_type->headerCellClass() ?>"><div id="elh_stock_godown_hs_packing_type" class="stock_godown_hs_packing_type"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_hs->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->packing_type) ?>',2);"><div id="elh_stock_godown_hs_packing_type" class="stock_godown_hs_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->packets->Visible) { // packets ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_godown_hs->packets->headerCellClass() ?>"><div id="elh_stock_godown_hs_packets" class="stock_godown_hs_packets"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_godown_hs->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->packets) ?>',2);"><div id="elh_stock_godown_hs_packets" class="stock_godown_hs_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->dated->Visible) { // dated ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_godown_hs->dated->headerCellClass() ?>"><div id="elh_stock_godown_hs_dated" class="stock_godown_hs_dated"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_godown_hs->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->dated) ?>',2);"><div id="elh_stock_godown_hs_dated" class="stock_godown_hs_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->operator->Visible) { // operator ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $stock_godown_hs->operator->headerCellClass() ?>"><div id="elh_stock_godown_hs_operator" class="stock_godown_hs_operator"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $stock_godown_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->operator) ?>',2);"><div id="elh_stock_godown_hs_operator" class="stock_godown_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_hs->remarks->Visible) { // remarks ?>
	<?php if ($stock_godown_hs->sortUrl($stock_godown_hs->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $stock_godown_hs->remarks->headerCellClass() ?>"><div id="elh_stock_godown_hs_remarks" class="stock_godown_hs_remarks"><div class="ew-table-header-caption"><?php echo $stock_godown_hs->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $stock_godown_hs->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_hs->SortUrl($stock_godown_hs->remarks) ?>',2);"><div id="elh_stock_godown_hs_remarks" class="stock_godown_hs_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_hs->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_hs->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_hs->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_godown_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_godown_hs->ExportAll && $stock_godown_hs->isExport()) {
	$stock_godown_hs_list->StopRec = $stock_godown_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_godown_hs_list->TotalRecs > $stock_godown_hs_list->StartRec + $stock_godown_hs_list->DisplayRecs - 1)
		$stock_godown_hs_list->StopRec = $stock_godown_hs_list->StartRec + $stock_godown_hs_list->DisplayRecs - 1;
	else
		$stock_godown_hs_list->StopRec = $stock_godown_hs_list->TotalRecs;
}
$stock_godown_hs_list->RecCnt = $stock_godown_hs_list->StartRec - 1;
if ($stock_godown_hs_list->Recordset && !$stock_godown_hs_list->Recordset->EOF) {
	$stock_godown_hs_list->Recordset->moveFirst();
	$selectLimit = $stock_godown_hs_list->UseSelectLimit;
	if (!$selectLimit && $stock_godown_hs_list->StartRec > 1)
		$stock_godown_hs_list->Recordset->move($stock_godown_hs_list->StartRec - 1);
} elseif (!$stock_godown_hs->AllowAddDeleteRow && $stock_godown_hs_list->StopRec == 0) {
	$stock_godown_hs_list->StopRec = $stock_godown_hs->GridAddRowCount;
}

// Initialize aggregate
$stock_godown_hs->RowType = ROWTYPE_AGGREGATEINIT;
$stock_godown_hs->resetAttributes();
$stock_godown_hs_list->renderRow();
while ($stock_godown_hs_list->RecCnt < $stock_godown_hs_list->StopRec) {
	$stock_godown_hs_list->RecCnt++;
	if ($stock_godown_hs_list->RecCnt >= $stock_godown_hs_list->StartRec) {
		$stock_godown_hs_list->RowCnt++;

		// Set up key count
		$stock_godown_hs_list->KeyCount = $stock_godown_hs_list->RowIndex;

		// Init row class and style
		$stock_godown_hs->resetAttributes();
		$stock_godown_hs->CssClass = "";
		if ($stock_godown_hs->isGridAdd()) {
		} else {
			$stock_godown_hs_list->loadRowValues($stock_godown_hs_list->Recordset); // Load row values
		}
		$stock_godown_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_godown_hs->RowAttrs = array_merge($stock_godown_hs->RowAttrs, array('data-rowindex'=>$stock_godown_hs_list->RowCnt, 'id'=>'r' . $stock_godown_hs_list->RowCnt . '_stock_godown_hs', 'data-rowtype'=>$stock_godown_hs->RowType));

		// Render row
		$stock_godown_hs_list->renderRow();

		// Render list options
		$stock_godown_hs_list->renderListOptions();
?>
	<tr<?php echo $stock_godown_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_godown_hs_list->ListOptions->render("body", "left", $stock_godown_hs_list->RowCnt);
?>
	<?php if ($stock_godown_hs->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $stock_godown_hs->ref->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_ref" class="stock_godown_hs_ref">
<span<?php echo $stock_godown_hs->ref->viewAttributes() ?>>
<?php echo $stock_godown_hs->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->item_code->Visible) { // item_code ?>
		<td data-name="item_code"<?php echo $stock_godown_hs->item_code->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_item_code" class="stock_godown_hs_item_code">
<span<?php echo $stock_godown_hs->item_code->viewAttributes() ?>>
<?php echo $stock_godown_hs->item_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->count_received->Visible) { // count_received ?>
		<td data-name="count_received"<?php echo $stock_godown_hs->count_received->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_count_received" class="stock_godown_hs_count_received">
<span<?php echo $stock_godown_hs->count_received->viewAttributes() ?>>
<?php echo $stock_godown_hs->count_received->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity"<?php echo $stock_godown_hs->jc_quantity->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_jc_quantity" class="stock_godown_hs_jc_quantity">
<span<?php echo $stock_godown_hs->jc_quantity->viewAttributes() ?>>
<?php echo $stock_godown_hs->jc_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_godown_hs->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_IN" class="stock_godown_hs_IN">
<span<?php echo $stock_godown_hs->IN->viewAttributes() ?>>
<?php echo $stock_godown_hs->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_godown_hs->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_OUT" class="stock_godown_hs_OUT">
<span<?php echo $stock_godown_hs->OUT->viewAttributes() ?>>
<?php echo $stock_godown_hs->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_godown_hs->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_Balance" class="stock_godown_hs_Balance">
<span<?php echo $stock_godown_hs->Balance->viewAttributes() ?>>
<?php echo $stock_godown_hs->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_godown_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_godown" class="stock_godown_hs_godown">
<span<?php echo $stock_godown_hs->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_hs->godown->getViewValue())) && $stock_godown_hs->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_hs->godown->linkAttributes() ?>><?php echo $stock_godown_hs->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_hs->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $stock_godown_hs->issue_to->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_issue_to" class="stock_godown_hs_issue_to">
<span<?php echo $stock_godown_hs->issue_to->viewAttributes() ?>>
<?php echo $stock_godown_hs->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_godown_hs->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_packing_type" class="stock_godown_hs_packing_type">
<span<?php echo $stock_godown_hs->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_hs->packing_type->getViewValue())) && $stock_godown_hs->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_hs->packing_type->linkAttributes() ?>><?php echo $stock_godown_hs->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_hs->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_godown_hs->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_packets" class="stock_godown_hs_packets">
<span<?php echo $stock_godown_hs->packets->viewAttributes() ?>>
<?php echo $stock_godown_hs->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_godown_hs->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_dated" class="stock_godown_hs_dated">
<span<?php echo $stock_godown_hs->dated->viewAttributes() ?>>
<?php echo $stock_godown_hs->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $stock_godown_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_operator" class="stock_godown_hs_operator">
<span<?php echo $stock_godown_hs->operator->viewAttributes() ?>>
<?php echo $stock_godown_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $stock_godown_hs->remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_hs_list->RowCnt ?>_stock_godown_hs_remarks" class="stock_godown_hs_remarks">
<span<?php echo $stock_godown_hs->remarks->viewAttributes() ?>>
<?php echo $stock_godown_hs->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_godown_hs_list->ListOptions->render("body", "right", $stock_godown_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_godown_hs->isGridAdd())
		$stock_godown_hs_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_godown_hs->RowType = ROWTYPE_AGGREGATE;
$stock_godown_hs->resetAttributes();
$stock_godown_hs_list->renderRow();
?>
<?php if ($stock_godown_hs_list->TotalRecs > 0 && !$stock_godown_hs->isGridAdd() && !$stock_godown_hs->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_godown_hs_list->renderListOptions();

// Render list options (footer, left)
$stock_godown_hs_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_godown_hs->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $stock_godown_hs->ref->footerCellClass() ?>"><span id="elf_stock_godown_hs_ref" class="stock_godown_hs_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->item_code->Visible) { // item_code ?>
		<td data-name="item_code" class="<?php echo $stock_godown_hs->item_code->footerCellClass() ?>"><span id="elf_stock_godown_hs_item_code" class="stock_godown_hs_item_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->count_received->Visible) { // count_received ?>
		<td data-name="count_received" class="<?php echo $stock_godown_hs->count_received->footerCellClass() ?>"><span id="elf_stock_godown_hs_count_received" class="stock_godown_hs_count_received">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity" class="<?php echo $stock_godown_hs->jc_quantity->footerCellClass() ?>"><span id="elf_stock_godown_hs_jc_quantity" class="stock_godown_hs_jc_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_godown_hs->IN->footerCellClass() ?>"><span id="elf_stock_godown_hs_IN" class="stock_godown_hs_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_hs->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_godown_hs->OUT->footerCellClass() ?>"><span id="elf_stock_godown_hs_OUT" class="stock_godown_hs_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_hs->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_godown_hs->Balance->footerCellClass() ?>"><span id="elf_stock_godown_hs_Balance" class="stock_godown_hs_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_hs->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_godown_hs->godown->footerCellClass() ?>"><span id="elf_stock_godown_hs_godown" class="stock_godown_hs_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $stock_godown_hs->issue_to->footerCellClass() ?>"><span id="elf_stock_godown_hs_issue_to" class="stock_godown_hs_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_godown_hs->packing_type->footerCellClass() ?>"><span id="elf_stock_godown_hs_packing_type" class="stock_godown_hs_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_godown_hs->packets->footerCellClass() ?>"><span id="elf_stock_godown_hs_packets" class="stock_godown_hs_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_godown_hs->dated->footerCellClass() ?>"><span id="elf_stock_godown_hs_dated" class="stock_godown_hs_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $stock_godown_hs->operator->footerCellClass() ?>"><span id="elf_stock_godown_hs_operator" class="stock_godown_hs_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $stock_godown_hs->remarks->footerCellClass() ?>"><span id="elf_stock_godown_hs_remarks" class="stock_godown_hs_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_godown_hs_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_godown_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_godown_hs_list->Recordset)
	$stock_godown_hs_list->Recordset->Close();
?>
<?php if (!$stock_godown_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_godown_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_hs_list->Pager)) $stock_godown_hs_list->Pager = new PrevNextPager($stock_godown_hs_list->StartRec, $stock_godown_hs_list->DisplayRecs, $stock_godown_hs_list->TotalRecs, $stock_godown_hs_list->AutoHidePager) ?>
<?php if ($stock_godown_hs_list->Pager->RecordCount > 0 && $stock_godown_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_hs_list->pageUrl() ?>start=<?php echo $stock_godown_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_hs_list->TotalRecs > 0 && (!$stock_godown_hs_list->AutoHidePageSizeSelector || $stock_godown_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_godown_hs_list->TotalRecs == 0 && !$stock_godown_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_godown_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_godown_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_godown_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_godown_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_godown_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_godown_hs_list->terminate();
?>