<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_godown_transfer_old_list = new stock_godown_transfer_old_list();

// Run the page
$stock_godown_transfer_old_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_godown_transfer_old_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_godown_transfer_oldlist = currentForm = new ew.Form("fstock_godown_transfer_oldlist", "list");
fstock_godown_transfer_oldlist.formKeyCountName = '<?php echo $stock_godown_transfer_old_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_godown_transfer_oldlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_godown_transfer_oldlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fstock_godown_transfer_oldlistsrch = currentSearchForm = new ew.Form("fstock_godown_transfer_oldlistsrch");

// Filters
fstock_godown_transfer_oldlistsrch.filterList = <?php echo $stock_godown_transfer_old_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_godown_transfer_oldlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_godown_transfer_old_list->TotalRecs > 0 && $stock_godown_transfer_old_list->ExportOptions->visible()) { ?>
<?php $stock_godown_transfer_old_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->ImportOptions->visible()) { ?>
<?php $stock_godown_transfer_old_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->SearchOptions->visible()) { ?>
<?php $stock_godown_transfer_old_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->FilterOptions->visible()) { ?>
<?php $stock_godown_transfer_old_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_godown_transfer_old_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_godown_transfer_old->isExport() && !$stock_godown_transfer_old->CurrentAction) { ?>
<form name="fstock_godown_transfer_oldlistsrch" id="fstock_godown_transfer_oldlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_godown_transfer_old_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_godown_transfer_oldlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_godown_transfer_old">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_godown_transfer_old_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_godown_transfer_old_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_godown_transfer_old_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_godown_transfer_old_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_old_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_old_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_old_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_godown_transfer_old_list->showPageHeader(); ?>
<?php
$stock_godown_transfer_old_list->showMessage();
?>
<?php if ($stock_godown_transfer_old_list->TotalRecs > 0 || $stock_godown_transfer_old->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_godown_transfer_old_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_godown_transfer_old">
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_godown_transfer_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_transfer_old_list->Pager)) $stock_godown_transfer_old_list->Pager = new PrevNextPager($stock_godown_transfer_old_list->StartRec, $stock_godown_transfer_old_list->DisplayRecs, $stock_godown_transfer_old_list->TotalRecs, $stock_godown_transfer_old_list->AutoHidePager) ?>
<?php if ($stock_godown_transfer_old_list->Pager->RecordCount > 0 && $stock_godown_transfer_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_transfer_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->TotalRecs > 0 && (!$stock_godown_transfer_old_list->AutoHidePageSizeSelector || $stock_godown_transfer_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_transfer_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_transfer_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_godown_transfer_oldlist" id="fstock_godown_transfer_oldlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_godown_transfer_old_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_godown_transfer_old_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_godown_transfer_old">
<div id="gmp_stock_godown_transfer_old" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_godown_transfer_old_list->TotalRecs > 0 || $stock_godown_transfer_old->isGridEdit()) { ?>
<table id="tbl_stock_godown_transfer_oldlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_godown_transfer_old_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_godown_transfer_old_list->renderListOptions();

// Render list options (header, left)
$stock_godown_transfer_old_list->ListOptions->render("header", "left");
?>
<?php if ($stock_godown_transfer_old->product->Visible) { // product ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_godown_transfer_old->product->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_product" class="stock_godown_transfer_old_product"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_godown_transfer_old->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->product) ?>',2);"><div id="elh_stock_godown_transfer_old_product" class="stock_godown_transfer_old_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->rid->Visible) { // rid ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_godown_transfer_old->rid->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_rid" class="stock_godown_transfer_old_rid"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_godown_transfer_old->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->rid) ?>',2);"><div id="elh_stock_godown_transfer_old_rid" class="stock_godown_transfer_old_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->godown->Visible) { // godown ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_godown_transfer_old->godown->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_godown" class="stock_godown_transfer_old_godown"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_godown_transfer_old->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->godown) ?>',2);"><div id="elh_stock_godown_transfer_old_godown" class="stock_godown_transfer_old_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->IN->Visible) { // IN ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_godown_transfer_old->IN->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_IN" class="stock_godown_transfer_old_IN"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_godown_transfer_old->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->IN) ?>',2);"><div id="elh_stock_godown_transfer_old_IN" class="stock_godown_transfer_old_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->OUT->Visible) { // OUT ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_transfer_old->OUT->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_OUT" class="stock_godown_transfer_old_OUT"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_transfer_old->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->OUT) ?>',2);"><div id="elh_stock_godown_transfer_old_OUT" class="stock_godown_transfer_old_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->packets->Visible) { // packets ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_godown_transfer_old->packets->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_packets" class="stock_godown_transfer_old_packets"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_godown_transfer_old->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->packets) ?>',2);"><div id="elh_stock_godown_transfer_old_packets" class="stock_godown_transfer_old_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_transfer_old->packing_type->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_packing_type" class="stock_godown_transfer_old_packing_type"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_transfer_old->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->packing_type) ?>',2);"><div id="elh_stock_godown_transfer_old_packing_type" class="stock_godown_transfer_old_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_godown_transfer_old->lot_no->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_lot_no" class="stock_godown_transfer_old_lot_no"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_godown_transfer_old->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->lot_no) ?>',2);"><div id="elh_stock_godown_transfer_old_lot_no" class="stock_godown_transfer_old_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->dated->Visible) { // dated ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_godown_transfer_old->dated->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_dated" class="stock_godown_transfer_old_dated"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_godown_transfer_old->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->dated) ?>',2);"><div id="elh_stock_godown_transfer_old_dated" class="stock_godown_transfer_old_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->type->Visible) { // type ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_godown_transfer_old->type->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_type" class="stock_godown_transfer_old_type"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_godown_transfer_old->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->type) ?>',2);"><div id="elh_stock_godown_transfer_old_type" class="stock_godown_transfer_old_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_godown_transfer_old->tmp_lot->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_tmp_lot" class="stock_godown_transfer_old_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_godown_transfer_old->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->tmp_lot) ?>',2);"><div id="elh_stock_godown_transfer_old_tmp_lot" class="stock_godown_transfer_old_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->url->Visible) { // url ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_godown_transfer_old->url->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_url" class="stock_godown_transfer_old_url"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_godown_transfer_old->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->url) ?>',2);"><div id="elh_stock_godown_transfer_old_url" class="stock_godown_transfer_old_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer_old->age->Visible) { // age ?>
	<?php if ($stock_godown_transfer_old->sortUrl($stock_godown_transfer_old->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_godown_transfer_old->age->headerCellClass() ?>"><div id="elh_stock_godown_transfer_old_age" class="stock_godown_transfer_old_age"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_godown_transfer_old->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer_old->SortUrl($stock_godown_transfer_old->age) ?>',2);"><div id="elh_stock_godown_transfer_old_age" class="stock_godown_transfer_old_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer_old->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer_old->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer_old->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_godown_transfer_old_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_godown_transfer_old->ExportAll && $stock_godown_transfer_old->isExport()) {
	$stock_godown_transfer_old_list->StopRec = $stock_godown_transfer_old_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_godown_transfer_old_list->TotalRecs > $stock_godown_transfer_old_list->StartRec + $stock_godown_transfer_old_list->DisplayRecs - 1)
		$stock_godown_transfer_old_list->StopRec = $stock_godown_transfer_old_list->StartRec + $stock_godown_transfer_old_list->DisplayRecs - 1;
	else
		$stock_godown_transfer_old_list->StopRec = $stock_godown_transfer_old_list->TotalRecs;
}
$stock_godown_transfer_old_list->RecCnt = $stock_godown_transfer_old_list->StartRec - 1;
if ($stock_godown_transfer_old_list->Recordset && !$stock_godown_transfer_old_list->Recordset->EOF) {
	$stock_godown_transfer_old_list->Recordset->moveFirst();
	$selectLimit = $stock_godown_transfer_old_list->UseSelectLimit;
	if (!$selectLimit && $stock_godown_transfer_old_list->StartRec > 1)
		$stock_godown_transfer_old_list->Recordset->move($stock_godown_transfer_old_list->StartRec - 1);
} elseif (!$stock_godown_transfer_old->AllowAddDeleteRow && $stock_godown_transfer_old_list->StopRec == 0) {
	$stock_godown_transfer_old_list->StopRec = $stock_godown_transfer_old->GridAddRowCount;
}

// Initialize aggregate
$stock_godown_transfer_old->RowType = ROWTYPE_AGGREGATEINIT;
$stock_godown_transfer_old->resetAttributes();
$stock_godown_transfer_old_list->renderRow();
while ($stock_godown_transfer_old_list->RecCnt < $stock_godown_transfer_old_list->StopRec) {
	$stock_godown_transfer_old_list->RecCnt++;
	if ($stock_godown_transfer_old_list->RecCnt >= $stock_godown_transfer_old_list->StartRec) {
		$stock_godown_transfer_old_list->RowCnt++;

		// Set up key count
		$stock_godown_transfer_old_list->KeyCount = $stock_godown_transfer_old_list->RowIndex;

		// Init row class and style
		$stock_godown_transfer_old->resetAttributes();
		$stock_godown_transfer_old->CssClass = "";
		if ($stock_godown_transfer_old->isGridAdd()) {
		} else {
			$stock_godown_transfer_old_list->loadRowValues($stock_godown_transfer_old_list->Recordset); // Load row values
		}
		$stock_godown_transfer_old->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_godown_transfer_old->RowAttrs = array_merge($stock_godown_transfer_old->RowAttrs, array('data-rowindex'=>$stock_godown_transfer_old_list->RowCnt, 'id'=>'r' . $stock_godown_transfer_old_list->RowCnt . '_stock_godown_transfer_old', 'data-rowtype'=>$stock_godown_transfer_old->RowType));

		// Render row
		$stock_godown_transfer_old_list->renderRow();

		// Render list options
		$stock_godown_transfer_old_list->renderListOptions();
?>
	<tr<?php echo $stock_godown_transfer_old->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_godown_transfer_old_list->ListOptions->render("body", "left", $stock_godown_transfer_old_list->RowCnt);
?>
	<?php if ($stock_godown_transfer_old->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_godown_transfer_old->product->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_product" class="stock_godown_transfer_old_product">
<span<?php echo $stock_godown_transfer_old->product->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_godown_transfer_old->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_rid" class="stock_godown_transfer_old_rid">
<span<?php echo $stock_godown_transfer_old->rid->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_godown_transfer_old->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_godown" class="stock_godown_transfer_old_godown">
<span<?php echo $stock_godown_transfer_old->godown->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_godown_transfer_old->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_IN" class="stock_godown_transfer_old_IN">
<span<?php echo $stock_godown_transfer_old->IN->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_godown_transfer_old->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_OUT" class="stock_godown_transfer_old_OUT">
<span<?php echo $stock_godown_transfer_old->OUT->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_godown_transfer_old->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_packets" class="stock_godown_transfer_old_packets">
<span<?php echo $stock_godown_transfer_old->packets->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_godown_transfer_old->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_packing_type" class="stock_godown_transfer_old_packing_type">
<span<?php echo $stock_godown_transfer_old->packing_type->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_godown_transfer_old->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_lot_no" class="stock_godown_transfer_old_lot_no">
<span<?php echo $stock_godown_transfer_old->lot_no->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_godown_transfer_old->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_dated" class="stock_godown_transfer_old_dated">
<span<?php echo $stock_godown_transfer_old->dated->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_godown_transfer_old->type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_type" class="stock_godown_transfer_old_type">
<span<?php echo $stock_godown_transfer_old->type->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_godown_transfer_old->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_tmp_lot" class="stock_godown_transfer_old_tmp_lot">
<span<?php echo $stock_godown_transfer_old->tmp_lot->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_godown_transfer_old->url->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_url" class="stock_godown_transfer_old_url">
<span<?php echo $stock_godown_transfer_old->url->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer_old->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_godown_transfer_old->age->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_old_list->RowCnt ?>_stock_godown_transfer_old_age" class="stock_godown_transfer_old_age">
<span<?php echo $stock_godown_transfer_old->age->viewAttributes() ?>>
<?php echo $stock_godown_transfer_old->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_godown_transfer_old_list->ListOptions->render("body", "right", $stock_godown_transfer_old_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_godown_transfer_old->isGridAdd())
		$stock_godown_transfer_old_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_godown_transfer_old->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_godown_transfer_old_list->Recordset)
	$stock_godown_transfer_old_list->Recordset->Close();
?>
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_godown_transfer_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_transfer_old_list->Pager)) $stock_godown_transfer_old_list->Pager = new PrevNextPager($stock_godown_transfer_old_list->StartRec, $stock_godown_transfer_old_list->DisplayRecs, $stock_godown_transfer_old_list->TotalRecs, $stock_godown_transfer_old_list->AutoHidePager) ?>
<?php if ($stock_godown_transfer_old_list->Pager->RecordCount > 0 && $stock_godown_transfer_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_transfer_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_transfer_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_transfer_old_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_transfer_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_old_list->TotalRecs > 0 && (!$stock_godown_transfer_old_list->AutoHidePageSizeSelector || $stock_godown_transfer_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_transfer_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_transfer_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_transfer_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_old_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_godown_transfer_old_list->TotalRecs == 0 && !$stock_godown_transfer_old->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_godown_transfer_old_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_godown_transfer_old->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_godown_transfer_old", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_godown_transfer_old_list->terminate();
?>