<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_godown_transfer_list = new stock_godown_transfer_list();

// Run the page
$stock_godown_transfer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_godown_transfer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_godown_transfer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_godown_transferlist = currentForm = new ew.Form("fstock_godown_transferlist", "list");
fstock_godown_transferlist.formKeyCountName = '<?php echo $stock_godown_transfer_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_godown_transferlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_godown_transferlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_godown_transferlist.lists["x_godown"] = <?php echo $stock_godown_transfer_list->godown->Lookup->toClientList() ?>;
fstock_godown_transferlist.lists["x_godown"].options = <?php echo JsonEncode($stock_godown_transfer_list->godown->lookupOptions()) ?>;
fstock_godown_transferlist.lists["x_packing_type"] = <?php echo $stock_godown_transfer_list->packing_type->Lookup->toClientList() ?>;
fstock_godown_transferlist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_godown_transfer_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_godown_transferlistsrch = currentSearchForm = new ew.Form("fstock_godown_transferlistsrch");

// Filters
fstock_godown_transferlistsrch.filterList = <?php echo $stock_godown_transfer_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_godown_transferlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_godown_transfer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_godown_transfer_list->TotalRecs > 0 && $stock_godown_transfer_list->ExportOptions->visible()) { ?>
<?php $stock_godown_transfer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_list->ImportOptions->visible()) { ?>
<?php $stock_godown_transfer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_list->SearchOptions->visible()) { ?>
<?php $stock_godown_transfer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_godown_transfer_list->FilterOptions->visible()) { ?>
<?php $stock_godown_transfer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_godown_transfer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_godown_transfer->isExport() && !$stock_godown_transfer->CurrentAction) { ?>
<form name="fstock_godown_transferlistsrch" id="fstock_godown_transferlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_godown_transfer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_godown_transferlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_godown_transfer">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_godown_transfer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_godown_transfer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_godown_transfer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_godown_transfer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_godown_transfer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_godown_transfer_list->showPageHeader(); ?>
<?php
$stock_godown_transfer_list->showMessage();
?>
<?php if ($stock_godown_transfer_list->TotalRecs > 0 || $stock_godown_transfer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_godown_transfer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_godown_transfer">
<?php if (!$stock_godown_transfer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_godown_transfer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_transfer_list->Pager)) $stock_godown_transfer_list->Pager = new PrevNextPager($stock_godown_transfer_list->StartRec, $stock_godown_transfer_list->DisplayRecs, $stock_godown_transfer_list->TotalRecs, $stock_godown_transfer_list->AutoHidePager) ?>
<?php if ($stock_godown_transfer_list->Pager->RecordCount > 0 && $stock_godown_transfer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_transfer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_transfer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_transfer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_transfer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_transfer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_list->TotalRecs > 0 && (!$stock_godown_transfer_list->AutoHidePageSizeSelector || $stock_godown_transfer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_transfer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_transfer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_transfer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_transfer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_transfer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_transfer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_transfer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_godown_transferlist" id="fstock_godown_transferlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_godown_transfer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_godown_transfer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_godown_transfer">
<div id="gmp_stock_godown_transfer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_godown_transfer_list->TotalRecs > 0 || $stock_godown_transfer->isGridEdit()) { ?>
<table id="tbl_stock_godown_transferlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_godown_transfer_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_godown_transfer_list->renderListOptions();

// Render list options (header, left)
$stock_godown_transfer_list->ListOptions->render("header", "left");
?>
<?php if ($stock_godown_transfer->product->Visible) { // product ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_godown_transfer->product->headerCellClass() ?>"><div id="elh_stock_godown_transfer_product" class="stock_godown_transfer_product"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_godown_transfer->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->product) ?>',2);"><div id="elh_stock_godown_transfer_product" class="stock_godown_transfer_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->product_code->Visible) { // product_code ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_godown_transfer->product_code->headerCellClass() ?>"><div id="elh_stock_godown_transfer_product_code" class="stock_godown_transfer_product_code"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_godown_transfer->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->product_code) ?>',2);"><div id="elh_stock_godown_transfer_product_code" class="stock_godown_transfer_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->godown->Visible) { // godown ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_godown_transfer->godown->headerCellClass() ?>"><div id="elh_stock_godown_transfer_godown" class="stock_godown_transfer_godown"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_godown_transfer->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->godown) ?>',2);"><div id="elh_stock_godown_transfer_godown" class="stock_godown_transfer_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->IN->Visible) { // IN ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_godown_transfer->IN->headerCellClass() ?>"><div id="elh_stock_godown_transfer_IN" class="stock_godown_transfer_IN"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_godown_transfer->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->IN) ?>',2);"><div id="elh_stock_godown_transfer_IN" class="stock_godown_transfer_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->OUT->Visible) { // OUT ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_transfer->OUT->headerCellClass() ?>"><div id="elh_stock_godown_transfer_OUT" class="stock_godown_transfer_OUT"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_godown_transfer->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->OUT) ?>',2);"><div id="elh_stock_godown_transfer_OUT" class="stock_godown_transfer_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->packets->Visible) { // packets ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_godown_transfer->packets->headerCellClass() ?>"><div id="elh_stock_godown_transfer_packets" class="stock_godown_transfer_packets"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_godown_transfer->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->packets) ?>',2);"><div id="elh_stock_godown_transfer_packets" class="stock_godown_transfer_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_transfer->packing_type->headerCellClass() ?>"><div id="elh_stock_godown_transfer_packing_type" class="stock_godown_transfer_packing_type"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_godown_transfer->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->packing_type) ?>',2);"><div id="elh_stock_godown_transfer_packing_type" class="stock_godown_transfer_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_godown_transfer->lot_no->headerCellClass() ?>"><div id="elh_stock_godown_transfer_lot_no" class="stock_godown_transfer_lot_no"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_godown_transfer->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->lot_no) ?>',2);"><div id="elh_stock_godown_transfer_lot_no" class="stock_godown_transfer_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_godown_transfer->tmp_lot->headerCellClass() ?>"><div id="elh_stock_godown_transfer_tmp_lot" class="stock_godown_transfer_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_godown_transfer->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->tmp_lot) ?>',2);"><div id="elh_stock_godown_transfer_tmp_lot" class="stock_godown_transfer_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->url->Visible) { // url ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_godown_transfer->url->headerCellClass() ?>"><div id="elh_stock_godown_transfer_url" class="stock_godown_transfer_url"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_godown_transfer->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->url) ?>',2);"><div id="elh_stock_godown_transfer_url" class="stock_godown_transfer_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->code->Visible) { // code ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->code) == "") { ?>
		<th data-name="code" class="<?php echo $stock_godown_transfer->code->headerCellClass() ?>"><div id="elh_stock_godown_transfer_code" class="stock_godown_transfer_code"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $stock_godown_transfer->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->code) ?>',2);"><div id="elh_stock_godown_transfer_code" class="stock_godown_transfer_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->age->Visible) { // age ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_godown_transfer->age->headerCellClass() ?>"><div id="elh_stock_godown_transfer_age" class="stock_godown_transfer_age"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_godown_transfer->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->age) ?>',2);"><div id="elh_stock_godown_transfer_age" class="stock_godown_transfer_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->dated->Visible) { // dated ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_godown_transfer->dated->headerCellClass() ?>"><div id="elh_stock_godown_transfer_dated" class="stock_godown_transfer_dated"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_godown_transfer->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->dated) ?>',2);"><div id="elh_stock_godown_transfer_dated" class="stock_godown_transfer_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_godown_transfer->type->Visible) { // type ?>
	<?php if ($stock_godown_transfer->sortUrl($stock_godown_transfer->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_godown_transfer->type->headerCellClass() ?>"><div id="elh_stock_godown_transfer_type" class="stock_godown_transfer_type"><div class="ew-table-header-caption"><?php echo $stock_godown_transfer->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_godown_transfer->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_godown_transfer->SortUrl($stock_godown_transfer->type) ?>',2);"><div id="elh_stock_godown_transfer_type" class="stock_godown_transfer_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_godown_transfer->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_godown_transfer->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_godown_transfer->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_godown_transfer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_godown_transfer->ExportAll && $stock_godown_transfer->isExport()) {
	$stock_godown_transfer_list->StopRec = $stock_godown_transfer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_godown_transfer_list->TotalRecs > $stock_godown_transfer_list->StartRec + $stock_godown_transfer_list->DisplayRecs - 1)
		$stock_godown_transfer_list->StopRec = $stock_godown_transfer_list->StartRec + $stock_godown_transfer_list->DisplayRecs - 1;
	else
		$stock_godown_transfer_list->StopRec = $stock_godown_transfer_list->TotalRecs;
}
$stock_godown_transfer_list->RecCnt = $stock_godown_transfer_list->StartRec - 1;
if ($stock_godown_transfer_list->Recordset && !$stock_godown_transfer_list->Recordset->EOF) {
	$stock_godown_transfer_list->Recordset->moveFirst();
	$selectLimit = $stock_godown_transfer_list->UseSelectLimit;
	if (!$selectLimit && $stock_godown_transfer_list->StartRec > 1)
		$stock_godown_transfer_list->Recordset->move($stock_godown_transfer_list->StartRec - 1);
} elseif (!$stock_godown_transfer->AllowAddDeleteRow && $stock_godown_transfer_list->StopRec == 0) {
	$stock_godown_transfer_list->StopRec = $stock_godown_transfer->GridAddRowCount;
}

// Initialize aggregate
$stock_godown_transfer->RowType = ROWTYPE_AGGREGATEINIT;
$stock_godown_transfer->resetAttributes();
$stock_godown_transfer_list->renderRow();
while ($stock_godown_transfer_list->RecCnt < $stock_godown_transfer_list->StopRec) {
	$stock_godown_transfer_list->RecCnt++;
	if ($stock_godown_transfer_list->RecCnt >= $stock_godown_transfer_list->StartRec) {
		$stock_godown_transfer_list->RowCnt++;

		// Set up key count
		$stock_godown_transfer_list->KeyCount = $stock_godown_transfer_list->RowIndex;

		// Init row class and style
		$stock_godown_transfer->resetAttributes();
		$stock_godown_transfer->CssClass = "";
		if ($stock_godown_transfer->isGridAdd()) {
		} else {
			$stock_godown_transfer_list->loadRowValues($stock_godown_transfer_list->Recordset); // Load row values
		}
		$stock_godown_transfer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_godown_transfer->RowAttrs = array_merge($stock_godown_transfer->RowAttrs, array('data-rowindex'=>$stock_godown_transfer_list->RowCnt, 'id'=>'r' . $stock_godown_transfer_list->RowCnt . '_stock_godown_transfer', 'data-rowtype'=>$stock_godown_transfer->RowType));

		// Render row
		$stock_godown_transfer_list->renderRow();

		// Render list options
		$stock_godown_transfer_list->renderListOptions();
?>
	<tr<?php echo $stock_godown_transfer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_godown_transfer_list->ListOptions->render("body", "left", $stock_godown_transfer_list->RowCnt);
?>
	<?php if ($stock_godown_transfer->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_godown_transfer->product->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_product" class="stock_godown_transfer_product">
<span<?php echo $stock_godown_transfer->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_transfer->product->getViewValue())) && $stock_godown_transfer->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_transfer->product->linkAttributes() ?>><?php echo $stock_godown_transfer->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_transfer->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_godown_transfer->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_product_code" class="stock_godown_transfer_product_code">
<span<?php echo $stock_godown_transfer->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_transfer->product_code->getViewValue())) && $stock_godown_transfer->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_transfer->product_code->linkAttributes() ?>><?php echo $stock_godown_transfer->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_transfer->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_godown_transfer->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_godown" class="stock_godown_transfer_godown">
<span<?php echo $stock_godown_transfer->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_transfer->godown->getViewValue())) && $stock_godown_transfer->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_transfer->godown->linkAttributes() ?>><?php echo $stock_godown_transfer->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_transfer->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_godown_transfer->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_IN" class="stock_godown_transfer_IN">
<span<?php echo $stock_godown_transfer->IN->viewAttributes() ?>>
<?php echo $stock_godown_transfer->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_godown_transfer->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_OUT" class="stock_godown_transfer_OUT">
<span<?php echo $stock_godown_transfer->OUT->viewAttributes() ?>>
<?php echo $stock_godown_transfer->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_godown_transfer->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_packets" class="stock_godown_transfer_packets">
<span<?php echo $stock_godown_transfer->packets->viewAttributes() ?>>
<?php echo $stock_godown_transfer->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_godown_transfer->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_packing_type" class="stock_godown_transfer_packing_type">
<span<?php echo $stock_godown_transfer->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_transfer->packing_type->getViewValue())) && $stock_godown_transfer->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_transfer->packing_type->linkAttributes() ?>><?php echo $stock_godown_transfer->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_transfer->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_godown_transfer->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_lot_no" class="stock_godown_transfer_lot_no">
<span<?php echo $stock_godown_transfer->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_godown_transfer->lot_no->getViewValue())) && $stock_godown_transfer->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_godown_transfer->lot_no->linkAttributes() ?>><?php echo $stock_godown_transfer->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_godown_transfer->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_godown_transfer->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_tmp_lot" class="stock_godown_transfer_tmp_lot">
<span<?php echo $stock_godown_transfer->tmp_lot->viewAttributes() ?>>
<?php echo $stock_godown_transfer->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_godown_transfer->url->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_url" class="stock_godown_transfer_url">
<span<?php echo $stock_godown_transfer->url->viewAttributes() ?>>
<?php echo $stock_godown_transfer->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->code->Visible) { // code ?>
		<td data-name="code"<?php echo $stock_godown_transfer->code->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_code" class="stock_godown_transfer_code">
<span<?php echo $stock_godown_transfer->code->viewAttributes() ?>>
<?php echo $stock_godown_transfer->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_godown_transfer->age->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_age" class="stock_godown_transfer_age">
<span<?php echo $stock_godown_transfer->age->viewAttributes() ?>>
<?php echo $stock_godown_transfer->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_godown_transfer->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_dated" class="stock_godown_transfer_dated">
<span<?php echo $stock_godown_transfer->dated->viewAttributes() ?>>
<?php echo $stock_godown_transfer->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_godown_transfer->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_godown_transfer->type->cellAttributes() ?>>
<span id="el<?php echo $stock_godown_transfer_list->RowCnt ?>_stock_godown_transfer_type" class="stock_godown_transfer_type">
<span<?php echo $stock_godown_transfer->type->viewAttributes() ?>>
<?php echo $stock_godown_transfer->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_godown_transfer_list->ListOptions->render("body", "right", $stock_godown_transfer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_godown_transfer->isGridAdd())
		$stock_godown_transfer_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_godown_transfer->RowType = ROWTYPE_AGGREGATE;
$stock_godown_transfer->resetAttributes();
$stock_godown_transfer_list->renderRow();
?>
<?php if ($stock_godown_transfer_list->TotalRecs > 0 && !$stock_godown_transfer->isGridAdd() && !$stock_godown_transfer->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_godown_transfer_list->renderListOptions();

// Render list options (footer, left)
$stock_godown_transfer_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_godown_transfer->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_godown_transfer->product->footerCellClass() ?>"><span id="elf_stock_godown_transfer_product" class="stock_godown_transfer_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_godown_transfer->product_code->footerCellClass() ?>"><span id="elf_stock_godown_transfer_product_code" class="stock_godown_transfer_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_godown_transfer->godown->footerCellClass() ?>"><span id="elf_stock_godown_transfer_godown" class="stock_godown_transfer_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_godown_transfer->IN->footerCellClass() ?>"><span id="elf_stock_godown_transfer_IN" class="stock_godown_transfer_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_transfer->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_godown_transfer->OUT->footerCellClass() ?>"><span id="elf_stock_godown_transfer_OUT" class="stock_godown_transfer_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_transfer->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_godown_transfer->packets->footerCellClass() ?>"><span id="elf_stock_godown_transfer_packets" class="stock_godown_transfer_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_godown_transfer->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_godown_transfer->packing_type->footerCellClass() ?>"><span id="elf_stock_godown_transfer_packing_type" class="stock_godown_transfer_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_godown_transfer->lot_no->footerCellClass() ?>"><span id="elf_stock_godown_transfer_lot_no" class="stock_godown_transfer_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_godown_transfer->tmp_lot->footerCellClass() ?>"><span id="elf_stock_godown_transfer_tmp_lot" class="stock_godown_transfer_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->url->Visible) { // url ?>
		<td data-name="url" class="<?php echo $stock_godown_transfer->url->footerCellClass() ?>"><span id="elf_stock_godown_transfer_url" class="stock_godown_transfer_url">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->code->Visible) { // code ?>
		<td data-name="code" class="<?php echo $stock_godown_transfer->code->footerCellClass() ?>"><span id="elf_stock_godown_transfer_code" class="stock_godown_transfer_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_godown_transfer->age->footerCellClass() ?>"><span id="elf_stock_godown_transfer_age" class="stock_godown_transfer_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_godown_transfer->dated->footerCellClass() ?>"><span id="elf_stock_godown_transfer_dated" class="stock_godown_transfer_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_godown_transfer->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_godown_transfer->type->footerCellClass() ?>"><span id="elf_stock_godown_transfer_type" class="stock_godown_transfer_type">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_godown_transfer_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_godown_transfer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_godown_transfer_list->Recordset)
	$stock_godown_transfer_list->Recordset->Close();
?>
<?php if (!$stock_godown_transfer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_godown_transfer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_godown_transfer_list->Pager)) $stock_godown_transfer_list->Pager = new PrevNextPager($stock_godown_transfer_list->StartRec, $stock_godown_transfer_list->DisplayRecs, $stock_godown_transfer_list->TotalRecs, $stock_godown_transfer_list->AutoHidePager) ?>
<?php if ($stock_godown_transfer_list->Pager->RecordCount > 0 && $stock_godown_transfer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_godown_transfer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_godown_transfer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_godown_transfer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_godown_transfer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_godown_transfer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_godown_transfer_list->pageUrl() ?>start=<?php echo $stock_godown_transfer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_godown_transfer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_godown_transfer_list->TotalRecs > 0 && (!$stock_godown_transfer_list->AutoHidePageSizeSelector || $stock_godown_transfer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_godown_transfer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_godown_transfer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_godown_transfer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_godown_transfer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_godown_transfer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_godown_transfer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_godown_transfer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_godown_transfer_list->TotalRecs == 0 && !$stock_godown_transfer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_godown_transfer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_godown_transfer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_godown_transfer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_godown_transfer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_godown_transfer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_godown_transfer_list->terminate();
?>