<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_godown_transfer_search = new stock_godown_transfer_search();

// Run the page
$stock_godown_transfer_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_godown_transfer_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_godown_transfer_search->IsModal) { ?>
var fstock_godown_transfersearch = currentAdvancedSearchForm = new ew.Form("fstock_godown_transfersearch", "search");
<?php } else { ?>
var fstock_godown_transfersearch = currentForm = new ew.Form("fstock_godown_transfersearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_godown_transfersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_godown_transfersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_godown_transfersearch.lists["x_godown"] = <?php echo $stock_godown_transfer_search->godown->Lookup->toClientList() ?>;
fstock_godown_transfersearch.lists["x_godown"].options = <?php echo JsonEncode($stock_godown_transfer_search->godown->lookupOptions()) ?>;
fstock_godown_transfersearch.lists["x_packing_type"] = <?php echo $stock_godown_transfer_search->packing_type->Lookup->toClientList() ?>;
fstock_godown_transfersearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_godown_transfer_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_godown_transfersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lot_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->lot_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->age->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_godown_transfer->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_godown_transfer_search->showPageHeader(); ?>
<?php
$stock_godown_transfer_search->showMessage();
?>
<form name="fstock_godown_transfersearch" id="fstock_godown_transfersearch" class="<?php echo $stock_godown_transfer_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_godown_transfer_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_godown_transfer_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_godown_transfer">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_godown_transfer_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_godown_transfer->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_product"><?php echo $stock_godown_transfer->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->product->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_product">
<input type="text" data-table="stock_godown_transfer" data-field="x_product" name="x_product" id="x_product" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_godown_transfer->product->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->product->EditValue ?>"<?php echo $stock_godown_transfer->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_product_code"><?php echo $stock_godown_transfer->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->product_code->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_product_code">
<input type="text" data-table="stock_godown_transfer" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($stock_godown_transfer->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->product_code->EditValue ?>"<?php echo $stock_godown_transfer->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_godown"><?php echo $stock_godown_transfer->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->godown->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_godown_transfer" data-field="x_godown" data-value-separator="<?php echo $stock_godown_transfer->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_godown_transfer->godown->editAttributes() ?>>
		<?php echo $stock_godown_transfer->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_godown_transfer->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_IN"><?php echo $stock_godown_transfer->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->IN->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_IN">
<input type="text" data-table="stock_godown_transfer" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->IN->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->IN->EditValue ?>"<?php echo $stock_godown_transfer->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_OUT"><?php echo $stock_godown_transfer->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->OUT->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_OUT">
<input type="text" data-table="stock_godown_transfer" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->OUT->EditValue ?>"<?php echo $stock_godown_transfer->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_packets"><?php echo $stock_godown_transfer->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->packets->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_packets">
<input type="text" data-table="stock_godown_transfer" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->packets->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->packets->EditValue ?>"<?php echo $stock_godown_transfer->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_packing_type"><?php echo $stock_godown_transfer->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->packing_type->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_godown_transfer" data-field="x_packing_type" data-value-separator="<?php echo $stock_godown_transfer->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_godown_transfer->packing_type->editAttributes() ?>>
		<?php echo $stock_godown_transfer->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_godown_transfer->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_lot_no"><?php echo $stock_godown_transfer->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->lot_no->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_lot_no">
<input type="text" data-table="stock_godown_transfer" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->lot_no->EditValue ?>"<?php echo $stock_godown_transfer->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_tmp_lot"><?php echo $stock_godown_transfer->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->tmp_lot->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_tmp_lot">
<input type="text" data-table="stock_godown_transfer" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->tmp_lot->EditValue ?>"<?php echo $stock_godown_transfer->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_url"><?php echo $stock_godown_transfer->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->url->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_url">
<input type="text" data-table="stock_godown_transfer" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="46" placeholder="<?php echo HtmlEncode($stock_godown_transfer->url->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->url->EditValue ?>"<?php echo $stock_godown_transfer->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_code"><?php echo $stock_godown_transfer->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->code->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_code">
<input type="text" data-table="stock_godown_transfer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_godown_transfer->code->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->code->EditValue ?>"<?php echo $stock_godown_transfer->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_age"><?php echo $stock_godown_transfer->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->age->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_age">
<input type="text" data-table="stock_godown_transfer" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($stock_godown_transfer->age->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->age->EditValue ?>"<?php echo $stock_godown_transfer->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_dated"><?php echo $stock_godown_transfer->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->dated->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_dated">
<input type="text" data-table="stock_godown_transfer" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_godown_transfer->dated->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->dated->EditValue ?>"<?php echo $stock_godown_transfer->dated->editAttributes() ?>>
<?php if (!$stock_godown_transfer->dated->ReadOnly && !$stock_godown_transfer->dated->Disabled && !isset($stock_godown_transfer->dated->EditAttrs["readonly"]) && !isset($stock_godown_transfer->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_godown_transfersearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_godown_transfer->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_godown_transfer_search->LeftColumnClass ?>"><span id="elh_stock_godown_transfer_type"><?php echo $stock_godown_transfer->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_godown_transfer_search->RightColumnClass ?>"><div<?php echo $stock_godown_transfer->type->cellAttributes() ?>>
			<span id="el_stock_godown_transfer_type">
<input type="text" data-table="stock_godown_transfer" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="18" placeholder="<?php echo HtmlEncode($stock_godown_transfer->type->getPlaceHolder()) ?>" value="<?php echo $stock_godown_transfer->type->EditValue ?>"<?php echo $stock_godown_transfer->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_godown_transfer_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_godown_transfer_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_godown_transfer_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_godown_transfer_search->terminate();
?>