<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_lcgp_all_list = new stock_lcgp_all_list();

// Run the page
$stock_lcgp_all_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgp_all_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_lcgp_all->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_lcgp_alllist = currentForm = new ew.Form("fstock_lcgp_alllist", "list");
fstock_lcgp_alllist.formKeyCountName = '<?php echo $stock_lcgp_all_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_lcgp_alllist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgp_alllist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fstock_lcgp_alllistsrch = currentSearchForm = new ew.Form("fstock_lcgp_alllistsrch");

// Filters
fstock_lcgp_alllistsrch.filterList = <?php echo $stock_lcgp_all_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_lcgp_alllistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_lcgp_all->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_lcgp_all_list->TotalRecs > 0 && $stock_lcgp_all_list->ExportOptions->visible()) { ?>
<?php $stock_lcgp_all_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_all_list->ImportOptions->visible()) { ?>
<?php $stock_lcgp_all_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_all_list->SearchOptions->visible()) { ?>
<?php $stock_lcgp_all_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_all_list->FilterOptions->visible()) { ?>
<?php $stock_lcgp_all_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_lcgp_all_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_lcgp_all->isExport() && !$stock_lcgp_all->CurrentAction) { ?>
<form name="fstock_lcgp_alllistsrch" id="fstock_lcgp_alllistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_lcgp_all_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_lcgp_alllistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_lcgp_all">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_lcgp_all_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_lcgp_all_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_lcgp_all_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_lcgp_all_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_all_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_all_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_all_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_lcgp_all_list->showPageHeader(); ?>
<?php
$stock_lcgp_all_list->showMessage();
?>
<?php if ($stock_lcgp_all_list->TotalRecs > 0 || $stock_lcgp_all->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_lcgp_all_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_lcgp_all">
<?php if (!$stock_lcgp_all->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_lcgp_all->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgp_all_list->Pager)) $stock_lcgp_all_list->Pager = new PrevNextPager($stock_lcgp_all_list->StartRec, $stock_lcgp_all_list->DisplayRecs, $stock_lcgp_all_list->TotalRecs, $stock_lcgp_all_list->AutoHidePager) ?>
<?php if ($stock_lcgp_all_list->Pager->RecordCount > 0 && $stock_lcgp_all_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgp_all_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgp_all_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgp_all_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgp_all_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgp_all_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgp_all_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgp_all_list->TotalRecs > 0 && (!$stock_lcgp_all_list->AutoHidePageSizeSelector || $stock_lcgp_all_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgp_all">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgp_all_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgp_all_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgp_all_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgp_all_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgp_all_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgp_all->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_all_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_lcgp_alllist" id="fstock_lcgp_alllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_lcgp_all_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_lcgp_all_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_lcgp_all">
<div id="gmp_stock_lcgp_all" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_lcgp_all_list->TotalRecs > 0 || $stock_lcgp_all->isGridEdit()) { ?>
<table id="tbl_stock_lcgp_alllist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_lcgp_all_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_lcgp_all_list->renderListOptions();

// Render list options (header, left)
$stock_lcgp_all_list->ListOptions->render("header", "left");
?>
<?php if ($stock_lcgp_all->id->Visible) { // id ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->id) == "") { ?>
		<th data-name="id" class="<?php echo $stock_lcgp_all->id->headerCellClass() ?>"><div id="elh_stock_lcgp_all_id" class="stock_lcgp_all_id"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $stock_lcgp_all->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->id) ?>',2);"><div id="elh_stock_lcgp_all_id" class="stock_lcgp_all_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->rid->Visible) { // rid ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp_all->rid->headerCellClass() ?>"><div id="elh_stock_lcgp_all_rid" class="stock_lcgp_all_rid"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp_all->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->rid) ?>',2);"><div id="elh_stock_lcgp_all_rid" class="stock_lcgp_all_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->grp->Visible) { // grp ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp_all->grp->headerCellClass() ?>"><div id="elh_stock_lcgp_all_grp" class="stock_lcgp_all_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp_all->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->grp) ?>',2);"><div id="elh_stock_lcgp_all_grp" class="stock_lcgp_all_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp_all->s_grp->headerCellClass() ?>"><div id="elh_stock_lcgp_all_s_grp" class="stock_lcgp_all_s_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp_all->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->s_grp) ?>',2);"><div id="elh_stock_lcgp_all_s_grp" class="stock_lcgp_all_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->product->Visible) { // product ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_lcgp_all->product->headerCellClass() ?>"><div id="elh_stock_lcgp_all_product" class="stock_lcgp_all_product"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_lcgp_all->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->product) ?>',2);"><div id="elh_stock_lcgp_all_product" class="stock_lcgp_all_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->godown->Visible) { // godown ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp_all->godown->headerCellClass() ?>"><div id="elh_stock_lcgp_all_godown" class="stock_lcgp_all_godown"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp_all->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->godown) ?>',2);"><div id="elh_stock_lcgp_all_godown" class="stock_lcgp_all_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->company_id->Visible) { // company_id ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp_all->company_id->headerCellClass() ?>"><div id="elh_stock_lcgp_all_company_id" class="stock_lcgp_all_company_id"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp_all->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->company_id) ?>',2);"><div id="elh_stock_lcgp_all_company_id" class="stock_lcgp_all_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->godown_n->Visible) { // godown_n ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->godown_n) == "") { ?>
		<th data-name="godown_n" class="<?php echo $stock_lcgp_all->godown_n->headerCellClass() ?>"><div id="elh_stock_lcgp_all_godown_n" class="stock_lcgp_all_godown_n"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->godown_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_n" class="<?php echo $stock_lcgp_all->godown_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->godown_n) ?>',2);"><div id="elh_stock_lcgp_all_godown_n" class="stock_lcgp_all_godown_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->godown_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->godown_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->godown_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->IN->Visible) { // IN ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp_all->IN->headerCellClass() ?>"><div id="elh_stock_lcgp_all_IN" class="stock_lcgp_all_IN"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp_all->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->IN) ?>',2);"><div id="elh_stock_lcgp_all_IN" class="stock_lcgp_all_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->OUT->Visible) { // OUT ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp_all->OUT->headerCellClass() ?>"><div id="elh_stock_lcgp_all_OUT" class="stock_lcgp_all_OUT"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp_all->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->OUT) ?>',2);"><div id="elh_stock_lcgp_all_OUT" class="stock_lcgp_all_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->HOLD->Visible) { // HOLD ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->HOLD) == "") { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp_all->HOLD->headerCellClass() ?>"><div id="elh_stock_lcgp_all_HOLD" class="stock_lcgp_all_HOLD"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->HOLD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp_all->HOLD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->HOLD) ?>',2);"><div id="elh_stock_lcgp_all_HOLD" class="stock_lcgp_all_HOLD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->HOLD->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->HOLD->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->HOLD->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->Balance->Visible) { // Balance ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp_all->Balance->headerCellClass() ?>"><div id="elh_stock_lcgp_all_Balance" class="stock_lcgp_all_Balance"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp_all->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->Balance) ?>',2);"><div id="elh_stock_lcgp_all_Balance" class="stock_lcgp_all_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->packets->Visible) { // packets ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp_all->packets->headerCellClass() ?>"><div id="elh_stock_lcgp_all_packets" class="stock_lcgp_all_packets"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp_all->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->packets) ?>',2);"><div id="elh_stock_lcgp_all_packets" class="stock_lcgp_all_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $stock_lcgp_all->avg_quantity->headerCellClass() ?>"><div id="elh_stock_lcgp_all_avg_quantity" class="stock_lcgp_all_avg_quantity"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $stock_lcgp_all->avg_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->avg_quantity) ?>',2);"><div id="elh_stock_lcgp_all_avg_quantity" class="stock_lcgp_all_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_lcgp_all->packing_type->headerCellClass() ?>"><div id="elh_stock_lcgp_all_packing_type" class="stock_lcgp_all_packing_type"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_lcgp_all->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->packing_type) ?>',2);"><div id="elh_stock_lcgp_all_packing_type" class="stock_lcgp_all_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->packing_type_n->Visible) { // packing_type_n ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->packing_type_n) == "") { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp_all->packing_type_n->headerCellClass() ?>"><div id="elh_stock_lcgp_all_packing_type_n" class="stock_lcgp_all_packing_type_n"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->packing_type_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp_all->packing_type_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->packing_type_n) ?>',2);"><div id="elh_stock_lcgp_all_packing_type_n" class="stock_lcgp_all_packing_type_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->packing_type_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->packing_type_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->packing_type_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp_all->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgp_all_lot_no" class="stock_lcgp_all_lot_no"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp_all->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->lot_no) ?>',2);"><div id="elh_stock_lcgp_all_lot_no" class="stock_lcgp_all_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->_40->Visible) { // @ ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $stock_lcgp_all->_40->headerCellClass() ?>"><div id="elh_stock_lcgp_all__40" class="stock_lcgp_all__40"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $stock_lcgp_all->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->_40) ?>',2);"><div id="elh_stock_lcgp_all__40" class="stock_lcgp_all__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp_all->age->Visible) { // age ?>
	<?php if ($stock_lcgp_all->sortUrl($stock_lcgp_all->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_lcgp_all->age->headerCellClass() ?>"><div id="elh_stock_lcgp_all_age" class="stock_lcgp_all_age"><div class="ew-table-header-caption"><?php echo $stock_lcgp_all->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_lcgp_all->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp_all->SortUrl($stock_lcgp_all->age) ?>',2);"><div id="elh_stock_lcgp_all_age" class="stock_lcgp_all_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp_all->age->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_all->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_all->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_lcgp_all_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_lcgp_all->ExportAll && $stock_lcgp_all->isExport()) {
	$stock_lcgp_all_list->StopRec = $stock_lcgp_all_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_lcgp_all_list->TotalRecs > $stock_lcgp_all_list->StartRec + $stock_lcgp_all_list->DisplayRecs - 1)
		$stock_lcgp_all_list->StopRec = $stock_lcgp_all_list->StartRec + $stock_lcgp_all_list->DisplayRecs - 1;
	else
		$stock_lcgp_all_list->StopRec = $stock_lcgp_all_list->TotalRecs;
}
$stock_lcgp_all_list->RecCnt = $stock_lcgp_all_list->StartRec - 1;
if ($stock_lcgp_all_list->Recordset && !$stock_lcgp_all_list->Recordset->EOF) {
	$stock_lcgp_all_list->Recordset->moveFirst();
	$selectLimit = $stock_lcgp_all_list->UseSelectLimit;
	if (!$selectLimit && $stock_lcgp_all_list->StartRec > 1)
		$stock_lcgp_all_list->Recordset->move($stock_lcgp_all_list->StartRec - 1);
} elseif (!$stock_lcgp_all->AllowAddDeleteRow && $stock_lcgp_all_list->StopRec == 0) {
	$stock_lcgp_all_list->StopRec = $stock_lcgp_all->GridAddRowCount;
}

// Initialize aggregate
$stock_lcgp_all->RowType = ROWTYPE_AGGREGATEINIT;
$stock_lcgp_all->resetAttributes();
$stock_lcgp_all_list->renderRow();
while ($stock_lcgp_all_list->RecCnt < $stock_lcgp_all_list->StopRec) {
	$stock_lcgp_all_list->RecCnt++;
	if ($stock_lcgp_all_list->RecCnt >= $stock_lcgp_all_list->StartRec) {
		$stock_lcgp_all_list->RowCnt++;

		// Set up key count
		$stock_lcgp_all_list->KeyCount = $stock_lcgp_all_list->RowIndex;

		// Init row class and style
		$stock_lcgp_all->resetAttributes();
		$stock_lcgp_all->CssClass = "";
		if ($stock_lcgp_all->isGridAdd()) {
		} else {
			$stock_lcgp_all_list->loadRowValues($stock_lcgp_all_list->Recordset); // Load row values
		}
		$stock_lcgp_all->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_lcgp_all->RowAttrs = array_merge($stock_lcgp_all->RowAttrs, array('data-rowindex'=>$stock_lcgp_all_list->RowCnt, 'id'=>'r' . $stock_lcgp_all_list->RowCnt . '_stock_lcgp_all', 'data-rowtype'=>$stock_lcgp_all->RowType));

		// Render row
		$stock_lcgp_all_list->renderRow();

		// Render list options
		$stock_lcgp_all_list->renderListOptions();
?>
	<tr<?php echo $stock_lcgp_all->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgp_all_list->ListOptions->render("body", "left", $stock_lcgp_all_list->RowCnt);
?>
	<?php if ($stock_lcgp_all->id->Visible) { // id ?>
		<td data-name="id"<?php echo $stock_lcgp_all->id->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_id" class="stock_lcgp_all_id">
<span<?php echo $stock_lcgp_all->id->viewAttributes() ?>>
<?php echo $stock_lcgp_all->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_lcgp_all->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_rid" class="stock_lcgp_all_rid">
<span<?php echo $stock_lcgp_all->rid->viewAttributes() ?>>
<?php echo $stock_lcgp_all->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $stock_lcgp_all->grp->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_grp" class="stock_lcgp_all_grp">
<span<?php echo $stock_lcgp_all->grp->viewAttributes() ?>>
<?php echo $stock_lcgp_all->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $stock_lcgp_all->s_grp->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_s_grp" class="stock_lcgp_all_s_grp">
<span<?php echo $stock_lcgp_all->s_grp->viewAttributes() ?>>
<?php echo $stock_lcgp_all->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_lcgp_all->product->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_product" class="stock_lcgp_all_product">
<span<?php echo $stock_lcgp_all->product->viewAttributes() ?>>
<?php echo $stock_lcgp_all->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_lcgp_all->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_godown" class="stock_lcgp_all_godown">
<span<?php echo $stock_lcgp_all->godown->viewAttributes() ?>>
<?php echo $stock_lcgp_all->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_lcgp_all->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_company_id" class="stock_lcgp_all_company_id">
<span<?php echo $stock_lcgp_all->company_id->viewAttributes() ?>>
<?php echo $stock_lcgp_all->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->godown_n->Visible) { // godown_n ?>
		<td data-name="godown_n"<?php echo $stock_lcgp_all->godown_n->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_godown_n" class="stock_lcgp_all_godown_n">
<span<?php echo $stock_lcgp_all->godown_n->viewAttributes() ?>>
<?php echo $stock_lcgp_all->godown_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_lcgp_all->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_IN" class="stock_lcgp_all_IN">
<span<?php echo $stock_lcgp_all->IN->viewAttributes() ?>>
<?php echo $stock_lcgp_all->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_lcgp_all->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_OUT" class="stock_lcgp_all_OUT">
<span<?php echo $stock_lcgp_all->OUT->viewAttributes() ?>>
<?php echo $stock_lcgp_all->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD"<?php echo $stock_lcgp_all->HOLD->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_HOLD" class="stock_lcgp_all_HOLD">
<span<?php echo $stock_lcgp_all->HOLD->viewAttributes() ?>>
<?php echo $stock_lcgp_all->HOLD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_lcgp_all->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_Balance" class="stock_lcgp_all_Balance">
<span<?php echo $stock_lcgp_all->Balance->viewAttributes() ?>>
<?php echo $stock_lcgp_all->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_lcgp_all->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_packets" class="stock_lcgp_all_packets">
<span<?php echo $stock_lcgp_all->packets->viewAttributes() ?>>
<?php echo $stock_lcgp_all->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $stock_lcgp_all->avg_quantity->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_avg_quantity" class="stock_lcgp_all_avg_quantity">
<span<?php echo $stock_lcgp_all->avg_quantity->viewAttributes() ?>>
<?php echo $stock_lcgp_all->avg_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_lcgp_all->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_packing_type" class="stock_lcgp_all_packing_type">
<span<?php echo $stock_lcgp_all->packing_type->viewAttributes() ?>>
<?php echo $stock_lcgp_all->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n"<?php echo $stock_lcgp_all->packing_type_n->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_packing_type_n" class="stock_lcgp_all_packing_type_n">
<span<?php echo $stock_lcgp_all->packing_type_n->viewAttributes() ?>>
<?php echo $stock_lcgp_all->packing_type_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_lcgp_all->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_lot_no" class="stock_lcgp_all_lot_no">
<span<?php echo $stock_lcgp_all->lot_no->viewAttributes() ?>>
<?php echo $stock_lcgp_all->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $stock_lcgp_all->_40->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all__40" class="stock_lcgp_all__40">
<span<?php echo $stock_lcgp_all->_40->viewAttributes() ?>>
<?php echo $stock_lcgp_all->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp_all->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_lcgp_all->age->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_all_list->RowCnt ?>_stock_lcgp_all_age" class="stock_lcgp_all_age">
<span<?php echo $stock_lcgp_all->age->viewAttributes() ?>>
<?php echo $stock_lcgp_all->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgp_all_list->ListOptions->render("body", "right", $stock_lcgp_all_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_lcgp_all->isGridAdd())
		$stock_lcgp_all_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_lcgp_all->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_lcgp_all_list->Recordset)
	$stock_lcgp_all_list->Recordset->Close();
?>
<?php if (!$stock_lcgp_all->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_lcgp_all->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgp_all_list->Pager)) $stock_lcgp_all_list->Pager = new PrevNextPager($stock_lcgp_all_list->StartRec, $stock_lcgp_all_list->DisplayRecs, $stock_lcgp_all_list->TotalRecs, $stock_lcgp_all_list->AutoHidePager) ?>
<?php if ($stock_lcgp_all_list->Pager->RecordCount > 0 && $stock_lcgp_all_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgp_all_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgp_all_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgp_all_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgp_all_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgp_all_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgp_all_list->pageUrl() ?>start=<?php echo $stock_lcgp_all_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgp_all_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgp_all_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgp_all_list->TotalRecs > 0 && (!$stock_lcgp_all_list->AutoHidePageSizeSelector || $stock_lcgp_all_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgp_all">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgp_all_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgp_all_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgp_all_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgp_all_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgp_all_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgp_all->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_all_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_lcgp_all_list->TotalRecs == 0 && !$stock_lcgp_all->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_all_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_lcgp_all_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_lcgp_all->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_lcgp_all->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_lcgp_all", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_lcgp_all_list->terminate();
?>