<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_lcgpd_list = new stock_lcgpd_list();

// Run the page
$stock_lcgpd_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgpd_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_lcgpd->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_lcgpdlist = currentForm = new ew.Form("fstock_lcgpdlist", "list");
fstock_lcgpdlist.formKeyCountName = '<?php echo $stock_lcgpd_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_lcgpdlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgpdlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgpdlist.lists["x_product"] = <?php echo $stock_lcgpd_list->product->Lookup->toClientList() ?>;
fstock_lcgpdlist.lists["x_product"].options = <?php echo JsonEncode($stock_lcgpd_list->product->lookupOptions()) ?>;
fstock_lcgpdlist.lists["x_godown"] = <?php echo $stock_lcgpd_list->godown->Lookup->toClientList() ?>;
fstock_lcgpdlist.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgpd_list->godown->lookupOptions()) ?>;
fstock_lcgpdlist.lists["x_packing_type"] = <?php echo $stock_lcgpd_list->packing_type->Lookup->toClientList() ?>;
fstock_lcgpdlist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_lcgpd_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_lcgpdlistsrch = currentSearchForm = new ew.Form("fstock_lcgpdlistsrch");

// Validate function for search
fstock_lcgpdlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgpd->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_lcgpdlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgpdlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgpdlistsrch.lists["x_product"] = <?php echo $stock_lcgpd_list->product->Lookup->toClientList() ?>;
fstock_lcgpdlistsrch.lists["x_product"].options = <?php echo JsonEncode($stock_lcgpd_list->product->lookupOptions()) ?>;
fstock_lcgpdlistsrch.lists["x_godown"] = <?php echo $stock_lcgpd_list->godown->Lookup->toClientList() ?>;
fstock_lcgpdlistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgpd_list->godown->lookupOptions()) ?>;

// Filters
fstock_lcgpdlistsrch.filterList = <?php echo $stock_lcgpd_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_lcgpdlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_lcgpd->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_lcgpd_list->TotalRecs > 0 && $stock_lcgpd_list->ExportOptions->visible()) { ?>
<?php $stock_lcgpd_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgpd_list->ImportOptions->visible()) { ?>
<?php $stock_lcgpd_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgpd_list->SearchOptions->visible()) { ?>
<?php $stock_lcgpd_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgpd_list->FilterOptions->visible()) { ?>
<?php $stock_lcgpd_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_lcgpd_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_lcgpd->isExport() && !$stock_lcgpd->CurrentAction) { ?>
<form name="fstock_lcgpdlistsrch" id="fstock_lcgpdlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_lcgpd_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_lcgpdlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_lcgpd">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_lcgpd_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_lcgpd->RowType = ROWTYPE_SEARCH;

// Render row
$stock_lcgpd->resetAttributes();
$stock_lcgpd_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_lcgpd->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $stock_lcgpd->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgpd" data-field="x_product" data-value-separator="<?php echo $stock_lcgpd->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_lcgpd->product->editAttributes() ?>>
		<?php echo $stock_lcgpd->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_lcgpd->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgpd->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_lcgpd->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgpd" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgpd->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgpd->product_code->EditValue ?>"<?php echo $stock_lcgpd->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgpd->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_lcgpd->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgpd" data-field="x_godown" data-value-separator="<?php echo $stock_lcgpd->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_lcgpd->godown->editAttributes() ?>>
		<?php echo $stock_lcgpd->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_lcgpd->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_lcgpd->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $stock_lcgpd->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_lcgpd->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgpd" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_lcgpd->dated->getPlaceHolder()) ?>" value="<?php echo $stock_lcgpd->dated->EditValue ?>"<?php echo $stock_lcgpd->dated->editAttributes() ?>>
<?php if (!$stock_lcgpd->dated->ReadOnly && !$stock_lcgpd->dated->Disabled && !isset($stock_lcgpd->dated->EditAttrs["readonly"]) && !isset($stock_lcgpd->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_lcgpdlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="stock_lcgpd" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_lcgpd->dated->getPlaceHolder()) ?>" value="<?php echo $stock_lcgpd->dated->EditValue2 ?>"<?php echo $stock_lcgpd->dated->editAttributes() ?>>
<?php if (!$stock_lcgpd->dated->ReadOnly && !$stock_lcgpd->dated->Disabled && !isset($stock_lcgpd->dated->EditAttrs["readonly"]) && !isset($stock_lcgpd->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_lcgpdlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgpd->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $stock_lcgpd->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgpd" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($stock_lcgpd->type->getPlaceHolder()) ?>" value="<?php echo $stock_lcgpd->type->EditValue ?>"<?php echo $stock_lcgpd->type->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_lcgpd_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_lcgpd_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_lcgpd_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_lcgpd_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgpd_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgpd_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgpd_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_lcgpd_list->showPageHeader(); ?>
<?php
$stock_lcgpd_list->showMessage();
?>
<?php if ($stock_lcgpd_list->TotalRecs > 0 || $stock_lcgpd->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_lcgpd_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_lcgpd">
<?php if (!$stock_lcgpd->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_lcgpd->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgpd_list->Pager)) $stock_lcgpd_list->Pager = new PrevNextPager($stock_lcgpd_list->StartRec, $stock_lcgpd_list->DisplayRecs, $stock_lcgpd_list->TotalRecs, $stock_lcgpd_list->AutoHidePager) ?>
<?php if ($stock_lcgpd_list->Pager->RecordCount > 0 && $stock_lcgpd_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgpd_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgpd_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgpd_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgpd_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgpd_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgpd_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgpd_list->TotalRecs > 0 && (!$stock_lcgpd_list->AutoHidePageSizeSelector || $stock_lcgpd_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgpd">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgpd_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgpd_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgpd_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgpd_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgpd_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgpd->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgpd_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_lcgpdlist" id="fstock_lcgpdlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_lcgpd_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_lcgpd_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_lcgpd">
<div id="gmp_stock_lcgpd" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_lcgpd_list->TotalRecs > 0 || $stock_lcgpd->isGridEdit()) { ?>
<table id="tbl_stock_lcgpdlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_lcgpd_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_lcgpd_list->renderListOptions();

// Render list options (header, left)
$stock_lcgpd_list->ListOptions->render("header", "left");
?>
<?php if ($stock_lcgpd->product->Visible) { // product ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_lcgpd->product->headerCellClass() ?>"><div id="elh_stock_lcgpd_product" class="stock_lcgpd_product"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_lcgpd->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->product) ?>',2);"><div id="elh_stock_lcgpd_product" class="stock_lcgpd_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->product_code->Visible) { // product_code ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgpd->product_code->headerCellClass() ?>"><div id="elh_stock_lcgpd_product_code" class="stock_lcgpd_product_code"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgpd->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->product_code) ?>',2);"><div id="elh_stock_lcgpd_product_code" class="stock_lcgpd_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->godown->Visible) { // godown ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_lcgpd->godown->headerCellClass() ?>"><div id="elh_stock_lcgpd_godown" class="stock_lcgpd_godown"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_lcgpd->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->godown) ?>',2);"><div id="elh_stock_lcgpd_godown" class="stock_lcgpd_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->IN->Visible) { // IN ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_lcgpd->IN->headerCellClass() ?>"><div id="elh_stock_lcgpd_IN" class="stock_lcgpd_IN"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_lcgpd->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->IN) ?>',2);"><div id="elh_stock_lcgpd_IN" class="stock_lcgpd_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->OUT->Visible) { // OUT ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgpd->OUT->headerCellClass() ?>"><div id="elh_stock_lcgpd_OUT" class="stock_lcgpd_OUT"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgpd->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->OUT) ?>',2);"><div id="elh_stock_lcgpd_OUT" class="stock_lcgpd_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->Balance->Visible) { // Balance ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgpd->Balance->headerCellClass() ?>"><div id="elh_stock_lcgpd_Balance" class="stock_lcgpd_Balance"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgpd->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->Balance) ?>',2);"><div id="elh_stock_lcgpd_Balance" class="stock_lcgpd_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->packets->Visible) { // packets ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_lcgpd->packets->headerCellClass() ?>"><div id="elh_stock_lcgpd_packets" class="stock_lcgpd_packets"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_lcgpd->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->packets) ?>',2);"><div id="elh_stock_lcgpd_packets" class="stock_lcgpd_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_lcgpd->packing_type->headerCellClass() ?>"><div id="elh_stock_lcgpd_packing_type" class="stock_lcgpd_packing_type"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_lcgpd->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->packing_type) ?>',2);"><div id="elh_stock_lcgpd_packing_type" class="stock_lcgpd_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgpd->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgpd_lot_no" class="stock_lcgpd_lot_no"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgpd->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->lot_no) ?>',2);"><div id="elh_stock_lcgpd_lot_no" class="stock_lcgpd_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->dated->Visible) { // dated ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_lcgpd->dated->headerCellClass() ?>"><div id="elh_stock_lcgpd_dated" class="stock_lcgpd_dated"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_lcgpd->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->dated) ?>',2);"><div id="elh_stock_lcgpd_dated" class="stock_lcgpd_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->type->Visible) { // type ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_lcgpd->type->headerCellClass() ?>"><div id="elh_stock_lcgpd_type" class="stock_lcgpd_type"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_lcgpd->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->type) ?>',2);"><div id="elh_stock_lcgpd_type" class="stock_lcgpd_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->age->Visible) { // age ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_lcgpd->age->headerCellClass() ?>"><div id="elh_stock_lcgpd_age" class="stock_lcgpd_age"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_lcgpd->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->age) ?>',2);"><div id="elh_stock_lcgpd_age" class="stock_lcgpd_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgpd->company_id->Visible) { // company_id ?>
	<?php if ($stock_lcgpd->sortUrl($stock_lcgpd->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgpd->company_id->headerCellClass() ?>"><div id="elh_stock_lcgpd_company_id" class="stock_lcgpd_company_id"><div class="ew-table-header-caption"><?php echo $stock_lcgpd->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgpd->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgpd->SortUrl($stock_lcgpd->company_id) ?>',2);"><div id="elh_stock_lcgpd_company_id" class="stock_lcgpd_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgpd->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgpd->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgpd->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_lcgpd_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_lcgpd->ExportAll && $stock_lcgpd->isExport()) {
	$stock_lcgpd_list->StopRec = $stock_lcgpd_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_lcgpd_list->TotalRecs > $stock_lcgpd_list->StartRec + $stock_lcgpd_list->DisplayRecs - 1)
		$stock_lcgpd_list->StopRec = $stock_lcgpd_list->StartRec + $stock_lcgpd_list->DisplayRecs - 1;
	else
		$stock_lcgpd_list->StopRec = $stock_lcgpd_list->TotalRecs;
}
$stock_lcgpd_list->RecCnt = $stock_lcgpd_list->StartRec - 1;
if ($stock_lcgpd_list->Recordset && !$stock_lcgpd_list->Recordset->EOF) {
	$stock_lcgpd_list->Recordset->moveFirst();
	$selectLimit = $stock_lcgpd_list->UseSelectLimit;
	if (!$selectLimit && $stock_lcgpd_list->StartRec > 1)
		$stock_lcgpd_list->Recordset->move($stock_lcgpd_list->StartRec - 1);
} elseif (!$stock_lcgpd->AllowAddDeleteRow && $stock_lcgpd_list->StopRec == 0) {
	$stock_lcgpd_list->StopRec = $stock_lcgpd->GridAddRowCount;
}

// Initialize aggregate
$stock_lcgpd->RowType = ROWTYPE_AGGREGATEINIT;
$stock_lcgpd->resetAttributes();
$stock_lcgpd_list->renderRow();
while ($stock_lcgpd_list->RecCnt < $stock_lcgpd_list->StopRec) {
	$stock_lcgpd_list->RecCnt++;
	if ($stock_lcgpd_list->RecCnt >= $stock_lcgpd_list->StartRec) {
		$stock_lcgpd_list->RowCnt++;

		// Set up key count
		$stock_lcgpd_list->KeyCount = $stock_lcgpd_list->RowIndex;

		// Init row class and style
		$stock_lcgpd->resetAttributes();
		$stock_lcgpd->CssClass = "";
		if ($stock_lcgpd->isGridAdd()) {
		} else {
			$stock_lcgpd_list->loadRowValues($stock_lcgpd_list->Recordset); // Load row values
		}
		$stock_lcgpd->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_lcgpd->RowAttrs = array_merge($stock_lcgpd->RowAttrs, array('data-rowindex'=>$stock_lcgpd_list->RowCnt, 'id'=>'r' . $stock_lcgpd_list->RowCnt . '_stock_lcgpd', 'data-rowtype'=>$stock_lcgpd->RowType));

		// Render row
		$stock_lcgpd_list->renderRow();

		// Render list options
		$stock_lcgpd_list->renderListOptions();
?>
	<tr<?php echo $stock_lcgpd->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgpd_list->ListOptions->render("body", "left", $stock_lcgpd_list->RowCnt);
?>
	<?php if ($stock_lcgpd->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_lcgpd->product->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_product" class="stock_lcgpd_product">
<span<?php echo $stock_lcgpd->product->viewAttributes() ?>>
<?php echo $stock_lcgpd->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_lcgpd->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_product_code" class="stock_lcgpd_product_code">
<span<?php echo $stock_lcgpd->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgpd->product_code->getViewValue())) && $stock_lcgpd->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgpd->product_code->linkAttributes() ?>><?php echo $stock_lcgpd->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgpd->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_lcgpd->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_godown" class="stock_lcgpd_godown">
<span<?php echo $stock_lcgpd->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgpd->godown->getViewValue())) && $stock_lcgpd->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgpd->godown->linkAttributes() ?>><?php echo $stock_lcgpd->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgpd->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_lcgpd->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_IN" class="stock_lcgpd_IN">
<span<?php echo $stock_lcgpd->IN->viewAttributes() ?>>
<?php echo $stock_lcgpd->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_lcgpd->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_OUT" class="stock_lcgpd_OUT">
<span<?php echo $stock_lcgpd->OUT->viewAttributes() ?>>
<?php echo $stock_lcgpd->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_lcgpd->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_Balance" class="stock_lcgpd_Balance">
<span<?php echo $stock_lcgpd->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgpd->Balance->getViewValue())) && $stock_lcgpd->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgpd->Balance->linkAttributes() ?>><?php echo $stock_lcgpd->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgpd->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_lcgpd->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_packets" class="stock_lcgpd_packets">
<span<?php echo $stock_lcgpd->packets->viewAttributes() ?>>
<?php echo $stock_lcgpd->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_lcgpd->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_packing_type" class="stock_lcgpd_packing_type">
<span<?php echo $stock_lcgpd->packing_type->viewAttributes() ?>>
<?php echo $stock_lcgpd->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_lcgpd->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_lot_no" class="stock_lcgpd_lot_no">
<span<?php echo $stock_lcgpd->lot_no->viewAttributes() ?>>
<?php echo $stock_lcgpd->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_lcgpd->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_dated" class="stock_lcgpd_dated">
<span<?php echo $stock_lcgpd->dated->viewAttributes() ?>>
<?php echo $stock_lcgpd->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_lcgpd->type->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_type" class="stock_lcgpd_type">
<span<?php echo $stock_lcgpd->type->viewAttributes() ?>>
<?php echo $stock_lcgpd->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_lcgpd->age->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_age" class="stock_lcgpd_age">
<span<?php echo $stock_lcgpd->age->viewAttributes() ?>>
<?php echo $stock_lcgpd->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgpd->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_lcgpd->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgpd_list->RowCnt ?>_stock_lcgpd_company_id" class="stock_lcgpd_company_id">
<span<?php echo $stock_lcgpd->company_id->viewAttributes() ?>>
<?php echo $stock_lcgpd->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgpd_list->ListOptions->render("body", "right", $stock_lcgpd_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_lcgpd->isGridAdd())
		$stock_lcgpd_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_lcgpd->RowType = ROWTYPE_AGGREGATE;
$stock_lcgpd->resetAttributes();
$stock_lcgpd_list->renderRow();
?>
<?php if ($stock_lcgpd_list->TotalRecs > 0 && !$stock_lcgpd->isGridAdd() && !$stock_lcgpd->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_lcgpd_list->renderListOptions();

// Render list options (footer, left)
$stock_lcgpd_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_lcgpd->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_lcgpd->product->footerCellClass() ?>"><span id="elf_stock_lcgpd_product" class="stock_lcgpd_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_lcgpd->product_code->footerCellClass() ?>"><span id="elf_stock_lcgpd_product_code" class="stock_lcgpd_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_lcgpd->godown->footerCellClass() ?>"><span id="elf_stock_lcgpd_godown" class="stock_lcgpd_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_lcgpd->IN->footerCellClass() ?>"><span id="elf_stock_lcgpd_IN" class="stock_lcgpd_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgpd->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_lcgpd->OUT->footerCellClass() ?>"><span id="elf_stock_lcgpd_OUT" class="stock_lcgpd_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgpd->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_lcgpd->Balance->footerCellClass() ?>"><span id="elf_stock_lcgpd_Balance" class="stock_lcgpd_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgpd->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_lcgpd->packets->footerCellClass() ?>"><span id="elf_stock_lcgpd_packets" class="stock_lcgpd_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_lcgpd->packing_type->footerCellClass() ?>"><span id="elf_stock_lcgpd_packing_type" class="stock_lcgpd_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_lcgpd->lot_no->footerCellClass() ?>"><span id="elf_stock_lcgpd_lot_no" class="stock_lcgpd_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_lcgpd->dated->footerCellClass() ?>"><span id="elf_stock_lcgpd_dated" class="stock_lcgpd_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_lcgpd->type->footerCellClass() ?>"><span id="elf_stock_lcgpd_type" class="stock_lcgpd_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_lcgpd->age->footerCellClass() ?>"><span id="elf_stock_lcgpd_age" class="stock_lcgpd_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgpd->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_lcgpd->company_id->footerCellClass() ?>"><span id="elf_stock_lcgpd_company_id" class="stock_lcgpd_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_lcgpd_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_lcgpd->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_lcgpd_list->Recordset)
	$stock_lcgpd_list->Recordset->Close();
?>
<?php if (!$stock_lcgpd->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_lcgpd->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgpd_list->Pager)) $stock_lcgpd_list->Pager = new PrevNextPager($stock_lcgpd_list->StartRec, $stock_lcgpd_list->DisplayRecs, $stock_lcgpd_list->TotalRecs, $stock_lcgpd_list->AutoHidePager) ?>
<?php if ($stock_lcgpd_list->Pager->RecordCount > 0 && $stock_lcgpd_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgpd_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgpd_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgpd_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgpd_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgpd_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgpd_list->pageUrl() ?>start=<?php echo $stock_lcgpd_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgpd_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgpd_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgpd_list->TotalRecs > 0 && (!$stock_lcgpd_list->AutoHidePageSizeSelector || $stock_lcgpd_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgpd">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgpd_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgpd_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgpd_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgpd_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgpd_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgpd->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgpd_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_lcgpd_list->TotalRecs == 0 && !$stock_lcgpd->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_lcgpd_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_lcgpd_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_lcgpd->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_lcgpd->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_lcgpd", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_lcgpd_list->terminate();
?>