<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($stock_lcgp_grid))
	$stock_lcgp_grid = new stock_lcgp_grid();

// Run the page
$stock_lcgp_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgp_grid->Page_Render();
?>
<?php if (!$stock_lcgp->isExport()) { ?>
<script>

// Form object
var fstock_lcgpgrid = new ew.Form("fstock_lcgpgrid", "grid");
fstock_lcgpgrid.formKeyCountName = '<?php echo $stock_lcgp_grid->FormKeyCountName ?>';

// Validate form
fstock_lcgpgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($stock_lcgp_grid->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->rid->caption(), $stock_lcgp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->rid->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->grp->caption(), $stock_lcgp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->product->caption(), $stock_lcgp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->product_code->caption(), $stock_lcgp->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->godown->caption(), $stock_lcgp->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->IN->Required) { ?>
			elm = this.getElements("x" + infix + "_IN");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->IN->caption(), $stock_lcgp->IN->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_IN");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->IN->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->OUT->Required) { ?>
			elm = this.getElements("x" + infix + "_OUT");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->OUT->caption(), $stock_lcgp->OUT->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_OUT");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->OUT->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->Balance->Required) { ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->Balance->caption(), $stock_lcgp->Balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->Balance->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->packets->caption(), $stock_lcgp->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->packets->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->packing_type_n->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type_n");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->packing_type_n->caption(), $stock_lcgp->packing_type_n->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->lot_no->caption(), $stock_lcgp->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->HOLD->Required) { ?>
			elm = this.getElements("x" + infix + "_HOLD");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->HOLD->caption(), $stock_lcgp->HOLD->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HOLD");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->HOLD->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->age->Required) { ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->age->caption(), $stock_lcgp->age->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->age->errorMessage()) ?>");
		<?php if ($stock_lcgp_grid->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->company_id->caption(), $stock_lcgp->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_lcgp_grid->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_lcgp->s_grp->caption(), $stock_lcgp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_lcgp->s_grp->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fstock_lcgpgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "product_code", false)) return false;
	if (ew.valueChanged(fobj, infix, "godown", false)) return false;
	if (ew.valueChanged(fobj, infix, "IN", false)) return false;
	if (ew.valueChanged(fobj, infix, "OUT", false)) return false;
	if (ew.valueChanged(fobj, infix, "Balance", false)) return false;
	if (ew.valueChanged(fobj, infix, "packets", false)) return false;
	if (ew.valueChanged(fobj, infix, "packing_type_n", false)) return false;
	if (ew.valueChanged(fobj, infix, "lot_no", false)) return false;
	if (ew.valueChanged(fobj, infix, "HOLD", false)) return false;
	if (ew.valueChanged(fobj, infix, "age", false)) return false;
	if (ew.valueChanged(fobj, infix, "company_id", false)) return false;
	if (ew.valueChanged(fobj, infix, "s_grp", false)) return false;
	return true;
}

// Form_CustomValidate event
fstock_lcgpgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgpgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgpgrid.lists["x_grp"] = <?php echo $stock_lcgp_grid->grp->Lookup->toClientList() ?>;
fstock_lcgpgrid.lists["x_grp"].options = <?php echo JsonEncode($stock_lcgp_grid->grp->lookupOptions()) ?>;
fstock_lcgpgrid.lists["x_product"] = <?php echo $stock_lcgp_grid->product->Lookup->toClientList() ?>;
fstock_lcgpgrid.lists["x_product"].options = <?php echo JsonEncode($stock_lcgp_grid->product->lookupOptions()) ?>;
fstock_lcgpgrid.lists["x_godown"] = <?php echo $stock_lcgp_grid->godown->Lookup->toClientList() ?>;
fstock_lcgpgrid.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgp_grid->godown->lookupOptions()) ?>;
fstock_lcgpgrid.lists["x_company_id"] = <?php echo $stock_lcgp_grid->company_id->Lookup->toClientList() ?>;
fstock_lcgpgrid.lists["x_company_id"].options = <?php echo JsonEncode($stock_lcgp_grid->company_id->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$stock_lcgp_grid->renderOtherOptions();
?>
<?php $stock_lcgp_grid->showPageHeader(); ?>
<?php
$stock_lcgp_grid->showMessage();
?>
<?php if ($stock_lcgp_grid->TotalRecs > 0 || $stock_lcgp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_lcgp_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_lcgp">
<?php if ($stock_lcgp_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $stock_lcgp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fstock_lcgpgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_stock_lcgp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_stock_lcgpgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_lcgp_grid->RowType = ROWTYPE_HEADER;

// Render list options
$stock_lcgp_grid->renderListOptions();

// Render list options (header, left)
$stock_lcgp_grid->ListOptions->render("header", "left");
?>
<?php if ($stock_lcgp->rid->Visible) { // rid ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid"><div class="ew-table-header-caption"><?php echo $stock_lcgp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><div><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><div id="elh_stock_lcgp_product" class="stock_lcgp_product"><div class="ew-table-header-caption"><?php echo $stock_lcgp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><div><div id="elh_stock_lcgp_product" class="stock_lcgp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code"><div class="ew-table-header-caption"><?php echo $stock_lcgp->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><div><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown"><div class="ew-table-header-caption"><?php echo $stock_lcgp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><div><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN"><div class="ew-table-header-caption"><?php echo $stock_lcgp->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><div><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT"><div class="ew-table-header-caption"><?php echo $stock_lcgp->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><div><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance"><div class="ew-table-header-caption"><?php echo $stock_lcgp->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><div><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets"><div class="ew-table-header-caption"><?php echo $stock_lcgp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><div><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->packing_type_n) == "") { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n"><div class="ew-table-header-caption"><?php echo $stock_lcgp->packing_type_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><div><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packing_type_n->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->packing_type_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->packing_type_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no"><div class="ew-table-header-caption"><?php echo $stock_lcgp->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><div><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->HOLD) == "") { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD"><div class="ew-table-header-caption"><?php echo $stock_lcgp->HOLD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><div><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->HOLD->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->HOLD->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->HOLD->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><div id="elh_stock_lcgp_age" class="stock_lcgp_age"><div class="ew-table-header-caption"><?php echo $stock_lcgp->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><div><div id="elh_stock_lcgp_age" class="stock_lcgp_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id"><div class="ew-table-header-caption"><?php echo $stock_lcgp->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><div><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_lcgp_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$stock_lcgp_grid->StartRec = 1;
$stock_lcgp_grid->StopRec = $stock_lcgp_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $stock_lcgp_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($stock_lcgp_grid->FormKeyCountName) && ($stock_lcgp->isGridAdd() || $stock_lcgp->isGridEdit() || $stock_lcgp->isConfirm())) {
		$stock_lcgp_grid->KeyCount = $CurrentForm->getValue($stock_lcgp_grid->FormKeyCountName);
		$stock_lcgp_grid->StopRec = $stock_lcgp_grid->StartRec + $stock_lcgp_grid->KeyCount - 1;
	}
}
$stock_lcgp_grid->RecCnt = $stock_lcgp_grid->StartRec - 1;
if ($stock_lcgp_grid->Recordset && !$stock_lcgp_grid->Recordset->EOF) {
	$stock_lcgp_grid->Recordset->moveFirst();
	$selectLimit = $stock_lcgp_grid->UseSelectLimit;
	if (!$selectLimit && $stock_lcgp_grid->StartRec > 1)
		$stock_lcgp_grid->Recordset->move($stock_lcgp_grid->StartRec - 1);
} elseif (!$stock_lcgp->AllowAddDeleteRow && $stock_lcgp_grid->StopRec == 0) {
	$stock_lcgp_grid->StopRec = $stock_lcgp->GridAddRowCount;
}

// Initialize aggregate
$stock_lcgp->RowType = ROWTYPE_AGGREGATEINIT;
$stock_lcgp->resetAttributes();
$stock_lcgp_grid->renderRow();
if ($stock_lcgp->isGridAdd())
	$stock_lcgp_grid->RowIndex = 0;
if ($stock_lcgp->isGridEdit())
	$stock_lcgp_grid->RowIndex = 0;
while ($stock_lcgp_grid->RecCnt < $stock_lcgp_grid->StopRec) {
	$stock_lcgp_grid->RecCnt++;
	if ($stock_lcgp_grid->RecCnt >= $stock_lcgp_grid->StartRec) {
		$stock_lcgp_grid->RowCnt++;
		if ($stock_lcgp->isGridAdd() || $stock_lcgp->isGridEdit() || $stock_lcgp->isConfirm()) {
			$stock_lcgp_grid->RowIndex++;
			$CurrentForm->Index = $stock_lcgp_grid->RowIndex;
			if ($CurrentForm->hasValue($stock_lcgp_grid->FormActionName) && $stock_lcgp_grid->EventCancelled)
				$stock_lcgp_grid->RowAction = strval($CurrentForm->getValue($stock_lcgp_grid->FormActionName));
			elseif ($stock_lcgp->isGridAdd())
				$stock_lcgp_grid->RowAction = "insert";
			else
				$stock_lcgp_grid->RowAction = "";
		}

		// Set up key count
		$stock_lcgp_grid->KeyCount = $stock_lcgp_grid->RowIndex;

		// Init row class and style
		$stock_lcgp->resetAttributes();
		$stock_lcgp->CssClass = "";
		if ($stock_lcgp->isGridAdd()) {
			if ($stock_lcgp->CurrentMode == "copy") {
				$stock_lcgp_grid->loadRowValues($stock_lcgp_grid->Recordset); // Load row values
				$stock_lcgp_grid->setRecordKey($stock_lcgp_grid->RowOldKey, $stock_lcgp_grid->Recordset); // Set old record key
			} else {
				$stock_lcgp_grid->loadRowValues(); // Load default values
				$stock_lcgp_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$stock_lcgp_grid->loadRowValues($stock_lcgp_grid->Recordset); // Load row values
		}
		$stock_lcgp->RowType = ROWTYPE_VIEW; // Render view
		if ($stock_lcgp->isGridAdd()) // Grid add
			$stock_lcgp->RowType = ROWTYPE_ADD; // Render add
		if ($stock_lcgp->isGridAdd() && $stock_lcgp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$stock_lcgp_grid->restoreCurrentRowFormValues($stock_lcgp_grid->RowIndex); // Restore form values
		if ($stock_lcgp->isGridEdit()) { // Grid edit
			if ($stock_lcgp->EventCancelled)
				$stock_lcgp_grid->restoreCurrentRowFormValues($stock_lcgp_grid->RowIndex); // Restore form values
			if ($stock_lcgp_grid->RowAction == "insert")
				$stock_lcgp->RowType = ROWTYPE_ADD; // Render add
			else
				$stock_lcgp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($stock_lcgp->isGridEdit() && ($stock_lcgp->RowType == ROWTYPE_EDIT || $stock_lcgp->RowType == ROWTYPE_ADD) && $stock_lcgp->EventCancelled) // Update failed
			$stock_lcgp_grid->restoreCurrentRowFormValues($stock_lcgp_grid->RowIndex); // Restore form values
		if ($stock_lcgp->RowType == ROWTYPE_EDIT) // Edit row
			$stock_lcgp_grid->EditRowCnt++;
		if ($stock_lcgp->isConfirm()) // Confirm row
			$stock_lcgp_grid->restoreCurrentRowFormValues($stock_lcgp_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$stock_lcgp->RowAttrs = array_merge($stock_lcgp->RowAttrs, array('data-rowindex'=>$stock_lcgp_grid->RowCnt, 'id'=>'r' . $stock_lcgp_grid->RowCnt . '_stock_lcgp', 'data-rowtype'=>$stock_lcgp->RowType));

		// Render row
		$stock_lcgp_grid->renderRow();

		// Render list options
		$stock_lcgp_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($stock_lcgp_grid->RowAction <> "delete" && $stock_lcgp_grid->RowAction <> "insertdelete" && !($stock_lcgp_grid->RowAction == "insert" && $stock_lcgp->isConfirm() && $stock_lcgp_grid->emptyRow())) {
?>
	<tr<?php echo $stock_lcgp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgp_grid->ListOptions->render("body", "left", $stock_lcgp_grid->RowCnt);
?>
	<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_lcgp->rid->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($stock_lcgp->rid->getSessionValue() <> "") { ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<input type="text" data-table="stock_lcgp" data-field="x_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->rid->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->rid->EditValue ?>"<?php echo $stock_lcgp->rid->editAttributes() ?>>
</span>
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($stock_lcgp->rid->getSessionValue() <> "") { ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<input type="text" data-table="stock_lcgp" data-field="x_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->rid->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->rid->EditValue ?>"<?php echo $stock_lcgp->rid->editAttributes() ?>>
</span>
<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_rid" class="stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<?php echo $stock_lcgp->rid->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $stock_lcgp->grp->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_grp" class="form-group stock_lcgp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_grp" data-value-separator="<?php echo $stock_lcgp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp"<?php echo $stock_lcgp->grp->editAttributes() ?>>
		<?php echo $stock_lcgp->grp->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $stock_lcgp->grp->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_grp") ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_grp" class="form-group stock_lcgp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_grp" data-value-separator="<?php echo $stock_lcgp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp"<?php echo $stock_lcgp->grp->editAttributes() ?>>
		<?php echo $stock_lcgp->grp->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $stock_lcgp->grp->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_grp") ?>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_grp" class="stock_lcgp_grp">
<span<?php echo $stock_lcgp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->grp->getViewValue())) && $stock_lcgp->grp->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->grp->linkAttributes() ?>><?php echo $stock_lcgp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_lcgp->product->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product" class="form-group stock_lcgp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_product" data-value-separator="<?php echo $stock_lcgp->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product"<?php echo $stock_lcgp->product->editAttributes() ?>>
		<?php echo $stock_lcgp->product->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock_lcgp->product->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product" class="form-group stock_lcgp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_product" data-value-separator="<?php echo $stock_lcgp->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product"<?php echo $stock_lcgp->product->editAttributes() ?>>
		<?php echo $stock_lcgp->product->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock_lcgp->product->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product" class="stock_lcgp_product">
<span<?php echo $stock_lcgp->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product->getViewValue())) && $stock_lcgp->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product->linkAttributes() ?>><?php echo $stock_lcgp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_lcgp->product_code->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product_code" class="form-group stock_lcgp_product_code">
<input type="text" data-table="stock_lcgp" data-field="x_product_code" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgp->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->product_code->EditValue ?>"<?php echo $stock_lcgp->product_code->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product_code" class="form-group stock_lcgp_product_code">
<input type="text" data-table="stock_lcgp" data-field="x_product_code" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgp->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->product_code->EditValue ?>"<?php echo $stock_lcgp->product_code->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_product_code" class="stock_lcgp_product_code">
<span<?php echo $stock_lcgp->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product_code->getViewValue())) && $stock_lcgp->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product_code->linkAttributes() ?>><?php echo $stock_lcgp->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_lcgp->godown->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_godown" class="form-group stock_lcgp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_godown" data-value-separator="<?php echo $stock_lcgp->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown"<?php echo $stock_lcgp->godown->editAttributes() ?>>
		<?php echo $stock_lcgp->godown->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $stock_lcgp->godown->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_godown") ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_godown" class="form-group stock_lcgp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_godown" data-value-separator="<?php echo $stock_lcgp->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown"<?php echo $stock_lcgp->godown->editAttributes() ?>>
		<?php echo $stock_lcgp->godown->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $stock_lcgp->godown->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_godown") ?>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_godown" class="stock_lcgp_godown">
<span<?php echo $stock_lcgp->godown->viewAttributes() ?>>
<?php echo $stock_lcgp->godown->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_lcgp->IN->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_IN" class="form-group stock_lcgp_IN">
<input type="text" data-table="stock_lcgp" data-field="x_IN" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->IN->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->IN->EditValue ?>"<?php echo $stock_lcgp->IN->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_IN" class="form-group stock_lcgp_IN">
<input type="text" data-table="stock_lcgp" data-field="x_IN" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->IN->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->IN->EditValue ?>"<?php echo $stock_lcgp->IN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_IN" class="stock_lcgp_IN">
<span<?php echo $stock_lcgp->IN->viewAttributes() ?>>
<?php echo $stock_lcgp->IN->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_lcgp->OUT->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_OUT" class="form-group stock_lcgp_OUT">
<input type="text" data-table="stock_lcgp" data-field="x_OUT" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->OUT->EditValue ?>"<?php echo $stock_lcgp->OUT->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_OUT" class="form-group stock_lcgp_OUT">
<input type="text" data-table="stock_lcgp" data-field="x_OUT" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->OUT->EditValue ?>"<?php echo $stock_lcgp->OUT->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_OUT" class="stock_lcgp_OUT">
<span<?php echo $stock_lcgp->OUT->viewAttributes() ?>>
<?php echo $stock_lcgp->OUT->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_lcgp->Balance->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_Balance" class="form-group stock_lcgp_Balance">
<input type="text" data-table="stock_lcgp" data-field="x_Balance" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->Balance->EditValue ?>"<?php echo $stock_lcgp->Balance->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_Balance" class="form-group stock_lcgp_Balance">
<input type="text" data-table="stock_lcgp" data-field="x_Balance" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->Balance->EditValue ?>"<?php echo $stock_lcgp->Balance->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_Balance" class="stock_lcgp_Balance">
<span<?php echo $stock_lcgp->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->Balance->getViewValue())) && $stock_lcgp->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->Balance->linkAttributes() ?>><?php echo $stock_lcgp->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_lcgp->packets->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packets" class="form-group stock_lcgp_packets">
<input type="text" data-table="stock_lcgp" data-field="x_packets" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->packets->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packets->EditValue ?>"<?php echo $stock_lcgp->packets->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packets" class="form-group stock_lcgp_packets">
<input type="text" data-table="stock_lcgp" data-field="x_packets" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->packets->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packets->EditValue ?>"<?php echo $stock_lcgp->packets->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packets" class="stock_lcgp_packets">
<span<?php echo $stock_lcgp->packets->viewAttributes() ?>>
<?php echo $stock_lcgp->packets->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n"<?php echo $stock_lcgp->packing_type_n->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packing_type_n" class="form-group stock_lcgp_packing_type_n">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type_n" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" size="30" maxlength="54" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type_n->EditValue ?>"<?php echo $stock_lcgp->packing_type_n->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packing_type_n" class="form-group stock_lcgp_packing_type_n">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type_n" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" size="30" maxlength="54" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type_n->EditValue ?>"<?php echo $stock_lcgp->packing_type_n->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
<span<?php echo $stock_lcgp->packing_type_n->viewAttributes() ?>>
<?php echo $stock_lcgp->packing_type_n->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_lcgp->lot_no->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_lot_no" class="form-group stock_lcgp_lot_no">
<input type="text" data-table="stock_lcgp" data-field="x_lot_no" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_lcgp->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->lot_no->EditValue ?>"<?php echo $stock_lcgp->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_lot_no" class="form-group stock_lcgp_lot_no">
<input type="text" data-table="stock_lcgp" data-field="x_lot_no" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_lcgp->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->lot_no->EditValue ?>"<?php echo $stock_lcgp->lot_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
<span<?php echo $stock_lcgp->lot_no->viewAttributes() ?>>
<?php echo $stock_lcgp->lot_no->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD"<?php echo $stock_lcgp->HOLD->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_HOLD" class="form-group stock_lcgp_HOLD">
<input type="text" data-table="stock_lcgp" data-field="x_HOLD" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->HOLD->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->HOLD->EditValue ?>"<?php echo $stock_lcgp->HOLD->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_HOLD" class="form-group stock_lcgp_HOLD">
<input type="text" data-table="stock_lcgp" data-field="x_HOLD" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->HOLD->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->HOLD->EditValue ?>"<?php echo $stock_lcgp->HOLD->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
<span<?php echo $stock_lcgp->HOLD->viewAttributes() ?>>
<?php echo $stock_lcgp->HOLD->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_lcgp->age->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_age" class="form-group stock_lcgp_age">
<input type="text" data-table="stock_lcgp" data-field="x_age" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->age->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->age->EditValue ?>"<?php echo $stock_lcgp->age->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_age" class="form-group stock_lcgp_age">
<input type="text" data-table="stock_lcgp" data-field="x_age" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->age->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->age->EditValue ?>"<?php echo $stock_lcgp->age->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_age" class="stock_lcgp_age">
<span<?php echo $stock_lcgp->age->viewAttributes() ?>>
<?php echo $stock_lcgp->age->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_lcgp->company_id->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_company_id" class="form-group stock_lcgp_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_company_id" data-value-separator="<?php echo $stock_lcgp->company_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id"<?php echo $stock_lcgp->company_id->editAttributes() ?>>
		<?php echo $stock_lcgp->company_id->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id") ?>
	</select>
</div>
<?php echo $stock_lcgp->company_id->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_company_id") ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_company_id" class="form-group stock_lcgp_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_company_id" data-value-separator="<?php echo $stock_lcgp->company_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id"<?php echo $stock_lcgp->company_id->editAttributes() ?>>
		<?php echo $stock_lcgp->company_id->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id") ?>
	</select>
</div>
<?php echo $stock_lcgp->company_id->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_company_id") ?>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_company_id" class="stock_lcgp_company_id">
<span<?php echo $stock_lcgp->company_id->viewAttributes() ?>>
<?php echo $stock_lcgp->company_id->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $stock_lcgp->s_grp->cellAttributes() ?>>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_s_grp" class="form-group stock_lcgp_s_grp">
<input type="text" data-table="stock_lcgp" data-field="x_s_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->s_grp->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->s_grp->EditValue ?>"<?php echo $stock_lcgp->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_s_grp" class="form-group stock_lcgp_s_grp">
<input type="text" data-table="stock_lcgp" data-field="x_s_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->s_grp->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->s_grp->EditValue ?>"<?php echo $stock_lcgp->s_grp->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock_lcgp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_lcgp_grid->RowCnt ?>_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
<span<?php echo $stock_lcgp->s_grp->viewAttributes() ?>>
<?php echo $stock_lcgp->s_grp->getViewValue() ?></span>
</span>
<?php if (!$stock_lcgp->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="fstock_lcgpgrid$x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="fstock_lcgpgrid$o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgp_grid->ListOptions->render("body", "right", $stock_lcgp_grid->RowCnt);
?>
	</tr>
<?php if ($stock_lcgp->RowType == ROWTYPE_ADD || $stock_lcgp->RowType == ROWTYPE_EDIT) { ?>
<script>
fstock_lcgpgrid.updateLists(<?php echo $stock_lcgp_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$stock_lcgp->isGridAdd() || $stock_lcgp->CurrentMode == "copy")
		if (!$stock_lcgp_grid->Recordset->EOF)
			$stock_lcgp_grid->Recordset->moveNext();
}
?>
<?php
	if ($stock_lcgp->CurrentMode == "add" || $stock_lcgp->CurrentMode == "copy" || $stock_lcgp->CurrentMode == "edit") {
		$stock_lcgp_grid->RowIndex = '$rowindex$';
		$stock_lcgp_grid->loadRowValues();

		// Set row properties
		$stock_lcgp->resetAttributes();
		$stock_lcgp->RowAttrs = array_merge($stock_lcgp->RowAttrs, array('data-rowindex'=>$stock_lcgp_grid->RowIndex, 'id'=>'r0_stock_lcgp', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($stock_lcgp->RowAttrs["class"], "ew-template");
		$stock_lcgp->RowType = ROWTYPE_ADD;

		// Render row
		$stock_lcgp_grid->renderRow();

		// Render list options
		$stock_lcgp_grid->renderListOptions();
		$stock_lcgp_grid->StartRowCnt = 0;
?>
	<tr<?php echo $stock_lcgp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgp_grid->ListOptions->render("body", "left", $stock_lcgp_grid->RowIndex);
?>
	<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<td data-name="rid">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<?php if ($stock_lcgp->rid->getSessionValue() <> "") { ?>
<span id="el$rowindex$_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<input type="text" data-table="stock_lcgp" data-field="x_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->rid->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->rid->EditValue ?>"<?php echo $stock_lcgp->rid->editAttributes() ?>>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_rid" class="form-group stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($stock_lcgp->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<td data-name="grp">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_grp" class="form-group stock_lcgp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_grp" data-value-separator="<?php echo $stock_lcgp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp"<?php echo $stock_lcgp->grp->editAttributes() ?>>
		<?php echo $stock_lcgp->grp->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $stock_lcgp->grp->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_grp") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_grp" class="form-group stock_lcgp_grp">
<span<?php echo $stock_lcgp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->grp->ViewValue)) && $stock_lcgp->grp->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->grp->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->grp->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($stock_lcgp->grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product->Visible) { // product ?>
		<td data-name="product">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_product" class="form-group stock_lcgp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_product" data-value-separator="<?php echo $stock_lcgp->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product"<?php echo $stock_lcgp->product->editAttributes() ?>>
		<?php echo $stock_lcgp->product->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock_lcgp->product->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_product") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_product" class="form-group stock_lcgp_product">
<span<?php echo $stock_lcgp->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product->ViewValue)) && $stock_lcgp->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->product->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->product->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock_lcgp->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<td data-name="product_code">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_product_code" class="form-group stock_lcgp_product_code">
<input type="text" data-table="stock_lcgp" data-field="x_product_code" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgp->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->product_code->EditValue ?>"<?php echo $stock_lcgp->product_code->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_product_code" class="form-group stock_lcgp_product_code">
<span<?php echo $stock_lcgp->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product_code->ViewValue)) && $stock_lcgp->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product_code->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->product_code->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->product_code->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock_lcgp->product_code->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<td data-name="godown">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_godown" class="form-group stock_lcgp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_godown" data-value-separator="<?php echo $stock_lcgp->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown"<?php echo $stock_lcgp->godown->editAttributes() ?>>
		<?php echo $stock_lcgp->godown->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $stock_lcgp->godown->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_godown") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_godown" class="form-group stock_lcgp_godown">
<span<?php echo $stock_lcgp->godown->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->godown->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($stock_lcgp->godown->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<td data-name="IN">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_IN" class="form-group stock_lcgp_IN">
<input type="text" data-table="stock_lcgp" data-field="x_IN" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->IN->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->IN->EditValue ?>"<?php echo $stock_lcgp->IN->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_IN" class="form-group stock_lcgp_IN">
<span<?php echo $stock_lcgp->IN->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->IN->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($stock_lcgp->IN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<td data-name="OUT">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_OUT" class="form-group stock_lcgp_OUT">
<input type="text" data-table="stock_lcgp" data-field="x_OUT" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->OUT->EditValue ?>"<?php echo $stock_lcgp->OUT->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_OUT" class="form-group stock_lcgp_OUT">
<span<?php echo $stock_lcgp->OUT->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->OUT->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_OUT" value="<?php echo HtmlEncode($stock_lcgp->OUT->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<td data-name="Balance">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_Balance" class="form-group stock_lcgp_Balance">
<input type="text" data-table="stock_lcgp" data-field="x_Balance" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->Balance->EditValue ?>"<?php echo $stock_lcgp->Balance->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_Balance" class="form-group stock_lcgp_Balance">
<span<?php echo $stock_lcgp->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->Balance->ViewValue)) && $stock_lcgp->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->Balance->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->Balance->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->Balance->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock_lcgp->Balance->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<td data-name="packets">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_packets" class="form-group stock_lcgp_packets">
<input type="text" data-table="stock_lcgp" data-field="x_packets" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->packets->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packets->EditValue ?>"<?php echo $stock_lcgp->packets->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_packets" class="form-group stock_lcgp_packets">
<span<?php echo $stock_lcgp->packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->packets->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock_lcgp->packets->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_packing_type_n" class="form-group stock_lcgp_packing_type_n">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type_n" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" size="30" maxlength="54" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type_n->EditValue ?>"<?php echo $stock_lcgp->packing_type_n->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_packing_type_n" class="form-group stock_lcgp_packing_type_n">
<span<?php echo $stock_lcgp->packing_type_n->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->packing_type_n->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_packing_type_n" value="<?php echo HtmlEncode($stock_lcgp->packing_type_n->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_lot_no" class="form-group stock_lcgp_lot_no">
<input type="text" data-table="stock_lcgp" data-field="x_lot_no" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_lcgp->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->lot_no->EditValue ?>"<?php echo $stock_lcgp->lot_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_lot_no" class="form-group stock_lcgp_lot_no">
<span<?php echo $stock_lcgp->lot_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->lot_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_lot_no" value="<?php echo HtmlEncode($stock_lcgp->lot_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_HOLD" class="form-group stock_lcgp_HOLD">
<input type="text" data-table="stock_lcgp" data-field="x_HOLD" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->HOLD->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->HOLD->EditValue ?>"<?php echo $stock_lcgp->HOLD->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_HOLD" class="form-group stock_lcgp_HOLD">
<span<?php echo $stock_lcgp->HOLD->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->HOLD->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_HOLD" value="<?php echo HtmlEncode($stock_lcgp->HOLD->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->age->Visible) { // age ?>
		<td data-name="age">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_age" class="form-group stock_lcgp_age">
<input type="text" data-table="stock_lcgp" data-field="x_age" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->age->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->age->EditValue ?>"<?php echo $stock_lcgp->age->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_age" class="form-group stock_lcgp_age">
<span<?php echo $stock_lcgp->age->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->age->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_age" value="<?php echo HtmlEncode($stock_lcgp->age->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<td data-name="company_id">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_company_id" class="form-group stock_lcgp_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_company_id" data-value-separator="<?php echo $stock_lcgp->company_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id"<?php echo $stock_lcgp->company_id->editAttributes() ?>>
		<?php echo $stock_lcgp->company_id->selectOptionListHtml("x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id") ?>
	</select>
</div>
<?php echo $stock_lcgp->company_id->Lookup->getParamTag("p_x" . $stock_lcgp_grid->RowIndex . "_company_id") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_company_id" class="form-group stock_lcgp_company_id">
<span<?php echo $stock_lcgp->company_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->company_id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_company_id" value="<?php echo HtmlEncode($stock_lcgp->company_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp">
<?php if (!$stock_lcgp->isConfirm()) { ?>
<span id="el$rowindex$_stock_lcgp_s_grp" class="form-group stock_lcgp_s_grp">
<input type="text" data-table="stock_lcgp" data-field="x_s_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->s_grp->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->s_grp->EditValue ?>"<?php echo $stock_lcgp->s_grp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_lcgp_s_grp" class="form-group stock_lcgp_s_grp">
<span<?php echo $stock_lcgp->s_grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_lcgp->s_grp->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="x<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" name="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" id="o<?php echo $stock_lcgp_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($stock_lcgp->s_grp->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgp_grid->ListOptions->render("body", "right", $stock_lcgp_grid->RowIndex);
?>
<script>
fstock_lcgpgrid.updateLists(<?php echo $stock_lcgp_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$stock_lcgp->RowType = ROWTYPE_AGGREGATE;
$stock_lcgp->resetAttributes();
$stock_lcgp_grid->renderRow();
?>
<?php if ($stock_lcgp_grid->TotalRecs > 0 && $stock_lcgp->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_lcgp_grid->renderListOptions();

// Render list options (footer, left)
$stock_lcgp_grid->ListOptions->render("footer", "left");
?>
	<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $stock_lcgp->rid->footerCellClass() ?>"><span id="elf_stock_lcgp_rid" class="stock_lcgp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $stock_lcgp->grp->footerCellClass() ?>"><span id="elf_stock_lcgp_grp" class="stock_lcgp_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_lcgp->product->footerCellClass() ?>"><span id="elf_stock_lcgp_product" class="stock_lcgp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_lcgp->product_code->footerCellClass() ?>"><span id="elf_stock_lcgp_product_code" class="stock_lcgp_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_lcgp->godown->footerCellClass() ?>"><span id="elf_stock_lcgp_godown" class="stock_lcgp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_lcgp->IN->footerCellClass() ?>"><span id="elf_stock_lcgp_IN" class="stock_lcgp_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_lcgp->OUT->footerCellClass() ?>"><span id="elf_stock_lcgp_OUT" class="stock_lcgp_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_lcgp->Balance->footerCellClass() ?>"><span id="elf_stock_lcgp_Balance" class="stock_lcgp_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_lcgp->packets->footerCellClass() ?>"><span id="elf_stock_lcgp_packets" class="stock_lcgp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->footerCellClass() ?>"><span id="elf_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->footerCellClass() ?>"><span id="elf_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->footerCellClass() ?>"><span id="elf_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_lcgp->age->footerCellClass() ?>"><span id="elf_stock_lcgp_age" class="stock_lcgp_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_lcgp->company_id->footerCellClass() ?>"><span id="elf_stock_lcgp_company_id" class="stock_lcgp_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->footerCellClass() ?>"><span id="elf_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_lcgp_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($stock_lcgp->CurrentMode == "add" || $stock_lcgp->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $stock_lcgp_grid->FormKeyCountName ?>" id="<?php echo $stock_lcgp_grid->FormKeyCountName ?>" value="<?php echo $stock_lcgp_grid->KeyCount ?>">
<?php echo $stock_lcgp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($stock_lcgp->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $stock_lcgp_grid->FormKeyCountName ?>" id="<?php echo $stock_lcgp_grid->FormKeyCountName ?>" value="<?php echo $stock_lcgp_grid->KeyCount ?>">
<?php echo $stock_lcgp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($stock_lcgp->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fstock_lcgpgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($stock_lcgp_grid->Recordset)
	$stock_lcgp_grid->Recordset->Close();
?>
</div>
<?php if ($stock_lcgp_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $stock_lcgp_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_lcgp_grid->TotalRecs == 0 && !$stock_lcgp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_lcgp_grid->terminate();
?>
<?php if (!$stock_lcgp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_lcgp", "100%", "500px");
</script>
<?php } ?>