<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_lcgp_list = new stock_lcgp_list();

// Run the page
$stock_lcgp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_lcgp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_lcgplist = currentForm = new ew.Form("fstock_lcgplist", "list");
fstock_lcgplist.formKeyCountName = '<?php echo $stock_lcgp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_lcgplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgplist.lists["x_grp"] = <?php echo $stock_lcgp_list->grp->Lookup->toClientList() ?>;
fstock_lcgplist.lists["x_grp"].options = <?php echo JsonEncode($stock_lcgp_list->grp->lookupOptions()) ?>;
fstock_lcgplist.lists["x_product"] = <?php echo $stock_lcgp_list->product->Lookup->toClientList() ?>;
fstock_lcgplist.lists["x_product"].options = <?php echo JsonEncode($stock_lcgp_list->product->lookupOptions()) ?>;
fstock_lcgplist.lists["x_godown"] = <?php echo $stock_lcgp_list->godown->Lookup->toClientList() ?>;
fstock_lcgplist.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgp_list->godown->lookupOptions()) ?>;
fstock_lcgplist.lists["x_company_id"] = <?php echo $stock_lcgp_list->company_id->Lookup->toClientList() ?>;
fstock_lcgplist.lists["x_company_id"].options = <?php echo JsonEncode($stock_lcgp_list->company_id->lookupOptions()) ?>;

// Form object for search
var fstock_lcgplistsrch = currentSearchForm = new ew.Form("fstock_lcgplistsrch");

// Validate function for search
fstock_lcgplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->s_grp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_lcgplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgplistsrch.lists["x_grp"] = <?php echo $stock_lcgp_list->grp->Lookup->toClientList() ?>;
fstock_lcgplistsrch.lists["x_grp"].options = <?php echo JsonEncode($stock_lcgp_list->grp->lookupOptions()) ?>;
fstock_lcgplistsrch.lists["x_godown"] = <?php echo $stock_lcgp_list->godown->Lookup->toClientList() ?>;
fstock_lcgplistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgp_list->godown->lookupOptions()) ?>;

// Filters
fstock_lcgplistsrch.filterList = <?php echo $stock_lcgp_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_lcgplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_lcgp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_lcgp_list->TotalRecs > 0 && $stock_lcgp_list->ExportOptions->visible()) { ?>
<?php $stock_lcgp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_list->ImportOptions->visible()) { ?>
<?php $stock_lcgp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_list->SearchOptions->visible()) { ?>
<?php $stock_lcgp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_lcgp_list->FilterOptions->visible()) { ?>
<?php $stock_lcgp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$stock_lcgp->isExport() || EXPORT_MASTER_RECORD && $stock_lcgp->isExport("print")) { ?>
<?php
if ($stock_lcgp_list->DbMasterFilter <> "" && $stock_lcgp->getCurrentMasterTable() == "required_material_compiled") {
	if ($stock_lcgp_list->MasterRecordExists) {
		include_once "required_material_compiledmaster.php";
	}
}
?>
<?php
if ($stock_lcgp_list->DbMasterFilter <> "" && $stock_lcgp->getCurrentMasterTable() == "required_material_compiled_live") {
	if ($stock_lcgp_list->MasterRecordExists) {
		include_once "required_material_compiled_livemaster.php";
	}
}
?>
<?php } ?>
<?php
$stock_lcgp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_lcgp->isExport() && !$stock_lcgp->CurrentAction) { ?>
<form name="fstock_lcgplistsrch" id="fstock_lcgplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_lcgp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_lcgplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_lcgp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_lcgp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_lcgp->RowType = ROWTYPE_SEARCH;

// Render row
$stock_lcgp->resetAttributes();
$stock_lcgp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $stock_lcgp->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_grp" data-value-separator="<?php echo $stock_lcgp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $stock_lcgp->grp->editAttributes() ?>>
		<?php echo $stock_lcgp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $stock_lcgp->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_lcgp->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgp" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgp->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->product_code->EditValue ?>"<?php echo $stock_lcgp->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_lcgp->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_godown" data-value-separator="<?php echo $stock_lcgp->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_lcgp->godown->editAttributes() ?>>
		<?php echo $stock_lcgp->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_lcgp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
	<div id="xsc_packing_type_n" class="ew-cell form-group">
		<label for="x_packing_type_n" class="ew-search-caption ew-label"><?php echo $stock_lcgp->packing_type_n->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing_type_n" id="z_packing_type_n" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type_n" name="x_packing_type_n" id="x_packing_type_n" size="30" maxlength="54" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type_n->EditValue ?>"<?php echo $stock_lcgp->packing_type_n->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
	<div id="xsc_lot_no" class="ew-cell form-group">
		<label for="x_lot_no" class="ew-search-caption ew-label"><?php echo $stock_lcgp->lot_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgp" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_lcgp->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->lot_no->EditValue ?>"<?php echo $stock_lcgp->lot_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $stock_lcgp->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_lcgp" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->s_grp->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->s_grp->EditValue ?>"<?php echo $stock_lcgp->s_grp->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_lcgp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_lcgp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_lcgp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_lcgp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_lcgp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_lcgp_list->showPageHeader(); ?>
<?php
$stock_lcgp_list->showMessage();
?>
<?php if ($stock_lcgp_list->TotalRecs > 0 || $stock_lcgp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_lcgp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_lcgp">
<?php if (!$stock_lcgp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_lcgp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgp_list->Pager)) $stock_lcgp_list->Pager = new PrevNextPager($stock_lcgp_list->StartRec, $stock_lcgp_list->DisplayRecs, $stock_lcgp_list->TotalRecs, $stock_lcgp_list->AutoHidePager) ?>
<?php if ($stock_lcgp_list->Pager->RecordCount > 0 && $stock_lcgp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgp_list->TotalRecs > 0 && (!$stock_lcgp_list->AutoHidePageSizeSelector || $stock_lcgp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_lcgplist" id="fstock_lcgplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_lcgp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_lcgp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_lcgp">
<?php if ($stock_lcgp->getCurrentMasterTable() == "required_material_compiled" && $stock_lcgp->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="required_material_compiled">
<input type="hidden" name="fk_req_material_rid" value="<?php echo $stock_lcgp->rid->getSessionValue() ?>">
<?php } ?>
<?php if ($stock_lcgp->getCurrentMasterTable() == "required_material_compiled_live" && $stock_lcgp->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="required_material_compiled_live">
<input type="hidden" name="fk_req_material_rid" value="<?php echo $stock_lcgp->rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_stock_lcgp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_lcgp_list->TotalRecs > 0 || $stock_lcgp->isGridEdit()) { ?>
<table id="tbl_stock_lcgplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_lcgp_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_lcgp_list->renderListOptions();

// Render list options (header, left)
$stock_lcgp_list->ListOptions->render("header", "left");
?>
<?php if ($stock_lcgp->rid->Visible) { // rid ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid"><div class="ew-table-header-caption"><?php echo $stock_lcgp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_lcgp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->rid) ?>',2);"><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->grp) ?>',2);"><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><div id="elh_stock_lcgp_product" class="stock_lcgp_product"><div class="ew-table-header-caption"><?php echo $stock_lcgp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->product) ?>',2);"><div id="elh_stock_lcgp_product" class="stock_lcgp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code"><div class="ew-table-header-caption"><?php echo $stock_lcgp->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->product_code) ?>',2);"><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown"><div class="ew-table-header-caption"><?php echo $stock_lcgp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->godown) ?>',2);"><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN"><div class="ew-table-header-caption"><?php echo $stock_lcgp->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->IN) ?>',2);"><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT"><div class="ew-table-header-caption"><?php echo $stock_lcgp->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->OUT) ?>',2);"><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance"><div class="ew-table-header-caption"><?php echo $stock_lcgp->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->Balance) ?>',2);"><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets"><div class="ew-table-header-caption"><?php echo $stock_lcgp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->packets) ?>',2);"><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->packing_type_n) == "") { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n"><div class="ew-table-header-caption"><?php echo $stock_lcgp->packing_type_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->packing_type_n) ?>',2);"><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packing_type_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->packing_type_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->packing_type_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no"><div class="ew-table-header-caption"><?php echo $stock_lcgp->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->lot_no) ?>',2);"><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->HOLD) == "") { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD"><div class="ew-table-header-caption"><?php echo $stock_lcgp->HOLD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->HOLD) ?>',2);"><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->HOLD->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->HOLD->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->HOLD->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><div id="elh_stock_lcgp_age" class="stock_lcgp_age"><div class="ew-table-header-caption"><?php echo $stock_lcgp->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->age) ?>',2);"><div id="elh_stock_lcgp_age" class="stock_lcgp_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id"><div class="ew-table-header-caption"><?php echo $stock_lcgp->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->company_id) ?>',2);"><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_lcgp->sortUrl($stock_lcgp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp"><div class="ew-table-header-caption"><?php echo $stock_lcgp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_lcgp->SortUrl($stock_lcgp->s_grp) ?>',2);"><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_lcgp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_lcgp->ExportAll && $stock_lcgp->isExport()) {
	$stock_lcgp_list->StopRec = $stock_lcgp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_lcgp_list->TotalRecs > $stock_lcgp_list->StartRec + $stock_lcgp_list->DisplayRecs - 1)
		$stock_lcgp_list->StopRec = $stock_lcgp_list->StartRec + $stock_lcgp_list->DisplayRecs - 1;
	else
		$stock_lcgp_list->StopRec = $stock_lcgp_list->TotalRecs;
}
$stock_lcgp_list->RecCnt = $stock_lcgp_list->StartRec - 1;
if ($stock_lcgp_list->Recordset && !$stock_lcgp_list->Recordset->EOF) {
	$stock_lcgp_list->Recordset->moveFirst();
	$selectLimit = $stock_lcgp_list->UseSelectLimit;
	if (!$selectLimit && $stock_lcgp_list->StartRec > 1)
		$stock_lcgp_list->Recordset->move($stock_lcgp_list->StartRec - 1);
} elseif (!$stock_lcgp->AllowAddDeleteRow && $stock_lcgp_list->StopRec == 0) {
	$stock_lcgp_list->StopRec = $stock_lcgp->GridAddRowCount;
}

// Initialize aggregate
$stock_lcgp->RowType = ROWTYPE_AGGREGATEINIT;
$stock_lcgp->resetAttributes();
$stock_lcgp_list->renderRow();
while ($stock_lcgp_list->RecCnt < $stock_lcgp_list->StopRec) {
	$stock_lcgp_list->RecCnt++;
	if ($stock_lcgp_list->RecCnt >= $stock_lcgp_list->StartRec) {
		$stock_lcgp_list->RowCnt++;

		// Set up key count
		$stock_lcgp_list->KeyCount = $stock_lcgp_list->RowIndex;

		// Init row class and style
		$stock_lcgp->resetAttributes();
		$stock_lcgp->CssClass = "";
		if ($stock_lcgp->isGridAdd()) {
		} else {
			$stock_lcgp_list->loadRowValues($stock_lcgp_list->Recordset); // Load row values
		}
		$stock_lcgp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_lcgp->RowAttrs = array_merge($stock_lcgp->RowAttrs, array('data-rowindex'=>$stock_lcgp_list->RowCnt, 'id'=>'r' . $stock_lcgp_list->RowCnt . '_stock_lcgp', 'data-rowtype'=>$stock_lcgp->RowType));

		// Render row
		$stock_lcgp_list->renderRow();

		// Render list options
		$stock_lcgp_list->renderListOptions();
?>
	<tr<?php echo $stock_lcgp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgp_list->ListOptions->render("body", "left", $stock_lcgp_list->RowCnt);
?>
	<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_lcgp->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_rid" class="stock_lcgp_rid">
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<?php echo $stock_lcgp->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $stock_lcgp->grp->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_grp" class="stock_lcgp_grp">
<span<?php echo $stock_lcgp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->grp->getViewValue())) && $stock_lcgp->grp->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->grp->linkAttributes() ?>><?php echo $stock_lcgp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_lcgp->product->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_product" class="stock_lcgp_product">
<span<?php echo $stock_lcgp->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product->getViewValue())) && $stock_lcgp->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product->linkAttributes() ?>><?php echo $stock_lcgp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_lcgp->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_product_code" class="stock_lcgp_product_code">
<span<?php echo $stock_lcgp->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product_code->getViewValue())) && $stock_lcgp->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product_code->linkAttributes() ?>><?php echo $stock_lcgp->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_lcgp->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_godown" class="stock_lcgp_godown">
<span<?php echo $stock_lcgp->godown->viewAttributes() ?>>
<?php echo $stock_lcgp->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_lcgp->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_IN" class="stock_lcgp_IN">
<span<?php echo $stock_lcgp->IN->viewAttributes() ?>>
<?php echo $stock_lcgp->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_lcgp->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_OUT" class="stock_lcgp_OUT">
<span<?php echo $stock_lcgp->OUT->viewAttributes() ?>>
<?php echo $stock_lcgp->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_lcgp->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_Balance" class="stock_lcgp_Balance">
<span<?php echo $stock_lcgp->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->Balance->getViewValue())) && $stock_lcgp->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->Balance->linkAttributes() ?>><?php echo $stock_lcgp->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_lcgp->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_packets" class="stock_lcgp_packets">
<span<?php echo $stock_lcgp->packets->viewAttributes() ?>>
<?php echo $stock_lcgp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n"<?php echo $stock_lcgp->packing_type_n->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
<span<?php echo $stock_lcgp->packing_type_n->viewAttributes() ?>>
<?php echo $stock_lcgp->packing_type_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_lcgp->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
<span<?php echo $stock_lcgp->lot_no->viewAttributes() ?>>
<?php echo $stock_lcgp->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD"<?php echo $stock_lcgp->HOLD->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
<span<?php echo $stock_lcgp->HOLD->viewAttributes() ?>>
<?php echo $stock_lcgp->HOLD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_lcgp->age->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_age" class="stock_lcgp_age">
<span<?php echo $stock_lcgp->age->viewAttributes() ?>>
<?php echo $stock_lcgp->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_lcgp->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_company_id" class="stock_lcgp_company_id">
<span<?php echo $stock_lcgp->company_id->viewAttributes() ?>>
<?php echo $stock_lcgp->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $stock_lcgp->s_grp->cellAttributes() ?>>
<span id="el<?php echo $stock_lcgp_list->RowCnt ?>_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
<span<?php echo $stock_lcgp->s_grp->viewAttributes() ?>>
<?php echo $stock_lcgp->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgp_list->ListOptions->render("body", "right", $stock_lcgp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_lcgp->isGridAdd())
		$stock_lcgp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_lcgp->RowType = ROWTYPE_AGGREGATE;
$stock_lcgp->resetAttributes();
$stock_lcgp_list->renderRow();
?>
<?php if ($stock_lcgp_list->TotalRecs > 0 && !$stock_lcgp->isGridAdd() && !$stock_lcgp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_lcgp_list->renderListOptions();

// Render list options (footer, left)
$stock_lcgp_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $stock_lcgp->rid->footerCellClass() ?>"><span id="elf_stock_lcgp_rid" class="stock_lcgp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $stock_lcgp->grp->footerCellClass() ?>"><span id="elf_stock_lcgp_grp" class="stock_lcgp_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_lcgp->product->footerCellClass() ?>"><span id="elf_stock_lcgp_product" class="stock_lcgp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_lcgp->product_code->footerCellClass() ?>"><span id="elf_stock_lcgp_product_code" class="stock_lcgp_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_lcgp->godown->footerCellClass() ?>"><span id="elf_stock_lcgp_godown" class="stock_lcgp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_lcgp->IN->footerCellClass() ?>"><span id="elf_stock_lcgp_IN" class="stock_lcgp_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_lcgp->OUT->footerCellClass() ?>"><span id="elf_stock_lcgp_OUT" class="stock_lcgp_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_lcgp->Balance->footerCellClass() ?>"><span id="elf_stock_lcgp_Balance" class="stock_lcgp_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_lcgp->packets->footerCellClass() ?>"><span id="elf_stock_lcgp_packets" class="stock_lcgp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<td data-name="packing_type_n" class="<?php echo $stock_lcgp->packing_type_n->footerCellClass() ?>"><span id="elf_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_lcgp->lot_no->footerCellClass() ?>"><span id="elf_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<td data-name="HOLD" class="<?php echo $stock_lcgp->HOLD->footerCellClass() ?>"><span id="elf_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_lcgp->age->footerCellClass() ?>"><span id="elf_stock_lcgp_age" class="stock_lcgp_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_lcgp->company_id->footerCellClass() ?>"><span id="elf_stock_lcgp_company_id" class="stock_lcgp_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $stock_lcgp->s_grp->footerCellClass() ?>"><span id="elf_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_lcgp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_lcgp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_lcgp_list->Recordset)
	$stock_lcgp_list->Recordset->Close();
?>
<?php if (!$stock_lcgp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_lcgp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_lcgp_list->Pager)) $stock_lcgp_list->Pager = new PrevNextPager($stock_lcgp_list->StartRec, $stock_lcgp_list->DisplayRecs, $stock_lcgp_list->TotalRecs, $stock_lcgp_list->AutoHidePager) ?>
<?php if ($stock_lcgp_list->Pager->RecordCount > 0 && $stock_lcgp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_lcgp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_lcgp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_lcgp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_lcgp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_lcgp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_lcgp_list->pageUrl() ?>start=<?php echo $stock_lcgp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_lcgp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_lcgp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_lcgp_list->TotalRecs > 0 && (!$stock_lcgp_list->AutoHidePageSizeSelector || $stock_lcgp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_lcgp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_lcgp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_lcgp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_lcgp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_lcgp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_lcgp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_lcgp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_lcgp_list->TotalRecs == 0 && !$stock_lcgp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_lcgp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_lcgp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_lcgp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_lcgp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_lcgp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_lcgp_list->terminate();
?>