<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$stock_lcgp_preview = new stock_lcgp_preview();

// Run the page
$stock_lcgp_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgp_preview->Page_Render();
?>
<?php $stock_lcgp_preview->showPageHeader(); ?>
<div class="card ew-grid stock_lcgp"><!-- .card -->
<?php if ($stock_lcgp_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$stock_lcgp_preview->renderListOptions();

// Render list options (header, left)
$stock_lcgp_preview->ListOptions->render("header", "left");
?>
<?php if ($stock_lcgp->rid->Visible) { // rid ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->rid) == "") { ?>
		<th class="<?php echo $stock_lcgp->rid->headerCellClass() ?>"><?php echo $stock_lcgp->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->rid->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->rid->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->rid->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->grp) == "") { ?>
		<th class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><?php echo $stock_lcgp->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->grp->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->grp->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->grp->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->product) == "") { ?>
		<th class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><?php echo $stock_lcgp->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->product->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->product->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->product->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->product_code) == "") { ?>
		<th class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><?php echo $stock_lcgp->product_code->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->product_code->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->product_code->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->product_code->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->product_code->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->godown) == "") { ?>
		<th class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><?php echo $stock_lcgp->godown->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->godown->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->godown->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->godown->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->godown->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->IN) == "") { ?>
		<th class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><?php echo $stock_lcgp->IN->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->IN->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->IN->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->IN->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->IN->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->OUT) == "") { ?>
		<th class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><?php echo $stock_lcgp->OUT->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->OUT->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->OUT->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->OUT->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->OUT->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->Balance) == "") { ?>
		<th class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><?php echo $stock_lcgp->Balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->Balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->Balance->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->Balance->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->Balance->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->packets) == "") { ?>
		<th class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><?php echo $stock_lcgp->packets->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->packets->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->packets->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->packets->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->packets->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->packing_type_n) == "") { ?>
		<th class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><?php echo $stock_lcgp->packing_type_n->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->packing_type_n->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->packing_type_n->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->packing_type_n->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->packing_type_n->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->packing_type_n->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->lot_no) == "") { ?>
		<th class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><?php echo $stock_lcgp->lot_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->lot_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->lot_no->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->lot_no->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->lot_no->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->HOLD) == "") { ?>
		<th class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><?php echo $stock_lcgp->HOLD->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->HOLD->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->HOLD->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->HOLD->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->HOLD->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->HOLD->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->age) == "") { ?>
		<th class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><?php echo $stock_lcgp->age->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->age->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->age->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->age->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->age->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->company_id) == "") { ?>
		<th class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><?php echo $stock_lcgp->company_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->company_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->company_id->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->company_id->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->company_id->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_lcgp->SortUrl($stock_lcgp->s_grp) == "") { ?>
		<th class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>"><?php echo $stock_lcgp->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock_lcgp->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock_lcgp->s_grp->Name) ?>" data-sort-order="<?php echo $stock_lcgp_preview->SortField == $stock_lcgp->s_grp->Name && $stock_lcgp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_lcgp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_lcgp_preview->SortField == $stock_lcgp->s_grp->Name) { ?><?php if ($stock_lcgp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_lcgp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_lcgp_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$stock_lcgp_preview->RecCount = 0;
$stock_lcgp_preview->RowCnt = 0;
while ($stock_lcgp_preview->Recordset && !$stock_lcgp_preview->Recordset->EOF) {

	// Init row class and style
	$stock_lcgp_preview->RecCount++;
	$stock_lcgp_preview->RowCnt++;
	$stock_lcgp_preview->CssStyle = "";
	$stock_lcgp_preview->loadListRowValues($stock_lcgp_preview->Recordset);
	$stock_lcgp_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$stock_lcgp_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$stock_lcgp_preview->resetAttributes();
	$stock_lcgp_preview->renderListRow();

	// Render list options
	$stock_lcgp_preview->renderListOptions();
?>
	<tr<?php echo $stock_lcgp_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_lcgp_preview->ListOptions->render("body", "left", $stock_lcgp_preview->RowCnt);
?>
<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $stock_lcgp->rid->cellAttributes() ?>>
<span<?php echo $stock_lcgp->rid->viewAttributes() ?>>
<?php echo $stock_lcgp->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $stock_lcgp->grp->cellAttributes() ?>>
<span<?php echo $stock_lcgp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->grp->getViewValue())) && $stock_lcgp->grp->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->grp->linkAttributes() ?>><?php echo $stock_lcgp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $stock_lcgp->product->cellAttributes() ?>>
<span<?php echo $stock_lcgp->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product->getViewValue())) && $stock_lcgp->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product->linkAttributes() ?>><?php echo $stock_lcgp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<!-- product_code -->
		<td<?php echo $stock_lcgp->product_code->cellAttributes() ?>>
<span<?php echo $stock_lcgp->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->product_code->getViewValue())) && $stock_lcgp->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->product_code->linkAttributes() ?>><?php echo $stock_lcgp->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->product_code->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<!-- godown -->
		<td<?php echo $stock_lcgp->godown->cellAttributes() ?>>
<span<?php echo $stock_lcgp->godown->viewAttributes() ?>>
<?php echo $stock_lcgp->godown->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<!-- IN -->
		<td<?php echo $stock_lcgp->IN->cellAttributes() ?>>
<span<?php echo $stock_lcgp->IN->viewAttributes() ?>>
<?php echo $stock_lcgp->IN->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<!-- OUT -->
		<td<?php echo $stock_lcgp->OUT->cellAttributes() ?>>
<span<?php echo $stock_lcgp->OUT->viewAttributes() ?>>
<?php echo $stock_lcgp->OUT->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<!-- Balance -->
		<td<?php echo $stock_lcgp->Balance->cellAttributes() ?>>
<span<?php echo $stock_lcgp->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_lcgp->Balance->getViewValue())) && $stock_lcgp->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_lcgp->Balance->linkAttributes() ?>><?php echo $stock_lcgp->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_lcgp->Balance->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<!-- packets -->
		<td<?php echo $stock_lcgp->packets->cellAttributes() ?>>
<span<?php echo $stock_lcgp->packets->viewAttributes() ?>>
<?php echo $stock_lcgp->packets->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<!-- packing_type_n -->
		<td<?php echo $stock_lcgp->packing_type_n->cellAttributes() ?>>
<span<?php echo $stock_lcgp->packing_type_n->viewAttributes() ?>>
<?php echo $stock_lcgp->packing_type_n->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<!-- lot_no -->
		<td<?php echo $stock_lcgp->lot_no->cellAttributes() ?>>
<span<?php echo $stock_lcgp->lot_no->viewAttributes() ?>>
<?php echo $stock_lcgp->lot_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<!-- HOLD -->
		<td<?php echo $stock_lcgp->HOLD->cellAttributes() ?>>
<span<?php echo $stock_lcgp->HOLD->viewAttributes() ?>>
<?php echo $stock_lcgp->HOLD->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
		<!-- age -->
		<td<?php echo $stock_lcgp->age->cellAttributes() ?>>
<span<?php echo $stock_lcgp->age->viewAttributes() ?>>
<?php echo $stock_lcgp->age->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td<?php echo $stock_lcgp->company_id->cellAttributes() ?>>
<span<?php echo $stock_lcgp->company_id->viewAttributes() ?>>
<?php echo $stock_lcgp->company_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $stock_lcgp->s_grp->cellAttributes() ?>>
<span<?php echo $stock_lcgp->s_grp->viewAttributes() ?>>
<?php echo $stock_lcgp->s_grp->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$stock_lcgp_preview->ListOptions->render("body", "right", $stock_lcgp_preview->RowCnt);
?>
	</tr>
<?php
	$stock_lcgp_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$stock_lcgp_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$stock_lcgp_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$stock_lcgp_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$stock_lcgp_preview->ListOptions->render("footer", "left");
?>
<?php if ($stock_lcgp->rid->Visible) { // rid ?>
		<!-- rid -->
		<td class="<?php echo $stock_lcgp->rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
		<!-- grp -->
		<td class="<?php echo $stock_lcgp->grp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
		<!-- product -->
		<td class="<?php echo $stock_lcgp->product->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
		<!-- product_code -->
		<td class="<?php echo $stock_lcgp->product_code->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
		<!-- godown -->
		<td class="<?php echo $stock_lcgp->godown->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
		<!-- IN -->
		<td class="<?php echo $stock_lcgp->IN->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->IN->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
		<!-- OUT -->
		<td class="<?php echo $stock_lcgp->OUT->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->OUT->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
		<!-- Balance -->
		<td class="<?php echo $stock_lcgp->Balance->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_lcgp->Balance->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
		<!-- packets -->
		<td class="<?php echo $stock_lcgp->packets->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
		<!-- packing_type_n -->
		<td class="<?php echo $stock_lcgp->packing_type_n->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
		<!-- lot_no -->
		<td class="<?php echo $stock_lcgp->lot_no->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
		<!-- HOLD -->
		<td class="<?php echo $stock_lcgp->HOLD->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
		<!-- age -->
		<td class="<?php echo $stock_lcgp->age->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td class="<?php echo $stock_lcgp->company_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td class="<?php echo $stock_lcgp->s_grp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$stock_lcgp_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($stock_lcgp_preview->TotalRecs > 0) { ?>
<?php if (!isset($stock_lcgp_preview->Pager)) $stock_lcgp_preview->Pager = new PrevNextPager($stock_lcgp_preview->StartRec, $stock_lcgp_preview->DisplayRecs, $stock_lcgp_preview->TotalRecs) ?>
<?php if ($stock_lcgp_preview->Pager->RecordCount > 0 && $stock_lcgp_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($stock_lcgp_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $stock_lcgp_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($stock_lcgp_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $stock_lcgp_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($stock_lcgp_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $stock_lcgp_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($stock_lcgp_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $stock_lcgp_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $stock_lcgp_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $stock_lcgp_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $stock_lcgp_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($stock_lcgp_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$stock_lcgp_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($stock_lcgp_preview->Recordset)
	$stock_lcgp_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$stock_lcgp_preview->terminate();
?>