<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_lcgp_search = new stock_lcgp_search();

// Run the page
$stock_lcgp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_lcgp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_lcgp_search->IsModal) { ?>
var fstock_lcgpsearch = currentAdvancedSearchForm = new ew.Form("fstock_lcgpsearch", "search");
<?php } else { ?>
var fstock_lcgpsearch = currentForm = new ew.Form("fstock_lcgpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_lcgpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_lcgpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_lcgpsearch.lists["x_grp"] = <?php echo $stock_lcgp_search->grp->Lookup->toClientList() ?>;
fstock_lcgpsearch.lists["x_grp"].options = <?php echo JsonEncode($stock_lcgp_search->grp->lookupOptions()) ?>;
fstock_lcgpsearch.lists["x_product"] = <?php echo $stock_lcgp_search->product->Lookup->toClientList() ?>;
fstock_lcgpsearch.lists["x_product"].options = <?php echo JsonEncode($stock_lcgp_search->product->lookupOptions()) ?>;
fstock_lcgpsearch.lists["x_godown"] = <?php echo $stock_lcgp_search->godown->Lookup->toClientList() ?>;
fstock_lcgpsearch.lists["x_godown"].options = <?php echo JsonEncode($stock_lcgp_search->godown->lookupOptions()) ?>;
fstock_lcgpsearch.lists["x_company_id"] = <?php echo $stock_lcgp_search->company_id->Lookup->toClientList() ?>;
fstock_lcgpsearch.lists["x_company_id"].options = <?php echo JsonEncode($stock_lcgp_search->company_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_lcgpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_HOLD");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->HOLD->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->avg_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->age->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_lcgp->s_grp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_lcgp_search->showPageHeader(); ?>
<?php
$stock_lcgp_search->showMessage();
?>
<form name="fstock_lcgpsearch" id="fstock_lcgpsearch" class="<?php echo $stock_lcgp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_lcgp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_lcgp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_lcgp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_lcgp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_lcgp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_grp"><?php echo $stock_lcgp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->grp->cellAttributes() ?>>
			<span id="el_stock_lcgp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_grp" data-value-separator="<?php echo $stock_lcgp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $stock_lcgp->grp->editAttributes() ?>>
		<?php echo $stock_lcgp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $stock_lcgp->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_product"><?php echo $stock_lcgp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->product->cellAttributes() ?>>
			<span id="el_stock_lcgp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_product" data-value-separator="<?php echo $stock_lcgp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_lcgp->product->editAttributes() ?>>
		<?php echo $stock_lcgp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_lcgp->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_product_code"><?php echo $stock_lcgp->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->product_code->cellAttributes() ?>>
			<span id="el_stock_lcgp_product_code">
<input type="text" data-table="stock_lcgp" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_lcgp->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->product_code->EditValue ?>"<?php echo $stock_lcgp->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_godown"><?php echo $stock_lcgp->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->godown->cellAttributes() ?>>
			<span id="el_stock_lcgp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_godown" data-value-separator="<?php echo $stock_lcgp->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_lcgp->godown->editAttributes() ?>>
		<?php echo $stock_lcgp->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_lcgp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->godown_n->Visible) { // godown_n ?>
	<div id="r_godown_n" class="form-group row">
		<label for="x_godown_n" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_godown_n"><?php echo $stock_lcgp->godown_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_godown_n" id="z_godown_n" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->godown_n->cellAttributes() ?>>
			<span id="el_stock_lcgp_godown_n">
<input type="text" data-table="stock_lcgp" data-field="x_godown_n" name="x_godown_n" id="x_godown_n" size="30" maxlength="28" placeholder="<?php echo HtmlEncode($stock_lcgp->godown_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->godown_n->EditValue ?>"<?php echo $stock_lcgp->godown_n->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_IN"><?php echo $stock_lcgp->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->IN->cellAttributes() ?>>
			<span id="el_stock_lcgp_IN">
<input type="text" data-table="stock_lcgp" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->IN->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->IN->EditValue ?>"<?php echo $stock_lcgp->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_OUT"><?php echo $stock_lcgp->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->OUT->cellAttributes() ?>>
			<span id="el_stock_lcgp_OUT">
<input type="text" data-table="stock_lcgp" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->OUT->EditValue ?>"<?php echo $stock_lcgp->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_Balance"><?php echo $stock_lcgp->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_lcgp->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_stock_lcgp_Balance">
<input type="text" data-table="stock_lcgp" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->Balance->EditValue ?>"<?php echo $stock_lcgp->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_stock_lcgp_Balance" class="btw1_Balance d-none">
<input type="text" data-table="stock_lcgp" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->Balance->EditValue2 ?>"<?php echo $stock_lcgp->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_packets"><?php echo $stock_lcgp->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->packets->cellAttributes() ?>>
			<span id="el_stock_lcgp_packets">
<input type="text" data-table="stock_lcgp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->packets->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packets->EditValue ?>"<?php echo $stock_lcgp->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->packing_type_n->Visible) { // packing_type_n ?>
	<div id="r_packing_type_n" class="form-group row">
		<label for="x_packing_type_n" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_packing_type_n"><?php echo $stock_lcgp->packing_type_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing_type_n" id="z_packing_type_n" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->packing_type_n->cellAttributes() ?>>
			<span id="el_stock_lcgp_packing_type_n">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type_n" name="x_packing_type_n" id="x_packing_type_n" size="30" maxlength="54" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type_n->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type_n->EditValue ?>"<?php echo $stock_lcgp->packing_type_n->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_lot_no"><?php echo $stock_lcgp->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->lot_no->cellAttributes() ?>>
			<span id="el_stock_lcgp_lot_no">
<input type="text" data-table="stock_lcgp" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_lcgp->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->lot_no->EditValue ?>"<?php echo $stock_lcgp->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_packing_type"><?php echo $stock_lcgp->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->packing_type->cellAttributes() ?>>
			<span id="el_stock_lcgp_packing_type">
<input type="text" data-table="stock_lcgp" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->packing_type->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->packing_type->EditValue ?>"<?php echo $stock_lcgp->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_url"><?php echo $stock_lcgp->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->url->cellAttributes() ?>>
			<span id="el_stock_lcgp_url">
<input type="text" data-table="stock_lcgp" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="187" placeholder="<?php echo HtmlEncode($stock_lcgp->url->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->url->EditValue ?>"<?php echo $stock_lcgp->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->HOLD->Visible) { // HOLD ?>
	<div id="r_HOLD" class="form-group row">
		<label for="x_HOLD" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_HOLD"><?php echo $stock_lcgp->HOLD->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_HOLD" id="z_HOLD" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->HOLD->cellAttributes() ?>>
			<span id="el_stock_lcgp_HOLD">
<input type="text" data-table="stock_lcgp" data-field="x_HOLD" name="x_HOLD" id="x_HOLD" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->HOLD->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->HOLD->EditValue ?>"<?php echo $stock_lcgp->HOLD->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label for="x_avg_quantity" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_avg_quantity"><?php echo $stock_lcgp->avg_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->avg_quantity->cellAttributes() ?>>
			<span id="el_stock_lcgp_avg_quantity">
<input type="text" data-table="stock_lcgp" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->avg_quantity->EditValue ?>"<?php echo $stock_lcgp->avg_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_age"><?php echo $stock_lcgp->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->age->cellAttributes() ?>>
			<span id="el_stock_lcgp_age">
<input type="text" data-table="stock_lcgp" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->age->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->age->EditValue ?>"<?php echo $stock_lcgp->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_company_id"><?php echo $stock_lcgp->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->company_id->cellAttributes() ?>>
			<span id="el_stock_lcgp_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_lcgp" data-field="x_company_id" data-value-separator="<?php echo $stock_lcgp->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $stock_lcgp->company_id->editAttributes() ?>>
		<?php echo $stock_lcgp->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $stock_lcgp->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_lcgp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $stock_lcgp_search->LeftColumnClass ?>"><span id="elh_stock_lcgp_s_grp"><?php echo $stock_lcgp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $stock_lcgp_search->RightColumnClass ?>"><div<?php echo $stock_lcgp->s_grp->cellAttributes() ?>>
			<span id="el_stock_lcgp_s_grp">
<input type="text" data-table="stock_lcgp" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($stock_lcgp->s_grp->getPlaceHolder()) ?>" value="<?php echo $stock_lcgp->s_grp->EditValue ?>"<?php echo $stock_lcgp->s_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_lcgp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_lcgp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_lcgp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_lcgp_search->terminate();
?>