<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_material_in_hs_list = new stock_material_in_hs_list();

// Run the page
$stock_material_in_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_material_in_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_material_in_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_material_in_hslist = currentForm = new ew.Form("fstock_material_in_hslist", "list");
fstock_material_in_hslist.formKeyCountName = '<?php echo $stock_material_in_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_material_in_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_material_in_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_material_in_hslist.lists["x_grp"] = <?php echo $stock_material_in_hs_list->grp->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_grp"].options = <?php echo JsonEncode($stock_material_in_hs_list->grp->options(FALSE, TRUE)) ?>;
fstock_material_in_hslist.lists["x_s_grp"] = <?php echo $stock_material_in_hs_list->s_grp->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_s_grp"].options = <?php echo JsonEncode($stock_material_in_hs_list->s_grp->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_product"] = <?php echo $stock_material_in_hs_list->product->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_product"].options = <?php echo JsonEncode($stock_material_in_hs_list->product->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_rid"] = <?php echo $stock_material_in_hs_list->rid->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_rid"].options = <?php echo JsonEncode($stock_material_in_hs_list->rid->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_IN"] = <?php echo $stock_material_in_hs_list->IN->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_IN"].options = <?php echo JsonEncode($stock_material_in_hs_list->IN->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_packets"] = <?php echo $stock_material_in_hs_list->packets->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_packets"].options = <?php echo JsonEncode($stock_material_in_hs_list->packets->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_packing_type"] = <?php echo $stock_material_in_hs_list->packing_type->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_material_in_hs_list->packing_type->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_godown"] = <?php echo $stock_material_in_hs_list->godown->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_godown"].options = <?php echo JsonEncode($stock_material_in_hs_list->godown->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_lot_no"] = <?php echo $stock_material_in_hs_list->lot_no->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_lot_no"].options = <?php echo JsonEncode($stock_material_in_hs_list->lot_no->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_tmp_lot"] = <?php echo $stock_material_in_hs_list->tmp_lot->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_tmp_lot"].options = <?php echo JsonEncode($stock_material_in_hs_list->tmp_lot->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_jc_no"] = <?php echo $stock_material_in_hs_list->jc_no->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_jc_no"].options = <?php echo JsonEncode($stock_material_in_hs_list->jc_no->lookupOptions()) ?>;
fstock_material_in_hslist.lists["x_item"] = <?php echo $stock_material_in_hs_list->item->Lookup->toClientList() ?>;
fstock_material_in_hslist.lists["x_item"].options = <?php echo JsonEncode($stock_material_in_hs_list->item->lookupOptions()) ?>;

// Form object for search
var fstock_material_in_hslistsrch = currentSearchForm = new ew.Form("fstock_material_in_hslistsrch");

// Filters
fstock_material_in_hslistsrch.filterList = <?php echo $stock_material_in_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_material_in_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_material_in_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_material_in_hs_list->TotalRecs > 0 && $stock_material_in_hs_list->ExportOptions->visible()) { ?>
<?php $stock_material_in_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_in_hs_list->ImportOptions->visible()) { ?>
<?php $stock_material_in_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_in_hs_list->SearchOptions->visible()) { ?>
<?php $stock_material_in_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_in_hs_list->FilterOptions->visible()) { ?>
<?php $stock_material_in_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_material_in_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_material_in_hs->isExport() && !$stock_material_in_hs->CurrentAction) { ?>
<form name="fstock_material_in_hslistsrch" id="fstock_material_in_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_material_in_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_material_in_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_material_in_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_material_in_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_material_in_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_material_in_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_material_in_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_material_in_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_material_in_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_material_in_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_material_in_hs_list->showPageHeader(); ?>
<?php
$stock_material_in_hs_list->showMessage();
?>
<?php if ($stock_material_in_hs_list->TotalRecs > 0 || $stock_material_in_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_material_in_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_material_in_hs">
<?php if (!$stock_material_in_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_material_in_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_in_hs_list->Pager)) $stock_material_in_hs_list->Pager = new PrevNextPager($stock_material_in_hs_list->StartRec, $stock_material_in_hs_list->DisplayRecs, $stock_material_in_hs_list->TotalRecs, $stock_material_in_hs_list->AutoHidePager) ?>
<?php if ($stock_material_in_hs_list->Pager->RecordCount > 0 && $stock_material_in_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_in_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_in_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_in_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_in_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_in_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_in_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_in_hs_list->TotalRecs > 0 && (!$stock_material_in_hs_list->AutoHidePageSizeSelector || $stock_material_in_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_in_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_in_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_in_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_in_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_in_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_in_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_in_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_in_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_material_in_hslist" id="fstock_material_in_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_material_in_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_material_in_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_material_in_hs">
<div id="gmp_stock_material_in_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_material_in_hs_list->TotalRecs > 0 || $stock_material_in_hs->isGridEdit()) { ?>
<table id="tbl_stock_material_in_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_material_in_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_material_in_hs_list->renderListOptions();

// Render list options (header, left)
$stock_material_in_hs_list->ListOptions->render("header", "left");
?>
<?php if ($stock_material_in_hs->grp->Visible) { // grp ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $stock_material_in_hs->grp->headerCellClass() ?>"><div id="elh_stock_material_in_hs_grp" class="stock_material_in_hs_grp"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $stock_material_in_hs->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->grp) ?>',2);"><div id="elh_stock_material_in_hs_grp" class="stock_material_in_hs_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $stock_material_in_hs->s_grp->headerCellClass() ?>"><div id="elh_stock_material_in_hs_s_grp" class="stock_material_in_hs_s_grp"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $stock_material_in_hs->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->s_grp) ?>',2);"><div id="elh_stock_material_in_hs_s_grp" class="stock_material_in_hs_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->product->Visible) { // product ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_material_in_hs->product->headerCellClass() ?>"><div id="elh_stock_material_in_hs_product" class="stock_material_in_hs_product"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_material_in_hs->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->product) ?>',2);"><div id="elh_stock_material_in_hs_product" class="stock_material_in_hs_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->rid->Visible) { // rid ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_material_in_hs->rid->headerCellClass() ?>"><div id="elh_stock_material_in_hs_rid" class="stock_material_in_hs_rid"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_material_in_hs->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->rid) ?>',2);"><div id="elh_stock_material_in_hs_rid" class="stock_material_in_hs_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->IN->Visible) { // IN ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_material_in_hs->IN->headerCellClass() ?>"><div id="elh_stock_material_in_hs_IN" class="stock_material_in_hs_IN"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_material_in_hs->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->IN) ?>',2);"><div id="elh_stock_material_in_hs_IN" class="stock_material_in_hs_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->packets->Visible) { // packets ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_material_in_hs->packets->headerCellClass() ?>"><div id="elh_stock_material_in_hs_packets" class="stock_material_in_hs_packets"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_material_in_hs->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->packets) ?>',2);"><div id="elh_stock_material_in_hs_packets" class="stock_material_in_hs_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_in_hs->packing_type->headerCellClass() ?>"><div id="elh_stock_material_in_hs_packing_type" class="stock_material_in_hs_packing_type"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_in_hs->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->packing_type) ?>',2);"><div id="elh_stock_material_in_hs_packing_type" class="stock_material_in_hs_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->godown->Visible) { // godown ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_material_in_hs->godown->headerCellClass() ?>"><div id="elh_stock_material_in_hs_godown" class="stock_material_in_hs_godown"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_material_in_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->godown) ?>',2);"><div id="elh_stock_material_in_hs_godown" class="stock_material_in_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_in_hs->lot_no->headerCellClass() ?>"><div id="elh_stock_material_in_hs_lot_no" class="stock_material_in_hs_lot_no"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_in_hs->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->lot_no) ?>',2);"><div id="elh_stock_material_in_hs_lot_no" class="stock_material_in_hs_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_material_in_hs->tmp_lot->headerCellClass() ?>"><div id="elh_stock_material_in_hs_tmp_lot" class="stock_material_in_hs_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_material_in_hs->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->tmp_lot) ?>',2);"><div id="elh_stock_material_in_hs_tmp_lot" class="stock_material_in_hs_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->jc_no->Visible) { // jc_no ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $stock_material_in_hs->jc_no->headerCellClass() ?>"><div id="elh_stock_material_in_hs_jc_no" class="stock_material_in_hs_jc_no"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $stock_material_in_hs->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->jc_no) ?>',2);"><div id="elh_stock_material_in_hs_jc_no" class="stock_material_in_hs_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->item->Visible) { // item ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->item) == "") { ?>
		<th data-name="item" class="<?php echo $stock_material_in_hs->item->headerCellClass() ?>"><div id="elh_stock_material_in_hs_item" class="stock_material_in_hs_item"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $stock_material_in_hs->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->item) ?>',2);"><div id="elh_stock_material_in_hs_item" class="stock_material_in_hs_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->po->Visible) { // po ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->po) == "") { ?>
		<th data-name="po" class="<?php echo $stock_material_in_hs->po->headerCellClass() ?>"><div id="elh_stock_material_in_hs_po" class="stock_material_in_hs_po"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $stock_material_in_hs->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->po) ?>',2);"><div id="elh_stock_material_in_hs_po" class="stock_material_in_hs_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->batch_no->Visible) { // batch_no ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $stock_material_in_hs->batch_no->headerCellClass() ?>"><div id="elh_stock_material_in_hs_batch_no" class="stock_material_in_hs_batch_no"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $stock_material_in_hs->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->batch_no) ?>',2);"><div id="elh_stock_material_in_hs_batch_no" class="stock_material_in_hs_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_in_hs->jc_quantity->Visible) { // jc_quantity ?>
	<?php if ($stock_material_in_hs->sortUrl($stock_material_in_hs->jc_quantity) == "") { ?>
		<th data-name="jc_quantity" class="<?php echo $stock_material_in_hs->jc_quantity->headerCellClass() ?>"><div id="elh_stock_material_in_hs_jc_quantity" class="stock_material_in_hs_jc_quantity"><div class="ew-table-header-caption"><?php echo $stock_material_in_hs->jc_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_quantity" class="<?php echo $stock_material_in_hs->jc_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_in_hs->SortUrl($stock_material_in_hs->jc_quantity) ?>',2);"><div id="elh_stock_material_in_hs_jc_quantity" class="stock_material_in_hs_jc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_in_hs->jc_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_in_hs->jc_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_in_hs->jc_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_material_in_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_material_in_hs->ExportAll && $stock_material_in_hs->isExport()) {
	$stock_material_in_hs_list->StopRec = $stock_material_in_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_material_in_hs_list->TotalRecs > $stock_material_in_hs_list->StartRec + $stock_material_in_hs_list->DisplayRecs - 1)
		$stock_material_in_hs_list->StopRec = $stock_material_in_hs_list->StartRec + $stock_material_in_hs_list->DisplayRecs - 1;
	else
		$stock_material_in_hs_list->StopRec = $stock_material_in_hs_list->TotalRecs;
}
$stock_material_in_hs_list->RecCnt = $stock_material_in_hs_list->StartRec - 1;
if ($stock_material_in_hs_list->Recordset && !$stock_material_in_hs_list->Recordset->EOF) {
	$stock_material_in_hs_list->Recordset->moveFirst();
	$selectLimit = $stock_material_in_hs_list->UseSelectLimit;
	if (!$selectLimit && $stock_material_in_hs_list->StartRec > 1)
		$stock_material_in_hs_list->Recordset->move($stock_material_in_hs_list->StartRec - 1);
} elseif (!$stock_material_in_hs->AllowAddDeleteRow && $stock_material_in_hs_list->StopRec == 0) {
	$stock_material_in_hs_list->StopRec = $stock_material_in_hs->GridAddRowCount;
}

// Initialize aggregate
$stock_material_in_hs->RowType = ROWTYPE_AGGREGATEINIT;
$stock_material_in_hs->resetAttributes();
$stock_material_in_hs_list->renderRow();
while ($stock_material_in_hs_list->RecCnt < $stock_material_in_hs_list->StopRec) {
	$stock_material_in_hs_list->RecCnt++;
	if ($stock_material_in_hs_list->RecCnt >= $stock_material_in_hs_list->StartRec) {
		$stock_material_in_hs_list->RowCnt++;

		// Set up key count
		$stock_material_in_hs_list->KeyCount = $stock_material_in_hs_list->RowIndex;

		// Init row class and style
		$stock_material_in_hs->resetAttributes();
		$stock_material_in_hs->CssClass = "";
		if ($stock_material_in_hs->isGridAdd()) {
		} else {
			$stock_material_in_hs_list->loadRowValues($stock_material_in_hs_list->Recordset); // Load row values
		}
		$stock_material_in_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_material_in_hs->RowAttrs = array_merge($stock_material_in_hs->RowAttrs, array('data-rowindex'=>$stock_material_in_hs_list->RowCnt, 'id'=>'r' . $stock_material_in_hs_list->RowCnt . '_stock_material_in_hs', 'data-rowtype'=>$stock_material_in_hs->RowType));

		// Render row
		$stock_material_in_hs_list->renderRow();

		// Render list options
		$stock_material_in_hs_list->renderListOptions();
?>
	<tr<?php echo $stock_material_in_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_material_in_hs_list->ListOptions->render("body", "left", $stock_material_in_hs_list->RowCnt);
?>
	<?php if ($stock_material_in_hs->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $stock_material_in_hs->grp->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_grp" class="stock_material_in_hs_grp">
<span<?php echo $stock_material_in_hs->grp->viewAttributes() ?>>
<?php echo $stock_material_in_hs->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $stock_material_in_hs->s_grp->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_s_grp" class="stock_material_in_hs_s_grp">
<span<?php echo $stock_material_in_hs->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->s_grp->getViewValue())) && $stock_material_in_hs->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->s_grp->linkAttributes() ?>><?php echo $stock_material_in_hs->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_material_in_hs->product->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_product" class="stock_material_in_hs_product">
<span<?php echo $stock_material_in_hs->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->product->getViewValue())) && $stock_material_in_hs->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->product->linkAttributes() ?>><?php echo $stock_material_in_hs->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_material_in_hs->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_rid" class="stock_material_in_hs_rid">
<span<?php echo $stock_material_in_hs->rid->viewAttributes() ?>>
<?php echo $stock_material_in_hs->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_material_in_hs->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_IN" class="stock_material_in_hs_IN">
<span<?php echo $stock_material_in_hs->IN->viewAttributes() ?>>
<?php echo $stock_material_in_hs->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_material_in_hs->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_packets" class="stock_material_in_hs_packets">
<span<?php echo $stock_material_in_hs->packets->viewAttributes() ?>>
<?php echo $stock_material_in_hs->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_material_in_hs->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_packing_type" class="stock_material_in_hs_packing_type">
<span<?php echo $stock_material_in_hs->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->packing_type->getViewValue())) && $stock_material_in_hs->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->packing_type->linkAttributes() ?>><?php echo $stock_material_in_hs->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_material_in_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_godown" class="stock_material_in_hs_godown">
<span<?php echo $stock_material_in_hs->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->godown->getViewValue())) && $stock_material_in_hs->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->godown->linkAttributes() ?>><?php echo $stock_material_in_hs->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_material_in_hs->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_lot_no" class="stock_material_in_hs_lot_no">
<span<?php echo $stock_material_in_hs->lot_no->viewAttributes() ?>>
<?php echo $stock_material_in_hs->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_material_in_hs->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_tmp_lot" class="stock_material_in_hs_tmp_lot">
<span<?php echo $stock_material_in_hs->tmp_lot->viewAttributes() ?>>
<?php echo $stock_material_in_hs->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $stock_material_in_hs->jc_no->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_jc_no" class="stock_material_in_hs_jc_no">
<span<?php echo $stock_material_in_hs->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->jc_no->getViewValue())) && $stock_material_in_hs->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->jc_no->linkAttributes() ?>><?php echo $stock_material_in_hs->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->item->Visible) { // item ?>
		<td data-name="item"<?php echo $stock_material_in_hs->item->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_item" class="stock_material_in_hs_item">
<span<?php echo $stock_material_in_hs->item->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_in_hs->item->getViewValue())) && $stock_material_in_hs->item->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_in_hs->item->linkAttributes() ?>><?php echo $stock_material_in_hs->item->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_in_hs->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->po->Visible) { // po ?>
		<td data-name="po"<?php echo $stock_material_in_hs->po->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_po" class="stock_material_in_hs_po">
<span<?php echo $stock_material_in_hs->po->viewAttributes() ?>>
<?php echo $stock_material_in_hs->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $stock_material_in_hs->batch_no->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_batch_no" class="stock_material_in_hs_batch_no">
<span<?php echo $stock_material_in_hs->batch_no->viewAttributes() ?>>
<?php echo $stock_material_in_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_in_hs->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity"<?php echo $stock_material_in_hs->jc_quantity->cellAttributes() ?>>
<span id="el<?php echo $stock_material_in_hs_list->RowCnt ?>_stock_material_in_hs_jc_quantity" class="stock_material_in_hs_jc_quantity">
<span<?php echo $stock_material_in_hs->jc_quantity->viewAttributes() ?>>
<?php echo $stock_material_in_hs->jc_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_material_in_hs_list->ListOptions->render("body", "right", $stock_material_in_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_material_in_hs->isGridAdd())
		$stock_material_in_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_material_in_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_material_in_hs_list->Recordset)
	$stock_material_in_hs_list->Recordset->Close();
?>
<?php if (!$stock_material_in_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_material_in_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_in_hs_list->Pager)) $stock_material_in_hs_list->Pager = new PrevNextPager($stock_material_in_hs_list->StartRec, $stock_material_in_hs_list->DisplayRecs, $stock_material_in_hs_list->TotalRecs, $stock_material_in_hs_list->AutoHidePager) ?>
<?php if ($stock_material_in_hs_list->Pager->RecordCount > 0 && $stock_material_in_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_in_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_in_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_in_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_in_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_in_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_in_hs_list->pageUrl() ?>start=<?php echo $stock_material_in_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_in_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_in_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_in_hs_list->TotalRecs > 0 && (!$stock_material_in_hs_list->AutoHidePageSizeSelector || $stock_material_in_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_in_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_in_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_in_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_in_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_in_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_in_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_in_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_in_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_material_in_hs_list->TotalRecs == 0 && !$stock_material_in_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_material_in_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_material_in_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_material_in_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_material_in_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_material_in_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_material_in_hs_list->terminate();
?>