<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_material_out_emp_hs_addopt = new stock_material_out_emp_hs_addopt();

// Run the page
$stock_material_out_emp_hs_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_material_out_emp_hs_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fstock_material_out_emp_hsaddopt = currentForm = new ew.Form("fstock_material_out_emp_hsaddopt", "addopt");

// Validate form
fstock_material_out_emp_hsaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($stock_material_out_emp_hs_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->product->caption(), $stock_material_out_emp_hs->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->jc_no->caption(), $stock_material_out_emp_hs->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->emp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->emp_id->caption(), $stock_material_out_emp_hs->emp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->emp_name->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->emp_name->caption(), $stock_material_out_emp_hs->emp_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->rid->caption(), $stock_material_out_emp_hs->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->OUT->Required) { ?>
			elm = this.getElements("x" + infix + "_OUT");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->OUT->caption(), $stock_material_out_emp_hs->OUT->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->item->caption(), $stock_material_out_emp_hs->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->item_code->Required) { ?>
			elm = this.getElements("x" + infix + "_item_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->item_code->caption(), $stock_material_out_emp_hs->item_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->IN->Required) { ?>
			elm = this.getElements("x" + infix + "_IN");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->IN->caption(), $stock_material_out_emp_hs->IN->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->Balance->Required) { ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->Balance->caption(), $stock_material_out_emp_hs->Balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->Balance->errorMessage()) ?>");
		<?php if ($stock_material_out_emp_hs_addopt->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->godown->caption(), $stock_material_out_emp_hs->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->outid->Required) { ?>
			elm = this.getElements("x" + infix + "_outid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->outid->caption(), $stock_material_out_emp_hs->outid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->Shortage->Required) { ?>
			elm = this.getElements("x" + infix + "_Shortage");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->Shortage->caption(), $stock_material_out_emp_hs->Shortage->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->count->Required) { ?>
			elm = this.getElements("x" + infix + "_count");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->count->caption(), $stock_material_out_emp_hs->count->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_count");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->count->errorMessage()) ?>");
		<?php if ($stock_material_out_emp_hs_addopt->jc_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->jc_quantity->caption(), $stock_material_out_emp_hs->jc_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->jc_quantity->errorMessage()) ?>");
		<?php if ($stock_material_out_emp_hs_addopt->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->po->caption(), $stock_material_out_emp_hs->po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->po->errorMessage()) ?>");
		<?php if ($stock_material_out_emp_hs_addopt->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->batch_no->caption(), $stock_material_out_emp_hs->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->count_received->Required) { ?>
			elm = this.getElements("x" + infix + "_count_received");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->count_received->caption(), $stock_material_out_emp_hs->count_received->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_count_received");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->count_received->errorMessage()) ?>");
		<?php if ($stock_material_out_emp_hs_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->status->caption(), $stock_material_out_emp_hs->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_material_out_emp_hs_addopt->jc_no_fp->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no_fp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_material_out_emp_hs->jc_no_fp->caption(), $stock_material_out_emp_hs->jc_no_fp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_no_fp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_material_out_emp_hs->jc_no_fp->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstock_material_out_emp_hsaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_material_out_emp_hsaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_material_out_emp_hsaddopt.lists["x_product"] = <?php echo $stock_material_out_emp_hs_addopt->product->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_product"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->product->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_jc_no"] = <?php echo $stock_material_out_emp_hs_addopt->jc_no->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_jc_no"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->jc_no->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_emp_id"] = <?php echo $stock_material_out_emp_hs_addopt->emp_id->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_emp_id"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->emp_id->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_emp_name"] = <?php echo $stock_material_out_emp_hs_addopt->emp_name->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_emp_name"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->emp_name->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_rid"] = <?php echo $stock_material_out_emp_hs_addopt->rid->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_rid"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->rid->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_OUT"] = <?php echo $stock_material_out_emp_hs_addopt->OUT->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_OUT"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->OUT->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_item"] = <?php echo $stock_material_out_emp_hs_addopt->item->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_item"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->item->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_material_out_emp_hsaddopt.lists["x_item_code"] = <?php echo $stock_material_out_emp_hs_addopt->item_code->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_item_code"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->item_code->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_IN"] = <?php echo $stock_material_out_emp_hs_addopt->IN->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_IN"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->IN->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_godown"] = <?php echo $stock_material_out_emp_hs_addopt->godown->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_godown"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->godown->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_outid"] = <?php echo $stock_material_out_emp_hs_addopt->outid->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_outid"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->outid->lookupOptions()) ?>;
fstock_material_out_emp_hsaddopt.lists["x_status"] = <?php echo $stock_material_out_emp_hs_addopt->status->Lookup->toClientList() ?>;
fstock_material_out_emp_hsaddopt.lists["x_status"].options = <?php echo JsonEncode($stock_material_out_emp_hs_addopt->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_material_out_emp_hs_addopt->showPageHeader(); ?>
<?php
$stock_material_out_emp_hs_addopt->showMessage();
?>
<form name="fstock_material_out_emp_hsaddopt" id="fstock_material_out_emp_hsaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($stock_material_out_emp_hs_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_material_out_emp_hs_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $stock_material_out_emp_hs_addopt->TableVar ?>">
<?php if ($stock_material_out_emp_hs->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $stock_material_out_emp_hs->product->caption() ?><?php echo ($stock_material_out_emp_hs->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_product" data-value-separator="<?php echo $stock_material_out_emp_hs->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_material_out_emp_hs->product->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $stock_material_out_emp_hs->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->jc_no->Visible) { // jc_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_jc_no"><?php echo $stock_material_out_emp_hs->jc_no->caption() ?><?php echo ($stock_material_out_emp_hs->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_jc_no" data-value-separator="<?php echo $stock_material_out_emp_hs->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $stock_material_out_emp_hs->jc_no->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
<?php echo $stock_material_out_emp_hs->jc_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->emp_id->Visible) { // emp_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_emp_id"><?php echo $stock_material_out_emp_hs->emp_id->caption() ?><?php echo ($stock_material_out_emp_hs->emp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_emp_id" data-value-separator="<?php echo $stock_material_out_emp_hs->emp_id->displayValueSeparatorAttribute() ?>" id="x_emp_id" name="x_emp_id"<?php echo $stock_material_out_emp_hs->emp_id->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->emp_id->selectOptionListHtml("x_emp_id") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
<?php echo $stock_material_out_emp_hs->emp_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->emp_name->Visible) { // emp_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_emp_name"><?php echo $stock_material_out_emp_hs->emp_name->caption() ?><?php echo ($stock_material_out_emp_hs->emp_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_emp_name" data-value-separator="<?php echo $stock_material_out_emp_hs->emp_name->displayValueSeparatorAttribute() ?>" id="x_emp_name" name="x_emp_name"<?php echo $stock_material_out_emp_hs->emp_name->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->emp_name->selectOptionListHtml("x_emp_name") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
<?php echo $stock_material_out_emp_hs->emp_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->rid->Visible) { // rid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_rid"><?php echo $stock_material_out_emp_hs->rid->caption() ?><?php echo ($stock_material_out_emp_hs->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_rid" data-value-separator="<?php echo $stock_material_out_emp_hs->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $stock_material_out_emp_hs->rid->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->rid->Lookup->getParamTag("p_x_rid") ?>
<?php echo $stock_material_out_emp_hs->rid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->OUT->Visible) { // OUT ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_OUT"><?php echo $stock_material_out_emp_hs->OUT->caption() ?><?php echo ($stock_material_out_emp_hs->OUT->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_OUT" data-value-separator="<?php echo $stock_material_out_emp_hs->OUT->displayValueSeparatorAttribute() ?>" id="x_OUT" name="x_OUT"<?php echo $stock_material_out_emp_hs->OUT->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->OUT->selectOptionListHtml("x_OUT") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->OUT->Lookup->getParamTag("p_x_OUT") ?>
<?php echo $stock_material_out_emp_hs->OUT->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $stock_material_out_emp_hs->item->caption() ?><?php echo ($stock_material_out_emp_hs->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$stock_material_out_emp_hs->item->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$stock_material_out_emp_hs->item->EditAttrs["onchange"] = "";
?>
<span id="as_x_item" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_item" id="sv_x_item" value="<?php echo RemoveHtml($stock_material_out_emp_hs->item->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->item->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->item->getPlaceHolder()) ?>"<?php echo $stock_material_out_emp_hs->item->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_material_out_emp_hs" data-field="x_item" data-value-separator="<?php echo $stock_material_out_emp_hs->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?php echo HtmlEncode($stock_material_out_emp_hs->item->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fstock_material_out_emp_hsaddopt.createAutoSuggest({"id":"x_item","forceSelect":false});
</script>
<?php echo $stock_material_out_emp_hs->item->Lookup->getParamTag("p_x_item") ?>
<?php echo $stock_material_out_emp_hs->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->item_code->Visible) { // item_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_item_code"><?php echo $stock_material_out_emp_hs->item_code->caption() ?><?php echo ($stock_material_out_emp_hs->item_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_item_code" data-value-separator="<?php echo $stock_material_out_emp_hs->item_code->displayValueSeparatorAttribute() ?>" id="x_item_code" name="x_item_code"<?php echo $stock_material_out_emp_hs->item_code->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->item_code->selectOptionListHtml("x_item_code") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->item_code->Lookup->getParamTag("p_x_item_code") ?>
<?php echo $stock_material_out_emp_hs->item_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->IN->Visible) { // IN ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_IN"><?php echo $stock_material_out_emp_hs->IN->caption() ?><?php echo ($stock_material_out_emp_hs->IN->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_IN" data-value-separator="<?php echo $stock_material_out_emp_hs->IN->displayValueSeparatorAttribute() ?>" id="x_IN" name="x_IN"<?php echo $stock_material_out_emp_hs->IN->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->IN->selectOptionListHtml("x_IN") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->IN->Lookup->getParamTag("p_x_IN") ?>
<?php echo $stock_material_out_emp_hs->IN->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->Balance->Visible) { // Balance ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Balance"><?php echo $stock_material_out_emp_hs->Balance->caption() ?><?php echo ($stock_material_out_emp_hs->Balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->Balance->EditValue ?>"<?php echo $stock_material_out_emp_hs->Balance->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->Balance->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->godown->Visible) { // godown ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_godown"><?php echo $stock_material_out_emp_hs->godown->caption() ?><?php echo ($stock_material_out_emp_hs->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_godown" data-value-separator="<?php echo $stock_material_out_emp_hs->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_material_out_emp_hs->godown->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->godown->Lookup->getParamTag("p_x_godown") ?>
<?php echo $stock_material_out_emp_hs->godown->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->outid->Visible) { // outid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_outid"><?php echo $stock_material_out_emp_hs->outid->caption() ?><?php echo ($stock_material_out_emp_hs->outid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_outid" data-value-separator="<?php echo $stock_material_out_emp_hs->outid->displayValueSeparatorAttribute() ?>" id="x_outid" name="x_outid"<?php echo $stock_material_out_emp_hs->outid->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->outid->selectOptionListHtml("x_outid") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->outid->Lookup->getParamTag("p_x_outid") ?>
<?php echo $stock_material_out_emp_hs->outid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->Shortage->Visible) { // Shortage ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Shortage"><?php echo $stock_material_out_emp_hs->Shortage->caption() ?><?php echo ($stock_material_out_emp_hs->Shortage->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_Shortage" name="x_Shortage" id="x_Shortage" size="30" maxlength="33" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->Shortage->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->Shortage->EditValue ?>"<?php echo $stock_material_out_emp_hs->Shortage->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->Shortage->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->count->Visible) { // count ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_count"><?php echo $stock_material_out_emp_hs->count->caption() ?><?php echo ($stock_material_out_emp_hs->count->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_count" name="x_count" id="x_count" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->count->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->count->EditValue ?>"<?php echo $stock_material_out_emp_hs->count->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->count->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->jc_quantity->Visible) { // jc_quantity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_jc_quantity"><?php echo $stock_material_out_emp_hs->jc_quantity->caption() ?><?php echo ($stock_material_out_emp_hs->jc_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_jc_quantity" name="x_jc_quantity" id="x_jc_quantity" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->jc_quantity->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->jc_quantity->EditValue ?>"<?php echo $stock_material_out_emp_hs->jc_quantity->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->jc_quantity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->po->Visible) { // po ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_po"><?php echo $stock_material_out_emp_hs->po->caption() ?><?php echo ($stock_material_out_emp_hs->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->po->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->po->EditValue ?>"<?php echo $stock_material_out_emp_hs->po->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->po->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->batch_no->Visible) { // batch_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_batch_no"><?php echo $stock_material_out_emp_hs->batch_no->caption() ?><?php echo ($stock_material_out_emp_hs->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->batch_no->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->batch_no->EditValue ?>"<?php echo $stock_material_out_emp_hs->batch_no->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->batch_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->count_received->Visible) { // count_received ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_count_received"><?php echo $stock_material_out_emp_hs->count_received->caption() ?><?php echo ($stock_material_out_emp_hs->count_received->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_count_received" name="x_count_received" id="x_count_received" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->count_received->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->count_received->EditValue ?>"<?php echo $stock_material_out_emp_hs->count_received->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->count_received->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $stock_material_out_emp_hs->status->caption() ?><?php echo ($stock_material_out_emp_hs->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out_emp_hs" data-field="x_status" data-value-separator="<?php echo $stock_material_out_emp_hs->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_material_out_emp_hs->status->editAttributes() ?>>
		<?php echo $stock_material_out_emp_hs->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $stock_material_out_emp_hs->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($stock_material_out_emp_hs->jc_no_fp->Visible) { // jc_no_fp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_jc_no_fp"><?php echo $stock_material_out_emp_hs->jc_no_fp->caption() ?><?php echo ($stock_material_out_emp_hs->jc_no_fp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="stock_material_out_emp_hs" data-field="x_jc_no_fp" name="x_jc_no_fp" id="x_jc_no_fp" size="30" placeholder="<?php echo HtmlEncode($stock_material_out_emp_hs->jc_no_fp->getPlaceHolder()) ?>" value="<?php echo $stock_material_out_emp_hs->jc_no_fp->EditValue ?>"<?php echo $stock_material_out_emp_hs->jc_no_fp->editAttributes() ?>>
<?php echo $stock_material_out_emp_hs->jc_no_fp->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$stock_material_out_emp_hs_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$stock_material_out_emp_hs_addopt->terminate();
?>