<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_material_out_f_list = new stock_material_out_f_list();

// Run the page
$stock_material_out_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_material_out_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_material_out_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_material_out_flist = currentForm = new ew.Form("fstock_material_out_flist", "list");
fstock_material_out_flist.formKeyCountName = '<?php echo $stock_material_out_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_material_out_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_material_out_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_material_out_flist.lists["x_product"] = <?php echo $stock_material_out_f_list->product->Lookup->toClientList() ?>;
fstock_material_out_flist.lists["x_product"].options = <?php echo JsonEncode($stock_material_out_f_list->product->lookupOptions()) ?>;
fstock_material_out_flist.lists["x_godown"] = <?php echo $stock_material_out_f_list->godown->Lookup->toClientList() ?>;
fstock_material_out_flist.lists["x_godown"].options = <?php echo JsonEncode($stock_material_out_f_list->godown->lookupOptions()) ?>;
fstock_material_out_flist.lists["x_packing_type"] = <?php echo $stock_material_out_f_list->packing_type->Lookup->toClientList() ?>;
fstock_material_out_flist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_material_out_f_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_material_out_flistsrch = currentSearchForm = new ew.Form("fstock_material_out_flistsrch");

// Filters
fstock_material_out_flistsrch.filterList = <?php echo $stock_material_out_f_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_material_out_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_material_out_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_material_out_f_list->TotalRecs > 0 && $stock_material_out_f_list->ExportOptions->visible()) { ?>
<?php $stock_material_out_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_f_list->ImportOptions->visible()) { ?>
<?php $stock_material_out_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_f_list->SearchOptions->visible()) { ?>
<?php $stock_material_out_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_f_list->FilterOptions->visible()) { ?>
<?php $stock_material_out_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_material_out_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_material_out_f->isExport() && !$stock_material_out_f->CurrentAction) { ?>
<form name="fstock_material_out_flistsrch" id="fstock_material_out_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_material_out_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_material_out_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_material_out_f">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_material_out_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_material_out_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_material_out_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_material_out_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_material_out_f_list->showPageHeader(); ?>
<?php
$stock_material_out_f_list->showMessage();
?>
<?php if ($stock_material_out_f_list->TotalRecs > 0 || $stock_material_out_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_material_out_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_material_out_f">
<?php if (!$stock_material_out_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_material_out_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_out_f_list->Pager)) $stock_material_out_f_list->Pager = new PrevNextPager($stock_material_out_f_list->StartRec, $stock_material_out_f_list->DisplayRecs, $stock_material_out_f_list->TotalRecs, $stock_material_out_f_list->AutoHidePager) ?>
<?php if ($stock_material_out_f_list->Pager->RecordCount > 0 && $stock_material_out_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_out_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_out_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_out_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_out_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_out_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_out_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_out_f_list->TotalRecs > 0 && (!$stock_material_out_f_list->AutoHidePageSizeSelector || $stock_material_out_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_out_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_out_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_out_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_out_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_out_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_out_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_out_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_out_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_material_out_flist" id="fstock_material_out_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_material_out_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_material_out_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_material_out_f">
<div id="gmp_stock_material_out_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_material_out_f_list->TotalRecs > 0 || $stock_material_out_f->isGridEdit()) { ?>
<table id="tbl_stock_material_out_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_material_out_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_material_out_f_list->renderListOptions();

// Render list options (header, left)
$stock_material_out_f_list->ListOptions->render("header", "left");
?>
<?php if ($stock_material_out_f->product->Visible) { // product ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_material_out_f->product->headerCellClass() ?>"><div id="elh_stock_material_out_f_product" class="stock_material_out_f_product"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_material_out_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->product) ?>',2);"><div id="elh_stock_material_out_f_product" class="stock_material_out_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->product_code->Visible) { // product_code ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_material_out_f->product_code->headerCellClass() ?>"><div id="elh_stock_material_out_f_product_code" class="stock_material_out_f_product_code"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_material_out_f->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->product_code) ?>',2);"><div id="elh_stock_material_out_f_product_code" class="stock_material_out_f_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->process->Visible) { // process ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->process) == "") { ?>
		<th data-name="process" class="<?php echo $stock_material_out_f->process->headerCellClass() ?>"><div id="elh_stock_material_out_f_process" class="stock_material_out_f_process"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $stock_material_out_f->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->process) ?>',2);"><div id="elh_stock_material_out_f_process" class="stock_material_out_f_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->process->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->godown->Visible) { // godown ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_material_out_f->godown->headerCellClass() ?>"><div id="elh_stock_material_out_f_godown" class="stock_material_out_f_godown"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_material_out_f->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->godown) ?>',2);"><div id="elh_stock_material_out_f_godown" class="stock_material_out_f_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->IN->Visible) { // IN ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_material_out_f->IN->headerCellClass() ?>"><div id="elh_stock_material_out_f_IN" class="stock_material_out_f_IN"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_material_out_f->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->IN) ?>',2);"><div id="elh_stock_material_out_f_IN" class="stock_material_out_f_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->OUT->Visible) { // OUT ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_material_out_f->OUT->headerCellClass() ?>"><div id="elh_stock_material_out_f_OUT" class="stock_material_out_f_OUT"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_material_out_f->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->OUT) ?>',2);"><div id="elh_stock_material_out_f_OUT" class="stock_material_out_f_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->packets->Visible) { // packets ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_material_out_f->packets->headerCellClass() ?>"><div id="elh_stock_material_out_f_packets" class="stock_material_out_f_packets"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_material_out_f->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->packets) ?>',2);"><div id="elh_stock_material_out_f_packets" class="stock_material_out_f_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_out_f->packing_type->headerCellClass() ?>"><div id="elh_stock_material_out_f_packing_type" class="stock_material_out_f_packing_type"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_out_f->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->packing_type) ?>',2);"><div id="elh_stock_material_out_f_packing_type" class="stock_material_out_f_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_out_f->lot_no->headerCellClass() ?>"><div id="elh_stock_material_out_f_lot_no" class="stock_material_out_f_lot_no"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_out_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->lot_no) ?>',2);"><div id="elh_stock_material_out_f_lot_no" class="stock_material_out_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_material_out_f->tmp_lot->headerCellClass() ?>"><div id="elh_stock_material_out_f_tmp_lot" class="stock_material_out_f_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_material_out_f->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->tmp_lot) ?>',2);"><div id="elh_stock_material_out_f_tmp_lot" class="stock_material_out_f_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out_f->url->Visible) { // url ?>
	<?php if ($stock_material_out_f->sortUrl($stock_material_out_f->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_material_out_f->url->headerCellClass() ?>"><div id="elh_stock_material_out_f_url" class="stock_material_out_f_url"><div class="ew-table-header-caption"><?php echo $stock_material_out_f->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_material_out_f->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out_f->SortUrl($stock_material_out_f->url) ?>',2);"><div id="elh_stock_material_out_f_url" class="stock_material_out_f_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out_f->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out_f->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out_f->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_material_out_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_material_out_f->ExportAll && $stock_material_out_f->isExport()) {
	$stock_material_out_f_list->StopRec = $stock_material_out_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_material_out_f_list->TotalRecs > $stock_material_out_f_list->StartRec + $stock_material_out_f_list->DisplayRecs - 1)
		$stock_material_out_f_list->StopRec = $stock_material_out_f_list->StartRec + $stock_material_out_f_list->DisplayRecs - 1;
	else
		$stock_material_out_f_list->StopRec = $stock_material_out_f_list->TotalRecs;
}
$stock_material_out_f_list->RecCnt = $stock_material_out_f_list->StartRec - 1;
if ($stock_material_out_f_list->Recordset && !$stock_material_out_f_list->Recordset->EOF) {
	$stock_material_out_f_list->Recordset->moveFirst();
	$selectLimit = $stock_material_out_f_list->UseSelectLimit;
	if (!$selectLimit && $stock_material_out_f_list->StartRec > 1)
		$stock_material_out_f_list->Recordset->move($stock_material_out_f_list->StartRec - 1);
} elseif (!$stock_material_out_f->AllowAddDeleteRow && $stock_material_out_f_list->StopRec == 0) {
	$stock_material_out_f_list->StopRec = $stock_material_out_f->GridAddRowCount;
}

// Initialize aggregate
$stock_material_out_f->RowType = ROWTYPE_AGGREGATEINIT;
$stock_material_out_f->resetAttributes();
$stock_material_out_f_list->renderRow();
while ($stock_material_out_f_list->RecCnt < $stock_material_out_f_list->StopRec) {
	$stock_material_out_f_list->RecCnt++;
	if ($stock_material_out_f_list->RecCnt >= $stock_material_out_f_list->StartRec) {
		$stock_material_out_f_list->RowCnt++;

		// Set up key count
		$stock_material_out_f_list->KeyCount = $stock_material_out_f_list->RowIndex;

		// Init row class and style
		$stock_material_out_f->resetAttributes();
		$stock_material_out_f->CssClass = "";
		if ($stock_material_out_f->isGridAdd()) {
		} else {
			$stock_material_out_f_list->loadRowValues($stock_material_out_f_list->Recordset); // Load row values
		}
		$stock_material_out_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_material_out_f->RowAttrs = array_merge($stock_material_out_f->RowAttrs, array('data-rowindex'=>$stock_material_out_f_list->RowCnt, 'id'=>'r' . $stock_material_out_f_list->RowCnt . '_stock_material_out_f', 'data-rowtype'=>$stock_material_out_f->RowType));

		// Render row
		$stock_material_out_f_list->renderRow();

		// Render list options
		$stock_material_out_f_list->renderListOptions();
?>
	<tr<?php echo $stock_material_out_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_material_out_f_list->ListOptions->render("body", "left", $stock_material_out_f_list->RowCnt);
?>
	<?php if ($stock_material_out_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_material_out_f->product->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_product" class="stock_material_out_f_product">
<span<?php echo $stock_material_out_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->product->getViewValue())) && $stock_material_out_f->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->product->linkAttributes() ?>><?php echo $stock_material_out_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_material_out_f->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_product_code" class="stock_material_out_f_product_code">
<span<?php echo $stock_material_out_f->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->product_code->getViewValue())) && $stock_material_out_f->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->product_code->linkAttributes() ?>><?php echo $stock_material_out_f->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->process->Visible) { // process ?>
		<td data-name="process"<?php echo $stock_material_out_f->process->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_process" class="stock_material_out_f_process">
<span<?php echo $stock_material_out_f->process->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->process->getViewValue())) && $stock_material_out_f->process->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->process->linkAttributes() ?>><?php echo $stock_material_out_f->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_material_out_f->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_godown" class="stock_material_out_f_godown">
<span<?php echo $stock_material_out_f->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->godown->getViewValue())) && $stock_material_out_f->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->godown->linkAttributes() ?>><?php echo $stock_material_out_f->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_material_out_f->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_IN" class="stock_material_out_f_IN">
<span<?php echo $stock_material_out_f->IN->viewAttributes() ?>>
<?php echo $stock_material_out_f->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_material_out_f->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_OUT" class="stock_material_out_f_OUT">
<span<?php echo $stock_material_out_f->OUT->viewAttributes() ?>>
<?php echo $stock_material_out_f->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_material_out_f->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_packets" class="stock_material_out_f_packets">
<span<?php echo $stock_material_out_f->packets->viewAttributes() ?>>
<?php echo $stock_material_out_f->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_material_out_f->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_packing_type" class="stock_material_out_f_packing_type">
<span<?php echo $stock_material_out_f->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->packing_type->getViewValue())) && $stock_material_out_f->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->packing_type->linkAttributes() ?>><?php echo $stock_material_out_f->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_material_out_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_lot_no" class="stock_material_out_f_lot_no">
<span<?php echo $stock_material_out_f->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out_f->lot_no->getViewValue())) && $stock_material_out_f->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out_f->lot_no->linkAttributes() ?>><?php echo $stock_material_out_f->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out_f->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_material_out_f->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_tmp_lot" class="stock_material_out_f_tmp_lot">
<span<?php echo $stock_material_out_f->tmp_lot->viewAttributes() ?>>
<?php echo $stock_material_out_f->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out_f->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_material_out_f->url->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_f_list->RowCnt ?>_stock_material_out_f_url" class="stock_material_out_f_url">
<span<?php echo $stock_material_out_f->url->viewAttributes() ?>>
<?php echo $stock_material_out_f->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_material_out_f_list->ListOptions->render("body", "right", $stock_material_out_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_material_out_f->isGridAdd())
		$stock_material_out_f_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_material_out_f->RowType = ROWTYPE_AGGREGATE;
$stock_material_out_f->resetAttributes();
$stock_material_out_f_list->renderRow();
?>
<?php if ($stock_material_out_f_list->TotalRecs > 0 && !$stock_material_out_f->isGridAdd() && !$stock_material_out_f->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_material_out_f_list->renderListOptions();

// Render list options (footer, left)
$stock_material_out_f_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_material_out_f->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_material_out_f->product->footerCellClass() ?>"><span id="elf_stock_material_out_f_product" class="stock_material_out_f_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_material_out_f->product_code->footerCellClass() ?>"><span id="elf_stock_material_out_f_product_code" class="stock_material_out_f_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $stock_material_out_f->process->footerCellClass() ?>"><span id="elf_stock_material_out_f_process" class="stock_material_out_f_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_material_out_f->godown->footerCellClass() ?>"><span id="elf_stock_material_out_f_godown" class="stock_material_out_f_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_material_out_f->IN->footerCellClass() ?>"><span id="elf_stock_material_out_f_IN" class="stock_material_out_f_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out_f->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_material_out_f->OUT->footerCellClass() ?>"><span id="elf_stock_material_out_f_OUT" class="stock_material_out_f_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out_f->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_material_out_f->packets->footerCellClass() ?>"><span id="elf_stock_material_out_f_packets" class="stock_material_out_f_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out_f->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_material_out_f->packing_type->footerCellClass() ?>"><span id="elf_stock_material_out_f_packing_type" class="stock_material_out_f_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_material_out_f->lot_no->footerCellClass() ?>"><span id="elf_stock_material_out_f_lot_no" class="stock_material_out_f_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_material_out_f->tmp_lot->footerCellClass() ?>"><span id="elf_stock_material_out_f_tmp_lot" class="stock_material_out_f_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out_f->url->Visible) { // url ?>
		<td data-name="url" class="<?php echo $stock_material_out_f->url->footerCellClass() ?>"><span id="elf_stock_material_out_f_url" class="stock_material_out_f_url">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_material_out_f_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_material_out_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_material_out_f_list->Recordset)
	$stock_material_out_f_list->Recordset->Close();
?>
<?php if (!$stock_material_out_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_material_out_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_out_f_list->Pager)) $stock_material_out_f_list->Pager = new PrevNextPager($stock_material_out_f_list->StartRec, $stock_material_out_f_list->DisplayRecs, $stock_material_out_f_list->TotalRecs, $stock_material_out_f_list->AutoHidePager) ?>
<?php if ($stock_material_out_f_list->Pager->RecordCount > 0 && $stock_material_out_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_out_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_out_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_out_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_out_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_out_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_out_f_list->pageUrl() ?>start=<?php echo $stock_material_out_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_out_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_out_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_out_f_list->TotalRecs > 0 && (!$stock_material_out_f_list->AutoHidePageSizeSelector || $stock_material_out_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_out_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_out_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_out_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_out_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_out_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_out_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_out_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_out_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_material_out_f_list->TotalRecs == 0 && !$stock_material_out_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_material_out_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_material_out_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_material_out_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_material_out_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_material_out_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_material_out_f_list->terminate();
?>