<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_material_out_list = new stock_material_out_list();

// Run the page
$stock_material_out_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_material_out_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_material_out->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_material_outlist = currentForm = new ew.Form("fstock_material_outlist", "list");
fstock_material_outlist.formKeyCountName = '<?php echo $stock_material_out_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_material_outlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_material_outlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_material_outlist.lists["x_product"] = <?php echo $stock_material_out_list->product->Lookup->toClientList() ?>;
fstock_material_outlist.lists["x_product"].options = <?php echo JsonEncode($stock_material_out_list->product->lookupOptions()) ?>;
fstock_material_outlist.lists["x_godown"] = <?php echo $stock_material_out_list->godown->Lookup->toClientList() ?>;
fstock_material_outlist.lists["x_godown"].options = <?php echo JsonEncode($stock_material_out_list->godown->lookupOptions()) ?>;
fstock_material_outlist.lists["x_packing_type"] = <?php echo $stock_material_out_list->packing_type->Lookup->toClientList() ?>;
fstock_material_outlist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_material_out_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_material_outlistsrch = currentSearchForm = new ew.Form("fstock_material_outlistsrch");

// Validate function for search
fstock_material_outlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_material_outlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_material_outlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_material_outlistsrch.lists["x_product"] = <?php echo $stock_material_out_list->product->Lookup->toClientList() ?>;
fstock_material_outlistsrch.lists["x_product"].options = <?php echo JsonEncode($stock_material_out_list->product->lookupOptions()) ?>;

// Filters
fstock_material_outlistsrch.filterList = <?php echo $stock_material_out_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_material_outlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_material_out->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_material_out_list->TotalRecs > 0 && $stock_material_out_list->ExportOptions->visible()) { ?>
<?php $stock_material_out_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_list->ImportOptions->visible()) { ?>
<?php $stock_material_out_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_list->SearchOptions->visible()) { ?>
<?php $stock_material_out_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_material_out_list->FilterOptions->visible()) { ?>
<?php $stock_material_out_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_material_out_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_material_out->isExport() && !$stock_material_out->CurrentAction) { ?>
<form name="fstock_material_outlistsrch" id="fstock_material_outlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_material_out_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_material_outlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_material_out">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_material_out_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_material_out->RowType = ROWTYPE_SEARCH;

// Render row
$stock_material_out->resetAttributes();
$stock_material_out_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_material_out->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $stock_material_out->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_material_out" data-field="x_product" data-value-separator="<?php echo $stock_material_out->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_material_out->product->editAttributes() ?>>
		<?php echo $stock_material_out->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_material_out->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_material_out->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_material_out->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_material_out" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($stock_material_out->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_material_out->product_code->EditValue ?>"<?php echo $stock_material_out->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_material_out_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_material_out_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_material_out_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_material_out_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_material_out_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_material_out_list->showPageHeader(); ?>
<?php
$stock_material_out_list->showMessage();
?>
<?php if ($stock_material_out_list->TotalRecs > 0 || $stock_material_out->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_material_out_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_material_out">
<?php if (!$stock_material_out->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_material_out->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_out_list->Pager)) $stock_material_out_list->Pager = new PrevNextPager($stock_material_out_list->StartRec, $stock_material_out_list->DisplayRecs, $stock_material_out_list->TotalRecs, $stock_material_out_list->AutoHidePager) ?>
<?php if ($stock_material_out_list->Pager->RecordCount > 0 && $stock_material_out_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_out_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_out_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_out_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_out_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_out_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_out_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_out_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_out_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_out_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_out_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_out_list->TotalRecs > 0 && (!$stock_material_out_list->AutoHidePageSizeSelector || $stock_material_out_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_out">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_out_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_out_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_out_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_out_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_out_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_out->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_out_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_material_outlist" id="fstock_material_outlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_material_out_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_material_out_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_material_out">
<div id="gmp_stock_material_out" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_material_out_list->TotalRecs > 0 || $stock_material_out->isGridEdit()) { ?>
<table id="tbl_stock_material_outlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_material_out_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_material_out_list->renderListOptions();

// Render list options (header, left)
$stock_material_out_list->ListOptions->render("header", "left");
?>
<?php if ($stock_material_out->product->Visible) { // product ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_material_out->product->headerCellClass() ?>"><div id="elh_stock_material_out_product" class="stock_material_out_product"><div class="ew-table-header-caption"><?php echo $stock_material_out->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_material_out->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->product) ?>',2);"><div id="elh_stock_material_out_product" class="stock_material_out_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->product_code->Visible) { // product_code ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_material_out->product_code->headerCellClass() ?>"><div id="elh_stock_material_out_product_code" class="stock_material_out_product_code"><div class="ew-table-header-caption"><?php echo $stock_material_out->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_material_out->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->product_code) ?>',2);"><div id="elh_stock_material_out_product_code" class="stock_material_out_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->godown->Visible) { // godown ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_material_out->godown->headerCellClass() ?>"><div id="elh_stock_material_out_godown" class="stock_material_out_godown"><div class="ew-table-header-caption"><?php echo $stock_material_out->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_material_out->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->godown) ?>',2);"><div id="elh_stock_material_out_godown" class="stock_material_out_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->IN->Visible) { // IN ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_material_out->IN->headerCellClass() ?>"><div id="elh_stock_material_out_IN" class="stock_material_out_IN"><div class="ew-table-header-caption"><?php echo $stock_material_out->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_material_out->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->IN) ?>',2);"><div id="elh_stock_material_out_IN" class="stock_material_out_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->OUT->Visible) { // OUT ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_material_out->OUT->headerCellClass() ?>"><div id="elh_stock_material_out_OUT" class="stock_material_out_OUT"><div class="ew-table-header-caption"><?php echo $stock_material_out->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_material_out->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->OUT) ?>',2);"><div id="elh_stock_material_out_OUT" class="stock_material_out_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->packets->Visible) { // packets ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_material_out->packets->headerCellClass() ?>"><div id="elh_stock_material_out_packets" class="stock_material_out_packets"><div class="ew-table-header-caption"><?php echo $stock_material_out->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_material_out->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->packets) ?>',2);"><div id="elh_stock_material_out_packets" class="stock_material_out_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_out->packing_type->headerCellClass() ?>"><div id="elh_stock_material_out_packing_type" class="stock_material_out_packing_type"><div class="ew-table-header-caption"><?php echo $stock_material_out->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_material_out->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->packing_type) ?>',2);"><div id="elh_stock_material_out_packing_type" class="stock_material_out_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_out->lot_no->headerCellClass() ?>"><div id="elh_stock_material_out_lot_no" class="stock_material_out_lot_no"><div class="ew-table-header-caption"><?php echo $stock_material_out->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_material_out->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->lot_no) ?>',2);"><div id="elh_stock_material_out_lot_no" class="stock_material_out_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->age->Visible) { // age ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_material_out->age->headerCellClass() ?>"><div id="elh_stock_material_out_age" class="stock_material_out_age"><div class="ew-table-header-caption"><?php echo $stock_material_out->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_material_out->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->age) ?>',2);"><div id="elh_stock_material_out_age" class="stock_material_out_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->dated->Visible) { // dated ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_material_out->dated->headerCellClass() ?>"><div id="elh_stock_material_out_dated" class="stock_material_out_dated"><div class="ew-table-header-caption"><?php echo $stock_material_out->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_material_out->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->dated) ?>',2);"><div id="elh_stock_material_out_dated" class="stock_material_out_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->type->Visible) { // type ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_material_out->type->headerCellClass() ?>"><div id="elh_stock_material_out_type" class="stock_material_out_type"><div class="ew-table-header-caption"><?php echo $stock_material_out->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_material_out->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->type) ?>',2);"><div id="elh_stock_material_out_type" class="stock_material_out_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_material_out->company_id->Visible) { // company_id ?>
	<?php if ($stock_material_out->sortUrl($stock_material_out->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_material_out->company_id->headerCellClass() ?>"><div id="elh_stock_material_out_company_id" class="stock_material_out_company_id"><div class="ew-table-header-caption"><?php echo $stock_material_out->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_material_out->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_material_out->SortUrl($stock_material_out->company_id) ?>',2);"><div id="elh_stock_material_out_company_id" class="stock_material_out_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_material_out->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_material_out->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_material_out->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_material_out_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_material_out->ExportAll && $stock_material_out->isExport()) {
	$stock_material_out_list->StopRec = $stock_material_out_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_material_out_list->TotalRecs > $stock_material_out_list->StartRec + $stock_material_out_list->DisplayRecs - 1)
		$stock_material_out_list->StopRec = $stock_material_out_list->StartRec + $stock_material_out_list->DisplayRecs - 1;
	else
		$stock_material_out_list->StopRec = $stock_material_out_list->TotalRecs;
}
$stock_material_out_list->RecCnt = $stock_material_out_list->StartRec - 1;
if ($stock_material_out_list->Recordset && !$stock_material_out_list->Recordset->EOF) {
	$stock_material_out_list->Recordset->moveFirst();
	$selectLimit = $stock_material_out_list->UseSelectLimit;
	if (!$selectLimit && $stock_material_out_list->StartRec > 1)
		$stock_material_out_list->Recordset->move($stock_material_out_list->StartRec - 1);
} elseif (!$stock_material_out->AllowAddDeleteRow && $stock_material_out_list->StopRec == 0) {
	$stock_material_out_list->StopRec = $stock_material_out->GridAddRowCount;
}

// Initialize aggregate
$stock_material_out->RowType = ROWTYPE_AGGREGATEINIT;
$stock_material_out->resetAttributes();
$stock_material_out_list->renderRow();
while ($stock_material_out_list->RecCnt < $stock_material_out_list->StopRec) {
	$stock_material_out_list->RecCnt++;
	if ($stock_material_out_list->RecCnt >= $stock_material_out_list->StartRec) {
		$stock_material_out_list->RowCnt++;

		// Set up key count
		$stock_material_out_list->KeyCount = $stock_material_out_list->RowIndex;

		// Init row class and style
		$stock_material_out->resetAttributes();
		$stock_material_out->CssClass = "";
		if ($stock_material_out->isGridAdd()) {
		} else {
			$stock_material_out_list->loadRowValues($stock_material_out_list->Recordset); // Load row values
		}
		$stock_material_out->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_material_out->RowAttrs = array_merge($stock_material_out->RowAttrs, array('data-rowindex'=>$stock_material_out_list->RowCnt, 'id'=>'r' . $stock_material_out_list->RowCnt . '_stock_material_out', 'data-rowtype'=>$stock_material_out->RowType));

		// Render row
		$stock_material_out_list->renderRow();

		// Render list options
		$stock_material_out_list->renderListOptions();
?>
	<tr<?php echo $stock_material_out->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_material_out_list->ListOptions->render("body", "left", $stock_material_out_list->RowCnt);
?>
	<?php if ($stock_material_out->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_material_out->product->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_product" class="stock_material_out_product">
<span<?php echo $stock_material_out->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out->product->getViewValue())) && $stock_material_out->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out->product->linkAttributes() ?>><?php echo $stock_material_out->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_material_out->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_product_code" class="stock_material_out_product_code">
<span<?php echo $stock_material_out->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out->product_code->getViewValue())) && $stock_material_out->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out->product_code->linkAttributes() ?>><?php echo $stock_material_out->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_material_out->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_godown" class="stock_material_out_godown">
<span<?php echo $stock_material_out->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out->godown->getViewValue())) && $stock_material_out->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out->godown->linkAttributes() ?>><?php echo $stock_material_out->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_material_out->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_IN" class="stock_material_out_IN">
<span<?php echo $stock_material_out->IN->viewAttributes() ?>>
<?php echo $stock_material_out->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_material_out->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_OUT" class="stock_material_out_OUT">
<span<?php echo $stock_material_out->OUT->viewAttributes() ?>>
<?php echo $stock_material_out->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_material_out->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_packets" class="stock_material_out_packets">
<span<?php echo $stock_material_out->packets->viewAttributes() ?>>
<?php echo $stock_material_out->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_material_out->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_packing_type" class="stock_material_out_packing_type">
<span<?php echo $stock_material_out->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out->packing_type->getViewValue())) && $stock_material_out->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out->packing_type->linkAttributes() ?>><?php echo $stock_material_out->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_material_out->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_lot_no" class="stock_material_out_lot_no">
<span<?php echo $stock_material_out->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_material_out->lot_no->getViewValue())) && $stock_material_out->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_material_out->lot_no->linkAttributes() ?>><?php echo $stock_material_out->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_material_out->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_material_out->age->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_age" class="stock_material_out_age">
<span<?php echo $stock_material_out->age->viewAttributes() ?>>
<?php echo $stock_material_out->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_material_out->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_dated" class="stock_material_out_dated">
<span<?php echo $stock_material_out->dated->viewAttributes() ?>>
<?php echo $stock_material_out->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_material_out->type->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_type" class="stock_material_out_type">
<span<?php echo $stock_material_out->type->viewAttributes() ?>>
<?php echo $stock_material_out->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_material_out->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_material_out->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_material_out_list->RowCnt ?>_stock_material_out_company_id" class="stock_material_out_company_id">
<span<?php echo $stock_material_out->company_id->viewAttributes() ?>>
<?php echo $stock_material_out->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_material_out_list->ListOptions->render("body", "right", $stock_material_out_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_material_out->isGridAdd())
		$stock_material_out_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_material_out->RowType = ROWTYPE_AGGREGATE;
$stock_material_out->resetAttributes();
$stock_material_out_list->renderRow();
?>
<?php if ($stock_material_out_list->TotalRecs > 0 && !$stock_material_out->isGridAdd() && !$stock_material_out->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_material_out_list->renderListOptions();

// Render list options (footer, left)
$stock_material_out_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_material_out->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_material_out->product->footerCellClass() ?>"><span id="elf_stock_material_out_product" class="stock_material_out_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_material_out->product_code->footerCellClass() ?>"><span id="elf_stock_material_out_product_code" class="stock_material_out_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_material_out->godown->footerCellClass() ?>"><span id="elf_stock_material_out_godown" class="stock_material_out_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_material_out->IN->footerCellClass() ?>"><span id="elf_stock_material_out_IN" class="stock_material_out_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_material_out->OUT->footerCellClass() ?>"><span id="elf_stock_material_out_OUT" class="stock_material_out_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_material_out->packets->footerCellClass() ?>"><span id="elf_stock_material_out_packets" class="stock_material_out_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_material_out->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_material_out->packing_type->footerCellClass() ?>"><span id="elf_stock_material_out_packing_type" class="stock_material_out_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_material_out->lot_no->footerCellClass() ?>"><span id="elf_stock_material_out_lot_no" class="stock_material_out_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_material_out->age->footerCellClass() ?>"><span id="elf_stock_material_out_age" class="stock_material_out_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_material_out->dated->footerCellClass() ?>"><span id="elf_stock_material_out_dated" class="stock_material_out_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_material_out->type->footerCellClass() ?>"><span id="elf_stock_material_out_type" class="stock_material_out_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_material_out->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_material_out->company_id->footerCellClass() ?>"><span id="elf_stock_material_out_company_id" class="stock_material_out_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_material_out_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_material_out->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_material_out_list->Recordset)
	$stock_material_out_list->Recordset->Close();
?>
<?php if (!$stock_material_out->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_material_out->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_material_out_list->Pager)) $stock_material_out_list->Pager = new PrevNextPager($stock_material_out_list->StartRec, $stock_material_out_list->DisplayRecs, $stock_material_out_list->TotalRecs, $stock_material_out_list->AutoHidePager) ?>
<?php if ($stock_material_out_list->Pager->RecordCount > 0 && $stock_material_out_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_material_out_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_material_out_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_material_out_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_material_out_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_material_out_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_material_out_list->pageUrl() ?>start=<?php echo $stock_material_out_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_material_out_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_material_out_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_material_out_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_material_out_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_material_out_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_material_out_list->TotalRecs > 0 && (!$stock_material_out_list->AutoHidePageSizeSelector || $stock_material_out_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_material_out">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_material_out_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_material_out_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_material_out_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_material_out_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_material_out_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_material_out->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_material_out_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_material_out_list->TotalRecs == 0 && !$stock_material_out->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_material_out_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_material_out_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_material_out->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_material_out->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_material_out", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_material_out_list->terminate();
?>