<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_movement_detailed_list = new stock_movement_detailed_list();

// Run the page
$stock_movement_detailed_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_movement_detailed_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_movement_detailed->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_movement_detailedlist = currentForm = new ew.Form("fstock_movement_detailedlist", "list");
fstock_movement_detailedlist.formKeyCountName = '<?php echo $stock_movement_detailed_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_movement_detailedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_movement_detailedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_movement_detailedlist.lists["x_product"] = <?php echo $stock_movement_detailed_list->product->Lookup->toClientList() ?>;
fstock_movement_detailedlist.lists["x_product"].options = <?php echo JsonEncode($stock_movement_detailed_list->product->lookupOptions()) ?>;
fstock_movement_detailedlist.lists["x_godown"] = <?php echo $stock_movement_detailed_list->godown->Lookup->toClientList() ?>;
fstock_movement_detailedlist.lists["x_godown"].options = <?php echo JsonEncode($stock_movement_detailed_list->godown->lookupOptions()) ?>;
fstock_movement_detailedlist.lists["x_packing_type"] = <?php echo $stock_movement_detailed_list->packing_type->Lookup->toClientList() ?>;
fstock_movement_detailedlist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_movement_detailed_list->packing_type->lookupOptions()) ?>;
fstock_movement_detailedlist.lists["x_type"] = <?php echo $stock_movement_detailed_list->type->Lookup->toClientList() ?>;
fstock_movement_detailedlist.lists["x_type"].options = <?php echo JsonEncode($stock_movement_detailed_list->type->lookupOptions()) ?>;

// Form object for search
var fstock_movement_detailedlistsrch = currentSearchForm = new ew.Form("fstock_movement_detailedlistsrch");

// Validate function for search
fstock_movement_detailedlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_movement_detailed->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_movement_detailedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_movement_detailedlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_movement_detailedlistsrch.lists["x_product"] = <?php echo $stock_movement_detailed_list->product->Lookup->toClientList() ?>;
fstock_movement_detailedlistsrch.lists["x_product"].options = <?php echo JsonEncode($stock_movement_detailed_list->product->lookupOptions()) ?>;
fstock_movement_detailedlistsrch.lists["x_godown"] = <?php echo $stock_movement_detailed_list->godown->Lookup->toClientList() ?>;
fstock_movement_detailedlistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_movement_detailed_list->godown->lookupOptions()) ?>;
fstock_movement_detailedlistsrch.lists["x_type"] = <?php echo $stock_movement_detailed_list->type->Lookup->toClientList() ?>;
fstock_movement_detailedlistsrch.lists["x_type"].options = <?php echo JsonEncode($stock_movement_detailed_list->type->lookupOptions()) ?>;

// Filters
fstock_movement_detailedlistsrch.filterList = <?php echo $stock_movement_detailed_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_movement_detailedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_movement_detailed->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_movement_detailed_list->TotalRecs > 0 && $stock_movement_detailed_list->ExportOptions->visible()) { ?>
<?php $stock_movement_detailed_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_movement_detailed_list->ImportOptions->visible()) { ?>
<?php $stock_movement_detailed_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_movement_detailed_list->SearchOptions->visible()) { ?>
<?php $stock_movement_detailed_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_movement_detailed_list->FilterOptions->visible()) { ?>
<?php $stock_movement_detailed_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_movement_detailed_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_movement_detailed->isExport() && !$stock_movement_detailed->CurrentAction) { ?>
<form name="fstock_movement_detailedlistsrch" id="fstock_movement_detailedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_movement_detailed_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_movement_detailedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_movement_detailed">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_movement_detailed_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_movement_detailed->RowType = ROWTYPE_SEARCH;

// Render row
$stock_movement_detailed->resetAttributes();
$stock_movement_detailed_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_movement_detailed->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $stock_movement_detailed->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_movement_detailed" data-field="x_product" data-value-separator="<?php echo $stock_movement_detailed->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_movement_detailed->product->editAttributes() ?>>
		<?php echo $stock_movement_detailed->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_movement_detailed->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_movement_detailed->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_movement_detailed->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_movement_detailed" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_movement_detailed->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_movement_detailed->product_code->EditValue ?>"<?php echo $stock_movement_detailed->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_movement_detailed->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_movement_detailed->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_movement_detailed" data-field="x_godown" data-value-separator="<?php echo $stock_movement_detailed->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_movement_detailed->godown->editAttributes() ?>>
		<?php echo $stock_movement_detailed->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_movement_detailed->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_movement_detailed->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $stock_movement_detailed->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_movement_detailed->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_movement_detailed" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_movement_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $stock_movement_detailed->dated->EditValue ?>"<?php echo $stock_movement_detailed->dated->editAttributes() ?>>
<?php if (!$stock_movement_detailed->dated->ReadOnly && !$stock_movement_detailed->dated->Disabled && !isset($stock_movement_detailed->dated->EditAttrs["readonly"]) && !isset($stock_movement_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_movement_detailedlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="stock_movement_detailed" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_movement_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $stock_movement_detailed->dated->EditValue2 ?>"<?php echo $stock_movement_detailed->dated->editAttributes() ?>>
<?php if (!$stock_movement_detailed->dated->ReadOnly && !$stock_movement_detailed->dated->Disabled && !isset($stock_movement_detailed->dated->EditAttrs["readonly"]) && !isset($stock_movement_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_movement_detailedlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_movement_detailed->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $stock_movement_detailed->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_movement_detailed" data-field="x_type" data-value-separator="<?php echo $stock_movement_detailed->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $stock_movement_detailed->type->editAttributes() ?>>
		<?php echo $stock_movement_detailed->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $stock_movement_detailed->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_movement_detailed_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_movement_detailed_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_movement_detailed_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_movement_detailed_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_movement_detailed_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_movement_detailed_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_movement_detailed_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_movement_detailed_list->showPageHeader(); ?>
<?php
$stock_movement_detailed_list->showMessage();
?>
<?php if ($stock_movement_detailed_list->TotalRecs > 0 || $stock_movement_detailed->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_movement_detailed_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_movement_detailed">
<?php if (!$stock_movement_detailed->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_movement_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_movement_detailed_list->Pager)) $stock_movement_detailed_list->Pager = new PrevNextPager($stock_movement_detailed_list->StartRec, $stock_movement_detailed_list->DisplayRecs, $stock_movement_detailed_list->TotalRecs, $stock_movement_detailed_list->AutoHidePager) ?>
<?php if ($stock_movement_detailed_list->Pager->RecordCount > 0 && $stock_movement_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_movement_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_movement_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_movement_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_movement_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_movement_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_movement_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_movement_detailed_list->TotalRecs > 0 && (!$stock_movement_detailed_list->AutoHidePageSizeSelector || $stock_movement_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_movement_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_movement_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_movement_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_movement_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_movement_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_movement_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_movement_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_movement_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_movement_detailedlist" id="fstock_movement_detailedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_movement_detailed_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_movement_detailed_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_movement_detailed">
<div id="gmp_stock_movement_detailed" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_movement_detailed_list->TotalRecs > 0 || $stock_movement_detailed->isGridEdit()) { ?>
<table id="tbl_stock_movement_detailedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_movement_detailed_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_movement_detailed_list->renderListOptions();

// Render list options (header, left)
$stock_movement_detailed_list->ListOptions->render("header", "left");
?>
<?php if ($stock_movement_detailed->product->Visible) { // product ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_movement_detailed->product->headerCellClass() ?>"><div id="elh_stock_movement_detailed_product" class="stock_movement_detailed_product"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_movement_detailed->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->product) ?>',2);"><div id="elh_stock_movement_detailed_product" class="stock_movement_detailed_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->product_code->Visible) { // product_code ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_movement_detailed->product_code->headerCellClass() ?>"><div id="elh_stock_movement_detailed_product_code" class="stock_movement_detailed_product_code"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_movement_detailed->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->product_code) ?>',2);"><div id="elh_stock_movement_detailed_product_code" class="stock_movement_detailed_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->godown->Visible) { // godown ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_movement_detailed->godown->headerCellClass() ?>"><div id="elh_stock_movement_detailed_godown" class="stock_movement_detailed_godown"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_movement_detailed->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->godown) ?>',2);"><div id="elh_stock_movement_detailed_godown" class="stock_movement_detailed_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->IN->Visible) { // IN ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_movement_detailed->IN->headerCellClass() ?>"><div id="elh_stock_movement_detailed_IN" class="stock_movement_detailed_IN"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_movement_detailed->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->IN) ?>',2);"><div id="elh_stock_movement_detailed_IN" class="stock_movement_detailed_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->OUT->Visible) { // OUT ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_movement_detailed->OUT->headerCellClass() ?>"><div id="elh_stock_movement_detailed_OUT" class="stock_movement_detailed_OUT"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_movement_detailed->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->OUT) ?>',2);"><div id="elh_stock_movement_detailed_OUT" class="stock_movement_detailed_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->packets->Visible) { // packets ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_movement_detailed->packets->headerCellClass() ?>"><div id="elh_stock_movement_detailed_packets" class="stock_movement_detailed_packets"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_movement_detailed->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->packets) ?>',2);"><div id="elh_stock_movement_detailed_packets" class="stock_movement_detailed_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_movement_detailed->packing_type->headerCellClass() ?>"><div id="elh_stock_movement_detailed_packing_type" class="stock_movement_detailed_packing_type"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_movement_detailed->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->packing_type) ?>',2);"><div id="elh_stock_movement_detailed_packing_type" class="stock_movement_detailed_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_movement_detailed->lot_no->headerCellClass() ?>"><div id="elh_stock_movement_detailed_lot_no" class="stock_movement_detailed_lot_no"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_movement_detailed->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->lot_no) ?>',2);"><div id="elh_stock_movement_detailed_lot_no" class="stock_movement_detailed_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->dated->Visible) { // dated ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_movement_detailed->dated->headerCellClass() ?>"><div id="elh_stock_movement_detailed_dated" class="stock_movement_detailed_dated"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_movement_detailed->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->dated) ?>',2);"><div id="elh_stock_movement_detailed_dated" class="stock_movement_detailed_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->type->Visible) { // type ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_movement_detailed->type->headerCellClass() ?>"><div id="elh_stock_movement_detailed_type" class="stock_movement_detailed_type"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_movement_detailed->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->type) ?>',2);"><div id="elh_stock_movement_detailed_type" class="stock_movement_detailed_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_movement_detailed->age->Visible) { // age ?>
	<?php if ($stock_movement_detailed->sortUrl($stock_movement_detailed->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_movement_detailed->age->headerCellClass() ?>"><div id="elh_stock_movement_detailed_age" class="stock_movement_detailed_age"><div class="ew-table-header-caption"><?php echo $stock_movement_detailed->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_movement_detailed->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_movement_detailed->SortUrl($stock_movement_detailed->age) ?>',2);"><div id="elh_stock_movement_detailed_age" class="stock_movement_detailed_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_movement_detailed->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_movement_detailed->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_movement_detailed->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_movement_detailed_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_movement_detailed->ExportAll && $stock_movement_detailed->isExport()) {
	$stock_movement_detailed_list->StopRec = $stock_movement_detailed_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_movement_detailed_list->TotalRecs > $stock_movement_detailed_list->StartRec + $stock_movement_detailed_list->DisplayRecs - 1)
		$stock_movement_detailed_list->StopRec = $stock_movement_detailed_list->StartRec + $stock_movement_detailed_list->DisplayRecs - 1;
	else
		$stock_movement_detailed_list->StopRec = $stock_movement_detailed_list->TotalRecs;
}
$stock_movement_detailed_list->RecCnt = $stock_movement_detailed_list->StartRec - 1;
if ($stock_movement_detailed_list->Recordset && !$stock_movement_detailed_list->Recordset->EOF) {
	$stock_movement_detailed_list->Recordset->moveFirst();
	$selectLimit = $stock_movement_detailed_list->UseSelectLimit;
	if (!$selectLimit && $stock_movement_detailed_list->StartRec > 1)
		$stock_movement_detailed_list->Recordset->move($stock_movement_detailed_list->StartRec - 1);
} elseif (!$stock_movement_detailed->AllowAddDeleteRow && $stock_movement_detailed_list->StopRec == 0) {
	$stock_movement_detailed_list->StopRec = $stock_movement_detailed->GridAddRowCount;
}

// Initialize aggregate
$stock_movement_detailed->RowType = ROWTYPE_AGGREGATEINIT;
$stock_movement_detailed->resetAttributes();
$stock_movement_detailed_list->renderRow();
while ($stock_movement_detailed_list->RecCnt < $stock_movement_detailed_list->StopRec) {
	$stock_movement_detailed_list->RecCnt++;
	if ($stock_movement_detailed_list->RecCnt >= $stock_movement_detailed_list->StartRec) {
		$stock_movement_detailed_list->RowCnt++;

		// Set up key count
		$stock_movement_detailed_list->KeyCount = $stock_movement_detailed_list->RowIndex;

		// Init row class and style
		$stock_movement_detailed->resetAttributes();
		$stock_movement_detailed->CssClass = "";
		if ($stock_movement_detailed->isGridAdd()) {
		} else {
			$stock_movement_detailed_list->loadRowValues($stock_movement_detailed_list->Recordset); // Load row values
		}
		$stock_movement_detailed->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_movement_detailed->RowAttrs = array_merge($stock_movement_detailed->RowAttrs, array('data-rowindex'=>$stock_movement_detailed_list->RowCnt, 'id'=>'r' . $stock_movement_detailed_list->RowCnt . '_stock_movement_detailed', 'data-rowtype'=>$stock_movement_detailed->RowType));

		// Render row
		$stock_movement_detailed_list->renderRow();

		// Render list options
		$stock_movement_detailed_list->renderListOptions();
?>
	<tr<?php echo $stock_movement_detailed->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_movement_detailed_list->ListOptions->render("body", "left", $stock_movement_detailed_list->RowCnt);
?>
	<?php if ($stock_movement_detailed->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_movement_detailed->product->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_product" class="stock_movement_detailed_product">
<span<?php echo $stock_movement_detailed->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_movement_detailed->product->getViewValue())) && $stock_movement_detailed->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_movement_detailed->product->linkAttributes() ?>><?php echo $stock_movement_detailed->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_movement_detailed->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_movement_detailed->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_product_code" class="stock_movement_detailed_product_code">
<span<?php echo $stock_movement_detailed->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_movement_detailed->product_code->getViewValue())) && $stock_movement_detailed->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_movement_detailed->product_code->linkAttributes() ?>><?php echo $stock_movement_detailed->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_movement_detailed->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_movement_detailed->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_godown" class="stock_movement_detailed_godown">
<span<?php echo $stock_movement_detailed->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_movement_detailed->godown->getViewValue())) && $stock_movement_detailed->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_movement_detailed->godown->linkAttributes() ?>><?php echo $stock_movement_detailed->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_movement_detailed->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_movement_detailed->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_IN" class="stock_movement_detailed_IN">
<span<?php echo $stock_movement_detailed->IN->viewAttributes() ?>>
<?php echo $stock_movement_detailed->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_movement_detailed->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_OUT" class="stock_movement_detailed_OUT">
<span<?php echo $stock_movement_detailed->OUT->viewAttributes() ?>>
<?php echo $stock_movement_detailed->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_movement_detailed->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_packets" class="stock_movement_detailed_packets">
<span<?php echo $stock_movement_detailed->packets->viewAttributes() ?>>
<?php if ((!EmptyString($stock_movement_detailed->packets->getViewValue())) && $stock_movement_detailed->packets->linkAttributes() <> "") { ?>
<a<?php echo $stock_movement_detailed->packets->linkAttributes() ?>><?php echo $stock_movement_detailed->packets->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_movement_detailed->packets->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_movement_detailed->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_packing_type" class="stock_movement_detailed_packing_type">
<span<?php echo $stock_movement_detailed->packing_type->viewAttributes() ?>>
<?php echo $stock_movement_detailed->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_movement_detailed->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_lot_no" class="stock_movement_detailed_lot_no">
<span<?php echo $stock_movement_detailed->lot_no->viewAttributes() ?>>
<?php echo $stock_movement_detailed->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_movement_detailed->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_dated" class="stock_movement_detailed_dated">
<span<?php echo $stock_movement_detailed->dated->viewAttributes() ?>>
<?php echo $stock_movement_detailed->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_movement_detailed->type->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_type" class="stock_movement_detailed_type">
<span<?php echo $stock_movement_detailed->type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_movement_detailed->type->getViewValue())) && $stock_movement_detailed->type->linkAttributes() <> "") { ?>
<a<?php echo $stock_movement_detailed->type->linkAttributes() ?>><?php echo $stock_movement_detailed->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_movement_detailed->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_movement_detailed->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_movement_detailed->age->cellAttributes() ?>>
<span id="el<?php echo $stock_movement_detailed_list->RowCnt ?>_stock_movement_detailed_age" class="stock_movement_detailed_age">
<span<?php echo $stock_movement_detailed->age->viewAttributes() ?>>
<?php echo $stock_movement_detailed->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_movement_detailed_list->ListOptions->render("body", "right", $stock_movement_detailed_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_movement_detailed->isGridAdd())
		$stock_movement_detailed_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_movement_detailed->RowType = ROWTYPE_AGGREGATE;
$stock_movement_detailed->resetAttributes();
$stock_movement_detailed_list->renderRow();
?>
<?php if ($stock_movement_detailed_list->TotalRecs > 0 && !$stock_movement_detailed->isGridAdd() && !$stock_movement_detailed->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_movement_detailed_list->renderListOptions();

// Render list options (footer, left)
$stock_movement_detailed_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_movement_detailed->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_movement_detailed->product->footerCellClass() ?>"><span id="elf_stock_movement_detailed_product" class="stock_movement_detailed_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_movement_detailed->product_code->footerCellClass() ?>"><span id="elf_stock_movement_detailed_product_code" class="stock_movement_detailed_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_movement_detailed->godown->footerCellClass() ?>"><span id="elf_stock_movement_detailed_godown" class="stock_movement_detailed_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_movement_detailed->IN->footerCellClass() ?>"><span id="elf_stock_movement_detailed_IN" class="stock_movement_detailed_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_movement_detailed->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_movement_detailed->OUT->footerCellClass() ?>"><span id="elf_stock_movement_detailed_OUT" class="stock_movement_detailed_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_movement_detailed->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_movement_detailed->packets->footerCellClass() ?>"><span id="elf_stock_movement_detailed_packets" class="stock_movement_detailed_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_movement_detailed->packing_type->footerCellClass() ?>"><span id="elf_stock_movement_detailed_packing_type" class="stock_movement_detailed_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_movement_detailed->lot_no->footerCellClass() ?>"><span id="elf_stock_movement_detailed_lot_no" class="stock_movement_detailed_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_movement_detailed->dated->footerCellClass() ?>"><span id="elf_stock_movement_detailed_dated" class="stock_movement_detailed_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_movement_detailed->type->footerCellClass() ?>"><span id="elf_stock_movement_detailed_type" class="stock_movement_detailed_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_movement_detailed->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_movement_detailed->age->footerCellClass() ?>"><span id="elf_stock_movement_detailed_age" class="stock_movement_detailed_age">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_movement_detailed_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_movement_detailed->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_movement_detailed_list->Recordset)
	$stock_movement_detailed_list->Recordset->Close();
?>
<?php if (!$stock_movement_detailed->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_movement_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_movement_detailed_list->Pager)) $stock_movement_detailed_list->Pager = new PrevNextPager($stock_movement_detailed_list->StartRec, $stock_movement_detailed_list->DisplayRecs, $stock_movement_detailed_list->TotalRecs, $stock_movement_detailed_list->AutoHidePager) ?>
<?php if ($stock_movement_detailed_list->Pager->RecordCount > 0 && $stock_movement_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_movement_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_movement_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_movement_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_movement_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_movement_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_movement_detailed_list->pageUrl() ?>start=<?php echo $stock_movement_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_movement_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_movement_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_movement_detailed_list->TotalRecs > 0 && (!$stock_movement_detailed_list->AutoHidePageSizeSelector || $stock_movement_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_movement_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_movement_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_movement_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_movement_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_movement_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_movement_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_movement_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_movement_detailed_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_movement_detailed_list->TotalRecs == 0 && !$stock_movement_detailed->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_movement_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_movement_detailed_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_movement_detailed->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_movement_detailed->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_movement_detailed", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_movement_detailed_list->terminate();
?>