<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_online_list = new stock_online_list();

// Run the page
$stock_online_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_online_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_online->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_onlinelist = currentForm = new ew.Form("fstock_onlinelist", "list");
fstock_onlinelist.formKeyCountName = '<?php echo $stock_online_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_onlinelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_onlinelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_onlinelist.lists["x_location"] = <?php echo $stock_online_list->location->Lookup->toClientList() ?>;
fstock_onlinelist.lists["x_location"].options = <?php echo JsonEncode($stock_online_list->location->lookupOptions()) ?>;
fstock_onlinelist.lists["x_design_id"] = <?php echo $stock_online_list->design_id->Lookup->toClientList() ?>;
fstock_onlinelist.lists["x_design_id"].options = <?php echo JsonEncode($stock_online_list->design_id->lookupOptions()) ?>;
fstock_onlinelist.lists["x_status"] = <?php echo $stock_online_list->status->Lookup->toClientList() ?>;
fstock_onlinelist.lists["x_status"].options = <?php echo JsonEncode($stock_online_list->status->options(FALSE, TRUE)) ?>;
fstock_onlinelist.lists["x_consumed_status"] = <?php echo $stock_online_list->consumed_status->Lookup->toClientList() ?>;
fstock_onlinelist.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_online_list->consumed_status->options(FALSE, TRUE)) ?>;
fstock_onlinelist.lists["x_category"] = <?php echo $stock_online_list->category->Lookup->toClientList() ?>;
fstock_onlinelist.lists["x_category"].options = <?php echo JsonEncode($stock_online_list->category->lookupOptions()) ?>;

// Form object for search
var fstock_onlinelistsrch = currentSearchForm = new ew.Form("fstock_onlinelistsrch");

// Validate function for search
fstock_onlinelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_online->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_onlinelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_onlinelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_onlinelistsrch.lists["x_status"] = <?php echo $stock_online_list->status->Lookup->toClientList() ?>;
fstock_onlinelistsrch.lists["x_status"].options = <?php echo JsonEncode($stock_online_list->status->options(FALSE, TRUE)) ?>;
fstock_onlinelistsrch.lists["x_category"] = <?php echo $stock_online_list->category->Lookup->toClientList() ?>;
fstock_onlinelistsrch.lists["x_category"].options = <?php echo JsonEncode($stock_online_list->category->lookupOptions()) ?>;

// Filters
fstock_onlinelistsrch.filterList = <?php echo $stock_online_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_onlinelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_online->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_online_list->TotalRecs > 0 && $stock_online_list->ExportOptions->visible()) { ?>
<?php $stock_online_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_online_list->ImportOptions->visible()) { ?>
<?php $stock_online_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_online_list->SearchOptions->visible()) { ?>
<?php $stock_online_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_online_list->FilterOptions->visible()) { ?>
<?php $stock_online_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_online_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_online->isExport() && !$stock_online->CurrentAction) { ?>
<form name="fstock_onlinelistsrch" id="fstock_onlinelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_online_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_onlinelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_online">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_online_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_online->RowType = ROWTYPE_SEARCH;

// Render row
$stock_online->resetAttributes();
$stock_online_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_online->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $stock_online->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_online" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_online->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_online->_barcode->EditValue ?>"<?php echo $stock_online->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="stock_online" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_online->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_online->_barcode->EditValue2 ?>"<?php echo $stock_online->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_online->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $stock_online->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_status" data-value-separator="<?php echo $stock_online->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_online->status->editAttributes() ?>>
		<?php echo $stock_online->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($stock_online->consumed_by->Visible) { // consumed_by ?>
	<div id="xsc_consumed_by" class="ew-cell form-group">
		<label for="x_consumed_by" class="ew-search-caption ew-label"><?php echo $stock_online->consumed_by->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_consumed_by" id="z_consumed_by" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_online" data-field="x_consumed_by" name="x_consumed_by" id="x_consumed_by" size="30" maxlength="18" placeholder="<?php echo HtmlEncode($stock_online->consumed_by->getPlaceHolder()) ?>" value="<?php echo $stock_online->consumed_by->EditValue ?>"<?php echo $stock_online->consumed_by->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_online->category->Visible) { // category ?>
	<div id="xsc_category" class="ew-cell form-group">
		<label for="x_category" class="ew-search-caption ew-label"><?php echo $stock_online->category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_category" data-value-separator="<?php echo $stock_online->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $stock_online->category->editAttributes() ?>>
		<?php echo $stock_online->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $stock_online->category->Lookup->getParamTag("p_x_category") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_online_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_online_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_online_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_online_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_online_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_online_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_online_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_online_list->showPageHeader(); ?>
<?php
$stock_online_list->showMessage();
?>
<?php if ($stock_online_list->TotalRecs > 0 || $stock_online->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_online_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_online">
<?php if (!$stock_online->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_online->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_online_list->Pager)) $stock_online_list->Pager = new PrevNextPager($stock_online_list->StartRec, $stock_online_list->DisplayRecs, $stock_online_list->TotalRecs, $stock_online_list->AutoHidePager) ?>
<?php if ($stock_online_list->Pager->RecordCount > 0 && $stock_online_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_online_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_online_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_online_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_online_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_online_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_online_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_online_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_online_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_online_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_online_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_online_list->TotalRecs > 0 && (!$stock_online_list->AutoHidePageSizeSelector || $stock_online_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_online">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_online_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_online_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_online_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_online_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_online_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_online->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_online_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_onlinelist" id="fstock_onlinelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_online_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_online_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_online">
<div id="gmp_stock_online" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_online_list->TotalRecs > 0 || $stock_online->isGridEdit()) { ?>
<table id="tbl_stock_onlinelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_online_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_online_list->renderListOptions();

// Render list options (header, left)
$stock_online_list->ListOptions->render("header", "left");
?>
<?php if ($stock_online->id->Visible) { // id ?>
	<?php if ($stock_online->sortUrl($stock_online->id) == "") { ?>
		<th data-name="id" class="<?php echo $stock_online->id->headerCellClass() ?>"><div id="elh_stock_online_id" class="stock_online_id"><div class="ew-table-header-caption"><?php echo $stock_online->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $stock_online->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->id) ?>',2);"><div id="elh_stock_online_id" class="stock_online_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->location->Visible) { // location ?>
	<?php if ($stock_online->sortUrl($stock_online->location) == "") { ?>
		<th data-name="location" class="<?php echo $stock_online->location->headerCellClass() ?>"><div id="elh_stock_online_location" class="stock_online_location"><div class="ew-table-header-caption"><?php echo $stock_online->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $stock_online->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->location) ?>',2);"><div id="elh_stock_online_location" class="stock_online_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->_barcode->Visible) { // barcode ?>
	<?php if ($stock_online->sortUrl($stock_online->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $stock_online->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_stock_online__barcode" class="stock_online__barcode"><div class="ew-table-header-caption"><?php echo $stock_online->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $stock_online->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->_barcode) ?>',2);"><div id="elh_stock_online__barcode" class="stock_online__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->design_id->Visible) { // design_id ?>
	<?php if ($stock_online->sortUrl($stock_online->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $stock_online->design_id->headerCellClass() ?>"><div id="elh_stock_online_design_id" class="stock_online_design_id"><div class="ew-table-header-caption"><?php echo $stock_online->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $stock_online->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->design_id) ?>',2);"><div id="elh_stock_online_design_id" class="stock_online_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->w_cm->Visible) { // w_cm ?>
	<?php if ($stock_online->sortUrl($stock_online->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $stock_online->w_cm->headerCellClass() ?>"><div id="elh_stock_online_w_cm" class="stock_online_w_cm"><div class="ew-table-header-caption"><?php echo $stock_online->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $stock_online->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->w_cm) ?>',2);"><div id="elh_stock_online_w_cm" class="stock_online_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->w_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->l_cm->Visible) { // l_cm ?>
	<?php if ($stock_online->sortUrl($stock_online->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $stock_online->l_cm->headerCellClass() ?>"><div id="elh_stock_online_l_cm" class="stock_online_l_cm"><div class="ew-table-header-caption"><?php echo $stock_online->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $stock_online->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->l_cm) ?>',2);"><div id="elh_stock_online_l_cm" class="stock_online_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->l_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->sqm->Visible) { // sqm ?>
	<?php if ($stock_online->sortUrl($stock_online->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $stock_online->sqm->headerCellClass() ?>"><div id="elh_stock_online_sqm" class="stock_online_sqm"><div class="ew-table-header-caption"><?php echo $stock_online->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $stock_online->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->sqm) ?>',2);"><div id="elh_stock_online_sqm" class="stock_online_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->Remarks->Visible) { // Remarks ?>
	<?php if ($stock_online->sortUrl($stock_online->Remarks) == "") { ?>
		<th data-name="Remarks" class="<?php echo $stock_online->Remarks->headerCellClass() ?>"><div id="elh_stock_online_Remarks" class="stock_online_Remarks"><div class="ew-table-header-caption"><?php echo $stock_online->Remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Remarks" class="<?php echo $stock_online->Remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->Remarks) ?>',2);"><div id="elh_stock_online_Remarks" class="stock_online_Remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->Remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->Remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->Remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->last_remarks->Visible) { // last_remarks ?>
	<?php if ($stock_online->sortUrl($stock_online->last_remarks) == "") { ?>
		<th data-name="last_remarks" class="<?php echo $stock_online->last_remarks->headerCellClass() ?>"><div id="elh_stock_online_last_remarks" class="stock_online_last_remarks"><div class="ew-table-header-caption"><?php echo $stock_online->last_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_remarks" class="<?php echo $stock_online->last_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->last_remarks) ?>',2);"><div id="elh_stock_online_last_remarks" class="stock_online_last_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->last_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->last_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->last_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->status->Visible) { // status ?>
	<?php if ($stock_online->sortUrl($stock_online->status) == "") { ?>
		<th data-name="status" class="<?php echo $stock_online->status->headerCellClass() ?>"><div id="elh_stock_online_status" class="stock_online_status"><div class="ew-table-header-caption"><?php echo $stock_online->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $stock_online->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->status) ?>',2);"><div id="elh_stock_online_status" class="stock_online_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->consumed_by->Visible) { // consumed_by ?>
	<?php if ($stock_online->sortUrl($stock_online->consumed_by) == "") { ?>
		<th data-name="consumed_by" class="<?php echo $stock_online->consumed_by->headerCellClass() ?>"><div id="elh_stock_online_consumed_by" class="stock_online_consumed_by"><div class="ew-table-header-caption"><?php echo $stock_online->consumed_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_by" class="<?php echo $stock_online->consumed_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->consumed_by) ?>',2);"><div id="elh_stock_online_consumed_by" class="stock_online_consumed_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->consumed_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_online->consumed_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->consumed_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->consumed_sqm->Visible) { // consumed_sqm ?>
	<?php if ($stock_online->sortUrl($stock_online->consumed_sqm) == "") { ?>
		<th data-name="consumed_sqm" class="<?php echo $stock_online->consumed_sqm->headerCellClass() ?>"><div id="elh_stock_online_consumed_sqm" class="stock_online_consumed_sqm"><div class="ew-table-header-caption"><?php echo $stock_online->consumed_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_sqm" class="<?php echo $stock_online->consumed_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->consumed_sqm) ?>',2);"><div id="elh_stock_online_consumed_sqm" class="stock_online_consumed_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->consumed_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->consumed_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->consumed_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->consumed_status->Visible) { // consumed_status ?>
	<?php if ($stock_online->sortUrl($stock_online->consumed_status) == "") { ?>
		<th data-name="consumed_status" class="<?php echo $stock_online->consumed_status->headerCellClass() ?>"><div id="elh_stock_online_consumed_status" class="stock_online_consumed_status"><div class="ew-table-header-caption"><?php echo $stock_online->consumed_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_status" class="<?php echo $stock_online->consumed_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->consumed_status) ?>',2);"><div id="elh_stock_online_consumed_status" class="stock_online_consumed_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->consumed_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->consumed_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->consumed_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_online->category->Visible) { // category ?>
	<?php if ($stock_online->sortUrl($stock_online->category) == "") { ?>
		<th data-name="category" class="<?php echo $stock_online->category->headerCellClass() ?>"><div id="elh_stock_online_category" class="stock_online_category"><div class="ew-table-header-caption"><?php echo $stock_online->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $stock_online->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_online->SortUrl($stock_online->category) ?>',2);"><div id="elh_stock_online_category" class="stock_online_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_online->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_online->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_online->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_online_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_online->ExportAll && $stock_online->isExport()) {
	$stock_online_list->StopRec = $stock_online_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_online_list->TotalRecs > $stock_online_list->StartRec + $stock_online_list->DisplayRecs - 1)
		$stock_online_list->StopRec = $stock_online_list->StartRec + $stock_online_list->DisplayRecs - 1;
	else
		$stock_online_list->StopRec = $stock_online_list->TotalRecs;
}
$stock_online_list->RecCnt = $stock_online_list->StartRec - 1;
if ($stock_online_list->Recordset && !$stock_online_list->Recordset->EOF) {
	$stock_online_list->Recordset->moveFirst();
	$selectLimit = $stock_online_list->UseSelectLimit;
	if (!$selectLimit && $stock_online_list->StartRec > 1)
		$stock_online_list->Recordset->move($stock_online_list->StartRec - 1);
} elseif (!$stock_online->AllowAddDeleteRow && $stock_online_list->StopRec == 0) {
	$stock_online_list->StopRec = $stock_online->GridAddRowCount;
}

// Initialize aggregate
$stock_online->RowType = ROWTYPE_AGGREGATEINIT;
$stock_online->resetAttributes();
$stock_online_list->renderRow();
while ($stock_online_list->RecCnt < $stock_online_list->StopRec) {
	$stock_online_list->RecCnt++;
	if ($stock_online_list->RecCnt >= $stock_online_list->StartRec) {
		$stock_online_list->RowCnt++;

		// Set up key count
		$stock_online_list->KeyCount = $stock_online_list->RowIndex;

		// Init row class and style
		$stock_online->resetAttributes();
		$stock_online->CssClass = "";
		if ($stock_online->isGridAdd()) {
		} else {
			$stock_online_list->loadRowValues($stock_online_list->Recordset); // Load row values
		}
		$stock_online->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_online->RowAttrs = array_merge($stock_online->RowAttrs, array('data-rowindex'=>$stock_online_list->RowCnt, 'id'=>'r' . $stock_online_list->RowCnt . '_stock_online', 'data-rowtype'=>$stock_online->RowType));

		// Render row
		$stock_online_list->renderRow();

		// Render list options
		$stock_online_list->renderListOptions();
?>
	<tr<?php echo $stock_online->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_online_list->ListOptions->render("body", "left", $stock_online_list->RowCnt);
?>
	<?php if ($stock_online->id->Visible) { // id ?>
		<td data-name="id"<?php echo $stock_online->id->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_id" class="stock_online_id">
<span<?php echo $stock_online->id->viewAttributes() ?>>
<?php echo $stock_online->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->location->Visible) { // location ?>
		<td data-name="location"<?php echo $stock_online->location->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_location" class="stock_online_location">
<span<?php echo $stock_online->location->viewAttributes() ?>>
<?php echo $stock_online->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $stock_online->_barcode->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online__barcode" class="stock_online__barcode">
<span<?php echo $stock_online->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($stock_online->_barcode->getViewValue())) && $stock_online->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $stock_online->_barcode->linkAttributes() ?>><?php echo $stock_online->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_online->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $stock_online->design_id->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_design_id" class="stock_online_design_id">
<span<?php echo $stock_online->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_online->design_id->getViewValue())) && $stock_online->design_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_online->design_id->linkAttributes() ?>><?php echo $stock_online->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_online->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $stock_online->w_cm->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_w_cm" class="stock_online_w_cm">
<span<?php echo $stock_online->w_cm->viewAttributes() ?>>
<?php echo $stock_online->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $stock_online->l_cm->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_l_cm" class="stock_online_l_cm">
<span<?php echo $stock_online->l_cm->viewAttributes() ?>>
<?php echo $stock_online->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $stock_online->sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_sqm" class="stock_online_sqm">
<span<?php echo $stock_online->sqm->viewAttributes() ?>>
<?php echo $stock_online->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->Remarks->Visible) { // Remarks ?>
		<td data-name="Remarks"<?php echo $stock_online->Remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_Remarks" class="stock_online_Remarks">
<span<?php echo $stock_online->Remarks->viewAttributes() ?>>
<?php echo $stock_online->Remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->last_remarks->Visible) { // last_remarks ?>
		<td data-name="last_remarks"<?php echo $stock_online->last_remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_last_remarks" class="stock_online_last_remarks">
<span<?php echo $stock_online->last_remarks->viewAttributes() ?>>
<?php echo $stock_online->last_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->status->Visible) { // status ?>
		<td data-name="status"<?php echo $stock_online->status->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_status" class="stock_online_status">
<span<?php echo $stock_online->status->viewAttributes() ?>>
<?php if ((!EmptyString($stock_online->status->getViewValue())) && $stock_online->status->linkAttributes() <> "") { ?>
<a<?php echo $stock_online->status->linkAttributes() ?>><?php echo $stock_online->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_online->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->consumed_by->Visible) { // consumed_by ?>
		<td data-name="consumed_by"<?php echo $stock_online->consumed_by->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_consumed_by" class="stock_online_consumed_by">
<span<?php echo $stock_online->consumed_by->viewAttributes() ?>>
<?php if ((!EmptyString($stock_online->consumed_by->getViewValue())) && $stock_online->consumed_by->linkAttributes() <> "") { ?>
<a<?php echo $stock_online->consumed_by->linkAttributes() ?>><?php echo $stock_online->consumed_by->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_online->consumed_by->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->consumed_sqm->Visible) { // consumed_sqm ?>
		<td data-name="consumed_sqm"<?php echo $stock_online->consumed_sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_consumed_sqm" class="stock_online_consumed_sqm">
<span<?php echo $stock_online->consumed_sqm->viewAttributes() ?>>
<?php echo $stock_online->consumed_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->consumed_status->Visible) { // consumed_status ?>
		<td data-name="consumed_status"<?php echo $stock_online->consumed_status->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_consumed_status" class="stock_online_consumed_status">
<span<?php echo $stock_online->consumed_status->viewAttributes() ?>>
<?php if ((!EmptyString($stock_online->consumed_status->getViewValue())) && $stock_online->consumed_status->linkAttributes() <> "") { ?>
<a<?php echo $stock_online->consumed_status->linkAttributes() ?>><?php echo $stock_online->consumed_status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_online->consumed_status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_online->category->Visible) { // category ?>
		<td data-name="category"<?php echo $stock_online->category->cellAttributes() ?>>
<span id="el<?php echo $stock_online_list->RowCnt ?>_stock_online_category" class="stock_online_category">
<span<?php echo $stock_online->category->viewAttributes() ?>>
<?php echo $stock_online->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_online_list->ListOptions->render("body", "right", $stock_online_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_online->isGridAdd())
		$stock_online_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_online->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_online_list->Recordset)
	$stock_online_list->Recordset->Close();
?>
<?php if (!$stock_online->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_online->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_online_list->Pager)) $stock_online_list->Pager = new PrevNextPager($stock_online_list->StartRec, $stock_online_list->DisplayRecs, $stock_online_list->TotalRecs, $stock_online_list->AutoHidePager) ?>
<?php if ($stock_online_list->Pager->RecordCount > 0 && $stock_online_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_online_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_online_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_online_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_online_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_online_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_online_list->pageUrl() ?>start=<?php echo $stock_online_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_online_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_online_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_online_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_online_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_online_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_online_list->TotalRecs > 0 && (!$stock_online_list->AutoHidePageSizeSelector || $stock_online_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_online">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_online_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_online_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_online_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_online_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_online_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_online->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_online_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_online_list->TotalRecs == 0 && !$stock_online->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_online_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_online_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_online->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_online->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_online", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_online_list->terminate();
?>