<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_online_search = new stock_online_search();

// Run the page
$stock_online_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_online_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_online_search->IsModal) { ?>
var fstock_onlinesearch = currentAdvancedSearchForm = new ew.Form("fstock_onlinesearch", "search");
<?php } else { ?>
var fstock_onlinesearch = currentForm = new ew.Form("fstock_onlinesearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_onlinesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_onlinesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_onlinesearch.lists["x_location"] = <?php echo $stock_online_search->location->Lookup->toClientList() ?>;
fstock_onlinesearch.lists["x_location"].options = <?php echo JsonEncode($stock_online_search->location->lookupOptions()) ?>;
fstock_onlinesearch.lists["x_design_id"] = <?php echo $stock_online_search->design_id->Lookup->toClientList() ?>;
fstock_onlinesearch.lists["x_design_id"].options = <?php echo JsonEncode($stock_online_search->design_id->lookupOptions()) ?>;
fstock_onlinesearch.lists["x_status"] = <?php echo $stock_online_search->status->Lookup->toClientList() ?>;
fstock_onlinesearch.lists["x_status"].options = <?php echo JsonEncode($stock_online_search->status->options(FALSE, TRUE)) ?>;
fstock_onlinesearch.lists["x_consumed_status"] = <?php echo $stock_online_search->consumed_status->Lookup->toClientList() ?>;
fstock_onlinesearch.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_online_search->consumed_status->options(FALSE, TRUE)) ?>;
fstock_onlinesearch.lists["x_category"] = <?php echo $stock_online_search->category->Lookup->toClientList() ?>;
fstock_onlinesearch.lists["x_category"].options = <?php echo JsonEncode($stock_online_search->category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_onlinesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_online->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_online->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_online->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_consumed_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_online->consumed_sqm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_online_search->showPageHeader(); ?>
<?php
$stock_online_search->showMessage();
?>
<form name="fstock_onlinesearch" id="fstock_onlinesearch" class="<?php echo $stock_online_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_online_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_online_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_online">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_online_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_online->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_id"><?php echo $stock_online->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->id->cellAttributes() ?>>
			<span id="el_stock_online_id">
<input type="text" data-table="stock_online" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($stock_online->id->getPlaceHolder()) ?>" value="<?php echo $stock_online->id->EditValue ?>"<?php echo $stock_online->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_location"><?php echo $stock_online->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->location->cellAttributes() ?>>
			<span id="el_stock_online_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_location" data-value-separator="<?php echo $stock_online->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $stock_online->location->editAttributes() ?>>
		<?php echo $stock_online->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $stock_online->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online__barcode"><?php echo $stock_online->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_online->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_stock_online__barcode">
<input type="text" data-table="stock_online" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_online->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_online->_barcode->EditValue ?>"<?php echo $stock_online->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_stock_online__barcode" class="btw1__barcode d-none">
<input type="text" data-table="stock_online" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_online->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_online->_barcode->EditValue2 ?>"<?php echo $stock_online->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_design_id"><?php echo $stock_online->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->design_id->cellAttributes() ?>>
			<span id="el_stock_online_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_design_id" data-value-separator="<?php echo $stock_online->design_id->displayValueSeparatorAttribute() ?>" id="x_design_id" name="x_design_id"<?php echo $stock_online->design_id->editAttributes() ?>>
		<?php echo $stock_online->design_id->selectOptionListHtml("x_design_id") ?>
	</select>
</div>
<?php echo $stock_online->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_sqm"><?php echo $stock_online->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->sqm->cellAttributes() ?>>
			<span id="el_stock_online_sqm">
<input type="text" data-table="stock_online" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($stock_online->sqm->getPlaceHolder()) ?>" value="<?php echo $stock_online->sqm->EditValue ?>"<?php echo $stock_online->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->Remarks->Visible) { // Remarks ?>
	<div id="r_Remarks" class="form-group row">
		<label for="x_Remarks" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_Remarks"><?php echo $stock_online->Remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Remarks" id="z_Remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->Remarks->cellAttributes() ?>>
			<span id="el_stock_online_Remarks">
<input type="text" data-table="stock_online" data-field="x_Remarks" name="x_Remarks" id="x_Remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($stock_online->Remarks->getPlaceHolder()) ?>" value="<?php echo $stock_online->Remarks->EditValue ?>"<?php echo $stock_online->Remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->last_remarks->Visible) { // last_remarks ?>
	<div id="r_last_remarks" class="form-group row">
		<label for="x_last_remarks" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_last_remarks"><?php echo $stock_online->last_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_last_remarks" id="z_last_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->last_remarks->cellAttributes() ?>>
			<span id="el_stock_online_last_remarks">
<input type="text" data-table="stock_online" data-field="x_last_remarks" name="x_last_remarks" id="x_last_remarks" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($stock_online->last_remarks->getPlaceHolder()) ?>" value="<?php echo $stock_online->last_remarks->EditValue ?>"<?php echo $stock_online->last_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_status"><?php echo $stock_online->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->status->cellAttributes() ?>>
			<span id="el_stock_online_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_status" data-value-separator="<?php echo $stock_online->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_online->status->editAttributes() ?>>
		<?php echo $stock_online->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->consumed_by->Visible) { // consumed_by ?>
	<div id="r_consumed_by" class="form-group row">
		<label for="x_consumed_by" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_consumed_by"><?php echo $stock_online->consumed_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_consumed_by" id="z_consumed_by" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->consumed_by->cellAttributes() ?>>
			<span id="el_stock_online_consumed_by">
<input type="text" data-table="stock_online" data-field="x_consumed_by" name="x_consumed_by" id="x_consumed_by" size="30" maxlength="18" placeholder="<?php echo HtmlEncode($stock_online->consumed_by->getPlaceHolder()) ?>" value="<?php echo $stock_online->consumed_by->EditValue ?>"<?php echo $stock_online->consumed_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->consumed_sqm->Visible) { // consumed_sqm ?>
	<div id="r_consumed_sqm" class="form-group row">
		<label for="x_consumed_sqm" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_consumed_sqm"><?php echo $stock_online->consumed_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_consumed_sqm" id="z_consumed_sqm" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->consumed_sqm->cellAttributes() ?>>
			<span id="el_stock_online_consumed_sqm">
<input type="text" data-table="stock_online" data-field="x_consumed_sqm" name="x_consumed_sqm" id="x_consumed_sqm" size="30" placeholder="<?php echo HtmlEncode($stock_online->consumed_sqm->getPlaceHolder()) ?>" value="<?php echo $stock_online->consumed_sqm->EditValue ?>"<?php echo $stock_online->consumed_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->consumed_status->Visible) { // consumed_status ?>
	<div id="r_consumed_status" class="form-group row">
		<label for="x_consumed_status" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_consumed_status"><?php echo $stock_online->consumed_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_consumed_status" id="z_consumed_status" value="="></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->consumed_status->cellAttributes() ?>>
			<span id="el_stock_online_consumed_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_consumed_status" data-value-separator="<?php echo $stock_online->consumed_status->displayValueSeparatorAttribute() ?>" id="x_consumed_status" name="x_consumed_status"<?php echo $stock_online->consumed_status->editAttributes() ?>>
		<?php echo $stock_online->consumed_status->selectOptionListHtml("x_consumed_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_online->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $stock_online_search->LeftColumnClass ?>"><span id="elh_stock_online_category"><?php echo $stock_online->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_online_search->RightColumnClass ?>"><div<?php echo $stock_online->category->cellAttributes() ?>>
			<span id="el_stock_online_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_online" data-field="x_category" data-value-separator="<?php echo $stock_online->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $stock_online->category->editAttributes() ?>>
		<?php echo $stock_online->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $stock_online->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_online_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_online_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_online_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_online_search->terminate();
?>