<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_packing_list = new stock_packing_list();

// Run the page
$stock_packing_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_packing_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_packing->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_packinglist = currentForm = new ew.Form("fstock_packinglist", "list");
fstock_packinglist.formKeyCountName = '<?php echo $stock_packing_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_packinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_packinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_packinglist.lists["x_product"] = <?php echo $stock_packing_list->product->Lookup->toClientList() ?>;
fstock_packinglist.lists["x_product"].options = <?php echo JsonEncode($stock_packing_list->product->lookupOptions()) ?>;
fstock_packinglist.lists["x_godown"] = <?php echo $stock_packing_list->godown->Lookup->toClientList() ?>;
fstock_packinglist.lists["x_godown"].options = <?php echo JsonEncode($stock_packing_list->godown->lookupOptions()) ?>;
fstock_packinglist.lists["x_packing_type"] = <?php echo $stock_packing_list->packing_type->Lookup->toClientList() ?>;
fstock_packinglist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_packing_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_packinglistsrch = currentSearchForm = new ew.Form("fstock_packinglistsrch");

// Filters
fstock_packinglistsrch.filterList = <?php echo $stock_packing_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_packinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_packing->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_packing_list->TotalRecs > 0 && $stock_packing_list->ExportOptions->visible()) { ?>
<?php $stock_packing_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_packing_list->ImportOptions->visible()) { ?>
<?php $stock_packing_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_packing_list->SearchOptions->visible()) { ?>
<?php $stock_packing_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_packing_list->FilterOptions->visible()) { ?>
<?php $stock_packing_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_packing_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_packing->isExport() && !$stock_packing->CurrentAction) { ?>
<form name="fstock_packinglistsrch" id="fstock_packinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_packing_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_packinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_packing">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_packing_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_packing_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_packing_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_packing_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_packing_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_packing_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_packing_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_packing_list->showPageHeader(); ?>
<?php
$stock_packing_list->showMessage();
?>
<?php if ($stock_packing_list->TotalRecs > 0 || $stock_packing->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_packing_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_packing">
<?php if (!$stock_packing->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_packing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_packing_list->Pager)) $stock_packing_list->Pager = new PrevNextPager($stock_packing_list->StartRec, $stock_packing_list->DisplayRecs, $stock_packing_list->TotalRecs, $stock_packing_list->AutoHidePager) ?>
<?php if ($stock_packing_list->Pager->RecordCount > 0 && $stock_packing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_packing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_packing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_packing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_packing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_packing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_packing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_packing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_packing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_packing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_packing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_packing_list->TotalRecs > 0 && (!$stock_packing_list->AutoHidePageSizeSelector || $stock_packing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_packing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_packing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_packing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_packing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_packing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_packing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_packing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_packing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_packinglist" id="fstock_packinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_packing_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_packing_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_packing">
<div id="gmp_stock_packing" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_packing_list->TotalRecs > 0 || $stock_packing->isGridEdit()) { ?>
<table id="tbl_stock_packinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_packing_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_packing_list->renderListOptions();

// Render list options (header, left)
$stock_packing_list->ListOptions->render("header", "left");
?>
<?php if ($stock_packing->product->Visible) { // product ?>
	<?php if ($stock_packing->sortUrl($stock_packing->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_packing->product->headerCellClass() ?>"><div id="elh_stock_packing_product" class="stock_packing_product"><div class="ew-table-header-caption"><?php echo $stock_packing->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_packing->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->product) ?>',2);"><div id="elh_stock_packing_product" class="stock_packing_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->product_code->Visible) { // product_code ?>
	<?php if ($stock_packing->sortUrl($stock_packing->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_packing->product_code->headerCellClass() ?>"><div id="elh_stock_packing_product_code" class="stock_packing_product_code"><div class="ew-table-header-caption"><?php echo $stock_packing->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_packing->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->product_code) ?>',2);"><div id="elh_stock_packing_product_code" class="stock_packing_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->godown->Visible) { // godown ?>
	<?php if ($stock_packing->sortUrl($stock_packing->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_packing->godown->headerCellClass() ?>"><div id="elh_stock_packing_godown" class="stock_packing_godown"><div class="ew-table-header-caption"><?php echo $stock_packing->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_packing->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->godown) ?>',2);"><div id="elh_stock_packing_godown" class="stock_packing_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->IN->Visible) { // IN ?>
	<?php if ($stock_packing->sortUrl($stock_packing->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_packing->IN->headerCellClass() ?>"><div id="elh_stock_packing_IN" class="stock_packing_IN"><div class="ew-table-header-caption"><?php echo $stock_packing->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_packing->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->IN) ?>',2);"><div id="elh_stock_packing_IN" class="stock_packing_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->packets->Visible) { // packets ?>
	<?php if ($stock_packing->sortUrl($stock_packing->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_packing->packets->headerCellClass() ?>"><div id="elh_stock_packing_packets" class="stock_packing_packets"><div class="ew-table-header-caption"><?php echo $stock_packing->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_packing->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->packets) ?>',2);"><div id="elh_stock_packing_packets" class="stock_packing_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_packing->sortUrl($stock_packing->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_packing->packing_type->headerCellClass() ?>"><div id="elh_stock_packing_packing_type" class="stock_packing_packing_type"><div class="ew-table-header-caption"><?php echo $stock_packing->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_packing->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->packing_type) ?>',2);"><div id="elh_stock_packing_packing_type" class="stock_packing_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_packing->sortUrl($stock_packing->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_packing->lot_no->headerCellClass() ?>"><div id="elh_stock_packing_lot_no" class="stock_packing_lot_no"><div class="ew-table-header-caption"><?php echo $stock_packing->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_packing->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->lot_no) ?>',2);"><div id="elh_stock_packing_lot_no" class="stock_packing_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_packing->sortUrl($stock_packing->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_packing->tmp_lot->headerCellClass() ?>"><div id="elh_stock_packing_tmp_lot" class="stock_packing_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_packing->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_packing->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->tmp_lot) ?>',2);"><div id="elh_stock_packing_tmp_lot" class="stock_packing_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_packing->url->Visible) { // url ?>
	<?php if ($stock_packing->sortUrl($stock_packing->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_packing->url->headerCellClass() ?>"><div id="elh_stock_packing_url" class="stock_packing_url"><div class="ew-table-header-caption"><?php echo $stock_packing->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_packing->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_packing->SortUrl($stock_packing->url) ?>',2);"><div id="elh_stock_packing_url" class="stock_packing_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_packing->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_packing->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_packing->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_packing_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_packing->ExportAll && $stock_packing->isExport()) {
	$stock_packing_list->StopRec = $stock_packing_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_packing_list->TotalRecs > $stock_packing_list->StartRec + $stock_packing_list->DisplayRecs - 1)
		$stock_packing_list->StopRec = $stock_packing_list->StartRec + $stock_packing_list->DisplayRecs - 1;
	else
		$stock_packing_list->StopRec = $stock_packing_list->TotalRecs;
}
$stock_packing_list->RecCnt = $stock_packing_list->StartRec - 1;
if ($stock_packing_list->Recordset && !$stock_packing_list->Recordset->EOF) {
	$stock_packing_list->Recordset->moveFirst();
	$selectLimit = $stock_packing_list->UseSelectLimit;
	if (!$selectLimit && $stock_packing_list->StartRec > 1)
		$stock_packing_list->Recordset->move($stock_packing_list->StartRec - 1);
} elseif (!$stock_packing->AllowAddDeleteRow && $stock_packing_list->StopRec == 0) {
	$stock_packing_list->StopRec = $stock_packing->GridAddRowCount;
}

// Initialize aggregate
$stock_packing->RowType = ROWTYPE_AGGREGATEINIT;
$stock_packing->resetAttributes();
$stock_packing_list->renderRow();
while ($stock_packing_list->RecCnt < $stock_packing_list->StopRec) {
	$stock_packing_list->RecCnt++;
	if ($stock_packing_list->RecCnt >= $stock_packing_list->StartRec) {
		$stock_packing_list->RowCnt++;

		// Set up key count
		$stock_packing_list->KeyCount = $stock_packing_list->RowIndex;

		// Init row class and style
		$stock_packing->resetAttributes();
		$stock_packing->CssClass = "";
		if ($stock_packing->isGridAdd()) {
		} else {
			$stock_packing_list->loadRowValues($stock_packing_list->Recordset); // Load row values
		}
		$stock_packing->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_packing->RowAttrs = array_merge($stock_packing->RowAttrs, array('data-rowindex'=>$stock_packing_list->RowCnt, 'id'=>'r' . $stock_packing_list->RowCnt . '_stock_packing', 'data-rowtype'=>$stock_packing->RowType));

		// Render row
		$stock_packing_list->renderRow();

		// Render list options
		$stock_packing_list->renderListOptions();
?>
	<tr<?php echo $stock_packing->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_packing_list->ListOptions->render("body", "left", $stock_packing_list->RowCnt);
?>
	<?php if ($stock_packing->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_packing->product->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_product" class="stock_packing_product">
<span<?php echo $stock_packing->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_packing->product->getViewValue())) && $stock_packing->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_packing->product->linkAttributes() ?>><?php echo $stock_packing->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_packing->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_packing->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_product_code" class="stock_packing_product_code">
<span<?php echo $stock_packing->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_packing->product_code->getViewValue())) && $stock_packing->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_packing->product_code->linkAttributes() ?>><?php echo $stock_packing->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_packing->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_packing->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_godown" class="stock_packing_godown">
<span<?php echo $stock_packing->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_packing->godown->getViewValue())) && $stock_packing->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_packing->godown->linkAttributes() ?>><?php echo $stock_packing->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_packing->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_packing->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_IN" class="stock_packing_IN">
<span<?php echo $stock_packing->IN->viewAttributes() ?>>
<?php echo $stock_packing->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_packing->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_packets" class="stock_packing_packets">
<span<?php echo $stock_packing->packets->viewAttributes() ?>>
<?php echo $stock_packing->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_packing->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_packing_type" class="stock_packing_packing_type">
<span<?php echo $stock_packing->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_packing->packing_type->getViewValue())) && $stock_packing->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_packing->packing_type->linkAttributes() ?>><?php echo $stock_packing->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_packing->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_packing->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_lot_no" class="stock_packing_lot_no">
<span<?php echo $stock_packing->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_packing->lot_no->getViewValue())) && $stock_packing->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_packing->lot_no->linkAttributes() ?>><?php echo $stock_packing->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_packing->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_packing->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_tmp_lot" class="stock_packing_tmp_lot">
<span<?php echo $stock_packing->tmp_lot->viewAttributes() ?>>
<?php echo $stock_packing->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_packing->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_packing->url->cellAttributes() ?>>
<span id="el<?php echo $stock_packing_list->RowCnt ?>_stock_packing_url" class="stock_packing_url">
<span<?php echo $stock_packing->url->viewAttributes() ?>>
<?php echo $stock_packing->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_packing_list->ListOptions->render("body", "right", $stock_packing_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_packing->isGridAdd())
		$stock_packing_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_packing->RowType = ROWTYPE_AGGREGATE;
$stock_packing->resetAttributes();
$stock_packing_list->renderRow();
?>
<?php if ($stock_packing_list->TotalRecs > 0 && !$stock_packing->isGridAdd() && !$stock_packing->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_packing_list->renderListOptions();

// Render list options (footer, left)
$stock_packing_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_packing->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_packing->product->footerCellClass() ?>"><span id="elf_stock_packing_product" class="stock_packing_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_packing->product_code->footerCellClass() ?>"><span id="elf_stock_packing_product_code" class="stock_packing_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_packing->godown->footerCellClass() ?>"><span id="elf_stock_packing_godown" class="stock_packing_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_packing->IN->footerCellClass() ?>"><span id="elf_stock_packing_IN" class="stock_packing_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_packing->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_packing->packets->footerCellClass() ?>"><span id="elf_stock_packing_packets" class="stock_packing_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_packing->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_packing->packing_type->footerCellClass() ?>"><span id="elf_stock_packing_packing_type" class="stock_packing_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_packing->lot_no->footerCellClass() ?>"><span id="elf_stock_packing_lot_no" class="stock_packing_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_packing->tmp_lot->footerCellClass() ?>"><span id="elf_stock_packing_tmp_lot" class="stock_packing_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_packing->url->Visible) { // url ?>
		<td data-name="url" class="<?php echo $stock_packing->url->footerCellClass() ?>"><span id="elf_stock_packing_url" class="stock_packing_url">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_packing_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_packing->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_packing_list->Recordset)
	$stock_packing_list->Recordset->Close();
?>
<?php if (!$stock_packing->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_packing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_packing_list->Pager)) $stock_packing_list->Pager = new PrevNextPager($stock_packing_list->StartRec, $stock_packing_list->DisplayRecs, $stock_packing_list->TotalRecs, $stock_packing_list->AutoHidePager) ?>
<?php if ($stock_packing_list->Pager->RecordCount > 0 && $stock_packing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_packing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_packing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_packing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_packing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_packing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_packing_list->pageUrl() ?>start=<?php echo $stock_packing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_packing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_packing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_packing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_packing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_packing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_packing_list->TotalRecs > 0 && (!$stock_packing_list->AutoHidePageSizeSelector || $stock_packing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_packing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_packing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_packing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_packing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_packing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_packing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_packing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_packing_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_packing_list->TotalRecs == 0 && !$stock_packing->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_packing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_packing_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_packing->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_packing->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_packing", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_packing_list->terminate();
?>