<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_process_action_material_list = new stock_process_action_material_list();

// Run the page
$stock_process_action_material_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_process_action_material_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_process_action_material->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_process_action_materiallist = currentForm = new ew.Form("fstock_process_action_materiallist", "list");
fstock_process_action_materiallist.formKeyCountName = '<?php echo $stock_process_action_material_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_process_action_materiallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_process_action_materiallist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fstock_process_action_materiallistsrch = currentSearchForm = new ew.Form("fstock_process_action_materiallistsrch");

// Filters
fstock_process_action_materiallistsrch.filterList = <?php echo $stock_process_action_material_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_process_action_materiallistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_process_action_material->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_process_action_material_list->TotalRecs > 0 && $stock_process_action_material_list->ExportOptions->visible()) { ?>
<?php $stock_process_action_material_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_action_material_list->ImportOptions->visible()) { ?>
<?php $stock_process_action_material_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_action_material_list->SearchOptions->visible()) { ?>
<?php $stock_process_action_material_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_action_material_list->FilterOptions->visible()) { ?>
<?php $stock_process_action_material_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_process_action_material_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_process_action_material->isExport() && !$stock_process_action_material->CurrentAction) { ?>
<form name="fstock_process_action_materiallistsrch" id="fstock_process_action_materiallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_process_action_material_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_process_action_materiallistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_process_action_material">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_process_action_material_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_process_action_material_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_process_action_material_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_process_action_material_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_process_action_material_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_process_action_material_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_process_action_material_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_process_action_material_list->showPageHeader(); ?>
<?php
$stock_process_action_material_list->showMessage();
?>
<?php if ($stock_process_action_material_list->TotalRecs > 0 || $stock_process_action_material->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_process_action_material_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_process_action_material">
<?php if (!$stock_process_action_material->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_process_action_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_process_action_material_list->Pager)) $stock_process_action_material_list->Pager = new PrevNextPager($stock_process_action_material_list->StartRec, $stock_process_action_material_list->DisplayRecs, $stock_process_action_material_list->TotalRecs, $stock_process_action_material_list->AutoHidePager) ?>
<?php if ($stock_process_action_material_list->Pager->RecordCount > 0 && $stock_process_action_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_process_action_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_process_action_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_process_action_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_process_action_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_process_action_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_process_action_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_process_action_material_list->TotalRecs > 0 && (!$stock_process_action_material_list->AutoHidePageSizeSelector || $stock_process_action_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_process_action_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_process_action_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_process_action_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_process_action_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_process_action_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_process_action_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_process_action_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_process_action_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_process_action_materiallist" id="fstock_process_action_materiallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_process_action_material_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_process_action_material_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_process_action_material">
<div id="gmp_stock_process_action_material" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_process_action_material_list->TotalRecs > 0 || $stock_process_action_material->isGridEdit()) { ?>
<table id="tbl_stock_process_action_materiallist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_process_action_material_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_process_action_material_list->renderListOptions();

// Render list options (header, left)
$stock_process_action_material_list->ListOptions->render("header", "left");
?>
<?php if ($stock_process_action_material->product->Visible) { // product ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_process_action_material->product->headerCellClass() ?>"><div id="elh_stock_process_action_material_product" class="stock_process_action_material_product"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_process_action_material->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->product) ?>',2);"><div id="elh_stock_process_action_material_product" class="stock_process_action_material_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->rid->Visible) { // rid ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_process_action_material->rid->headerCellClass() ?>"><div id="elh_stock_process_action_material_rid" class="stock_process_action_material_rid"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_process_action_material->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->rid) ?>',2);"><div id="elh_stock_process_action_material_rid" class="stock_process_action_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->code->Visible) { // code ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->code) == "") { ?>
		<th data-name="code" class="<?php echo $stock_process_action_material->code->headerCellClass() ?>"><div id="elh_stock_process_action_material_code" class="stock_process_action_material_code"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $stock_process_action_material->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->code) ?>',2);"><div id="elh_stock_process_action_material_code" class="stock_process_action_material_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->godown->Visible) { // godown ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_process_action_material->godown->headerCellClass() ?>"><div id="elh_stock_process_action_material_godown" class="stock_process_action_material_godown"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_process_action_material->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->godown) ?>',2);"><div id="elh_stock_process_action_material_godown" class="stock_process_action_material_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->IN->Visible) { // IN ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_process_action_material->IN->headerCellClass() ?>"><div id="elh_stock_process_action_material_IN" class="stock_process_action_material_IN"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_process_action_material->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->IN) ?>',2);"><div id="elh_stock_process_action_material_IN" class="stock_process_action_material_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->OUT->Visible) { // OUT ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_process_action_material->OUT->headerCellClass() ?>"><div id="elh_stock_process_action_material_OUT" class="stock_process_action_material_OUT"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_process_action_material->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->OUT) ?>',2);"><div id="elh_stock_process_action_material_OUT" class="stock_process_action_material_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->packets->Visible) { // packets ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_process_action_material->packets->headerCellClass() ?>"><div id="elh_stock_process_action_material_packets" class="stock_process_action_material_packets"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_process_action_material->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->packets) ?>',2);"><div id="elh_stock_process_action_material_packets" class="stock_process_action_material_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_process_action_material->packing_type->headerCellClass() ?>"><div id="elh_stock_process_action_material_packing_type" class="stock_process_action_material_packing_type"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_process_action_material->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->packing_type) ?>',2);"><div id="elh_stock_process_action_material_packing_type" class="stock_process_action_material_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_process_action_material->lot_no->headerCellClass() ?>"><div id="elh_stock_process_action_material_lot_no" class="stock_process_action_material_lot_no"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_process_action_material->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->lot_no) ?>',2);"><div id="elh_stock_process_action_material_lot_no" class="stock_process_action_material_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->url->Visible) { // url ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_process_action_material->url->headerCellClass() ?>"><div id="elh_stock_process_action_material_url" class="stock_process_action_material_url"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_process_action_material->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->url) ?>',2);"><div id="elh_stock_process_action_material_url" class="stock_process_action_material_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->age->Visible) { // age ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_process_action_material->age->headerCellClass() ?>"><div id="elh_stock_process_action_material_age" class="stock_process_action_material_age"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_process_action_material->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->age) ?>',2);"><div id="elh_stock_process_action_material_age" class="stock_process_action_material_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->dated->Visible) { // dated ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_process_action_material->dated->headerCellClass() ?>"><div id="elh_stock_process_action_material_dated" class="stock_process_action_material_dated"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_process_action_material->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->dated) ?>',2);"><div id="elh_stock_process_action_material_dated" class="stock_process_action_material_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->type->Visible) { // type ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_process_action_material->type->headerCellClass() ?>"><div id="elh_stock_process_action_material_type" class="stock_process_action_material_type"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_process_action_material->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->type) ?>',2);"><div id="elh_stock_process_action_material_type" class="stock_process_action_material_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process_action_material->company_id->Visible) { // company_id ?>
	<?php if ($stock_process_action_material->sortUrl($stock_process_action_material->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_process_action_material->company_id->headerCellClass() ?>"><div id="elh_stock_process_action_material_company_id" class="stock_process_action_material_company_id"><div class="ew-table-header-caption"><?php echo $stock_process_action_material->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_process_action_material->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process_action_material->SortUrl($stock_process_action_material->company_id) ?>',2);"><div id="elh_stock_process_action_material_company_id" class="stock_process_action_material_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process_action_material->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process_action_material->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process_action_material->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_process_action_material_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_process_action_material->ExportAll && $stock_process_action_material->isExport()) {
	$stock_process_action_material_list->StopRec = $stock_process_action_material_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_process_action_material_list->TotalRecs > $stock_process_action_material_list->StartRec + $stock_process_action_material_list->DisplayRecs - 1)
		$stock_process_action_material_list->StopRec = $stock_process_action_material_list->StartRec + $stock_process_action_material_list->DisplayRecs - 1;
	else
		$stock_process_action_material_list->StopRec = $stock_process_action_material_list->TotalRecs;
}
$stock_process_action_material_list->RecCnt = $stock_process_action_material_list->StartRec - 1;
if ($stock_process_action_material_list->Recordset && !$stock_process_action_material_list->Recordset->EOF) {
	$stock_process_action_material_list->Recordset->moveFirst();
	$selectLimit = $stock_process_action_material_list->UseSelectLimit;
	if (!$selectLimit && $stock_process_action_material_list->StartRec > 1)
		$stock_process_action_material_list->Recordset->move($stock_process_action_material_list->StartRec - 1);
} elseif (!$stock_process_action_material->AllowAddDeleteRow && $stock_process_action_material_list->StopRec == 0) {
	$stock_process_action_material_list->StopRec = $stock_process_action_material->GridAddRowCount;
}

// Initialize aggregate
$stock_process_action_material->RowType = ROWTYPE_AGGREGATEINIT;
$stock_process_action_material->resetAttributes();
$stock_process_action_material_list->renderRow();
while ($stock_process_action_material_list->RecCnt < $stock_process_action_material_list->StopRec) {
	$stock_process_action_material_list->RecCnt++;
	if ($stock_process_action_material_list->RecCnt >= $stock_process_action_material_list->StartRec) {
		$stock_process_action_material_list->RowCnt++;

		// Set up key count
		$stock_process_action_material_list->KeyCount = $stock_process_action_material_list->RowIndex;

		// Init row class and style
		$stock_process_action_material->resetAttributes();
		$stock_process_action_material->CssClass = "";
		if ($stock_process_action_material->isGridAdd()) {
		} else {
			$stock_process_action_material_list->loadRowValues($stock_process_action_material_list->Recordset); // Load row values
		}
		$stock_process_action_material->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_process_action_material->RowAttrs = array_merge($stock_process_action_material->RowAttrs, array('data-rowindex'=>$stock_process_action_material_list->RowCnt, 'id'=>'r' . $stock_process_action_material_list->RowCnt . '_stock_process_action_material', 'data-rowtype'=>$stock_process_action_material->RowType));

		// Render row
		$stock_process_action_material_list->renderRow();

		// Render list options
		$stock_process_action_material_list->renderListOptions();
?>
	<tr<?php echo $stock_process_action_material->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_process_action_material_list->ListOptions->render("body", "left", $stock_process_action_material_list->RowCnt);
?>
	<?php if ($stock_process_action_material->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_process_action_material->product->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_product" class="stock_process_action_material_product">
<span<?php echo $stock_process_action_material->product->viewAttributes() ?>>
<?php echo $stock_process_action_material->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_process_action_material->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_rid" class="stock_process_action_material_rid">
<span<?php echo $stock_process_action_material->rid->viewAttributes() ?>>
<?php echo $stock_process_action_material->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->code->Visible) { // code ?>
		<td data-name="code"<?php echo $stock_process_action_material->code->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_code" class="stock_process_action_material_code">
<span<?php echo $stock_process_action_material->code->viewAttributes() ?>>
<?php echo $stock_process_action_material->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_process_action_material->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_godown" class="stock_process_action_material_godown">
<span<?php echo $stock_process_action_material->godown->viewAttributes() ?>>
<?php echo $stock_process_action_material->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_process_action_material->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_IN" class="stock_process_action_material_IN">
<span<?php echo $stock_process_action_material->IN->viewAttributes() ?>>
<?php echo $stock_process_action_material->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_process_action_material->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_OUT" class="stock_process_action_material_OUT">
<span<?php echo $stock_process_action_material->OUT->viewAttributes() ?>>
<?php echo $stock_process_action_material->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_process_action_material->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_packets" class="stock_process_action_material_packets">
<span<?php echo $stock_process_action_material->packets->viewAttributes() ?>>
<?php echo $stock_process_action_material->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_process_action_material->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_packing_type" class="stock_process_action_material_packing_type">
<span<?php echo $stock_process_action_material->packing_type->viewAttributes() ?>>
<?php echo $stock_process_action_material->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_process_action_material->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_lot_no" class="stock_process_action_material_lot_no">
<span<?php echo $stock_process_action_material->lot_no->viewAttributes() ?>>
<?php echo $stock_process_action_material->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_process_action_material->url->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_url" class="stock_process_action_material_url">
<span<?php echo $stock_process_action_material->url->viewAttributes() ?>>
<?php echo $stock_process_action_material->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_process_action_material->age->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_age" class="stock_process_action_material_age">
<span<?php echo $stock_process_action_material->age->viewAttributes() ?>>
<?php echo $stock_process_action_material->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_process_action_material->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_dated" class="stock_process_action_material_dated">
<span<?php echo $stock_process_action_material->dated->viewAttributes() ?>>
<?php echo $stock_process_action_material->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_process_action_material->type->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_type" class="stock_process_action_material_type">
<span<?php echo $stock_process_action_material->type->viewAttributes() ?>>
<?php echo $stock_process_action_material->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process_action_material->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_process_action_material->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_process_action_material_list->RowCnt ?>_stock_process_action_material_company_id" class="stock_process_action_material_company_id">
<span<?php echo $stock_process_action_material->company_id->viewAttributes() ?>>
<?php echo $stock_process_action_material->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_process_action_material_list->ListOptions->render("body", "right", $stock_process_action_material_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_process_action_material->isGridAdd())
		$stock_process_action_material_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_process_action_material->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_process_action_material_list->Recordset)
	$stock_process_action_material_list->Recordset->Close();
?>
<?php if (!$stock_process_action_material->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_process_action_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_process_action_material_list->Pager)) $stock_process_action_material_list->Pager = new PrevNextPager($stock_process_action_material_list->StartRec, $stock_process_action_material_list->DisplayRecs, $stock_process_action_material_list->TotalRecs, $stock_process_action_material_list->AutoHidePager) ?>
<?php if ($stock_process_action_material_list->Pager->RecordCount > 0 && $stock_process_action_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_process_action_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_process_action_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_process_action_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_process_action_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_process_action_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_process_action_material_list->pageUrl() ?>start=<?php echo $stock_process_action_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_process_action_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_process_action_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_process_action_material_list->TotalRecs > 0 && (!$stock_process_action_material_list->AutoHidePageSizeSelector || $stock_process_action_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_process_action_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_process_action_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_process_action_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_process_action_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_process_action_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_process_action_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_process_action_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_process_action_material_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_process_action_material_list->TotalRecs == 0 && !$stock_process_action_material->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_process_action_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_process_action_material_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_process_action_material->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_process_action_material->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_process_action_material", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_process_action_material_list->terminate();
?>