<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_process_f_search = new stock_process_f_search();

// Run the page
$stock_process_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_process_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_process_f_search->IsModal) { ?>
var fstock_process_fsearch = currentAdvancedSearchForm = new ew.Form("fstock_process_fsearch", "search");
<?php } else { ?>
var fstock_process_fsearch = currentForm = new ew.Form("fstock_process_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_process_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_process_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_process_fsearch.lists["x_product"] = <?php echo $stock_process_f_search->product->Lookup->toClientList() ?>;
fstock_process_fsearch.lists["x_product"].options = <?php echo JsonEncode($stock_process_f_search->product->lookupOptions()) ?>;
fstock_process_fsearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fstock_process_fsearch.lists["x_godown"] = <?php echo $stock_process_f_search->godown->Lookup->toClientList() ?>;
fstock_process_fsearch.lists["x_godown"].options = <?php echo JsonEncode($stock_process_f_search->godown->lookupOptions()) ?>;
fstock_process_fsearch.lists["x_packing_type"] = <?php echo $stock_process_f_search->packing_type->Lookup->toClientList() ?>;
fstock_process_fsearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_process_f_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_process_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_process_f->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_process_f->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_process_f->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lot_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_process_f->lot_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_process_f->tmp_lot->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_process_f_search->showPageHeader(); ?>
<?php
$stock_process_f_search->showMessage();
?>
<form name="fstock_process_fsearch" id="fstock_process_fsearch" class="<?php echo $stock_process_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_process_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_process_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_process_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_process_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_process_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_product"><?php echo $stock_process_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->product->cellAttributes() ?>>
			<span id="el_stock_process_f_product">
<?php
$wrkonchange = "" . trim(@$stock_process_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$stock_process_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8990">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($stock_process_f->product->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_process_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($stock_process_f->product->getPlaceHolder()) ?>"<?php echo $stock_process_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_process_f" data-field="x_product" data-value-separator="<?php echo $stock_process_f->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($stock_process_f->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fstock_process_fsearch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $stock_process_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_code"><?php echo $stock_process_f->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->code->cellAttributes() ?>>
			<span id="el_stock_process_f_code">
<input type="text" data-table="stock_process_f" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($stock_process_f->code->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->code->EditValue ?>"<?php echo $stock_process_f->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_product_code"><?php echo $stock_process_f->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->product_code->cellAttributes() ?>>
			<span id="el_stock_process_f_product_code">
<input type="text" data-table="stock_process_f" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($stock_process_f->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->product_code->EditValue ?>"<?php echo $stock_process_f->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_godown"><?php echo $stock_process_f->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->godown->cellAttributes() ?>>
			<span id="el_stock_process_f_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_process_f" data-field="x_godown" data-value-separator="<?php echo $stock_process_f->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_process_f->godown->editAttributes() ?>>
		<?php echo $stock_process_f->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_process_f->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_IN"><?php echo $stock_process_f->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->IN->cellAttributes() ?>>
			<span id="el_stock_process_f_IN">
<input type="text" data-table="stock_process_f" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_process_f->IN->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->IN->EditValue ?>"<?php echo $stock_process_f->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_packets"><?php echo $stock_process_f->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->packets->cellAttributes() ?>>
			<span id="el_stock_process_f_packets">
<input type="text" data-table="stock_process_f" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_process_f->packets->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->packets->EditValue ?>"<?php echo $stock_process_f->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_packing_type"><?php echo $stock_process_f->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->packing_type->cellAttributes() ?>>
			<span id="el_stock_process_f_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_process_f" data-field="x_packing_type" data-value-separator="<?php echo $stock_process_f->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_process_f->packing_type->editAttributes() ?>>
		<?php echo $stock_process_f->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_process_f->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_process"><?php echo $stock_process_f->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->process->cellAttributes() ?>>
			<span id="el_stock_process_f_process">
<input type="text" data-table="stock_process_f" data-field="x_process" name="x_process" id="x_process" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($stock_process_f->process->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->process->EditValue ?>"<?php echo $stock_process_f->process->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_lot_no"><?php echo $stock_process_f->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->lot_no->cellAttributes() ?>>
			<span id="el_stock_process_f_lot_no">
<input type="text" data-table="stock_process_f" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($stock_process_f->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->lot_no->EditValue ?>"<?php echo $stock_process_f->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_process_f->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $stock_process_f_search->LeftColumnClass ?>"><span id="elh_stock_process_f_tmp_lot"><?php echo $stock_process_f->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $stock_process_f_search->RightColumnClass ?>"><div<?php echo $stock_process_f->tmp_lot->cellAttributes() ?>>
			<span id="el_stock_process_f_tmp_lot">
<input type="text" data-table="stock_process_f" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($stock_process_f->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $stock_process_f->tmp_lot->EditValue ?>"<?php echo $stock_process_f->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_process_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_process_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_process_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_process_f_search->terminate();
?>