<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_processing_job_list = new stock_processing_job_list();

// Run the page
$stock_processing_job_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_processing_job_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_processing_job->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_processing_joblist = currentForm = new ew.Form("fstock_processing_joblist", "list");
fstock_processing_joblist.formKeyCountName = '<?php echo $stock_processing_job_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_processing_joblist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_joblist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_joblist.lists["x_packing_type"] = <?php echo $stock_processing_job_list->packing_type->Lookup->toClientList() ?>;
fstock_processing_joblist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_processing_job_list->packing_type->lookupOptions()) ?>;
fstock_processing_joblist.lists["x_Item[]"] = <?php echo $stock_processing_job_list->Item->Lookup->toClientList() ?>;
fstock_processing_joblist.lists["x_Item[]"].options = <?php echo JsonEncode($stock_processing_job_list->Item->lookupOptions()) ?>;
fstock_processing_joblist.lists["x_new_process[]"] = <?php echo $stock_processing_job_list->new_process->Lookup->toClientList() ?>;
fstock_processing_joblist.lists["x_new_process[]"].options = <?php echo JsonEncode($stock_processing_job_list->new_process->lookupOptions()) ?>;
fstock_processing_joblist.lists["x_status"] = <?php echo $stock_processing_job_list->status->Lookup->toClientList() ?>;
fstock_processing_joblist.lists["x_status"].options = <?php echo JsonEncode($stock_processing_job_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fstock_processing_joblistsrch = currentSearchForm = new ew.Form("fstock_processing_joblistsrch");

// Validate function for search
fstock_processing_joblistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_processing_joblistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_joblistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_joblistsrch.lists["x_Item[]"] = <?php echo $stock_processing_job_list->Item->Lookup->toClientList() ?>;
fstock_processing_joblistsrch.lists["x_Item[]"].options = <?php echo JsonEncode($stock_processing_job_list->Item->lookupOptions()) ?>;
fstock_processing_joblistsrch.lists["x_status"] = <?php echo $stock_processing_job_list->status->Lookup->toClientList() ?>;
fstock_processing_joblistsrch.lists["x_status"].options = <?php echo JsonEncode($stock_processing_job_list->status->options(FALSE, TRUE)) ?>;

// Filters
fstock_processing_joblistsrch.filterList = <?php echo $stock_processing_job_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_processing_joblistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_processing_job->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_processing_job_list->TotalRecs > 0 && $stock_processing_job_list->ExportOptions->visible()) { ?>
<?php $stock_processing_job_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_job_list->ImportOptions->visible()) { ?>
<?php $stock_processing_job_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_job_list->SearchOptions->visible()) { ?>
<?php $stock_processing_job_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_job_list->FilterOptions->visible()) { ?>
<?php $stock_processing_job_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_processing_job_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_processing_job->isExport() && !$stock_processing_job->CurrentAction) { ?>
<form name="fstock_processing_joblistsrch" id="fstock_processing_joblistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_processing_job_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_processing_joblistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_processing_job">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_processing_job_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_processing_job->RowType = ROWTYPE_SEARCH;

// Render row
$stock_processing_job->resetAttributes();
$stock_processing_job_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_processing_job->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_processing_job->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_processing_job" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_job->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->product_code->EditValue ?>"<?php echo $stock_processing_job->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_processing_job->Item->Visible) { // Item ?>
	<div id="xsc_Item" class="ew-cell form-group">
		<label for="x_Item" class="ew-search-caption ew-label"><?php echo $stock_processing_job->Item->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Item" id="z_Item" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_processing_job" data-field="x_Item" name="x_Item" id="x_Item" placeholder="<?php echo HtmlEncode($stock_processing_job->Item->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->Item->EditValue ?>"<?php echo $stock_processing_job->Item->editAttributes() ?>>
<?php echo $stock_processing_job->Item->Lookup->getParamTag("p_x_Item") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_processing_job->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $stock_processing_job->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_job" data-field="x_status" data-value-separator="<?php echo $stock_processing_job->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_processing_job->status->editAttributes() ?>>
		<?php echo $stock_processing_job->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_processing_job_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_processing_job_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_processing_job_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_processing_job_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_job_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_job_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_job_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_processing_job_list->showPageHeader(); ?>
<?php
$stock_processing_job_list->showMessage();
?>
<?php if ($stock_processing_job_list->TotalRecs > 0 || $stock_processing_job->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_processing_job_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_processing_job">
<?php if (!$stock_processing_job->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_processing_job->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_processing_job_list->Pager)) $stock_processing_job_list->Pager = new PrevNextPager($stock_processing_job_list->StartRec, $stock_processing_job_list->DisplayRecs, $stock_processing_job_list->TotalRecs, $stock_processing_job_list->AutoHidePager) ?>
<?php if ($stock_processing_job_list->Pager->RecordCount > 0 && $stock_processing_job_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_processing_job_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_processing_job_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_processing_job_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_processing_job_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_processing_job_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_processing_job_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_processing_job_list->TotalRecs > 0 && (!$stock_processing_job_list->AutoHidePageSizeSelector || $stock_processing_job_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_processing_job">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_processing_job_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_processing_job_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_processing_job_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_processing_job_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_processing_job_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_processing_job->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_processing_job_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_processing_joblist" id="fstock_processing_joblist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_processing_job_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_processing_job_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_processing_job">
<div id="gmp_stock_processing_job" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_processing_job_list->TotalRecs > 0 || $stock_processing_job->isGridEdit()) { ?>
<table id="tbl_stock_processing_joblist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_processing_job_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_processing_job_list->renderListOptions();

// Render list options (header, left)
$stock_processing_job_list->ListOptions->render("header", "left");
?>
<?php if ($stock_processing_job->product_code->Visible) { // product_code ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_processing_job->product_code->headerCellClass() ?>"><div id="elh_stock_processing_job_product_code" class="stock_processing_job_product_code"><div class="ew-table-header-caption"><?php echo $stock_processing_job->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_processing_job->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->product_code) ?>',2);"><div id="elh_stock_processing_job_product_code" class="stock_processing_job_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_processing_job->lot_no->headerCellClass() ?>"><div id="elh_stock_processing_job_lot_no" class="stock_processing_job_lot_no"><div class="ew-table-header-caption"><?php echo $stock_processing_job->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_processing_job->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->lot_no) ?>',2);"><div id="elh_stock_processing_job_lot_no" class="stock_processing_job_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_processing_job->packing_type->headerCellClass() ?>"><div id="elh_stock_processing_job_packing_type" class="stock_processing_job_packing_type"><div class="ew-table-header-caption"><?php echo $stock_processing_job->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_processing_job->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->packing_type) ?>',2);"><div id="elh_stock_processing_job_packing_type" class="stock_processing_job_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_processing_job->tmp_lot->headerCellClass() ?>"><div id="elh_stock_processing_job_tmp_lot" class="stock_processing_job_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_processing_job->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_processing_job->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->tmp_lot) ?>',2);"><div id="elh_stock_processing_job_tmp_lot" class="stock_processing_job_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->gcode->Visible) { // gcode ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $stock_processing_job->gcode->headerCellClass() ?>"><div id="elh_stock_processing_job_gcode" class="stock_processing_job_gcode"><div class="ew-table-header-caption"><?php echo $stock_processing_job->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $stock_processing_job->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->gcode) ?>',2);"><div id="elh_stock_processing_job_gcode" class="stock_processing_job_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->gcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->dated->Visible) { // dated ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_processing_job->dated->headerCellClass() ?>"><div id="elh_stock_processing_job_dated" class="stock_processing_job_dated"><div class="ew-table-header-caption"><?php echo $stock_processing_job->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_processing_job->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->dated) ?>',2);"><div id="elh_stock_processing_job_dated" class="stock_processing_job_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->IN->Visible) { // IN ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_processing_job->IN->headerCellClass() ?>"><div id="elh_stock_processing_job_IN" class="stock_processing_job_IN"><div class="ew-table-header-caption"><?php echo $stock_processing_job->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_processing_job->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->IN) ?>',2);"><div id="elh_stock_processing_job_IN" class="stock_processing_job_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->IN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->OUT->Visible) { // OUT ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_processing_job->OUT->headerCellClass() ?>"><div id="elh_stock_processing_job_OUT" class="stock_processing_job_OUT"><div class="ew-table-header-caption"><?php echo $stock_processing_job->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_processing_job->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->OUT) ?>',2);"><div id="elh_stock_processing_job_OUT" class="stock_processing_job_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->Balance->Visible) { // Balance ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_processing_job->Balance->headerCellClass() ?>"><div id="elh_stock_processing_job_Balance" class="stock_processing_job_Balance"><div class="ew-table-header-caption"><?php echo $stock_processing_job->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_processing_job->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->Balance) ?>',2);"><div id="elh_stock_processing_job_Balance" class="stock_processing_job_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->Balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->Item->Visible) { // Item ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->Item) == "") { ?>
		<th data-name="Item" class="<?php echo $stock_processing_job->Item->headerCellClass() ?>"><div id="elh_stock_processing_job_Item" class="stock_processing_job_Item"><div class="ew-table-header-caption"><?php echo $stock_processing_job->Item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Item" class="<?php echo $stock_processing_job->Item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->Item) ?>',2);"><div id="elh_stock_processing_job_Item" class="stock_processing_job_Item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->Item->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->Item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->Item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->new_process->Visible) { // new_process ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->new_process) == "") { ?>
		<th data-name="new_process" class="<?php echo $stock_processing_job->new_process->headerCellClass() ?>"><div id="elh_stock_processing_job_new_process" class="stock_processing_job_new_process"><div class="ew-table-header-caption"><?php echo $stock_processing_job->new_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="new_process" class="<?php echo $stock_processing_job->new_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->new_process) ?>',2);"><div id="elh_stock_processing_job_new_process" class="stock_processing_job_new_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->new_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->new_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->new_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->avg_yield->Visible) { // avg_yield ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->avg_yield) == "") { ?>
		<th data-name="avg_yield" class="<?php echo $stock_processing_job->avg_yield->headerCellClass() ?>"><div id="elh_stock_processing_job_avg_yield" class="stock_processing_job_avg_yield"><div class="ew-table-header-caption"><?php echo $stock_processing_job->avg_yield->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_yield" class="<?php echo $stock_processing_job->avg_yield->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->avg_yield) ?>',2);"><div id="elh_stock_processing_job_avg_yield" class="stock_processing_job_avg_yield">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->avg_yield->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->avg_yield->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->avg_yield->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->remarks->Visible) { // remarks ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $stock_processing_job->remarks->headerCellClass() ?>"><div id="elh_stock_processing_job_remarks" class="stock_processing_job_remarks"><div class="ew-table-header-caption"><?php echo $stock_processing_job->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $stock_processing_job->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->remarks) ?>',2);"><div id="elh_stock_processing_job_remarks" class="stock_processing_job_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->status->Visible) { // status ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->status) == "") { ?>
		<th data-name="status" class="<?php echo $stock_processing_job->status->headerCellClass() ?>"><div id="elh_stock_processing_job_status" class="stock_processing_job_status"><div class="ew-table-header-caption"><?php echo $stock_processing_job->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $stock_processing_job->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->status) ?>',2);"><div id="elh_stock_processing_job_status" class="stock_processing_job_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->age->Visible) { // age ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_processing_job->age->headerCellClass() ?>"><div id="elh_stock_processing_job_age" class="stock_processing_job_age"><div class="ew-table-header-caption"><?php echo $stock_processing_job->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_processing_job->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->age) ?>',2);"><div id="elh_stock_processing_job_age" class="stock_processing_job_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->age->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_job->type->Visible) { // type ?>
	<?php if ($stock_processing_job->sortUrl($stock_processing_job->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_processing_job->type->headerCellClass() ?>"><div id="elh_stock_processing_job_type" class="stock_processing_job_type"><div class="ew-table-header-caption"><?php echo $stock_processing_job->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_processing_job->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_job->SortUrl($stock_processing_job->type) ?>',2);"><div id="elh_stock_processing_job_type" class="stock_processing_job_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_job->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_job->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_job->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_processing_job_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_processing_job->ExportAll && $stock_processing_job->isExport()) {
	$stock_processing_job_list->StopRec = $stock_processing_job_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_processing_job_list->TotalRecs > $stock_processing_job_list->StartRec + $stock_processing_job_list->DisplayRecs - 1)
		$stock_processing_job_list->StopRec = $stock_processing_job_list->StartRec + $stock_processing_job_list->DisplayRecs - 1;
	else
		$stock_processing_job_list->StopRec = $stock_processing_job_list->TotalRecs;
}
$stock_processing_job_list->RecCnt = $stock_processing_job_list->StartRec - 1;
if ($stock_processing_job_list->Recordset && !$stock_processing_job_list->Recordset->EOF) {
	$stock_processing_job_list->Recordset->moveFirst();
	$selectLimit = $stock_processing_job_list->UseSelectLimit;
	if (!$selectLimit && $stock_processing_job_list->StartRec > 1)
		$stock_processing_job_list->Recordset->move($stock_processing_job_list->StartRec - 1);
} elseif (!$stock_processing_job->AllowAddDeleteRow && $stock_processing_job_list->StopRec == 0) {
	$stock_processing_job_list->StopRec = $stock_processing_job->GridAddRowCount;
}

// Initialize aggregate
$stock_processing_job->RowType = ROWTYPE_AGGREGATEINIT;
$stock_processing_job->resetAttributes();
$stock_processing_job_list->renderRow();
while ($stock_processing_job_list->RecCnt < $stock_processing_job_list->StopRec) {
	$stock_processing_job_list->RecCnt++;
	if ($stock_processing_job_list->RecCnt >= $stock_processing_job_list->StartRec) {
		$stock_processing_job_list->RowCnt++;

		// Set up key count
		$stock_processing_job_list->KeyCount = $stock_processing_job_list->RowIndex;

		// Init row class and style
		$stock_processing_job->resetAttributes();
		$stock_processing_job->CssClass = "";
		if ($stock_processing_job->isGridAdd()) {
		} else {
			$stock_processing_job_list->loadRowValues($stock_processing_job_list->Recordset); // Load row values
		}
		$stock_processing_job->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_processing_job->RowAttrs = array_merge($stock_processing_job->RowAttrs, array('data-rowindex'=>$stock_processing_job_list->RowCnt, 'id'=>'r' . $stock_processing_job_list->RowCnt . '_stock_processing_job', 'data-rowtype'=>$stock_processing_job->RowType));

		// Render row
		$stock_processing_job_list->renderRow();

		// Render list options
		$stock_processing_job_list->renderListOptions();
?>
	<tr<?php echo $stock_processing_job->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_processing_job_list->ListOptions->render("body", "left", $stock_processing_job_list->RowCnt);
?>
	<?php if ($stock_processing_job->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_processing_job->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_product_code" class="stock_processing_job_product_code">
<span<?php echo $stock_processing_job->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_processing_job->product_code->getViewValue())) && $stock_processing_job->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_processing_job->product_code->linkAttributes() ?>><?php echo $stock_processing_job->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_processing_job->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_processing_job->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_lot_no" class="stock_processing_job_lot_no">
<span<?php echo $stock_processing_job->lot_no->viewAttributes() ?>>
<?php echo $stock_processing_job->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_processing_job->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_packing_type" class="stock_processing_job_packing_type">
<span<?php echo $stock_processing_job->packing_type->viewAttributes() ?>>
<?php echo $stock_processing_job->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_processing_job->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_tmp_lot" class="stock_processing_job_tmp_lot">
<span<?php echo $stock_processing_job->tmp_lot->viewAttributes() ?>>
<?php echo $stock_processing_job->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $stock_processing_job->gcode->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_gcode" class="stock_processing_job_gcode">
<span<?php echo $stock_processing_job->gcode->viewAttributes() ?>>
<?php echo $stock_processing_job->gcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_processing_job->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_dated" class="stock_processing_job_dated">
<span<?php echo $stock_processing_job->dated->viewAttributes() ?>>
<?php echo $stock_processing_job->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_processing_job->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_IN" class="stock_processing_job_IN">
<span<?php echo $stock_processing_job->IN->viewAttributes() ?>>
<?php echo $stock_processing_job->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_processing_job->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_OUT" class="stock_processing_job_OUT">
<span<?php echo $stock_processing_job->OUT->viewAttributes() ?>>
<?php echo $stock_processing_job->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_processing_job->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_Balance" class="stock_processing_job_Balance">
<span<?php echo $stock_processing_job->Balance->viewAttributes() ?>>
<?php echo $stock_processing_job->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->Item->Visible) { // Item ?>
		<td data-name="Item"<?php echo $stock_processing_job->Item->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_Item" class="stock_processing_job_Item">
<span<?php echo $stock_processing_job->Item->viewAttributes() ?>>
<?php echo $stock_processing_job->Item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->new_process->Visible) { // new_process ?>
		<td data-name="new_process"<?php echo $stock_processing_job->new_process->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_new_process" class="stock_processing_job_new_process">
<span<?php echo $stock_processing_job->new_process->viewAttributes() ?>>
<?php echo $stock_processing_job->new_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield"<?php echo $stock_processing_job->avg_yield->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_avg_yield" class="stock_processing_job_avg_yield">
<span<?php echo $stock_processing_job->avg_yield->viewAttributes() ?>>
<?php echo $stock_processing_job->avg_yield->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $stock_processing_job->remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_remarks" class="stock_processing_job_remarks">
<span<?php echo $stock_processing_job->remarks->viewAttributes() ?>>
<?php echo $stock_processing_job->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->status->Visible) { // status ?>
		<td data-name="status"<?php echo $stock_processing_job->status->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_status" class="stock_processing_job_status">
<span<?php echo $stock_processing_job->status->viewAttributes() ?>>
<?php echo $stock_processing_job->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_processing_job->age->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_age" class="stock_processing_job_age">
<span<?php echo $stock_processing_job->age->viewAttributes() ?>>
<?php echo $stock_processing_job->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_job->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_processing_job->type->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_job_list->RowCnt ?>_stock_processing_job_type" class="stock_processing_job_type">
<span<?php echo $stock_processing_job->type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_processing_job->type->getViewValue())) && $stock_processing_job->type->linkAttributes() <> "") { ?>
<a<?php echo $stock_processing_job->type->linkAttributes() ?>><?php echo $stock_processing_job->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_processing_job->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_processing_job_list->ListOptions->render("body", "right", $stock_processing_job_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_processing_job->isGridAdd())
		$stock_processing_job_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_processing_job->RowType = ROWTYPE_AGGREGATE;
$stock_processing_job->resetAttributes();
$stock_processing_job_list->renderRow();
?>
<?php if ($stock_processing_job_list->TotalRecs > 0 && !$stock_processing_job->isGridAdd() && !$stock_processing_job->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_processing_job_list->renderListOptions();

// Render list options (footer, left)
$stock_processing_job_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_processing_job->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_processing_job->product_code->footerCellClass() ?>"><span id="elf_stock_processing_job_product_code" class="stock_processing_job_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_processing_job->lot_no->footerCellClass() ?>"><span id="elf_stock_processing_job_lot_no" class="stock_processing_job_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_processing_job->packing_type->footerCellClass() ?>"><span id="elf_stock_processing_job_packing_type" class="stock_processing_job_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_processing_job->tmp_lot->footerCellClass() ?>"><span id="elf_stock_processing_job_tmp_lot" class="stock_processing_job_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->gcode->Visible) { // gcode ?>
		<td data-name="gcode" class="<?php echo $stock_processing_job->gcode->footerCellClass() ?>"><span id="elf_stock_processing_job_gcode" class="stock_processing_job_gcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_processing_job->dated->footerCellClass() ?>"><span id="elf_stock_processing_job_dated" class="stock_processing_job_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_processing_job->IN->footerCellClass() ?>"><span id="elf_stock_processing_job_IN" class="stock_processing_job_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_job->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_processing_job->OUT->footerCellClass() ?>"><span id="elf_stock_processing_job_OUT" class="stock_processing_job_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_job->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_processing_job->Balance->footerCellClass() ?>"><span id="elf_stock_processing_job_Balance" class="stock_processing_job_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_job->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->Item->Visible) { // Item ?>
		<td data-name="Item" class="<?php echo $stock_processing_job->Item->footerCellClass() ?>"><span id="elf_stock_processing_job_Item" class="stock_processing_job_Item">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->new_process->Visible) { // new_process ?>
		<td data-name="new_process" class="<?php echo $stock_processing_job->new_process->footerCellClass() ?>"><span id="elf_stock_processing_job_new_process" class="stock_processing_job_new_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield" class="<?php echo $stock_processing_job->avg_yield->footerCellClass() ?>"><span id="elf_stock_processing_job_avg_yield" class="stock_processing_job_avg_yield">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_job->avg_yield->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $stock_processing_job->remarks->footerCellClass() ?>"><span id="elf_stock_processing_job_remarks" class="stock_processing_job_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $stock_processing_job->status->footerCellClass() ?>"><span id="elf_stock_processing_job_status" class="stock_processing_job_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_processing_job->age->footerCellClass() ?>"><span id="elf_stock_processing_job_age" class="stock_processing_job_age">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_job->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_processing_job->type->footerCellClass() ?>"><span id="elf_stock_processing_job_type" class="stock_processing_job_type">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_processing_job_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_processing_job->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_processing_job_list->Recordset)
	$stock_processing_job_list->Recordset->Close();
?>
<?php if (!$stock_processing_job->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_processing_job->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_processing_job_list->Pager)) $stock_processing_job_list->Pager = new PrevNextPager($stock_processing_job_list->StartRec, $stock_processing_job_list->DisplayRecs, $stock_processing_job_list->TotalRecs, $stock_processing_job_list->AutoHidePager) ?>
<?php if ($stock_processing_job_list->Pager->RecordCount > 0 && $stock_processing_job_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_processing_job_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_processing_job_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_processing_job_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_processing_job_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_processing_job_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_processing_job_list->pageUrl() ?>start=<?php echo $stock_processing_job_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_processing_job_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_processing_job_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_processing_job_list->TotalRecs > 0 && (!$stock_processing_job_list->AutoHidePageSizeSelector || $stock_processing_job_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_processing_job">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_processing_job_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_processing_job_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_processing_job_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_processing_job_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_processing_job_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_processing_job->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_processing_job_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_processing_job_list->TotalRecs == 0 && !$stock_processing_job->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_processing_job_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_processing_job_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_processing_job->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_processing_job->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_processing_job", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_processing_job_list->terminate();
?>