<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_processing_job_search = new stock_processing_job_search();

// Run the page
$stock_processing_job_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_processing_job_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_processing_job_search->IsModal) { ?>
var fstock_processing_jobsearch = currentAdvancedSearchForm = new ew.Form("fstock_processing_jobsearch", "search");
<?php } else { ?>
var fstock_processing_jobsearch = currentForm = new ew.Form("fstock_processing_jobsearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_processing_jobsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_jobsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_jobsearch.lists["x_product"] = <?php echo $stock_processing_job_search->product->Lookup->toClientList() ?>;
fstock_processing_jobsearch.lists["x_product"].options = <?php echo JsonEncode($stock_processing_job_search->product->lookupOptions()) ?>;
fstock_processing_jobsearch.lists["x_packing_type"] = <?php echo $stock_processing_job_search->packing_type->Lookup->toClientList() ?>;
fstock_processing_jobsearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_processing_job_search->packing_type->lookupOptions()) ?>;
fstock_processing_jobsearch.lists["x_Item[]"] = <?php echo $stock_processing_job_search->Item->Lookup->toClientList() ?>;
fstock_processing_jobsearch.lists["x_Item[]"].options = <?php echo JsonEncode($stock_processing_job_search->Item->lookupOptions()) ?>;
fstock_processing_jobsearch.lists["x_new_process[]"] = <?php echo $stock_processing_job_search->new_process->Lookup->toClientList() ?>;
fstock_processing_jobsearch.lists["x_new_process[]"].options = <?php echo JsonEncode($stock_processing_job_search->new_process->lookupOptions()) ?>;
fstock_processing_jobsearch.lists["x_status"] = <?php echo $stock_processing_job_search->status->Lookup->toClientList() ?>;
fstock_processing_jobsearch.lists["x_status"].options = <?php echo JsonEncode($stock_processing_job_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fstock_processing_jobsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_yield");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->avg_yield->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_job->age->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_processing_job_search->showPageHeader(); ?>
<?php
$stock_processing_job_search->showMessage();
?>
<form name="fstock_processing_jobsearch" id="fstock_processing_jobsearch" class="<?php echo $stock_processing_job_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_processing_job_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_processing_job_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_processing_job">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_processing_job_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_processing_job->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_id"><?php echo $stock_processing_job->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->id->cellAttributes() ?>>
			<span id="el_stock_processing_job_id">
<input type="text" data-table="stock_processing_job" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->id->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->id->EditValue ?>"<?php echo $stock_processing_job->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_product"><?php echo $stock_processing_job->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->product->cellAttributes() ?>>
			<span id="el_stock_processing_job_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_job" data-field="x_product" data-value-separator="<?php echo $stock_processing_job->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_processing_job->product->editAttributes() ?>>
		<?php echo $stock_processing_job->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_processing_job->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_product_code"><?php echo $stock_processing_job->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->product_code->cellAttributes() ?>>
			<span id="el_stock_processing_job_product_code">
<input type="text" data-table="stock_processing_job" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_job->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->product_code->EditValue ?>"<?php echo $stock_processing_job->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_lot_no"><?php echo $stock_processing_job->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->lot_no->cellAttributes() ?>>
			<span id="el_stock_processing_job_lot_no">
<input type="text" data-table="stock_processing_job" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_processing_job->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->lot_no->EditValue ?>"<?php echo $stock_processing_job->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_packing_type"><?php echo $stock_processing_job->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->packing_type->cellAttributes() ?>>
			<span id="el_stock_processing_job_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_job" data-field="x_packing_type" data-value-separator="<?php echo $stock_processing_job->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_processing_job->packing_type->editAttributes() ?>>
		<?php echo $stock_processing_job->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_processing_job->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_tmp_lot"><?php echo $stock_processing_job->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->tmp_lot->cellAttributes() ?>>
			<span id="el_stock_processing_job_tmp_lot">
<input type="text" data-table="stock_processing_job" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->tmp_lot->EditValue ?>"<?php echo $stock_processing_job->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label for="x_gcode" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_gcode"><?php echo $stock_processing_job->gcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gcode" id="z_gcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->gcode->cellAttributes() ?>>
			<span id="el_stock_processing_job_gcode">
<input type="text" data-table="stock_processing_job" data-field="x_gcode" name="x_gcode" id="x_gcode" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($stock_processing_job->gcode->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->gcode->EditValue ?>"<?php echo $stock_processing_job->gcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_dated"><?php echo $stock_processing_job->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->dated->cellAttributes() ?>>
			<span id="el_stock_processing_job_dated">
<input type="text" data-table="stock_processing_job" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_processing_job->dated->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->dated->EditValue ?>"<?php echo $stock_processing_job->dated->editAttributes() ?>>
<?php if (!$stock_processing_job->dated->ReadOnly && !$stock_processing_job->dated->Disabled && !isset($stock_processing_job->dated->EditAttrs["readonly"]) && !isset($stock_processing_job->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_processing_jobsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_IN"><?php echo $stock_processing_job->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->IN->cellAttributes() ?>>
			<span id="el_stock_processing_job_IN">
<input type="text" data-table="stock_processing_job" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->IN->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->IN->EditValue ?>"<?php echo $stock_processing_job->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_OUT"><?php echo $stock_processing_job->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->OUT->cellAttributes() ?>>
			<span id="el_stock_processing_job_OUT">
<input type="text" data-table="stock_processing_job" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->OUT->EditValue ?>"<?php echo $stock_processing_job->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_Balance"><?php echo $stock_processing_job->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->Balance->cellAttributes() ?>>
			<span id="el_stock_processing_job_Balance">
<input type="text" data-table="stock_processing_job" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->Balance->EditValue ?>"<?php echo $stock_processing_job->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->Item->Visible) { // Item ?>
	<div id="r_Item" class="form-group row">
		<label for="x_Item" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_Item"><?php echo $stock_processing_job->Item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Item" id="z_Item" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->Item->cellAttributes() ?>>
			<span id="el_stock_processing_job_Item">
<input type="text" data-table="stock_processing_job" data-field="x_Item" name="x_Item" id="x_Item" placeholder="<?php echo HtmlEncode($stock_processing_job->Item->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->Item->EditValue ?>"<?php echo $stock_processing_job->Item->editAttributes() ?>>
<?php echo $stock_processing_job->Item->Lookup->getParamTag("p_x_Item") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->new_process->Visible) { // new_process ?>
	<div id="r_new_process" class="form-group row">
		<label for="x_new_process" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_new_process"><?php echo $stock_processing_job->new_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_new_process" id="z_new_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->new_process->cellAttributes() ?>>
			<span id="el_stock_processing_job_new_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_job" data-field="x_new_process" data-value-separator="<?php echo $stock_processing_job->new_process->displayValueSeparatorAttribute() ?>" id="x_new_process[]" name="x_new_process[]" multiple="multiple"<?php echo $stock_processing_job->new_process->editAttributes() ?>>
		<?php echo $stock_processing_job->new_process->selectOptionListHtml("x_new_process[]") ?>
	</select>
</div>
<?php echo $stock_processing_job->new_process->Lookup->getParamTag("p_x_new_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_avg_yield"><?php echo $stock_processing_job->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->avg_yield->cellAttributes() ?>>
			<span id="el_stock_processing_job_avg_yield">
<input type="text" data-table="stock_processing_job" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->avg_yield->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->avg_yield->EditValue ?>"<?php echo $stock_processing_job->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_remarks"><?php echo $stock_processing_job->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->remarks->cellAttributes() ?>>
			<span id="el_stock_processing_job_remarks">
<input type="text" data-table="stock_processing_job" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_job->remarks->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->remarks->EditValue ?>"<?php echo $stock_processing_job->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_status"><?php echo $stock_processing_job->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->status->cellAttributes() ?>>
			<span id="el_stock_processing_job_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_job" data-field="x_status" data-value-separator="<?php echo $stock_processing_job->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_processing_job->status->editAttributes() ?>>
		<?php echo $stock_processing_job->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_url"><?php echo $stock_processing_job->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->url->cellAttributes() ?>>
			<span id="el_stock_processing_job_url">
<input type="text" data-table="stock_processing_job" data-field="x_url" name="x_url" id="x_url" size="35" placeholder="<?php echo HtmlEncode($stock_processing_job->url->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->url->EditValue ?>"<?php echo $stock_processing_job->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_age"><?php echo $stock_processing_job->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->age->cellAttributes() ?>>
			<span id="el_stock_processing_job_age">
<input type="text" data-table="stock_processing_job" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($stock_processing_job->age->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->age->EditValue ?>"<?php echo $stock_processing_job->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_job->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_processing_job_search->LeftColumnClass ?>"><span id="elh_stock_processing_job_type"><?php echo $stock_processing_job->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_job_search->RightColumnClass ?>"><div<?php echo $stock_processing_job->type->cellAttributes() ?>>
			<span id="el_stock_processing_job_type">
<input type="text" data-table="stock_processing_job" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($stock_processing_job->type->getPlaceHolder()) ?>" value="<?php echo $stock_processing_job->type->EditValue ?>"<?php echo $stock_processing_job->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_processing_job_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_processing_job_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_processing_job_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_processing_job_search->terminate();
?>