<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_processing_outside_list = new stock_processing_outside_list();

// Run the page
$stock_processing_outside_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_processing_outside_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_processing_outside->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_processing_outsidelist = currentForm = new ew.Form("fstock_processing_outsidelist", "list");
fstock_processing_outsidelist.formKeyCountName = '<?php echo $stock_processing_outside_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_processing_outsidelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_outsidelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_outsidelist.lists["x_process_type"] = <?php echo $stock_processing_outside_list->process_type->Lookup->toClientList() ?>;
fstock_processing_outsidelist.lists["x_process_type"].options = <?php echo JsonEncode($stock_processing_outside_list->process_type->lookupOptions()) ?>;
fstock_processing_outsidelist.lists["x_packing_type"] = <?php echo $stock_processing_outside_list->packing_type->Lookup->toClientList() ?>;
fstock_processing_outsidelist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_processing_outside_list->packing_type->lookupOptions()) ?>;
fstock_processing_outsidelist.lists["x_godown"] = <?php echo $stock_processing_outside_list->godown->Lookup->toClientList() ?>;
fstock_processing_outsidelist.lists["x_godown"].options = <?php echo JsonEncode($stock_processing_outside_list->godown->lookupOptions()) ?>;
fstock_processing_outsidelist.lists["x_godown_n"] = <?php echo $stock_processing_outside_list->godown_n->Lookup->toClientList() ?>;
fstock_processing_outsidelist.lists["x_godown_n"].options = <?php echo JsonEncode($stock_processing_outside_list->godown_n->lookupOptions()) ?>;

// Form object for search
var fstock_processing_outsidelistsrch = currentSearchForm = new ew.Form("fstock_processing_outsidelistsrch");

// Validate function for search
fstock_processing_outsidelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_processing_outsidelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_outsidelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_outsidelistsrch.lists["x_godown"] = <?php echo $stock_processing_outside_list->godown->Lookup->toClientList() ?>;
fstock_processing_outsidelistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_processing_outside_list->godown->lookupOptions()) ?>;

// Filters
fstock_processing_outsidelistsrch.filterList = <?php echo $stock_processing_outside_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_processing_outsidelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_processing_outside->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_processing_outside_list->TotalRecs > 0 && $stock_processing_outside_list->ExportOptions->visible()) { ?>
<?php $stock_processing_outside_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_outside_list->ImportOptions->visible()) { ?>
<?php $stock_processing_outside_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_outside_list->SearchOptions->visible()) { ?>
<?php $stock_processing_outside_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_processing_outside_list->FilterOptions->visible()) { ?>
<?php $stock_processing_outside_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_processing_outside_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_processing_outside->isExport() && !$stock_processing_outside->CurrentAction) { ?>
<form name="fstock_processing_outsidelistsrch" id="fstock_processing_outsidelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_processing_outside_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_processing_outsidelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_processing_outside">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_processing_outside_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_processing_outside->RowType = ROWTYPE_SEARCH;

// Render row
$stock_processing_outside->resetAttributes();
$stock_processing_outside_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_processing_outside->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_processing_outside->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_processing_outside" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_outside->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->product_code->EditValue ?>"<?php echo $stock_processing_outside->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_processing_outside->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_godown" data-value-separator="<?php echo $stock_processing_outside->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_processing_outside->godown->editAttributes() ?>>
		<?php echo $stock_processing_outside->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_processing_outside->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $stock_processing_outside->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_processing_outside" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_processing_outside->dated->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->dated->EditValue ?>"<?php echo $stock_processing_outside->dated->editAttributes() ?>>
<?php if (!$stock_processing_outside->dated->ReadOnly && !$stock_processing_outside->dated->Disabled && !isset($stock_processing_outside->dated->EditAttrs["readonly"]) && !isset($stock_processing_outside->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_processing_outsidelistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="stock_processing_outside" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_processing_outside->dated->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->dated->EditValue2 ?>"<?php echo $stock_processing_outside->dated->editAttributes() ?>>
<?php if (!$stock_processing_outside->dated->ReadOnly && !$stock_processing_outside->dated->Disabled && !isset($stock_processing_outside->dated->EditAttrs["readonly"]) && !isset($stock_processing_outside->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_processing_outsidelistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_processing_outside->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $stock_processing_outside->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_processing_outside" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($stock_processing_outside->type->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->type->EditValue ?>"<?php echo $stock_processing_outside->type->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_processing_outside_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_processing_outside_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_processing_outside_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_processing_outside_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_outside_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_outside_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_processing_outside_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_processing_outside_list->showPageHeader(); ?>
<?php
$stock_processing_outside_list->showMessage();
?>
<?php if ($stock_processing_outside_list->TotalRecs > 0 || $stock_processing_outside->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_processing_outside_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_processing_outside">
<?php if (!$stock_processing_outside->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_processing_outside->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_processing_outside_list->Pager)) $stock_processing_outside_list->Pager = new PrevNextPager($stock_processing_outside_list->StartRec, $stock_processing_outside_list->DisplayRecs, $stock_processing_outside_list->TotalRecs, $stock_processing_outside_list->AutoHidePager) ?>
<?php if ($stock_processing_outside_list->Pager->RecordCount > 0 && $stock_processing_outside_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_processing_outside_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_processing_outside_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_processing_outside_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_processing_outside_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_processing_outside_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_processing_outside_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_processing_outside_list->TotalRecs > 0 && (!$stock_processing_outside_list->AutoHidePageSizeSelector || $stock_processing_outside_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_processing_outside">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_processing_outside_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_processing_outside_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_processing_outside_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_processing_outside_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_processing_outside_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_processing_outside->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_processing_outside_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_processing_outsidelist" id="fstock_processing_outsidelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_processing_outside_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_processing_outside_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_processing_outside">
<div id="gmp_stock_processing_outside" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_processing_outside_list->TotalRecs > 0 || $stock_processing_outside->isGridEdit()) { ?>
<table id="tbl_stock_processing_outsidelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_processing_outside_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_processing_outside_list->renderListOptions();

// Render list options (header, left)
$stock_processing_outside_list->ListOptions->render("header", "left");
?>
<?php if ($stock_processing_outside->product_n->Visible) { // product_n ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $stock_processing_outside->product_n->headerCellClass() ?>"><div id="elh_stock_processing_outside_product_n" class="stock_processing_outside_product_n"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $stock_processing_outside->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->product_n) ?>',2);"><div id="elh_stock_processing_outside_product_n" class="stock_processing_outside_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->product_code->Visible) { // product_code ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_processing_outside->product_code->headerCellClass() ?>"><div id="elh_stock_processing_outside_product_code" class="stock_processing_outside_product_code"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_processing_outside->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->product_code) ?>',2);"><div id="elh_stock_processing_outside_product_code" class="stock_processing_outside_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_processing_outside->lot_no->headerCellClass() ?>"><div id="elh_stock_processing_outside_lot_no" class="stock_processing_outside_lot_no"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_processing_outside->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->lot_no) ?>',2);"><div id="elh_stock_processing_outside_lot_no" class="stock_processing_outside_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->process_type->Visible) { // process_type ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $stock_processing_outside->process_type->headerCellClass() ?>"><div id="elh_stock_processing_outside_process_type" class="stock_processing_outside_process_type"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $stock_processing_outside->process_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->process_type) ?>',2);"><div id="elh_stock_processing_outside_process_type" class="stock_processing_outside_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_processing_outside->tmp_lot->headerCellClass() ?>"><div id="elh_stock_processing_outside_tmp_lot" class="stock_processing_outside_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_processing_outside->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->tmp_lot) ?>',2);"><div id="elh_stock_processing_outside_tmp_lot" class="stock_processing_outside_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->packets->Visible) { // packets ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_processing_outside->packets->headerCellClass() ?>"><div id="elh_stock_processing_outside_packets" class="stock_processing_outside_packets"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_processing_outside->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->packets) ?>',2);"><div id="elh_stock_processing_outside_packets" class="stock_processing_outside_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_processing_outside->packing_type->headerCellClass() ?>"><div id="elh_stock_processing_outside_packing_type" class="stock_processing_outside_packing_type"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_processing_outside->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->packing_type) ?>',2);"><div id="elh_stock_processing_outside_packing_type" class="stock_processing_outside_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->godown->Visible) { // godown ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_processing_outside->godown->headerCellClass() ?>"><div id="elh_stock_processing_outside_godown" class="stock_processing_outside_godown"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_processing_outside->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->godown) ?>',2);"><div id="elh_stock_processing_outside_godown" class="stock_processing_outside_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->godown_n->Visible) { // godown_n ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->godown_n) == "") { ?>
		<th data-name="godown_n" class="<?php echo $stock_processing_outside->godown_n->headerCellClass() ?>"><div id="elh_stock_processing_outside_godown_n" class="stock_processing_outside_godown_n"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->godown_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_n" class="<?php echo $stock_processing_outside->godown_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->godown_n) ?>',2);"><div id="elh_stock_processing_outside_godown_n" class="stock_processing_outside_godown_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->godown_n->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->godown_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->godown_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->dated->Visible) { // dated ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_processing_outside->dated->headerCellClass() ?>"><div id="elh_stock_processing_outside_dated" class="stock_processing_outside_dated"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_processing_outside->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->dated) ?>',2);"><div id="elh_stock_processing_outside_dated" class="stock_processing_outside_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->IN->Visible) { // IN ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_processing_outside->IN->headerCellClass() ?>"><div id="elh_stock_processing_outside_IN" class="stock_processing_outside_IN"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_processing_outside->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->IN) ?>',2);"><div id="elh_stock_processing_outside_IN" class="stock_processing_outside_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->OUT->Visible) { // OUT ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_processing_outside->OUT->headerCellClass() ?>"><div id="elh_stock_processing_outside_OUT" class="stock_processing_outside_OUT"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_processing_outside->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->OUT) ?>',2);"><div id="elh_stock_processing_outside_OUT" class="stock_processing_outside_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->Balance->Visible) { // Balance ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_processing_outside->Balance->headerCellClass() ?>"><div id="elh_stock_processing_outside_Balance" class="stock_processing_outside_Balance"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_processing_outside->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->Balance) ?>',2);"><div id="elh_stock_processing_outside_Balance" class="stock_processing_outside_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->type->Visible) { // type ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_processing_outside->type->headerCellClass() ?>"><div id="elh_stock_processing_outside_type" class="stock_processing_outside_type"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_processing_outside->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->type) ?>',2);"><div id="elh_stock_processing_outside_type" class="stock_processing_outside_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_processing_outside->company_id->Visible) { // company_id ?>
	<?php if ($stock_processing_outside->sortUrl($stock_processing_outside->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_processing_outside->company_id->headerCellClass() ?>"><div id="elh_stock_processing_outside_company_id" class="stock_processing_outside_company_id"><div class="ew-table-header-caption"><?php echo $stock_processing_outside->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_processing_outside->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_processing_outside->SortUrl($stock_processing_outside->company_id) ?>',2);"><div id="elh_stock_processing_outside_company_id" class="stock_processing_outside_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_processing_outside->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_processing_outside->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_processing_outside->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_processing_outside_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_processing_outside->ExportAll && $stock_processing_outside->isExport()) {
	$stock_processing_outside_list->StopRec = $stock_processing_outside_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_processing_outside_list->TotalRecs > $stock_processing_outside_list->StartRec + $stock_processing_outside_list->DisplayRecs - 1)
		$stock_processing_outside_list->StopRec = $stock_processing_outside_list->StartRec + $stock_processing_outside_list->DisplayRecs - 1;
	else
		$stock_processing_outside_list->StopRec = $stock_processing_outside_list->TotalRecs;
}
$stock_processing_outside_list->RecCnt = $stock_processing_outside_list->StartRec - 1;
if ($stock_processing_outside_list->Recordset && !$stock_processing_outside_list->Recordset->EOF) {
	$stock_processing_outside_list->Recordset->moveFirst();
	$selectLimit = $stock_processing_outside_list->UseSelectLimit;
	if (!$selectLimit && $stock_processing_outside_list->StartRec > 1)
		$stock_processing_outside_list->Recordset->move($stock_processing_outside_list->StartRec - 1);
} elseif (!$stock_processing_outside->AllowAddDeleteRow && $stock_processing_outside_list->StopRec == 0) {
	$stock_processing_outside_list->StopRec = $stock_processing_outside->GridAddRowCount;
}

// Initialize aggregate
$stock_processing_outside->RowType = ROWTYPE_AGGREGATEINIT;
$stock_processing_outside->resetAttributes();
$stock_processing_outside_list->renderRow();
while ($stock_processing_outside_list->RecCnt < $stock_processing_outside_list->StopRec) {
	$stock_processing_outside_list->RecCnt++;
	if ($stock_processing_outside_list->RecCnt >= $stock_processing_outside_list->StartRec) {
		$stock_processing_outside_list->RowCnt++;

		// Set up key count
		$stock_processing_outside_list->KeyCount = $stock_processing_outside_list->RowIndex;

		// Init row class and style
		$stock_processing_outside->resetAttributes();
		$stock_processing_outside->CssClass = "";
		if ($stock_processing_outside->isGridAdd()) {
		} else {
			$stock_processing_outside_list->loadRowValues($stock_processing_outside_list->Recordset); // Load row values
		}
		$stock_processing_outside->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_processing_outside->RowAttrs = array_merge($stock_processing_outside->RowAttrs, array('data-rowindex'=>$stock_processing_outside_list->RowCnt, 'id'=>'r' . $stock_processing_outside_list->RowCnt . '_stock_processing_outside', 'data-rowtype'=>$stock_processing_outside->RowType));

		// Render row
		$stock_processing_outside_list->renderRow();

		// Render list options
		$stock_processing_outside_list->renderListOptions();
?>
	<tr<?php echo $stock_processing_outside->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_processing_outside_list->ListOptions->render("body", "left", $stock_processing_outside_list->RowCnt);
?>
	<?php if ($stock_processing_outside->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $stock_processing_outside->product_n->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_product_n" class="stock_processing_outside_product_n">
<span<?php echo $stock_processing_outside->product_n->viewAttributes() ?>>
<?php echo $stock_processing_outside->product_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_processing_outside->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_product_code" class="stock_processing_outside_product_code">
<span<?php echo $stock_processing_outside->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_processing_outside->product_code->getViewValue())) && $stock_processing_outside->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_processing_outside->product_code->linkAttributes() ?>><?php echo $stock_processing_outside->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_processing_outside->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_processing_outside->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_lot_no" class="stock_processing_outside_lot_no">
<span<?php echo $stock_processing_outside->lot_no->viewAttributes() ?>>
<?php echo $stock_processing_outside->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $stock_processing_outside->process_type->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_process_type" class="stock_processing_outside_process_type">
<span<?php echo $stock_processing_outside->process_type->viewAttributes() ?>>
<?php echo $stock_processing_outside->process_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_processing_outside->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_tmp_lot" class="stock_processing_outside_tmp_lot">
<span<?php echo $stock_processing_outside->tmp_lot->viewAttributes() ?>>
<?php echo $stock_processing_outside->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_processing_outside->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_packets" class="stock_processing_outside_packets">
<span<?php echo $stock_processing_outside->packets->viewAttributes() ?>>
<?php echo $stock_processing_outside->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_processing_outside->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_packing_type" class="stock_processing_outside_packing_type">
<span<?php echo $stock_processing_outside->packing_type->viewAttributes() ?>>
<?php echo $stock_processing_outside->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_processing_outside->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_godown" class="stock_processing_outside_godown">
<span<?php echo $stock_processing_outside->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_processing_outside->godown->getViewValue())) && $stock_processing_outside->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_processing_outside->godown->linkAttributes() ?>><?php echo $stock_processing_outside->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_processing_outside->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->godown_n->Visible) { // godown_n ?>
		<td data-name="godown_n"<?php echo $stock_processing_outside->godown_n->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_godown_n" class="stock_processing_outside_godown_n">
<span<?php echo $stock_processing_outside->godown_n->viewAttributes() ?>>
<?php echo $stock_processing_outside->godown_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_processing_outside->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_dated" class="stock_processing_outside_dated">
<span<?php echo $stock_processing_outside->dated->viewAttributes() ?>>
<?php echo $stock_processing_outside->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_processing_outside->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_IN" class="stock_processing_outside_IN">
<span<?php echo $stock_processing_outside->IN->viewAttributes() ?>>
<?php echo $stock_processing_outside->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_processing_outside->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_OUT" class="stock_processing_outside_OUT">
<span<?php echo $stock_processing_outside->OUT->viewAttributes() ?>>
<?php echo $stock_processing_outside->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_processing_outside->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_Balance" class="stock_processing_outside_Balance">
<span<?php echo $stock_processing_outside->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_processing_outside->Balance->getViewValue())) && $stock_processing_outside->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_processing_outside->Balance->linkAttributes() ?>><?php echo $stock_processing_outside->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_processing_outside->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_processing_outside->type->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_type" class="stock_processing_outside_type">
<span<?php echo $stock_processing_outside->type->viewAttributes() ?>>
<?php echo $stock_processing_outside->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_processing_outside->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_processing_outside->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_processing_outside_list->RowCnt ?>_stock_processing_outside_company_id" class="stock_processing_outside_company_id">
<span<?php echo $stock_processing_outside->company_id->viewAttributes() ?>>
<?php echo $stock_processing_outside->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_processing_outside_list->ListOptions->render("body", "right", $stock_processing_outside_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_processing_outside->isGridAdd())
		$stock_processing_outside_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_processing_outside->RowType = ROWTYPE_AGGREGATE;
$stock_processing_outside->resetAttributes();
$stock_processing_outside_list->renderRow();
?>
<?php if ($stock_processing_outside_list->TotalRecs > 0 && !$stock_processing_outside->isGridAdd() && !$stock_processing_outside->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_processing_outside_list->renderListOptions();

// Render list options (footer, left)
$stock_processing_outside_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_processing_outside->product_n->Visible) { // product_n ?>
		<td data-name="product_n" class="<?php echo $stock_processing_outside->product_n->footerCellClass() ?>"><span id="elf_stock_processing_outside_product_n" class="stock_processing_outside_product_n">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_processing_outside->product_code->footerCellClass() ?>"><span id="elf_stock_processing_outside_product_code" class="stock_processing_outside_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_processing_outside->lot_no->footerCellClass() ?>"><span id="elf_stock_processing_outside_lot_no" class="stock_processing_outside_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->process_type->Visible) { // process_type ?>
		<td data-name="process_type" class="<?php echo $stock_processing_outside->process_type->footerCellClass() ?>"><span id="elf_stock_processing_outside_process_type" class="stock_processing_outside_process_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_processing_outside->tmp_lot->footerCellClass() ?>"><span id="elf_stock_processing_outside_tmp_lot" class="stock_processing_outside_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_processing_outside->packets->footerCellClass() ?>"><span id="elf_stock_processing_outside_packets" class="stock_processing_outside_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_processing_outside->packing_type->footerCellClass() ?>"><span id="elf_stock_processing_outside_packing_type" class="stock_processing_outside_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_processing_outside->godown->footerCellClass() ?>"><span id="elf_stock_processing_outside_godown" class="stock_processing_outside_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->godown_n->Visible) { // godown_n ?>
		<td data-name="godown_n" class="<?php echo $stock_processing_outside->godown_n->footerCellClass() ?>"><span id="elf_stock_processing_outside_godown_n" class="stock_processing_outside_godown_n">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_processing_outside->dated->footerCellClass() ?>"><span id="elf_stock_processing_outside_dated" class="stock_processing_outside_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_processing_outside->IN->footerCellClass() ?>"><span id="elf_stock_processing_outside_IN" class="stock_processing_outside_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_outside->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_processing_outside->OUT->footerCellClass() ?>"><span id="elf_stock_processing_outside_OUT" class="stock_processing_outside_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_outside->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_processing_outside->Balance->footerCellClass() ?>"><span id="elf_stock_processing_outside_Balance" class="stock_processing_outside_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_processing_outside->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_processing_outside->type->footerCellClass() ?>"><span id="elf_stock_processing_outside_type" class="stock_processing_outside_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_processing_outside->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_processing_outside->company_id->footerCellClass() ?>"><span id="elf_stock_processing_outside_company_id" class="stock_processing_outside_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_processing_outside_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_processing_outside->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_processing_outside_list->Recordset)
	$stock_processing_outside_list->Recordset->Close();
?>
<?php if (!$stock_processing_outside->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_processing_outside->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_processing_outside_list->Pager)) $stock_processing_outside_list->Pager = new PrevNextPager($stock_processing_outside_list->StartRec, $stock_processing_outside_list->DisplayRecs, $stock_processing_outside_list->TotalRecs, $stock_processing_outside_list->AutoHidePager) ?>
<?php if ($stock_processing_outside_list->Pager->RecordCount > 0 && $stock_processing_outside_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_processing_outside_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_processing_outside_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_processing_outside_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_processing_outside_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_processing_outside_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_processing_outside_list->pageUrl() ?>start=<?php echo $stock_processing_outside_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_processing_outside_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_processing_outside_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_processing_outside_list->TotalRecs > 0 && (!$stock_processing_outside_list->AutoHidePageSizeSelector || $stock_processing_outside_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_processing_outside">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_processing_outside_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_processing_outside_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_processing_outside_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_processing_outside_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_processing_outside_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_processing_outside->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_processing_outside_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_processing_outside_list->TotalRecs == 0 && !$stock_processing_outside->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_processing_outside_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_processing_outside_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_processing_outside->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_processing_outside->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_processing_outside", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_processing_outside_list->terminate();
?>