<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_processing_outside_search = new stock_processing_outside_search();

// Run the page
$stock_processing_outside_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_processing_outside_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_processing_outside_search->IsModal) { ?>
var fstock_processing_outsidesearch = currentAdvancedSearchForm = new ew.Form("fstock_processing_outsidesearch", "search");
<?php } else { ?>
var fstock_processing_outsidesearch = currentForm = new ew.Form("fstock_processing_outsidesearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_processing_outsidesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processing_outsidesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_processing_outsidesearch.lists["x_product"] = <?php echo $stock_processing_outside_search->product->Lookup->toClientList() ?>;
fstock_processing_outsidesearch.lists["x_product"].options = <?php echo JsonEncode($stock_processing_outside_search->product->lookupOptions()) ?>;
fstock_processing_outsidesearch.lists["x_process_type"] = <?php echo $stock_processing_outside_search->process_type->Lookup->toClientList() ?>;
fstock_processing_outsidesearch.lists["x_process_type"].options = <?php echo JsonEncode($stock_processing_outside_search->process_type->lookupOptions()) ?>;
fstock_processing_outsidesearch.lists["x_packing_type"] = <?php echo $stock_processing_outside_search->packing_type->Lookup->toClientList() ?>;
fstock_processing_outsidesearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_processing_outside_search->packing_type->lookupOptions()) ?>;
fstock_processing_outsidesearch.lists["x_godown"] = <?php echo $stock_processing_outside_search->godown->Lookup->toClientList() ?>;
fstock_processing_outsidesearch.lists["x_godown"].options = <?php echo JsonEncode($stock_processing_outside_search->godown->lookupOptions()) ?>;
fstock_processing_outsidesearch.lists["x_godown_n"] = <?php echo $stock_processing_outside_search->godown_n->Lookup->toClientList() ?>;
fstock_processing_outsidesearch.lists["x_godown_n"].options = <?php echo JsonEncode($stock_processing_outside_search->godown_n->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_processing_outsidesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_processing_outside->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_processing_outside_search->showPageHeader(); ?>
<?php
$stock_processing_outside_search->showMessage();
?>
<form name="fstock_processing_outsidesearch" id="fstock_processing_outsidesearch" class="<?php echo $stock_processing_outside_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_processing_outside_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_processing_outside_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_processing_outside">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_processing_outside_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_processing_outside->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_id"><?php echo $stock_processing_outside->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->id->cellAttributes() ?>>
			<span id="el_stock_processing_outside_id">
<input type="text" data-table="stock_processing_outside" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->id->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->id->EditValue ?>"<?php echo $stock_processing_outside->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product"><?php echo $stock_processing_outside->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->product->cellAttributes() ?>>
			<span id="el_stock_processing_outside_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_product" data-value-separator="<?php echo $stock_processing_outside->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_processing_outside->product->editAttributes() ?>>
		<?php echo $stock_processing_outside->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_processing_outside->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->product_n->Visible) { // product_n ?>
	<div id="r_product_n" class="form-group row">
		<label for="x_product_n" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product_n"><?php echo $stock_processing_outside->product_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_n" id="z_product_n" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->product_n->cellAttributes() ?>>
			<span id="el_stock_processing_outside_product_n">
<input type="text" data-table="stock_processing_outside" data-field="x_product_n" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_outside->product_n->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->product_n->EditValue ?>"<?php echo $stock_processing_outside->product_n->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_rid"><?php echo $stock_processing_outside->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->rid->cellAttributes() ?>>
			<span id="el_stock_processing_outside_rid">
<input type="text" data-table="stock_processing_outside" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->rid->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->rid->EditValue ?>"<?php echo $stock_processing_outside->rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_code"><?php echo $stock_processing_outside->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->code->cellAttributes() ?>>
			<span id="el_stock_processing_outside_code">
<input type="text" data-table="stock_processing_outside" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($stock_processing_outside->code->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->code->EditValue ?>"<?php echo $stock_processing_outside->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_product_code"><?php echo $stock_processing_outside->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->product_code->cellAttributes() ?>>
			<span id="el_stock_processing_outside_product_code">
<input type="text" data-table="stock_processing_outside" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_processing_outside->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->product_code->EditValue ?>"<?php echo $stock_processing_outside->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_lot_no"><?php echo $stock_processing_outside->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->lot_no->cellAttributes() ?>>
			<span id="el_stock_processing_outside_lot_no">
<input type="text" data-table="stock_processing_outside" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_processing_outside->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->lot_no->EditValue ?>"<?php echo $stock_processing_outside->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->process_type->Visible) { // process_type ?>
	<div id="r_process_type" class="form-group row">
		<label for="x_process_type" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_process_type"><?php echo $stock_processing_outside->process_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_type" id="z_process_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->process_type->cellAttributes() ?>>
			<span id="el_stock_processing_outside_process_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_process_type" data-value-separator="<?php echo $stock_processing_outside->process_type->displayValueSeparatorAttribute() ?>" id="x_process_type" name="x_process_type"<?php echo $stock_processing_outside->process_type->editAttributes() ?>>
		<?php echo $stock_processing_outside->process_type->selectOptionListHtml("x_process_type") ?>
	</select>
</div>
<?php echo $stock_processing_outside->process_type->Lookup->getParamTag("p_x_process_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_tmp_lot"><?php echo $stock_processing_outside->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->tmp_lot->cellAttributes() ?>>
			<span id="el_stock_processing_outside_tmp_lot">
<input type="text" data-table="stock_processing_outside" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="44" placeholder="<?php echo HtmlEncode($stock_processing_outside->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->tmp_lot->EditValue ?>"<?php echo $stock_processing_outside->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_packets"><?php echo $stock_processing_outside->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->packets->cellAttributes() ?>>
			<span id="el_stock_processing_outside_packets">
<input type="text" data-table="stock_processing_outside" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->packets->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->packets->EditValue ?>"<?php echo $stock_processing_outside->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_packing_type"><?php echo $stock_processing_outside->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->packing_type->cellAttributes() ?>>
			<span id="el_stock_processing_outside_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_packing_type" data-value-separator="<?php echo $stock_processing_outside->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_processing_outside->packing_type->editAttributes() ?>>
		<?php echo $stock_processing_outside->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_processing_outside->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_godown"><?php echo $stock_processing_outside->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->godown->cellAttributes() ?>>
			<span id="el_stock_processing_outside_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_godown" data-value-separator="<?php echo $stock_processing_outside->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_processing_outside->godown->editAttributes() ?>>
		<?php echo $stock_processing_outside->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_processing_outside->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->godown_n->Visible) { // godown_n ?>
	<div id="r_godown_n" class="form-group row">
		<label for="x_godown_n" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_godown_n"><?php echo $stock_processing_outside->godown_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown_n" id="z_godown_n" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->godown_n->cellAttributes() ?>>
			<span id="el_stock_processing_outside_godown_n">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_processing_outside" data-field="x_godown_n" data-value-separator="<?php echo $stock_processing_outside->godown_n->displayValueSeparatorAttribute() ?>" id="x_godown_n" name="x_godown_n"<?php echo $stock_processing_outside->godown_n->editAttributes() ?>>
		<?php echo $stock_processing_outside->godown_n->selectOptionListHtml("x_godown_n") ?>
	</select>
</div>
<?php echo $stock_processing_outside->godown_n->Lookup->getParamTag("p_x_godown_n") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_dated"><?php echo $stock_processing_outside->dated->caption() ?></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_processing_outside->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_stock_processing_outside_dated">
<input type="text" data-table="stock_processing_outside" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_processing_outside->dated->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->dated->EditValue ?>"<?php echo $stock_processing_outside->dated->editAttributes() ?>>
<?php if (!$stock_processing_outside->dated->ReadOnly && !$stock_processing_outside->dated->Disabled && !isset($stock_processing_outside->dated->EditAttrs["readonly"]) && !isset($stock_processing_outside->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_processing_outsidesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_stock_processing_outside_dated" class="btw1_dated d-none">
<input type="text" data-table="stock_processing_outside" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_processing_outside->dated->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->dated->EditValue2 ?>"<?php echo $stock_processing_outside->dated->editAttributes() ?>>
<?php if (!$stock_processing_outside->dated->ReadOnly && !$stock_processing_outside->dated->Disabled && !isset($stock_processing_outside->dated->EditAttrs["readonly"]) && !isset($stock_processing_outside->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_processing_outsidesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_IN"><?php echo $stock_processing_outside->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->IN->cellAttributes() ?>>
			<span id="el_stock_processing_outside_IN">
<input type="text" data-table="stock_processing_outside" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->IN->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->IN->EditValue ?>"<?php echo $stock_processing_outside->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_OUT"><?php echo $stock_processing_outside->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->OUT->cellAttributes() ?>>
			<span id="el_stock_processing_outside_OUT">
<input type="text" data-table="stock_processing_outside" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->OUT->EditValue ?>"<?php echo $stock_processing_outside->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_Balance"><?php echo $stock_processing_outside->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->Balance->cellAttributes() ?>>
			<span id="el_stock_processing_outside_Balance">
<input type="text" data-table="stock_processing_outside" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->Balance->EditValue ?>"<?php echo $stock_processing_outside->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->Item->Visible) { // Item ?>
	<div id="r_Item" class="form-group row">
		<label for="x_Item" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_Item"><?php echo $stock_processing_outside->Item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Item" id="z_Item" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->Item->cellAttributes() ?>>
			<span id="el_stock_processing_outside_Item">
<input type="text" data-table="stock_processing_outside" data-field="x_Item" name="x_Item" id="x_Item" size="35" placeholder="<?php echo HtmlEncode($stock_processing_outside->Item->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->Item->EditValue ?>"<?php echo $stock_processing_outside->Item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->new_process->Visible) { // new_process ?>
	<div id="r_new_process" class="form-group row">
		<label for="x_new_process" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_new_process"><?php echo $stock_processing_outside->new_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_new_process" id="z_new_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->new_process->cellAttributes() ?>>
			<span id="el_stock_processing_outside_new_process">
<input type="text" data-table="stock_processing_outside" data-field="x_new_process" name="x_new_process" id="x_new_process" size="35" placeholder="<?php echo HtmlEncode($stock_processing_outside->new_process->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->new_process->EditValue ?>"<?php echo $stock_processing_outside->new_process->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_remarks"><?php echo $stock_processing_outside->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->remarks->cellAttributes() ?>>
			<span id="el_stock_processing_outside_remarks">
<input type="text" data-table="stock_processing_outside" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($stock_processing_outside->remarks->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->remarks->EditValue ?>"<?php echo $stock_processing_outside->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_type"><?php echo $stock_processing_outside->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->type->cellAttributes() ?>>
			<span id="el_stock_processing_outside_type">
<input type="text" data-table="stock_processing_outside" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($stock_processing_outside->type->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->type->EditValue ?>"<?php echo $stock_processing_outside->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_processing_outside->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $stock_processing_outside_search->LeftColumnClass ?>"><span id="elh_stock_processing_outside_company_id"><?php echo $stock_processing_outside->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $stock_processing_outside_search->RightColumnClass ?>"><div<?php echo $stock_processing_outside->company_id->cellAttributes() ?>>
			<span id="el_stock_processing_outside_company_id">
<input type="text" data-table="stock_processing_outside" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($stock_processing_outside->company_id->getPlaceHolder()) ?>" value="<?php echo $stock_processing_outside->company_id->EditValue ?>"<?php echo $stock_processing_outside->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_processing_outside_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_processing_outside_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_processing_outside_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_processing_outside_search->terminate();
?>