<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_process_list = new stock_process_list();

// Run the page
$stock_process_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_process_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_process->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_processlist = currentForm = new ew.Form("fstock_processlist", "list");
fstock_processlist.formKeyCountName = '<?php echo $stock_process_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_processlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_processlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fstock_processlistsrch = currentSearchForm = new ew.Form("fstock_processlistsrch");

// Filters
fstock_processlistsrch.filterList = <?php echo $stock_process_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_processlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_process->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_process_list->TotalRecs > 0 && $stock_process_list->ExportOptions->visible()) { ?>
<?php $stock_process_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_list->ImportOptions->visible()) { ?>
<?php $stock_process_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_list->SearchOptions->visible()) { ?>
<?php $stock_process_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_process_list->FilterOptions->visible()) { ?>
<?php $stock_process_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_process_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_process->isExport() && !$stock_process->CurrentAction) { ?>
<form name="fstock_processlistsrch" id="fstock_processlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_process_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_processlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_process">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_process_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_process_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_process_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_process_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_process_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_process_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_process_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_process_list->showPageHeader(); ?>
<?php
$stock_process_list->showMessage();
?>
<?php if ($stock_process_list->TotalRecs > 0 || $stock_process->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_process_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_process">
<?php if (!$stock_process->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_process_list->Pager)) $stock_process_list->Pager = new PrevNextPager($stock_process_list->StartRec, $stock_process_list->DisplayRecs, $stock_process_list->TotalRecs, $stock_process_list->AutoHidePager) ?>
<?php if ($stock_process_list->Pager->RecordCount > 0 && $stock_process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_process_list->TotalRecs > 0 && (!$stock_process_list->AutoHidePageSizeSelector || $stock_process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_processlist" id="fstock_processlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_process_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_process_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_process">
<div id="gmp_stock_process" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_process_list->TotalRecs > 0 || $stock_process->isGridEdit()) { ?>
<table id="tbl_stock_processlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_process_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_process_list->renderListOptions();

// Render list options (header, left)
$stock_process_list->ListOptions->render("header", "left");
?>
<?php if ($stock_process->grp->Visible) { // grp ?>
	<?php if ($stock_process->sortUrl($stock_process->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $stock_process->grp->headerCellClass() ?>"><div id="elh_stock_process_grp" class="stock_process_grp"><div class="ew-table-header-caption"><?php echo $stock_process->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $stock_process->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->grp) ?>',2);"><div id="elh_stock_process_grp" class="stock_process_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->s_grp->Visible) { // s_grp ?>
	<?php if ($stock_process->sortUrl($stock_process->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $stock_process->s_grp->headerCellClass() ?>"><div id="elh_stock_process_s_grp" class="stock_process_s_grp"><div class="ew-table-header-caption"><?php echo $stock_process->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $stock_process->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->s_grp) ?>',2);"><div id="elh_stock_process_s_grp" class="stock_process_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->product->Visible) { // product ?>
	<?php if ($stock_process->sortUrl($stock_process->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_process->product->headerCellClass() ?>"><div id="elh_stock_process_product" class="stock_process_product"><div class="ew-table-header-caption"><?php echo $stock_process->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_process->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->product) ?>',2);"><div id="elh_stock_process_product" class="stock_process_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->rid->Visible) { // rid ?>
	<?php if ($stock_process->sortUrl($stock_process->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_process->rid->headerCellClass() ?>"><div id="elh_stock_process_rid" class="stock_process_rid"><div class="ew-table-header-caption"><?php echo $stock_process->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_process->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->rid) ?>',2);"><div id="elh_stock_process_rid" class="stock_process_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->code->Visible) { // code ?>
	<?php if ($stock_process->sortUrl($stock_process->code) == "") { ?>
		<th data-name="code" class="<?php echo $stock_process->code->headerCellClass() ?>"><div id="elh_stock_process_code" class="stock_process_code"><div class="ew-table-header-caption"><?php echo $stock_process->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $stock_process->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->code) ?>',2);"><div id="elh_stock_process_code" class="stock_process_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->product_code->Visible) { // product_code ?>
	<?php if ($stock_process->sortUrl($stock_process->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_process->product_code->headerCellClass() ?>"><div id="elh_stock_process_product_code" class="stock_process_product_code"><div class="ew-table-header-caption"><?php echo $stock_process->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_process->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->product_code) ?>',2);"><div id="elh_stock_process_product_code" class="stock_process_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->godown->Visible) { // godown ?>
	<?php if ($stock_process->sortUrl($stock_process->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_process->godown->headerCellClass() ?>"><div id="elh_stock_process_godown" class="stock_process_godown"><div class="ew-table-header-caption"><?php echo $stock_process->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_process->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->godown) ?>',2);"><div id="elh_stock_process_godown" class="stock_process_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->IN->Visible) { // IN ?>
	<?php if ($stock_process->sortUrl($stock_process->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_process->IN->headerCellClass() ?>"><div id="elh_stock_process_IN" class="stock_process_IN"><div class="ew-table-header-caption"><?php echo $stock_process->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_process->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->IN) ?>',2);"><div id="elh_stock_process_IN" class="stock_process_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->OUT->Visible) { // OUT ?>
	<?php if ($stock_process->sortUrl($stock_process->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_process->OUT->headerCellClass() ?>"><div id="elh_stock_process_OUT" class="stock_process_OUT"><div class="ew-table-header-caption"><?php echo $stock_process->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_process->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->OUT) ?>',2);"><div id="elh_stock_process_OUT" class="stock_process_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->packets->Visible) { // packets ?>
	<?php if ($stock_process->sortUrl($stock_process->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_process->packets->headerCellClass() ?>"><div id="elh_stock_process_packets" class="stock_process_packets"><div class="ew-table-header-caption"><?php echo $stock_process->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_process->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->packets) ?>',2);"><div id="elh_stock_process_packets" class="stock_process_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_process->sortUrl($stock_process->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_process->packing_type->headerCellClass() ?>"><div id="elh_stock_process_packing_type" class="stock_process_packing_type"><div class="ew-table-header-caption"><?php echo $stock_process->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_process->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->packing_type) ?>',2);"><div id="elh_stock_process_packing_type" class="stock_process_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_process->sortUrl($stock_process->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_process->lot_no->headerCellClass() ?>"><div id="elh_stock_process_lot_no" class="stock_process_lot_no"><div class="ew-table-header-caption"><?php echo $stock_process->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_process->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->lot_no) ?>',2);"><div id="elh_stock_process_lot_no" class="stock_process_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_process->sortUrl($stock_process->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_process->tmp_lot->headerCellClass() ?>"><div id="elh_stock_process_tmp_lot" class="stock_process_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_process->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_process->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->tmp_lot) ?>',2);"><div id="elh_stock_process_tmp_lot" class="stock_process_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->url->Visible) { // url ?>
	<?php if ($stock_process->sortUrl($stock_process->url) == "") { ?>
		<th data-name="url" class="<?php echo $stock_process->url->headerCellClass() ?>"><div id="elh_stock_process_url" class="stock_process_url"><div class="ew-table-header-caption"><?php echo $stock_process->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $stock_process->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->url) ?>',2);"><div id="elh_stock_process_url" class="stock_process_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->age->Visible) { // age ?>
	<?php if ($stock_process->sortUrl($stock_process->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_process->age->headerCellClass() ?>"><div id="elh_stock_process_age" class="stock_process_age"><div class="ew-table-header-caption"><?php echo $stock_process->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_process->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->age) ?>',2);"><div id="elh_stock_process_age" class="stock_process_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->dated->Visible) { // dated ?>
	<?php if ($stock_process->sortUrl($stock_process->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_process->dated->headerCellClass() ?>"><div id="elh_stock_process_dated" class="stock_process_dated"><div class="ew-table-header-caption"><?php echo $stock_process->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_process->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->dated) ?>',2);"><div id="elh_stock_process_dated" class="stock_process_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->type->Visible) { // type ?>
	<?php if ($stock_process->sortUrl($stock_process->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_process->type->headerCellClass() ?>"><div id="elh_stock_process_type" class="stock_process_type"><div class="ew-table-header-caption"><?php echo $stock_process->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_process->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->type) ?>',2);"><div id="elh_stock_process_type" class="stock_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_process->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_process->company_id->Visible) { // company_id ?>
	<?php if ($stock_process->sortUrl($stock_process->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_process->company_id->headerCellClass() ?>"><div id="elh_stock_process_company_id" class="stock_process_company_id"><div class="ew-table-header-caption"><?php echo $stock_process->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_process->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_process->SortUrl($stock_process->company_id) ?>',2);"><div id="elh_stock_process_company_id" class="stock_process_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_process->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_process->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_process->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_process_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_process->ExportAll && $stock_process->isExport()) {
	$stock_process_list->StopRec = $stock_process_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_process_list->TotalRecs > $stock_process_list->StartRec + $stock_process_list->DisplayRecs - 1)
		$stock_process_list->StopRec = $stock_process_list->StartRec + $stock_process_list->DisplayRecs - 1;
	else
		$stock_process_list->StopRec = $stock_process_list->TotalRecs;
}
$stock_process_list->RecCnt = $stock_process_list->StartRec - 1;
if ($stock_process_list->Recordset && !$stock_process_list->Recordset->EOF) {
	$stock_process_list->Recordset->moveFirst();
	$selectLimit = $stock_process_list->UseSelectLimit;
	if (!$selectLimit && $stock_process_list->StartRec > 1)
		$stock_process_list->Recordset->move($stock_process_list->StartRec - 1);
} elseif (!$stock_process->AllowAddDeleteRow && $stock_process_list->StopRec == 0) {
	$stock_process_list->StopRec = $stock_process->GridAddRowCount;
}

// Initialize aggregate
$stock_process->RowType = ROWTYPE_AGGREGATEINIT;
$stock_process->resetAttributes();
$stock_process_list->renderRow();
while ($stock_process_list->RecCnt < $stock_process_list->StopRec) {
	$stock_process_list->RecCnt++;
	if ($stock_process_list->RecCnt >= $stock_process_list->StartRec) {
		$stock_process_list->RowCnt++;

		// Set up key count
		$stock_process_list->KeyCount = $stock_process_list->RowIndex;

		// Init row class and style
		$stock_process->resetAttributes();
		$stock_process->CssClass = "";
		if ($stock_process->isGridAdd()) {
		} else {
			$stock_process_list->loadRowValues($stock_process_list->Recordset); // Load row values
		}
		$stock_process->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_process->RowAttrs = array_merge($stock_process->RowAttrs, array('data-rowindex'=>$stock_process_list->RowCnt, 'id'=>'r' . $stock_process_list->RowCnt . '_stock_process', 'data-rowtype'=>$stock_process->RowType));

		// Render row
		$stock_process_list->renderRow();

		// Render list options
		$stock_process_list->renderListOptions();
?>
	<tr<?php echo $stock_process->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_process_list->ListOptions->render("body", "left", $stock_process_list->RowCnt);
?>
	<?php if ($stock_process->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $stock_process->grp->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_grp" class="stock_process_grp">
<span<?php echo $stock_process->grp->viewAttributes() ?>>
<?php echo $stock_process->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $stock_process->s_grp->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_s_grp" class="stock_process_s_grp">
<span<?php echo $stock_process->s_grp->viewAttributes() ?>>
<?php echo $stock_process->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_process->product->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_product" class="stock_process_product">
<span<?php echo $stock_process->product->viewAttributes() ?>>
<?php echo $stock_process->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_process->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_rid" class="stock_process_rid">
<span<?php echo $stock_process->rid->viewAttributes() ?>>
<?php echo $stock_process->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->code->Visible) { // code ?>
		<td data-name="code"<?php echo $stock_process->code->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_code" class="stock_process_code">
<span<?php echo $stock_process->code->viewAttributes() ?>>
<?php echo $stock_process->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_process->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_product_code" class="stock_process_product_code">
<span<?php echo $stock_process->product_code->viewAttributes() ?>>
<?php echo $stock_process->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_process->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_godown" class="stock_process_godown">
<span<?php echo $stock_process->godown->viewAttributes() ?>>
<?php echo $stock_process->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_process->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_IN" class="stock_process_IN">
<span<?php echo $stock_process->IN->viewAttributes() ?>>
<?php echo $stock_process->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_process->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_OUT" class="stock_process_OUT">
<span<?php echo $stock_process->OUT->viewAttributes() ?>>
<?php echo $stock_process->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_process->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_packets" class="stock_process_packets">
<span<?php echo $stock_process->packets->viewAttributes() ?>>
<?php echo $stock_process->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_process->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_packing_type" class="stock_process_packing_type">
<span<?php echo $stock_process->packing_type->viewAttributes() ?>>
<?php echo $stock_process->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_process->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_lot_no" class="stock_process_lot_no">
<span<?php echo $stock_process->lot_no->viewAttributes() ?>>
<?php echo $stock_process->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_process->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_tmp_lot" class="stock_process_tmp_lot">
<span<?php echo $stock_process->tmp_lot->viewAttributes() ?>>
<?php echo $stock_process->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->url->Visible) { // url ?>
		<td data-name="url"<?php echo $stock_process->url->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_url" class="stock_process_url">
<span<?php echo $stock_process->url->viewAttributes() ?>>
<?php echo $stock_process->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_process->age->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_age" class="stock_process_age">
<span<?php echo $stock_process->age->viewAttributes() ?>>
<?php echo $stock_process->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_process->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_dated" class="stock_process_dated">
<span<?php echo $stock_process->dated->viewAttributes() ?>>
<?php echo $stock_process->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_process->type->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_type" class="stock_process_type">
<span<?php echo $stock_process->type->viewAttributes() ?>>
<?php echo $stock_process->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_process->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_process->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_process_list->RowCnt ?>_stock_process_company_id" class="stock_process_company_id">
<span<?php echo $stock_process->company_id->viewAttributes() ?>>
<?php echo $stock_process->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_process_list->ListOptions->render("body", "right", $stock_process_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_process->isGridAdd())
		$stock_process_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_process->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_process_list->Recordset)
	$stock_process_list->Recordset->Close();
?>
<?php if (!$stock_process->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_process->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_process_list->Pager)) $stock_process_list->Pager = new PrevNextPager($stock_process_list->StartRec, $stock_process_list->DisplayRecs, $stock_process_list->TotalRecs, $stock_process_list->AutoHidePager) ?>
<?php if ($stock_process_list->Pager->RecordCount > 0 && $stock_process_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_process_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_process_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_process_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_process_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_process_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_process_list->pageUrl() ?>start=<?php echo $stock_process_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_process_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_process_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_process_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_process_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_process_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_process_list->TotalRecs > 0 && (!$stock_process_list->AutoHidePageSizeSelector || $stock_process_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_process">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_process_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_process_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_process_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_process_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_process_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_process->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_process_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_process_list->TotalRecs == 0 && !$stock_process->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_process_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_process_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_process->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_process->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_process", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_process_list->terminate();
?>