<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_purchase_l_list = new stock_purchase_l_list();

// Run the page
$stock_purchase_l_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_purchase_l_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_purchase_l->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_purchase_llist = currentForm = new ew.Form("fstock_purchase_llist", "list");
fstock_purchase_llist.formKeyCountName = '<?php echo $stock_purchase_l_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_purchase_llist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_purchase_llist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_purchase_llist.lists["x_product"] = <?php echo $stock_purchase_l_list->product->Lookup->toClientList() ?>;
fstock_purchase_llist.lists["x_product"].options = <?php echo JsonEncode($stock_purchase_l_list->product->lookupOptions()) ?>;
fstock_purchase_llist.lists["x_godown"] = <?php echo $stock_purchase_l_list->godown->Lookup->toClientList() ?>;
fstock_purchase_llist.lists["x_godown"].options = <?php echo JsonEncode($stock_purchase_l_list->godown->lookupOptions()) ?>;
fstock_purchase_llist.lists["x_packing_type"] = <?php echo $stock_purchase_l_list->packing_type->Lookup->toClientList() ?>;
fstock_purchase_llist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_purchase_l_list->packing_type->lookupOptions()) ?>;
fstock_purchase_llist.lists["x_supplier"] = <?php echo $stock_purchase_l_list->supplier->Lookup->toClientList() ?>;
fstock_purchase_llist.lists["x_supplier"].options = <?php echo JsonEncode($stock_purchase_l_list->supplier->lookupOptions()) ?>;
fstock_purchase_llist.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fstock_purchase_llistsrch = currentSearchForm = new ew.Form("fstock_purchase_llistsrch");

// Filters
fstock_purchase_llistsrch.filterList = <?php echo $stock_purchase_l_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_purchase_llistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_purchase_l->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_purchase_l_list->TotalRecs > 0 && $stock_purchase_l_list->ExportOptions->visible()) { ?>
<?php $stock_purchase_l_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_purchase_l_list->ImportOptions->visible()) { ?>
<?php $stock_purchase_l_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_purchase_l_list->SearchOptions->visible()) { ?>
<?php $stock_purchase_l_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_purchase_l_list->FilterOptions->visible()) { ?>
<?php $stock_purchase_l_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_purchase_l_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_purchase_l->isExport() && !$stock_purchase_l->CurrentAction) { ?>
<form name="fstock_purchase_llistsrch" id="fstock_purchase_llistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_purchase_l_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_purchase_llistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_purchase_l">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_purchase_l_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_purchase_l_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_purchase_l_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_purchase_l_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_purchase_l_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_purchase_l_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_purchase_l_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_purchase_l_list->showPageHeader(); ?>
<?php
$stock_purchase_l_list->showMessage();
?>
<?php if ($stock_purchase_l_list->TotalRecs > 0 || $stock_purchase_l->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_purchase_l_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_purchase_l">
<?php if (!$stock_purchase_l->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_purchase_l->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_purchase_l_list->Pager)) $stock_purchase_l_list->Pager = new PrevNextPager($stock_purchase_l_list->StartRec, $stock_purchase_l_list->DisplayRecs, $stock_purchase_l_list->TotalRecs, $stock_purchase_l_list->AutoHidePager) ?>
<?php if ($stock_purchase_l_list->Pager->RecordCount > 0 && $stock_purchase_l_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_purchase_l_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_purchase_l_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_purchase_l_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_purchase_l_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_purchase_l_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_purchase_l_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_purchase_l_list->TotalRecs > 0 && (!$stock_purchase_l_list->AutoHidePageSizeSelector || $stock_purchase_l_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_purchase_l">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_purchase_l_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_purchase_l_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_purchase_l_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_purchase_l_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_purchase_l_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_purchase_l->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_purchase_l_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_purchase_llist" id="fstock_purchase_llist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_purchase_l_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_purchase_l_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_purchase_l">
<div id="gmp_stock_purchase_l" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_purchase_l_list->TotalRecs > 0 || $stock_purchase_l->isGridEdit()) { ?>
<table id="tbl_stock_purchase_llist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_purchase_l_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_purchase_l_list->renderListOptions();

// Render list options (header, left)
$stock_purchase_l_list->ListOptions->render("header", "left");
?>
<?php if ($stock_purchase_l->product->Visible) { // product ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_purchase_l->product->headerCellClass() ?>"><div id="elh_stock_purchase_l_product" class="stock_purchase_l_product"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_purchase_l->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->product) ?>',2);"><div id="elh_stock_purchase_l_product" class="stock_purchase_l_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->product_code->Visible) { // product_code ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_purchase_l->product_code->headerCellClass() ?>"><div id="elh_stock_purchase_l_product_code" class="stock_purchase_l_product_code"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_purchase_l->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->product_code) ?>',2);"><div id="elh_stock_purchase_l_product_code" class="stock_purchase_l_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->godown->Visible) { // godown ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_purchase_l->godown->headerCellClass() ?>"><div id="elh_stock_purchase_l_godown" class="stock_purchase_l_godown"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_purchase_l->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->godown) ?>',2);"><div id="elh_stock_purchase_l_godown" class="stock_purchase_l_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->IN->Visible) { // IN ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_purchase_l->IN->headerCellClass() ?>"><div id="elh_stock_purchase_l_IN" class="stock_purchase_l_IN"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_purchase_l->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->IN) ?>',2);"><div id="elh_stock_purchase_l_IN" class="stock_purchase_l_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->packets->Visible) { // packets ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_purchase_l->packets->headerCellClass() ?>"><div id="elh_stock_purchase_l_packets" class="stock_purchase_l_packets"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_purchase_l->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->packets) ?>',2);"><div id="elh_stock_purchase_l_packets" class="stock_purchase_l_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_purchase_l->packing_type->headerCellClass() ?>"><div id="elh_stock_purchase_l_packing_type" class="stock_purchase_l_packing_type"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_purchase_l->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->packing_type) ?>',2);"><div id="elh_stock_purchase_l_packing_type" class="stock_purchase_l_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_purchase_l->lot_no->headerCellClass() ?>"><div id="elh_stock_purchase_l_lot_no" class="stock_purchase_l_lot_no"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_purchase_l->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->lot_no) ?>',2);"><div id="elh_stock_purchase_l_lot_no" class="stock_purchase_l_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->supplier->Visible) { // supplier ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->supplier) == "") { ?>
		<th data-name="supplier" class="<?php echo $stock_purchase_l->supplier->headerCellClass() ?>"><div id="elh_stock_purchase_l_supplier" class="stock_purchase_l_supplier"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->supplier->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="supplier" class="<?php echo $stock_purchase_l->supplier->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->supplier) ?>',2);"><div id="elh_stock_purchase_l_supplier" class="stock_purchase_l_supplier">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->supplier->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->supplier->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->supplier->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->age->Visible) { // age ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_purchase_l->age->headerCellClass() ?>"><div id="elh_stock_purchase_l_age" class="stock_purchase_l_age"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_purchase_l->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->age) ?>',2);"><div id="elh_stock_purchase_l_age" class="stock_purchase_l_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->dated->Visible) { // dated ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_purchase_l->dated->headerCellClass() ?>"><div id="elh_stock_purchase_l_dated" class="stock_purchase_l_dated"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_purchase_l->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->dated) ?>',2);"><div id="elh_stock_purchase_l_dated" class="stock_purchase_l_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->type->Visible) { // type ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_purchase_l->type->headerCellClass() ?>"><div id="elh_stock_purchase_l_type" class="stock_purchase_l_type"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_purchase_l->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->type) ?>',2);"><div id="elh_stock_purchase_l_type" class="stock_purchase_l_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_purchase_l->company_id->Visible) { // company_id ?>
	<?php if ($stock_purchase_l->sortUrl($stock_purchase_l->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_purchase_l->company_id->headerCellClass() ?>"><div id="elh_stock_purchase_l_company_id" class="stock_purchase_l_company_id"><div class="ew-table-header-caption"><?php echo $stock_purchase_l->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_purchase_l->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_purchase_l->SortUrl($stock_purchase_l->company_id) ?>',2);"><div id="elh_stock_purchase_l_company_id" class="stock_purchase_l_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_purchase_l->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_purchase_l->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_purchase_l->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_purchase_l_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_purchase_l->ExportAll && $stock_purchase_l->isExport()) {
	$stock_purchase_l_list->StopRec = $stock_purchase_l_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_purchase_l_list->TotalRecs > $stock_purchase_l_list->StartRec + $stock_purchase_l_list->DisplayRecs - 1)
		$stock_purchase_l_list->StopRec = $stock_purchase_l_list->StartRec + $stock_purchase_l_list->DisplayRecs - 1;
	else
		$stock_purchase_l_list->StopRec = $stock_purchase_l_list->TotalRecs;
}
$stock_purchase_l_list->RecCnt = $stock_purchase_l_list->StartRec - 1;
if ($stock_purchase_l_list->Recordset && !$stock_purchase_l_list->Recordset->EOF) {
	$stock_purchase_l_list->Recordset->moveFirst();
	$selectLimit = $stock_purchase_l_list->UseSelectLimit;
	if (!$selectLimit && $stock_purchase_l_list->StartRec > 1)
		$stock_purchase_l_list->Recordset->move($stock_purchase_l_list->StartRec - 1);
} elseif (!$stock_purchase_l->AllowAddDeleteRow && $stock_purchase_l_list->StopRec == 0) {
	$stock_purchase_l_list->StopRec = $stock_purchase_l->GridAddRowCount;
}

// Initialize aggregate
$stock_purchase_l->RowType = ROWTYPE_AGGREGATEINIT;
$stock_purchase_l->resetAttributes();
$stock_purchase_l_list->renderRow();
while ($stock_purchase_l_list->RecCnt < $stock_purchase_l_list->StopRec) {
	$stock_purchase_l_list->RecCnt++;
	if ($stock_purchase_l_list->RecCnt >= $stock_purchase_l_list->StartRec) {
		$stock_purchase_l_list->RowCnt++;

		// Set up key count
		$stock_purchase_l_list->KeyCount = $stock_purchase_l_list->RowIndex;

		// Init row class and style
		$stock_purchase_l->resetAttributes();
		$stock_purchase_l->CssClass = "";
		if ($stock_purchase_l->isGridAdd()) {
		} else {
			$stock_purchase_l_list->loadRowValues($stock_purchase_l_list->Recordset); // Load row values
		}
		$stock_purchase_l->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_purchase_l->RowAttrs = array_merge($stock_purchase_l->RowAttrs, array('data-rowindex'=>$stock_purchase_l_list->RowCnt, 'id'=>'r' . $stock_purchase_l_list->RowCnt . '_stock_purchase_l', 'data-rowtype'=>$stock_purchase_l->RowType));

		// Render row
		$stock_purchase_l_list->renderRow();

		// Render list options
		$stock_purchase_l_list->renderListOptions();
?>
	<tr<?php echo $stock_purchase_l->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_purchase_l_list->ListOptions->render("body", "left", $stock_purchase_l_list->RowCnt);
?>
	<?php if ($stock_purchase_l->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_purchase_l->product->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_product" class="stock_purchase_l_product">
<span<?php echo $stock_purchase_l->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->product->getViewValue())) && $stock_purchase_l->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->product->linkAttributes() ?>><?php echo $stock_purchase_l->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_purchase_l->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_product_code" class="stock_purchase_l_product_code">
<span<?php echo $stock_purchase_l->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->product_code->getViewValue())) && $stock_purchase_l->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->product_code->linkAttributes() ?>><?php echo $stock_purchase_l->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_purchase_l->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_godown" class="stock_purchase_l_godown">
<span<?php echo $stock_purchase_l->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->godown->getViewValue())) && $stock_purchase_l->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->godown->linkAttributes() ?>><?php echo $stock_purchase_l->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_purchase_l->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_IN" class="stock_purchase_l_IN">
<span<?php echo $stock_purchase_l->IN->viewAttributes() ?>>
<?php echo $stock_purchase_l->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_purchase_l->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_packets" class="stock_purchase_l_packets">
<span<?php echo $stock_purchase_l->packets->viewAttributes() ?>>
<?php echo $stock_purchase_l->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_purchase_l->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_packing_type" class="stock_purchase_l_packing_type">
<span<?php echo $stock_purchase_l->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->packing_type->getViewValue())) && $stock_purchase_l->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->packing_type->linkAttributes() ?>><?php echo $stock_purchase_l->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_purchase_l->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_lot_no" class="stock_purchase_l_lot_no">
<span<?php echo $stock_purchase_l->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->lot_no->getViewValue())) && $stock_purchase_l->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->lot_no->linkAttributes() ?>><?php echo $stock_purchase_l->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->supplier->Visible) { // supplier ?>
		<td data-name="supplier"<?php echo $stock_purchase_l->supplier->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_supplier" class="stock_purchase_l_supplier">
<span<?php echo $stock_purchase_l->supplier->viewAttributes() ?>>
<?php if ((!EmptyString($stock_purchase_l->supplier->getViewValue())) && $stock_purchase_l->supplier->linkAttributes() <> "") { ?>
<a<?php echo $stock_purchase_l->supplier->linkAttributes() ?>><?php echo $stock_purchase_l->supplier->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_purchase_l->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_purchase_l->age->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_age" class="stock_purchase_l_age">
<span<?php echo $stock_purchase_l->age->viewAttributes() ?>>
<?php echo $stock_purchase_l->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_purchase_l->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_dated" class="stock_purchase_l_dated">
<span<?php echo $stock_purchase_l->dated->viewAttributes() ?>>
<?php echo $stock_purchase_l->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_purchase_l->type->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_type" class="stock_purchase_l_type">
<span<?php echo $stock_purchase_l->type->viewAttributes() ?>>
<?php echo $stock_purchase_l->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_purchase_l->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_purchase_l->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_purchase_l_list->RowCnt ?>_stock_purchase_l_company_id" class="stock_purchase_l_company_id">
<span<?php echo $stock_purchase_l->company_id->viewAttributes() ?>>
<?php echo $stock_purchase_l->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_purchase_l_list->ListOptions->render("body", "right", $stock_purchase_l_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_purchase_l->isGridAdd())
		$stock_purchase_l_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_purchase_l->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_purchase_l_list->Recordset)
	$stock_purchase_l_list->Recordset->Close();
?>
<?php if (!$stock_purchase_l->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_purchase_l->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_purchase_l_list->Pager)) $stock_purchase_l_list->Pager = new PrevNextPager($stock_purchase_l_list->StartRec, $stock_purchase_l_list->DisplayRecs, $stock_purchase_l_list->TotalRecs, $stock_purchase_l_list->AutoHidePager) ?>
<?php if ($stock_purchase_l_list->Pager->RecordCount > 0 && $stock_purchase_l_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_purchase_l_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_purchase_l_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_purchase_l_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_purchase_l_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_purchase_l_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_purchase_l_list->pageUrl() ?>start=<?php echo $stock_purchase_l_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_purchase_l_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_purchase_l_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_purchase_l_list->TotalRecs > 0 && (!$stock_purchase_l_list->AutoHidePageSizeSelector || $stock_purchase_l_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_purchase_l">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_purchase_l_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_purchase_l_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_purchase_l_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_purchase_l_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_purchase_l_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_purchase_l->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_purchase_l_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_purchase_l_list->TotalRecs == 0 && !$stock_purchase_l->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_purchase_l_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_purchase_l_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_purchase_l->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_purchase_l->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_purchase_l", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_purchase_l_list->terminate();
?>