<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_purchase_l_search = new stock_purchase_l_search();

// Run the page
$stock_purchase_l_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_purchase_l_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_purchase_l_search->IsModal) { ?>
var fstock_purchase_lsearch = currentAdvancedSearchForm = new ew.Form("fstock_purchase_lsearch", "search");
<?php } else { ?>
var fstock_purchase_lsearch = currentForm = new ew.Form("fstock_purchase_lsearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_purchase_lsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_purchase_lsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_purchase_lsearch.lists["x_product"] = <?php echo $stock_purchase_l_search->product->Lookup->toClientList() ?>;
fstock_purchase_lsearch.lists["x_product"].options = <?php echo JsonEncode($stock_purchase_l_search->product->lookupOptions()) ?>;
fstock_purchase_lsearch.lists["x_godown"] = <?php echo $stock_purchase_l_search->godown->Lookup->toClientList() ?>;
fstock_purchase_lsearch.lists["x_godown"].options = <?php echo JsonEncode($stock_purchase_l_search->godown->lookupOptions()) ?>;
fstock_purchase_lsearch.lists["x_packing_type"] = <?php echo $stock_purchase_l_search->packing_type->Lookup->toClientList() ?>;
fstock_purchase_lsearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_purchase_l_search->packing_type->lookupOptions()) ?>;
fstock_purchase_lsearch.lists["x_supplier"] = <?php echo $stock_purchase_l_search->supplier->Lookup->toClientList() ?>;
fstock_purchase_lsearch.lists["x_supplier"].options = <?php echo JsonEncode($stock_purchase_l_search->supplier->lookupOptions()) ?>;
fstock_purchase_lsearch.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fstock_purchase_lsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lot_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->lot_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->supplier->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->age->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_purchase_l->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_purchase_l_search->showPageHeader(); ?>
<?php
$stock_purchase_l_search->showMessage();
?>
<form name="fstock_purchase_lsearch" id="fstock_purchase_lsearch" class="<?php echo $stock_purchase_l_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_purchase_l_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_purchase_l_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_purchase_l">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_purchase_l_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_purchase_l->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_product"><?php echo $stock_purchase_l->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->product->cellAttributes() ?>>
			<span id="el_stock_purchase_l_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_purchase_l" data-field="x_product" data-value-separator="<?php echo $stock_purchase_l->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_purchase_l->product->editAttributes() ?>>
		<?php echo $stock_purchase_l->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_purchase_l->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_product_code"><?php echo $stock_purchase_l->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->product_code->cellAttributes() ?>>
			<span id="el_stock_purchase_l_product_code">
<input type="text" data-table="stock_purchase_l" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($stock_purchase_l->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->product_code->EditValue ?>"<?php echo $stock_purchase_l->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_godown"><?php echo $stock_purchase_l->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->godown->cellAttributes() ?>>
			<span id="el_stock_purchase_l_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_purchase_l" data-field="x_godown" data-value-separator="<?php echo $stock_purchase_l->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_purchase_l->godown->editAttributes() ?>>
		<?php echo $stock_purchase_l->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_purchase_l->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_IN"><?php echo $stock_purchase_l->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->IN->cellAttributes() ?>>
			<span id="el_stock_purchase_l_IN">
<input type="text" data-table="stock_purchase_l" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->IN->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->IN->EditValue ?>"<?php echo $stock_purchase_l->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_packets"><?php echo $stock_purchase_l->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->packets->cellAttributes() ?>>
			<span id="el_stock_purchase_l_packets">
<input type="text" data-table="stock_purchase_l" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->packets->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->packets->EditValue ?>"<?php echo $stock_purchase_l->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_packing_type"><?php echo $stock_purchase_l->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->packing_type->cellAttributes() ?>>
			<span id="el_stock_purchase_l_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_purchase_l" data-field="x_packing_type" data-value-separator="<?php echo $stock_purchase_l->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_purchase_l->packing_type->editAttributes() ?>>
		<?php echo $stock_purchase_l->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_purchase_l->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_lot_no"><?php echo $stock_purchase_l->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->lot_no->cellAttributes() ?>>
			<span id="el_stock_purchase_l_lot_no">
<input type="text" data-table="stock_purchase_l" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->lot_no->EditValue ?>"<?php echo $stock_purchase_l->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_supplier"><?php echo $stock_purchase_l->supplier->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->supplier->cellAttributes() ?>>
			<span id="el_stock_purchase_l_supplier">
<?php
$wrkonchange = "" . trim(@$stock_purchase_l->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$stock_purchase_l->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8900">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($stock_purchase_l->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($stock_purchase_l->supplier->getPlaceHolder()) ?>"<?php echo $stock_purchase_l->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock_purchase_l" data-field="x_supplier" data-value-separator="<?php echo $stock_purchase_l->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($stock_purchase_l->supplier->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fstock_purchase_lsearch.createAutoSuggest({"id":"x_supplier","forceSelect":false});
</script>
<?php echo $stock_purchase_l->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_age"><?php echo $stock_purchase_l->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->age->cellAttributes() ?>>
			<span id="el_stock_purchase_l_age">
<input type="text" data-table="stock_purchase_l" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->age->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->age->EditValue ?>"<?php echo $stock_purchase_l->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_dated"><?php echo $stock_purchase_l->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->dated->cellAttributes() ?>>
			<span id="el_stock_purchase_l_dated">
<input type="text" data-table="stock_purchase_l" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_purchase_l->dated->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->dated->EditValue ?>"<?php echo $stock_purchase_l->dated->editAttributes() ?>>
<?php if (!$stock_purchase_l->dated->ReadOnly && !$stock_purchase_l->dated->Disabled && !isset($stock_purchase_l->dated->EditAttrs["readonly"]) && !isset($stock_purchase_l->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_purchase_lsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_type"><?php echo $stock_purchase_l->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->type->cellAttributes() ?>>
			<span id="el_stock_purchase_l_type">
<input type="text" data-table="stock_purchase_l" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($stock_purchase_l->type->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->type->EditValue ?>"<?php echo $stock_purchase_l->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_purchase_l->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $stock_purchase_l_search->LeftColumnClass ?>"><span id="elh_stock_purchase_l_company_id"><?php echo $stock_purchase_l->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $stock_purchase_l_search->RightColumnClass ?>"><div<?php echo $stock_purchase_l->company_id->cellAttributes() ?>>
			<span id="el_stock_purchase_l_company_id">
<input type="text" data-table="stock_purchase_l" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($stock_purchase_l->company_id->getPlaceHolder()) ?>" value="<?php echo $stock_purchase_l->company_id->EditValue ?>"<?php echo $stock_purchase_l->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_purchase_l_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_purchase_l_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_purchase_l_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_purchase_l_search->terminate();
?>