<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_setup_edit = new stock_setup_edit();

// Run the page
$stock_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fstock_setupedit = currentForm = new ew.Form("fstock_setupedit", "edit");

// Validate form
fstock_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($stock_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->id->caption(), $stock_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_setup->id->errorMessage()) ?>");
		<?php if ($stock_setup_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->rid->caption(), $stock_setup->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_setup_edit->date_from->Required) { ?>
			elm = this.getElements("x" + infix + "_date_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->date_from->caption(), $stock_setup->date_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_from");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_setup->date_from->errorMessage()) ?>");
		<?php if ($stock_setup_edit->date_to->Required) { ?>
			elm = this.getElements("x" + infix + "_date_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->date_to->caption(), $stock_setup->date_to->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_to");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock_setup->date_to->errorMessage()) ?>");
		<?php if ($stock_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->operator->caption(), $stock_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_setup->datetime->caption(), $stock_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstock_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_setupedit.lists["x_rid"] = <?php echo $stock_setup_edit->rid->Lookup->toClientList() ?>;
fstock_setupedit.lists["x_rid"].options = <?php echo JsonEncode($stock_setup_edit->rid->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_setup_edit->showPageHeader(); ?>
<?php
$stock_setup_edit->showMessage();
?>
<form name="fstock_setupedit" id="fstock_setupedit" class="<?php echo $stock_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$stock_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($stock_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_stock_setup_id" for="x_id" class="<?php echo $stock_setup_edit->LeftColumnClass ?>"><?php echo $stock_setup->id->caption() ?><?php echo ($stock_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_setup_edit->RightColumnClass ?>"><div<?php echo $stock_setup->id->cellAttributes() ?>>
<span id="el_stock_setup_id">
<span<?php echo $stock_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($stock_setup->id->CurrentValue) ?>">
<?php echo $stock_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_setup->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_stock_setup_rid" for="x_rid" class="<?php echo $stock_setup_edit->LeftColumnClass ?>"><?php echo $stock_setup->rid->caption() ?><?php echo ($stock_setup->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_setup_edit->RightColumnClass ?>"><div<?php echo $stock_setup->rid->cellAttributes() ?>>
<span id="el_stock_setup_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_setup" data-field="x_rid" data-value-separator="<?php echo $stock_setup->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $stock_setup->rid->editAttributes() ?>>
		<?php echo $stock_setup->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $stock_setup->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $stock_setup->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_setup->date_from->Visible) { // date_from ?>
	<div id="r_date_from" class="form-group row">
		<label id="elh_stock_setup_date_from" for="x_date_from" class="<?php echo $stock_setup_edit->LeftColumnClass ?>"><?php echo $stock_setup->date_from->caption() ?><?php echo ($stock_setup->date_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_setup_edit->RightColumnClass ?>"><div<?php echo $stock_setup->date_from->cellAttributes() ?>>
<span id="el_stock_setup_date_from">
<input type="text" data-table="stock_setup" data-field="x_date_from" data-format="11" name="x_date_from" id="x_date_from" placeholder="<?php echo HtmlEncode($stock_setup->date_from->getPlaceHolder()) ?>" value="<?php echo $stock_setup->date_from->EditValue ?>"<?php echo $stock_setup->date_from->editAttributes() ?>>
<?php if (!$stock_setup->date_from->ReadOnly && !$stock_setup->date_from->Disabled && !isset($stock_setup->date_from->EditAttrs["readonly"]) && !isset($stock_setup->date_from->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_setupedit", "x_date_from", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $stock_setup->date_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_setup->date_to->Visible) { // date_to ?>
	<div id="r_date_to" class="form-group row">
		<label id="elh_stock_setup_date_to" for="x_date_to" class="<?php echo $stock_setup_edit->LeftColumnClass ?>"><?php echo $stock_setup->date_to->caption() ?><?php echo ($stock_setup->date_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_setup_edit->RightColumnClass ?>"><div<?php echo $stock_setup->date_to->cellAttributes() ?>>
<span id="el_stock_setup_date_to">
<input type="text" data-table="stock_setup" data-field="x_date_to" data-format="11" name="x_date_to" id="x_date_to" placeholder="<?php echo HtmlEncode($stock_setup->date_to->getPlaceHolder()) ?>" value="<?php echo $stock_setup->date_to->EditValue ?>"<?php echo $stock_setup->date_to->editAttributes() ?>>
<?php if (!$stock_setup->date_to->ReadOnly && !$stock_setup->date_to->Disabled && !isset($stock_setup->date_to->EditAttrs["readonly"]) && !isset($stock_setup->date_to->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_setupedit", "x_date_to", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $stock_setup->date_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $stock_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_setup_edit->terminate();
?>