<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_setup_list = new stock_setup_list();

// Run the page
$stock_setup_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_setup_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_setuplist = currentForm = new ew.Form("fstock_setuplist", "list");
fstock_setuplist.formKeyCountName = '<?php echo $stock_setup_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_setuplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_setuplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_setuplist.lists["x_rid"] = <?php echo $stock_setup_list->rid->Lookup->toClientList() ?>;
fstock_setuplist.lists["x_rid"].options = <?php echo JsonEncode($stock_setup_list->rid->lookupOptions()) ?>;

// Form object for search
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_setup_list->TotalRecs > 0 && $stock_setup_list->ExportOptions->visible()) { ?>
<?php $stock_setup_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_setup_list->ImportOptions->visible()) { ?>
<?php $stock_setup_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_setup_list->renderOtherOptions();
?>
<?php $stock_setup_list->showPageHeader(); ?>
<?php
$stock_setup_list->showMessage();
?>
<?php if ($stock_setup_list->TotalRecs > 0 || $stock_setup->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_setup_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_setup">
<?php if (!$stock_setup->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_setup_list->Pager)) $stock_setup_list->Pager = new PrevNextPager($stock_setup_list->StartRec, $stock_setup_list->DisplayRecs, $stock_setup_list->TotalRecs, $stock_setup_list->AutoHidePager) ?>
<?php if ($stock_setup_list->Pager->RecordCount > 0 && $stock_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_setup_list->TotalRecs > 0 && (!$stock_setup_list->AutoHidePageSizeSelector || $stock_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_setuplist" id="fstock_setuplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_setup_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_setup_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_setup">
<div id="gmp_stock_setup" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_setup_list->TotalRecs > 0 || $stock_setup->isGridEdit()) { ?>
<table id="tbl_stock_setuplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_setup_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_setup_list->renderListOptions();

// Render list options (header, left)
$stock_setup_list->ListOptions->render("header", "left");
?>
<?php if ($stock_setup->id->Visible) { // id ?>
	<?php if ($stock_setup->sortUrl($stock_setup->id) == "") { ?>
		<th data-name="id" class="<?php echo $stock_setup->id->headerCellClass() ?>"><div id="elh_stock_setup_id" class="stock_setup_id"><div class="ew-table-header-caption"><?php echo $stock_setup->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $stock_setup->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->id) ?>',2);"><div id="elh_stock_setup_id" class="stock_setup_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_setup->rid->Visible) { // rid ?>
	<?php if ($stock_setup->sortUrl($stock_setup->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_setup->rid->headerCellClass() ?>"><div id="elh_stock_setup_rid" class="stock_setup_rid"><div class="ew-table-header-caption"><?php echo $stock_setup->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_setup->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->rid) ?>',2);"><div id="elh_stock_setup_rid" class="stock_setup_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_setup->date_from->Visible) { // date_from ?>
	<?php if ($stock_setup->sortUrl($stock_setup->date_from) == "") { ?>
		<th data-name="date_from" class="<?php echo $stock_setup->date_from->headerCellClass() ?>"><div id="elh_stock_setup_date_from" class="stock_setup_date_from"><div class="ew-table-header-caption"><?php echo $stock_setup->date_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_from" class="<?php echo $stock_setup->date_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->date_from) ?>',2);"><div id="elh_stock_setup_date_from" class="stock_setup_date_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->date_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->date_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->date_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_setup->date_to->Visible) { // date_to ?>
	<?php if ($stock_setup->sortUrl($stock_setup->date_to) == "") { ?>
		<th data-name="date_to" class="<?php echo $stock_setup->date_to->headerCellClass() ?>"><div id="elh_stock_setup_date_to" class="stock_setup_date_to"><div class="ew-table-header-caption"><?php echo $stock_setup->date_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_to" class="<?php echo $stock_setup->date_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->date_to) ?>',2);"><div id="elh_stock_setup_date_to" class="stock_setup_date_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->date_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->date_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->date_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_setup->operator->Visible) { // operator ?>
	<?php if ($stock_setup->sortUrl($stock_setup->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $stock_setup->operator->headerCellClass() ?>"><div id="elh_stock_setup_operator" class="stock_setup_operator"><div class="ew-table-header-caption"><?php echo $stock_setup->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $stock_setup->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->operator) ?>',2);"><div id="elh_stock_setup_operator" class="stock_setup_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_setup->datetime->Visible) { // datetime ?>
	<?php if ($stock_setup->sortUrl($stock_setup->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $stock_setup->datetime->headerCellClass() ?>"><div id="elh_stock_setup_datetime" class="stock_setup_datetime"><div class="ew-table-header-caption"><?php echo $stock_setup->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $stock_setup->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_setup->SortUrl($stock_setup->datetime) ?>',2);"><div id="elh_stock_setup_datetime" class="stock_setup_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_setup->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_setup->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_setup->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_setup_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_setup->ExportAll && $stock_setup->isExport()) {
	$stock_setup_list->StopRec = $stock_setup_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_setup_list->TotalRecs > $stock_setup_list->StartRec + $stock_setup_list->DisplayRecs - 1)
		$stock_setup_list->StopRec = $stock_setup_list->StartRec + $stock_setup_list->DisplayRecs - 1;
	else
		$stock_setup_list->StopRec = $stock_setup_list->TotalRecs;
}
$stock_setup_list->RecCnt = $stock_setup_list->StartRec - 1;
if ($stock_setup_list->Recordset && !$stock_setup_list->Recordset->EOF) {
	$stock_setup_list->Recordset->moveFirst();
	$selectLimit = $stock_setup_list->UseSelectLimit;
	if (!$selectLimit && $stock_setup_list->StartRec > 1)
		$stock_setup_list->Recordset->move($stock_setup_list->StartRec - 1);
} elseif (!$stock_setup->AllowAddDeleteRow && $stock_setup_list->StopRec == 0) {
	$stock_setup_list->StopRec = $stock_setup->GridAddRowCount;
}

// Initialize aggregate
$stock_setup->RowType = ROWTYPE_AGGREGATEINIT;
$stock_setup->resetAttributes();
$stock_setup_list->renderRow();
while ($stock_setup_list->RecCnt < $stock_setup_list->StopRec) {
	$stock_setup_list->RecCnt++;
	if ($stock_setup_list->RecCnt >= $stock_setup_list->StartRec) {
		$stock_setup_list->RowCnt++;

		// Set up key count
		$stock_setup_list->KeyCount = $stock_setup_list->RowIndex;

		// Init row class and style
		$stock_setup->resetAttributes();
		$stock_setup->CssClass = "";
		if ($stock_setup->isGridAdd()) {
		} else {
			$stock_setup_list->loadRowValues($stock_setup_list->Recordset); // Load row values
		}
		$stock_setup->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_setup->RowAttrs = array_merge($stock_setup->RowAttrs, array('data-rowindex'=>$stock_setup_list->RowCnt, 'id'=>'r' . $stock_setup_list->RowCnt . '_stock_setup', 'data-rowtype'=>$stock_setup->RowType));

		// Render row
		$stock_setup_list->renderRow();

		// Render list options
		$stock_setup_list->renderListOptions();
?>
	<tr<?php echo $stock_setup->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_setup_list->ListOptions->render("body", "left", $stock_setup_list->RowCnt);
?>
	<?php if ($stock_setup->id->Visible) { // id ?>
		<td data-name="id"<?php echo $stock_setup->id->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_id" class="stock_setup_id">
<span<?php echo $stock_setup->id->viewAttributes() ?>>
<?php echo $stock_setup->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_setup->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_setup->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_rid" class="stock_setup_rid">
<span<?php echo $stock_setup->rid->viewAttributes() ?>>
<?php echo $stock_setup->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_setup->date_from->Visible) { // date_from ?>
		<td data-name="date_from"<?php echo $stock_setup->date_from->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_date_from" class="stock_setup_date_from">
<span<?php echo $stock_setup->date_from->viewAttributes() ?>>
<?php echo $stock_setup->date_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_setup->date_to->Visible) { // date_to ?>
		<td data-name="date_to"<?php echo $stock_setup->date_to->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_date_to" class="stock_setup_date_to">
<span<?php echo $stock_setup->date_to->viewAttributes() ?>>
<?php echo $stock_setup->date_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_setup->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $stock_setup->operator->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_operator" class="stock_setup_operator">
<span<?php echo $stock_setup->operator->viewAttributes() ?>>
<?php echo $stock_setup->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_setup->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $stock_setup->datetime->cellAttributes() ?>>
<span id="el<?php echo $stock_setup_list->RowCnt ?>_stock_setup_datetime" class="stock_setup_datetime">
<span<?php echo $stock_setup->datetime->viewAttributes() ?>>
<?php echo $stock_setup->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_setup_list->ListOptions->render("body", "right", $stock_setup_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_setup->isGridAdd())
		$stock_setup_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_setup->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_setup_list->Recordset)
	$stock_setup_list->Recordset->Close();
?>
<?php if (!$stock_setup->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_setup_list->Pager)) $stock_setup_list->Pager = new PrevNextPager($stock_setup_list->StartRec, $stock_setup_list->DisplayRecs, $stock_setup_list->TotalRecs, $stock_setup_list->AutoHidePager) ?>
<?php if ($stock_setup_list->Pager->RecordCount > 0 && $stock_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_setup_list->pageUrl() ?>start=<?php echo $stock_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_setup_list->TotalRecs > 0 && (!$stock_setup_list->AutoHidePageSizeSelector || $stock_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_setup_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_setup_list->TotalRecs == 0 && !$stock_setup->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_setup_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_setup->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_setup", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_setup_list->terminate();
?>