<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($stock_grid))
	$stock_grid = new stock_grid();

// Run the page
$stock_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_grid->Page_Render();
?>
<?php if (!$stock->isExport()) { ?>
<script>

// Form object
var fstockgrid = new ew.Form("fstockgrid", "grid");
fstockgrid.formKeyCountName = '<?php echo $stock_grid->FormKeyCountName ?>';

// Validate form
fstockgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($stock_grid->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->product->caption(), $stock->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_grid->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->product_code->caption(), $stock->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_grid->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->packing_type->caption(), $stock->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_grid->Balance->Required) { ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->Balance->caption(), $stock->Balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_Balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock->Balance->errorMessage()) ?>");
		<?php if ($stock_grid->hold->Required) { ?>
			elm = this.getElements("x" + infix + "_hold");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->hold->caption(), $stock->hold->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_hold");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock->hold->errorMessage()) ?>");
		<?php if ($stock_grid->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->packets->caption(), $stock->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock->packets->errorMessage()) ?>");
		<?php if ($stock_grid->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock->avg_quantity->caption(), $stock->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($stock->avg_quantity->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fstockgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "product_code", false)) return false;
	if (ew.valueChanged(fobj, infix, "packing_type", false)) return false;
	if (ew.valueChanged(fobj, infix, "Balance", false)) return false;
	if (ew.valueChanged(fobj, infix, "hold", false)) return false;
	if (ew.valueChanged(fobj, infix, "packets", false)) return false;
	if (ew.valueChanged(fobj, infix, "avg_quantity", false)) return false;
	return true;
}

// Form_CustomValidate event
fstockgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstockgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstockgrid.lists["x_product"] = <?php echo $stock_grid->product->Lookup->toClientList() ?>;
fstockgrid.lists["x_product"].options = <?php echo JsonEncode($stock_grid->product->lookupOptions()) ?>;
fstockgrid.lists["x_packing_type"] = <?php echo $stock_grid->packing_type->Lookup->toClientList() ?>;
fstockgrid.lists["x_packing_type"].options = <?php echo JsonEncode($stock_grid->packing_type->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$stock_grid->renderOtherOptions();
?>
<?php $stock_grid->showPageHeader(); ?>
<?php
$stock_grid->showMessage();
?>
<?php if ($stock_grid->TotalRecs > 0 || $stock->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock">
<?php if ($stock_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $stock_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fstockgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_stock" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_stockgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_grid->RowType = ROWTYPE_HEADER;

// Render list options
$stock_grid->renderListOptions();

// Render list options (header, left)
$stock_grid->ListOptions->render("header", "left");
?>
<?php if ($stock->product->Visible) { // product ?>
	<?php if ($stock->sortUrl($stock->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock->product->headerCellClass() ?>"><div id="elh_stock_product" class="stock_product"><div class="ew-table-header-caption"><?php echo $stock->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock->product->headerCellClass() ?>"><div><div id="elh_stock_product" class="stock_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
	<?php if ($stock->sortUrl($stock->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock->product_code->headerCellClass() ?>"><div id="elh_stock_product_code" class="stock_product_code"><div class="ew-table-header-caption"><?php echo $stock->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock->product_code->headerCellClass() ?>"><div><div id="elh_stock_product_code" class="stock_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
	<?php if ($stock->sortUrl($stock->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock->packing_type->headerCellClass() ?>"><div id="elh_stock_packing_type" class="stock_packing_type"><div class="ew-table-header-caption"><?php echo $stock->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock->packing_type->headerCellClass() ?>"><div><div id="elh_stock_packing_type" class="stock_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
	<?php if ($stock->sortUrl($stock->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock->Balance->headerCellClass() ?>"><div id="elh_stock_Balance" class="stock_Balance"><div class="ew-table-header-caption"><?php echo $stock->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock->Balance->headerCellClass() ?>"><div><div id="elh_stock_Balance" class="stock_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
	<?php if ($stock->sortUrl($stock->hold) == "") { ?>
		<th data-name="hold" class="<?php echo $stock->hold->headerCellClass() ?>"><div id="elh_stock_hold" class="stock_hold"><div class="ew-table-header-caption"><?php echo $stock->hold->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hold" class="<?php echo $stock->hold->headerCellClass() ?>"><div><div id="elh_stock_hold" class="stock_hold">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->hold->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->hold->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->hold->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
	<?php if ($stock->sortUrl($stock->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock->packets->headerCellClass() ?>"><div id="elh_stock_packets" class="stock_packets"><div class="ew-table-header-caption"><?php echo $stock->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock->packets->headerCellClass() ?>"><div><div id="elh_stock_packets" class="stock_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($stock->sortUrl($stock->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><div id="elh_stock_avg_quantity" class="stock_avg_quantity"><div class="ew-table-header-caption"><?php echo $stock->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><div><div id="elh_stock_avg_quantity" class="stock_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$stock_grid->StartRec = 1;
$stock_grid->StopRec = $stock_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $stock_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($stock_grid->FormKeyCountName) && ($stock->isGridAdd() || $stock->isGridEdit() || $stock->isConfirm())) {
		$stock_grid->KeyCount = $CurrentForm->getValue($stock_grid->FormKeyCountName);
		$stock_grid->StopRec = $stock_grid->StartRec + $stock_grid->KeyCount - 1;
	}
}
$stock_grid->RecCnt = $stock_grid->StartRec - 1;
if ($stock_grid->Recordset && !$stock_grid->Recordset->EOF) {
	$stock_grid->Recordset->moveFirst();
	$selectLimit = $stock_grid->UseSelectLimit;
	if (!$selectLimit && $stock_grid->StartRec > 1)
		$stock_grid->Recordset->move($stock_grid->StartRec - 1);
} elseif (!$stock->AllowAddDeleteRow && $stock_grid->StopRec == 0) {
	$stock_grid->StopRec = $stock->GridAddRowCount;
}

// Initialize aggregate
$stock->RowType = ROWTYPE_AGGREGATEINIT;
$stock->resetAttributes();
$stock_grid->renderRow();
if ($stock->isGridAdd())
	$stock_grid->RowIndex = 0;
if ($stock->isGridEdit())
	$stock_grid->RowIndex = 0;
while ($stock_grid->RecCnt < $stock_grid->StopRec) {
	$stock_grid->RecCnt++;
	if ($stock_grid->RecCnt >= $stock_grid->StartRec) {
		$stock_grid->RowCnt++;
		if ($stock->isGridAdd() || $stock->isGridEdit() || $stock->isConfirm()) {
			$stock_grid->RowIndex++;
			$CurrentForm->Index = $stock_grid->RowIndex;
			if ($CurrentForm->hasValue($stock_grid->FormActionName) && $stock_grid->EventCancelled)
				$stock_grid->RowAction = strval($CurrentForm->getValue($stock_grid->FormActionName));
			elseif ($stock->isGridAdd())
				$stock_grid->RowAction = "insert";
			else
				$stock_grid->RowAction = "";
		}

		// Set up key count
		$stock_grid->KeyCount = $stock_grid->RowIndex;

		// Init row class and style
		$stock->resetAttributes();
		$stock->CssClass = "";
		if ($stock->isGridAdd()) {
			if ($stock->CurrentMode == "copy") {
				$stock_grid->loadRowValues($stock_grid->Recordset); // Load row values
				$stock_grid->setRecordKey($stock_grid->RowOldKey, $stock_grid->Recordset); // Set old record key
			} else {
				$stock_grid->loadRowValues(); // Load default values
				$stock_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$stock_grid->loadRowValues($stock_grid->Recordset); // Load row values
		}
		$stock->RowType = ROWTYPE_VIEW; // Render view
		if ($stock->isGridAdd()) // Grid add
			$stock->RowType = ROWTYPE_ADD; // Render add
		if ($stock->isGridAdd() && $stock->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$stock_grid->restoreCurrentRowFormValues($stock_grid->RowIndex); // Restore form values
		if ($stock->isGridEdit()) { // Grid edit
			if ($stock->EventCancelled)
				$stock_grid->restoreCurrentRowFormValues($stock_grid->RowIndex); // Restore form values
			if ($stock_grid->RowAction == "insert")
				$stock->RowType = ROWTYPE_ADD; // Render add
			else
				$stock->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($stock->isGridEdit() && ($stock->RowType == ROWTYPE_EDIT || $stock->RowType == ROWTYPE_ADD) && $stock->EventCancelled) // Update failed
			$stock_grid->restoreCurrentRowFormValues($stock_grid->RowIndex); // Restore form values
		if ($stock->RowType == ROWTYPE_EDIT) // Edit row
			$stock_grid->EditRowCnt++;
		if ($stock->isConfirm()) // Confirm row
			$stock_grid->restoreCurrentRowFormValues($stock_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$stock->RowAttrs = array_merge($stock->RowAttrs, array('data-rowindex'=>$stock_grid->RowCnt, 'id'=>'r' . $stock_grid->RowCnt . '_stock', 'data-rowtype'=>$stock->RowType));

		// Render row
		$stock_grid->renderRow();

		// Render list options
		$stock_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($stock_grid->RowAction <> "delete" && $stock_grid->RowAction <> "insertdelete" && !($stock_grid->RowAction == "insert" && $stock->isConfirm() && $stock_grid->emptyRow())) {
?>
	<tr<?php echo $stock->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_grid->ListOptions->render("body", "left", $stock_grid->RowCnt);
?>
	<?php if ($stock->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock->product->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product" class="form-group stock_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_product" data-value-separator="<?php echo $stock->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_product" name="x<?php echo $stock_grid->RowIndex ?>_product"<?php echo $stock->product->editAttributes() ?>>
		<?php echo $stock->product->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock->product->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="stock" data-field="x_product" name="o<?php echo $stock_grid->RowIndex ?>_product" id="o<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product" class="form-group stock_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_product" data-value-separator="<?php echo $stock->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_product" name="x<?php echo $stock_grid->RowIndex ?>_product"<?php echo $stock->product->editAttributes() ?>>
		<?php echo $stock->product->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock->product->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product" class="stock_product">
<span<?php echo $stock->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product->getViewValue())) && $stock->product->linkAttributes() <> "") { ?>
<a<?php echo $stock->product->linkAttributes() ?>><?php echo $stock->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_product" name="x<?php echo $stock_grid->RowIndex ?>_product" id="x<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product" name="o<?php echo $stock_grid->RowIndex ?>_product" id="o<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_product" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_product" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_product" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock->product_code->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product_code" class="form-group stock_product_code">
<input type="text" data-table="stock" data-field="x_product_code" name="x<?php echo $stock_grid->RowIndex ?>_product_code" id="x<?php echo $stock_grid->RowIndex ?>_product_code" size="30" maxlength="104" placeholder="<?php echo HtmlEncode($stock->product_code->getPlaceHolder()) ?>" value="<?php echo $stock->product_code->EditValue ?>"<?php echo $stock->product_code->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock" data-field="x_product_code" name="o<?php echo $stock_grid->RowIndex ?>_product_code" id="o<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product_code" class="form-group stock_product_code">
<input type="text" data-table="stock" data-field="x_product_code" name="x<?php echo $stock_grid->RowIndex ?>_product_code" id="x<?php echo $stock_grid->RowIndex ?>_product_code" size="30" maxlength="104" placeholder="<?php echo HtmlEncode($stock->product_code->getPlaceHolder()) ?>" value="<?php echo $stock->product_code->EditValue ?>"<?php echo $stock->product_code->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_product_code" class="stock_product_code">
<span<?php echo $stock->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product_code->getViewValue())) && $stock->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock->product_code->linkAttributes() ?>><?php echo $stock->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_product_code" name="x<?php echo $stock_grid->RowIndex ?>_product_code" id="x<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product_code" name="o<?php echo $stock_grid->RowIndex ?>_product_code" id="o<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_product_code" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_product_code" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product_code" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_product_code" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock->packing_type->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packing_type" class="form-group stock_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_packing_type" data-value-separator="<?php echo $stock->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_packing_type" name="x<?php echo $stock_grid->RowIndex ?>_packing_type"<?php echo $stock->packing_type->editAttributes() ?>>
		<?php echo $stock->packing_type->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $stock->packing_type->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_packing_type") ?>
</span>
<input type="hidden" data-table="stock" data-field="x_packing_type" name="o<?php echo $stock_grid->RowIndex ?>_packing_type" id="o<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packing_type" class="form-group stock_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_packing_type" data-value-separator="<?php echo $stock->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_packing_type" name="x<?php echo $stock_grid->RowIndex ?>_packing_type"<?php echo $stock->packing_type->editAttributes() ?>>
		<?php echo $stock->packing_type->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $stock->packing_type->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_packing_type") ?>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packing_type" class="stock_packing_type">
<span<?php echo $stock->packing_type->viewAttributes() ?>>
<?php echo $stock->packing_type->getViewValue() ?></span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_packing_type" name="x<?php echo $stock_grid->RowIndex ?>_packing_type" id="x<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packing_type" name="o<?php echo $stock_grid->RowIndex ?>_packing_type" id="o<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_packing_type" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_packing_type" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packing_type" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_packing_type" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock->Balance->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_Balance" class="form-group stock_Balance">
<input type="text" data-table="stock" data-field="x_Balance" name="x<?php echo $stock_grid->RowIndex ?>_Balance" id="x<?php echo $stock_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock" data-field="x_Balance" name="o<?php echo $stock_grid->RowIndex ?>_Balance" id="o<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_Balance" class="form-group stock_Balance">
<input type="text" data-table="stock" data-field="x_Balance" name="x<?php echo $stock_grid->RowIndex ?>_Balance" id="x<?php echo $stock_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_Balance" class="stock_Balance">
<span<?php echo $stock->Balance->viewAttributes() ?>>
<?php echo $stock->Balance->getViewValue() ?></span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_Balance" name="x<?php echo $stock_grid->RowIndex ?>_Balance" id="x<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_Balance" name="o<?php echo $stock_grid->RowIndex ?>_Balance" id="o<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_Balance" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_Balance" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_Balance" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_Balance" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->hold->Visible) { // hold ?>
		<td data-name="hold"<?php echo $stock->hold->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_hold" class="form-group stock_hold">
<input type="text" data-table="stock" data-field="x_hold" name="x<?php echo $stock_grid->RowIndex ?>_hold" id="x<?php echo $stock_grid->RowIndex ?>_hold" size="30" placeholder="<?php echo HtmlEncode($stock->hold->getPlaceHolder()) ?>" value="<?php echo $stock->hold->EditValue ?>"<?php echo $stock->hold->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock" data-field="x_hold" name="o<?php echo $stock_grid->RowIndex ?>_hold" id="o<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_hold" class="form-group stock_hold">
<input type="text" data-table="stock" data-field="x_hold" name="x<?php echo $stock_grid->RowIndex ?>_hold" id="x<?php echo $stock_grid->RowIndex ?>_hold" size="30" placeholder="<?php echo HtmlEncode($stock->hold->getPlaceHolder()) ?>" value="<?php echo $stock->hold->EditValue ?>"<?php echo $stock->hold->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_hold" class="stock_hold">
<span<?php echo $stock->hold->viewAttributes() ?>>
<?php echo $stock->hold->getViewValue() ?></span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_hold" name="x<?php echo $stock_grid->RowIndex ?>_hold" id="x<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_hold" name="o<?php echo $stock_grid->RowIndex ?>_hold" id="o<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_hold" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_hold" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_hold" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_hold" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock->packets->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packets" class="form-group stock_packets">
<input type="text" data-table="stock" data-field="x_packets" name="x<?php echo $stock_grid->RowIndex ?>_packets" id="x<?php echo $stock_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock->packets->getPlaceHolder()) ?>" value="<?php echo $stock->packets->EditValue ?>"<?php echo $stock->packets->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock" data-field="x_packets" name="o<?php echo $stock_grid->RowIndex ?>_packets" id="o<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packets" class="form-group stock_packets">
<input type="text" data-table="stock" data-field="x_packets" name="x<?php echo $stock_grid->RowIndex ?>_packets" id="x<?php echo $stock_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock->packets->getPlaceHolder()) ?>" value="<?php echo $stock->packets->EditValue ?>"<?php echo $stock->packets->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_packets" class="stock_packets">
<span<?php echo $stock->packets->viewAttributes() ?>>
<?php echo $stock->packets->getViewValue() ?></span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_packets" name="x<?php echo $stock_grid->RowIndex ?>_packets" id="x<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packets" name="o<?php echo $stock_grid->RowIndex ?>_packets" id="o<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_packets" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_packets" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packets" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_packets" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $stock->avg_quantity->cellAttributes() ?>>
<?php if ($stock->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_avg_quantity" class="form-group stock_avg_quantity">
<input type="text" data-table="stock" data-field="x_avg_quantity" name="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($stock->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $stock->avg_quantity->EditValue ?>"<?php echo $stock->avg_quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->OldValue) ?>">
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_avg_quantity" class="form-group stock_avg_quantity">
<input type="text" data-table="stock" data-field="x_avg_quantity" name="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($stock->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $stock->avg_quantity->EditValue ?>"<?php echo $stock->avg_quantity->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($stock->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $stock_grid->RowCnt ?>_stock_avg_quantity" class="stock_avg_quantity">
<span<?php echo $stock->avg_quantity->viewAttributes() ?>>
<?php echo $stock->avg_quantity->getViewValue() ?></span>
</span>
<?php if (!$stock->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="fstockgrid$x<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="fstockgrid$o<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_grid->ListOptions->render("body", "right", $stock_grid->RowCnt);
?>
	</tr>
<?php if ($stock->RowType == ROWTYPE_ADD || $stock->RowType == ROWTYPE_EDIT) { ?>
<script>
fstockgrid.updateLists(<?php echo $stock_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$stock->isGridAdd() || $stock->CurrentMode == "copy")
		if (!$stock_grid->Recordset->EOF)
			$stock_grid->Recordset->moveNext();
}
?>
<?php
	if ($stock->CurrentMode == "add" || $stock->CurrentMode == "copy" || $stock->CurrentMode == "edit") {
		$stock_grid->RowIndex = '$rowindex$';
		$stock_grid->loadRowValues();

		// Set row properties
		$stock->resetAttributes();
		$stock->RowAttrs = array_merge($stock->RowAttrs, array('data-rowindex'=>$stock_grid->RowIndex, 'id'=>'r0_stock', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($stock->RowAttrs["class"], "ew-template");
		$stock->RowType = ROWTYPE_ADD;

		// Render row
		$stock_grid->renderRow();

		// Render list options
		$stock_grid->renderListOptions();
		$stock_grid->StartRowCnt = 0;
?>
	<tr<?php echo $stock->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_grid->ListOptions->render("body", "left", $stock_grid->RowIndex);
?>
	<?php if ($stock->product->Visible) { // product ?>
		<td data-name="product">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_product" class="form-group stock_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_product" data-value-separator="<?php echo $stock->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_product" name="x<?php echo $stock_grid->RowIndex ?>_product"<?php echo $stock->product->editAttributes() ?>>
		<?php echo $stock->product->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $stock->product->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_product") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_product" class="form-group stock_product">
<span<?php echo $stock->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product->ViewValue)) && $stock->product->linkAttributes() <> "") { ?>
<a<?php echo $stock->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->product->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->product->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock" data-field="x_product" name="x<?php echo $stock_grid->RowIndex ?>_product" id="x<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_product" name="o<?php echo $stock_grid->RowIndex ?>_product" id="o<?php echo $stock_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($stock->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->product_code->Visible) { // product_code ?>
		<td data-name="product_code">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_product_code" class="form-group stock_product_code">
<input type="text" data-table="stock" data-field="x_product_code" name="x<?php echo $stock_grid->RowIndex ?>_product_code" id="x<?php echo $stock_grid->RowIndex ?>_product_code" size="30" maxlength="104" placeholder="<?php echo HtmlEncode($stock->product_code->getPlaceHolder()) ?>" value="<?php echo $stock->product_code->EditValue ?>"<?php echo $stock->product_code->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_product_code" class="form-group stock_product_code">
<span<?php echo $stock->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product_code->ViewValue)) && $stock->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock->product_code->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->product_code->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->product_code->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock" data-field="x_product_code" name="x<?php echo $stock_grid->RowIndex ?>_product_code" id="x<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_product_code" name="o<?php echo $stock_grid->RowIndex ?>_product_code" id="o<?php echo $stock_grid->RowIndex ?>_product_code" value="<?php echo HtmlEncode($stock->product_code->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_packing_type" class="form-group stock_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_packing_type" data-value-separator="<?php echo $stock->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $stock_grid->RowIndex ?>_packing_type" name="x<?php echo $stock_grid->RowIndex ?>_packing_type"<?php echo $stock->packing_type->editAttributes() ?>>
		<?php echo $stock->packing_type->selectOptionListHtml("x<?php echo $stock_grid->RowIndex ?>_packing_type") ?>
	</select>
</div>
<?php echo $stock->packing_type->Lookup->getParamTag("p_x" . $stock_grid->RowIndex . "_packing_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_packing_type" class="form-group stock_packing_type">
<span<?php echo $stock->packing_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->packing_type->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock" data-field="x_packing_type" name="x<?php echo $stock_grid->RowIndex ?>_packing_type" id="x<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_packing_type" name="o<?php echo $stock_grid->RowIndex ?>_packing_type" id="o<?php echo $stock_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($stock->packing_type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_Balance" class="form-group stock_Balance">
<input type="text" data-table="stock" data-field="x_Balance" name="x<?php echo $stock_grid->RowIndex ?>_Balance" id="x<?php echo $stock_grid->RowIndex ?>_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_Balance" class="form-group stock_Balance">
<span<?php echo $stock->Balance->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->Balance->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock" data-field="x_Balance" name="x<?php echo $stock_grid->RowIndex ?>_Balance" id="x<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_Balance" name="o<?php echo $stock_grid->RowIndex ?>_Balance" id="o<?php echo $stock_grid->RowIndex ?>_Balance" value="<?php echo HtmlEncode($stock->Balance->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->hold->Visible) { // hold ?>
		<td data-name="hold">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_hold" class="form-group stock_hold">
<input type="text" data-table="stock" data-field="x_hold" name="x<?php echo $stock_grid->RowIndex ?>_hold" id="x<?php echo $stock_grid->RowIndex ?>_hold" size="30" placeholder="<?php echo HtmlEncode($stock->hold->getPlaceHolder()) ?>" value="<?php echo $stock->hold->EditValue ?>"<?php echo $stock->hold->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_hold" class="form-group stock_hold">
<span<?php echo $stock->hold->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->hold->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock" data-field="x_hold" name="x<?php echo $stock_grid->RowIndex ?>_hold" id="x<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_hold" name="o<?php echo $stock_grid->RowIndex ?>_hold" id="o<?php echo $stock_grid->RowIndex ?>_hold" value="<?php echo HtmlEncode($stock->hold->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->packets->Visible) { // packets ?>
		<td data-name="packets">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_packets" class="form-group stock_packets">
<input type="text" data-table="stock" data-field="x_packets" name="x<?php echo $stock_grid->RowIndex ?>_packets" id="x<?php echo $stock_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($stock->packets->getPlaceHolder()) ?>" value="<?php echo $stock->packets->EditValue ?>"<?php echo $stock->packets->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_packets" class="form-group stock_packets">
<span<?php echo $stock->packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->packets->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock" data-field="x_packets" name="x<?php echo $stock_grid->RowIndex ?>_packets" id="x<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_packets" name="o<?php echo $stock_grid->RowIndex ?>_packets" id="o<?php echo $stock_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($stock->packets->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity">
<?php if (!$stock->isConfirm()) { ?>
<span id="el$rowindex$_stock_avg_quantity" class="form-group stock_avg_quantity">
<input type="text" data-table="stock" data-field="x_avg_quantity" name="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($stock->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $stock->avg_quantity->EditValue ?>"<?php echo $stock->avg_quantity->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_stock_avg_quantity" class="form-group stock_avg_quantity">
<span<?php echo $stock->avg_quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock->avg_quantity->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="x<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" name="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" id="o<?php echo $stock_grid->RowIndex ?>_avg_quantity" value="<?php echo HtmlEncode($stock->avg_quantity->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_grid->ListOptions->render("body", "right", $stock_grid->RowIndex);
?>
<script>
fstockgrid.updateLists(<?php echo $stock_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$stock->RowType = ROWTYPE_AGGREGATE;
$stock->resetAttributes();
$stock_grid->renderRow();
?>
<?php if ($stock_grid->TotalRecs > 0 && $stock->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_grid->renderListOptions();

// Render list options (footer, left)
$stock_grid->ListOptions->render("footer", "left");
?>
	<?php if ($stock->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock->product->footerCellClass() ?>"><span id="elf_stock_product" class="stock_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock->product_code->footerCellClass() ?>"><span id="elf_stock_product_code" class="stock_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock->packing_type->footerCellClass() ?>"><span id="elf_stock_packing_type" class="stock_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock->Balance->footerCellClass() ?>"><span id="elf_stock_Balance" class="stock_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->hold->Visible) { // hold ?>
		<td data-name="hold" class="<?php echo $stock->hold->footerCellClass() ?>"><span id="elf_stock_hold" class="stock_hold">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->hold->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock->packets->footerCellClass() ?>"><span id="elf_stock_packets" class="stock_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity" class="<?php echo $stock->avg_quantity->footerCellClass() ?>"><span id="elf_stock_avg_quantity" class="stock_avg_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($stock->CurrentMode == "add" || $stock->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $stock_grid->FormKeyCountName ?>" id="<?php echo $stock_grid->FormKeyCountName ?>" value="<?php echo $stock_grid->KeyCount ?>">
<?php echo $stock_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($stock->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $stock_grid->FormKeyCountName ?>" id="<?php echo $stock_grid->FormKeyCountName ?>" value="<?php echo $stock_grid->KeyCount ?>">
<?php echo $stock_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($stock->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fstockgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($stock_grid->Recordset)
	$stock_grid->Recordset->Close();
?>
</div>
<?php if ($stock_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $stock_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_grid->TotalRecs == 0 && !$stock->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_grid->terminate();
?>
<?php if (!$stock->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock", "100%", "500px");
</script>
<?php } ?>