<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_list = new stock_list();

// Run the page
$stock_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstocklist = currentForm = new ew.Form("fstocklist", "list");
fstocklist.formKeyCountName = '<?php echo $stock_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstocklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstocklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstocklist.lists["x_product"] = <?php echo $stock_list->product->Lookup->toClientList() ?>;
fstocklist.lists["x_product"].options = <?php echo JsonEncode($stock_list->product->lookupOptions()) ?>;
fstocklist.lists["x_packing_type"] = <?php echo $stock_list->packing_type->Lookup->toClientList() ?>;
fstocklist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstocklistsrch = currentSearchForm = new ew.Form("fstocklistsrch");

// Validate function for search
fstocklistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstocklistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstocklistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstocklistsrch.lists["x_product"] = <?php echo $stock_list->product->Lookup->toClientList() ?>;
fstocklistsrch.lists["x_product"].options = <?php echo JsonEncode($stock_list->product->lookupOptions()) ?>;

// Filters
fstocklistsrch.filterList = <?php echo $stock_list->getFilterList() ?>;

// Init search panel as collapsed
fstocklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_list->TotalRecs > 0 && $stock_list->ExportOptions->visible()) { ?>
<?php $stock_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_list->ImportOptions->visible()) { ?>
<?php $stock_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_list->SearchOptions->visible()) { ?>
<?php $stock_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_list->FilterOptions->visible()) { ?>
<?php $stock_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$stock->isExport() || EXPORT_MASTER_RECORD && $stock->isExport("print")) { ?>
<?php
if ($stock_list->DbMasterFilter <> "" && $stock->getCurrentMasterTable() == "material_status") {
	if ($stock_list->MasterRecordExists) {
		include_once "material_statusmaster.php";
	}
}
?>
<?php } ?>
<?php
$stock_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock->isExport() && !$stock->CurrentAction) { ?>
<form name="fstocklistsrch" id="fstocklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstocklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock->RowType = ROWTYPE_SEARCH;

// Render row
$stock->resetAttributes();
$stock_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $stock->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_product" data-value-separator="<?php echo $stock->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock->product->editAttributes() ?>>
		<?php echo $stock->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
	<div id="xsc_Balance" class="ew-cell form-group">
		<label for="x_Balance" class="ew-search-caption ew-label"><?php echo $stock->Balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_Balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Balance style="d-none"">
<input type="text" data-table="stock" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue2 ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_list->showPageHeader(); ?>
<?php
$stock_list->showMessage();
?>
<?php if ($stock_list->TotalRecs > 0 || $stock->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock">
<?php if (!$stock->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_list->Pager)) $stock_list->Pager = new PrevNextPager($stock_list->StartRec, $stock_list->DisplayRecs, $stock_list->TotalRecs, $stock_list->AutoHidePager) ?>
<?php if ($stock_list->Pager->RecordCount > 0 && $stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_list->TotalRecs > 0 && (!$stock_list->AutoHidePageSizeSelector || $stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstocklist" id="fstocklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock">
<?php if ($stock->getCurrentMasterTable() == "material_status" && $stock->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="material_status">
<input type="hidden" name="fk_id" value="<?php echo $stock->rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_stock" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_list->TotalRecs > 0 || $stock->isGridEdit()) { ?>
<table id="tbl_stocklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_list->renderListOptions();

// Render list options (header, left)
$stock_list->ListOptions->render("header", "left");
?>
<?php if ($stock->product->Visible) { // product ?>
	<?php if ($stock->sortUrl($stock->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock->product->headerCellClass() ?>"><div id="elh_stock_product" class="stock_product"><div class="ew-table-header-caption"><?php echo $stock->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->product) ?>',2);"><div id="elh_stock_product" class="stock_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
	<?php if ($stock->sortUrl($stock->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock->product_code->headerCellClass() ?>"><div id="elh_stock_product_code" class="stock_product_code"><div class="ew-table-header-caption"><?php echo $stock->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->product_code) ?>',2);"><div id="elh_stock_product_code" class="stock_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
	<?php if ($stock->sortUrl($stock->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock->packing_type->headerCellClass() ?>"><div id="elh_stock_packing_type" class="stock_packing_type"><div class="ew-table-header-caption"><?php echo $stock->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->packing_type) ?>',2);"><div id="elh_stock_packing_type" class="stock_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
	<?php if ($stock->sortUrl($stock->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock->Balance->headerCellClass() ?>"><div id="elh_stock_Balance" class="stock_Balance"><div class="ew-table-header-caption"><?php echo $stock->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->Balance) ?>',2);"><div id="elh_stock_Balance" class="stock_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->Balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
	<?php if ($stock->sortUrl($stock->hold) == "") { ?>
		<th data-name="hold" class="<?php echo $stock->hold->headerCellClass() ?>"><div id="elh_stock_hold" class="stock_hold"><div class="ew-table-header-caption"><?php echo $stock->hold->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hold" class="<?php echo $stock->hold->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->hold) ?>',2);"><div id="elh_stock_hold" class="stock_hold">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->hold->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->hold->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->hold->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
	<?php if ($stock->sortUrl($stock->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock->packets->headerCellClass() ?>"><div id="elh_stock_packets" class="stock_packets"><div class="ew-table-header-caption"><?php echo $stock->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->packets) ?>',2);"><div id="elh_stock_packets" class="stock_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($stock->sortUrl($stock->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><div id="elh_stock_avg_quantity" class="stock_avg_quantity"><div class="ew-table-header-caption"><?php echo $stock->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock->SortUrl($stock->avg_quantity) ?>',2);"><div id="elh_stock_avg_quantity" class="stock_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock->ExportAll && $stock->isExport()) {
	$stock_list->StopRec = $stock_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_list->TotalRecs > $stock_list->StartRec + $stock_list->DisplayRecs - 1)
		$stock_list->StopRec = $stock_list->StartRec + $stock_list->DisplayRecs - 1;
	else
		$stock_list->StopRec = $stock_list->TotalRecs;
}
$stock_list->RecCnt = $stock_list->StartRec - 1;
if ($stock_list->Recordset && !$stock_list->Recordset->EOF) {
	$stock_list->Recordset->moveFirst();
	$selectLimit = $stock_list->UseSelectLimit;
	if (!$selectLimit && $stock_list->StartRec > 1)
		$stock_list->Recordset->move($stock_list->StartRec - 1);
} elseif (!$stock->AllowAddDeleteRow && $stock_list->StopRec == 0) {
	$stock_list->StopRec = $stock->GridAddRowCount;
}

// Initialize aggregate
$stock->RowType = ROWTYPE_AGGREGATEINIT;
$stock->resetAttributes();
$stock_list->renderRow();
while ($stock_list->RecCnt < $stock_list->StopRec) {
	$stock_list->RecCnt++;
	if ($stock_list->RecCnt >= $stock_list->StartRec) {
		$stock_list->RowCnt++;

		// Set up key count
		$stock_list->KeyCount = $stock_list->RowIndex;

		// Init row class and style
		$stock->resetAttributes();
		$stock->CssClass = "";
		if ($stock->isGridAdd()) {
		} else {
			$stock_list->loadRowValues($stock_list->Recordset); // Load row values
		}
		$stock->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock->RowAttrs = array_merge($stock->RowAttrs, array('data-rowindex'=>$stock_list->RowCnt, 'id'=>'r' . $stock_list->RowCnt . '_stock', 'data-rowtype'=>$stock->RowType));

		// Render row
		$stock_list->renderRow();

		// Render list options
		$stock_list->renderListOptions();
?>
	<tr<?php echo $stock->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_list->ListOptions->render("body", "left", $stock_list->RowCnt);
?>
	<?php if ($stock->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock->product->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_product" class="stock_product">
<span<?php echo $stock->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product->getViewValue())) && $stock->product->linkAttributes() <> "") { ?>
<a<?php echo $stock->product->linkAttributes() ?>><?php echo $stock->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_product_code" class="stock_product_code">
<span<?php echo $stock->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product_code->getViewValue())) && $stock->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock->product_code->linkAttributes() ?>><?php echo $stock->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_packing_type" class="stock_packing_type">
<span<?php echo $stock->packing_type->viewAttributes() ?>>
<?php echo $stock->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_Balance" class="stock_Balance">
<span<?php echo $stock->Balance->viewAttributes() ?>>
<?php echo $stock->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->hold->Visible) { // hold ?>
		<td data-name="hold"<?php echo $stock->hold->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_hold" class="stock_hold">
<span<?php echo $stock->hold->viewAttributes() ?>>
<?php echo $stock->hold->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_packets" class="stock_packets">
<span<?php echo $stock->packets->viewAttributes() ?>>
<?php echo $stock->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $stock->avg_quantity->cellAttributes() ?>>
<span id="el<?php echo $stock_list->RowCnt ?>_stock_avg_quantity" class="stock_avg_quantity">
<span<?php echo $stock->avg_quantity->viewAttributes() ?>>
<?php echo $stock->avg_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_list->ListOptions->render("body", "right", $stock_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock->isGridAdd())
		$stock_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock->RowType = ROWTYPE_AGGREGATE;
$stock->resetAttributes();
$stock_list->renderRow();
?>
<?php if ($stock_list->TotalRecs > 0 && !$stock->isGridAdd() && !$stock->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_list->renderListOptions();

// Render list options (footer, left)
$stock_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock->product->footerCellClass() ?>"><span id="elf_stock_product" class="stock_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock->product_code->footerCellClass() ?>"><span id="elf_stock_product_code" class="stock_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock->packing_type->footerCellClass() ?>"><span id="elf_stock_packing_type" class="stock_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock->Balance->footerCellClass() ?>"><span id="elf_stock_Balance" class="stock_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->hold->Visible) { // hold ?>
		<td data-name="hold" class="<?php echo $stock->hold->footerCellClass() ?>"><span id="elf_stock_hold" class="stock_hold">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->hold->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock->packets->footerCellClass() ?>"><span id="elf_stock_packets" class="stock_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity" class="<?php echo $stock->avg_quantity->footerCellClass() ?>"><span id="elf_stock_avg_quantity" class="stock_avg_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_list->Recordset)
	$stock_list->Recordset->Close();
?>
<?php if (!$stock->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_list->Pager)) $stock_list->Pager = new PrevNextPager($stock_list->StartRec, $stock_list->DisplayRecs, $stock_list->TotalRecs, $stock_list->AutoHidePager) ?>
<?php if ($stock_list->Pager->RecordCount > 0 && $stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_list->pageUrl() ?>start=<?php echo $stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_list->TotalRecs > 0 && (!$stock_list->AutoHidePageSizeSelector || $stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_list->TotalRecs == 0 && !$stock->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_list->terminate();
?>