<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$stock_preview = new stock_preview();

// Run the page
$stock_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_preview->Page_Render();
?>
<?php $stock_preview->showPageHeader(); ?>
<div class="card ew-grid stock"><!-- .card -->
<?php if ($stock_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$stock_preview->renderListOptions();

// Render list options (header, left)
$stock_preview->ListOptions->render("header", "left");
?>
<?php if ($stock->product->Visible) { // product ?>
	<?php if ($stock->SortUrl($stock->product) == "") { ?>
		<th class="<?php echo $stock->product->headerCellClass() ?>"><?php echo $stock->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->product->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->product->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->product->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
	<?php if ($stock->SortUrl($stock->product_code) == "") { ?>
		<th class="<?php echo $stock->product_code->headerCellClass() ?>"><?php echo $stock->product_code->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->product_code->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->product_code->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->product_code->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->product_code->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
	<?php if ($stock->SortUrl($stock->packing_type) == "") { ?>
		<th class="<?php echo $stock->packing_type->headerCellClass() ?>"><?php echo $stock->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->packing_type->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->packing_type->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->packing_type->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
	<?php if ($stock->SortUrl($stock->Balance) == "") { ?>
		<th class="<?php echo $stock->Balance->headerCellClass() ?>"><?php echo $stock->Balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->Balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->Balance->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->Balance->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->Balance->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
	<?php if ($stock->SortUrl($stock->hold) == "") { ?>
		<th class="<?php echo $stock->hold->headerCellClass() ?>"><?php echo $stock->hold->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->hold->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->hold->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->hold->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->hold->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->hold->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
	<?php if ($stock->SortUrl($stock->packets) == "") { ?>
		<th class="<?php echo $stock->packets->headerCellClass() ?>"><?php echo $stock->packets->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->packets->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->packets->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->packets->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->packets->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($stock->SortUrl($stock->avg_quantity) == "") { ?>
		<th class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><?php echo $stock->avg_quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $stock->avg_quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($stock->avg_quantity->Name) ?>" data-sort-order="<?php echo $stock_preview->SortField == $stock->avg_quantity->Name && $stock_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_preview->SortField == $stock->avg_quantity->Name) { ?><?php if ($stock_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$stock_preview->RecCount = 0;
$stock_preview->RowCnt = 0;
while ($stock_preview->Recordset && !$stock_preview->Recordset->EOF) {

	// Init row class and style
	$stock_preview->RecCount++;
	$stock_preview->RowCnt++;
	$stock_preview->CssStyle = "";
	$stock_preview->loadListRowValues($stock_preview->Recordset);
	$stock_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$stock_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$stock_preview->resetAttributes();
	$stock_preview->renderListRow();

	// Render list options
	$stock_preview->renderListOptions();
?>
	<tr<?php echo $stock_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_preview->ListOptions->render("body", "left", $stock_preview->RowCnt);
?>
<?php if ($stock->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $stock->product->cellAttributes() ?>>
<span<?php echo $stock->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product->getViewValue())) && $stock->product->linkAttributes() <> "") { ?>
<a<?php echo $stock->product->linkAttributes() ?>><?php echo $stock->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
		<!-- product_code -->
		<td<?php echo $stock->product_code->cellAttributes() ?>>
<span<?php echo $stock->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock->product_code->getViewValue())) && $stock->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock->product_code->linkAttributes() ?>><?php echo $stock->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock->product_code->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $stock->packing_type->cellAttributes() ?>>
<span<?php echo $stock->packing_type->viewAttributes() ?>>
<?php echo $stock->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
		<!-- Balance -->
		<td<?php echo $stock->Balance->cellAttributes() ?>>
<span<?php echo $stock->Balance->viewAttributes() ?>>
<?php echo $stock->Balance->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
		<!-- hold -->
		<td<?php echo $stock->hold->cellAttributes() ?>>
<span<?php echo $stock->hold->viewAttributes() ?>>
<?php echo $stock->hold->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
		<!-- packets -->
		<td<?php echo $stock->packets->cellAttributes() ?>>
<span<?php echo $stock->packets->viewAttributes() ?>>
<?php echo $stock->packets->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<!-- avg_quantity -->
		<td<?php echo $stock->avg_quantity->cellAttributes() ?>>
<span<?php echo $stock->avg_quantity->viewAttributes() ?>>
<?php echo $stock->avg_quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$stock_preview->ListOptions->render("body", "right", $stock_preview->RowCnt);
?>
	</tr>
<?php
	$stock_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$stock_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$stock_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$stock_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$stock_preview->ListOptions->render("footer", "left");
?>
<?php if ($stock->product->Visible) { // product ?>
		<!-- product -->
		<td class="<?php echo $stock->product->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
		<!-- product_code -->
		<td class="<?php echo $stock->product_code->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td class="<?php echo $stock->packing_type->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
		<!-- Balance -->
		<td class="<?php echo $stock->Balance->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->Balance->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
		<!-- hold -->
		<td class="<?php echo $stock->hold->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->hold->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
		<!-- packets -->
		<td class="<?php echo $stock->packets->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock->packets->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($stock->avg_quantity->Visible) { // avg_quantity ?>
		<!-- avg_quantity -->
		<td class="<?php echo $stock->avg_quantity->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$stock_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($stock_preview->TotalRecs > 0) { ?>
<?php if (!isset($stock_preview->Pager)) $stock_preview->Pager = new PrevNextPager($stock_preview->StartRec, $stock_preview->DisplayRecs, $stock_preview->TotalRecs) ?>
<?php if ($stock_preview->Pager->RecordCount > 0 && $stock_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($stock_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $stock_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($stock_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $stock_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($stock_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $stock_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($stock_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $stock_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $stock_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $stock_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $stock_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($stock_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$stock_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($stock_preview->Recordset)
	$stock_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$stock_preview->terminate();
?>