<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_search = new stock_search();

// Run the page
$stock_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_search->IsModal) { ?>
var fstocksearch = currentAdvancedSearchForm = new ew.Form("fstocksearch", "search");
<?php } else { ?>
var fstocksearch = currentForm = new ew.Form("fstocksearch", "search");
<?php } ?>

// Form_CustomValidate event
fstocksearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstocksearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstocksearch.lists["x_product"] = <?php echo $stock_search->product->Lookup->toClientList() ?>;
fstocksearch.lists["x_product"].options = <?php echo JsonEncode($stock_search->product->lookupOptions()) ?>;
fstocksearch.lists["x_packing_type"] = <?php echo $stock_search->packing_type->Lookup->toClientList() ?>;
fstocksearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstocksearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_hold");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock->hold->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock->packets->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_search->showPageHeader(); ?>
<?php
$stock_search->showMessage();
?>
<form name="fstocksearch" id="fstocksearch" class="<?php echo $stock_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_product"><?php echo $stock->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->product->cellAttributes() ?>>
			<span id="el_stock_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_product" data-value-separator="<?php echo $stock->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock->product->editAttributes() ?>>
		<?php echo $stock->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_product_code"><?php echo $stock->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->product_code->cellAttributes() ?>>
			<span id="el_stock_product_code">
<input type="text" data-table="stock" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="104" placeholder="<?php echo HtmlEncode($stock->product_code->getPlaceHolder()) ?>" value="<?php echo $stock->product_code->EditValue ?>"<?php echo $stock->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_packing_type"><?php echo $stock->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->packing_type->cellAttributes() ?>>
			<span id="el_stock_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock" data-field="x_packing_type" data-value-separator="<?php echo $stock->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock->packing_type->editAttributes() ?>>
		<?php echo $stock->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_Balance"><?php echo $stock->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_stock_Balance">
<input type="text" data-table="stock" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_stock_Balance" class="btw1_Balance d-none">
<input type="text" data-table="stock" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($stock->Balance->getPlaceHolder()) ?>" value="<?php echo $stock->Balance->EditValue2 ?>"<?php echo $stock->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock->hold->Visible) { // hold ?>
	<div id="r_hold" class="form-group row">
		<label for="x_hold" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_hold"><?php echo $stock->hold->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_hold" id="z_hold" value="="></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->hold->cellAttributes() ?>>
			<span id="el_stock_hold">
<input type="text" data-table="stock" data-field="x_hold" name="x_hold" id="x_hold" size="30" placeholder="<?php echo HtmlEncode($stock->hold->getPlaceHolder()) ?>" value="<?php echo $stock->hold->EditValue ?>"<?php echo $stock->hold->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_search->LeftColumnClass ?>"><span id="elh_stock_packets"><?php echo $stock->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_search->RightColumnClass ?>"><div<?php echo $stock->packets->cellAttributes() ?>>
			<span id="el_stock_packets">
<input type="text" data-table="stock" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock->packets->getPlaceHolder()) ?>" value="<?php echo $stock->packets->EditValue ?>"<?php echo $stock->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_search->terminate();
?>