<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sub_process_type_list = new sub_process_type_list();

// Run the page
$sub_process_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sub_process_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sub_process_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsub_process_typelist = currentForm = new ew.Form("fsub_process_typelist", "list");
fsub_process_typelist.formKeyCountName = '<?php echo $sub_process_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsub_process_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsub_process_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsub_process_typelist.lists["x_grp[]"] = <?php echo $sub_process_type_list->grp->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_grp[]"].options = <?php echo JsonEncode($sub_process_type_list->grp->lookupOptions()) ?>;
fsub_process_typelist.lists["x_s_grp[]"] = <?php echo $sub_process_type_list->s_grp->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_s_grp[]"].options = <?php echo JsonEncode($sub_process_type_list->s_grp->lookupOptions()) ?>;
fsub_process_typelist.lists["x_type"] = <?php echo $sub_process_type_list->type->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_type"].options = <?php echo JsonEncode($sub_process_type_list->type->options(FALSE, TRUE)) ?>;
fsub_process_typelist.lists["x_type_cat"] = <?php echo $sub_process_type_list->type_cat->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_type_cat"].options = <?php echo JsonEncode($sub_process_type_list->type_cat->options(FALSE, TRUE)) ?>;
fsub_process_typelist.lists["x_output_packing"] = <?php echo $sub_process_type_list->output_packing->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_output_packing"].options = <?php echo JsonEncode($sub_process_type_list->output_packing->lookupOptions()) ?>;
fsub_process_typelist.lists["x_m_employee"] = <?php echo $sub_process_type_list->m_employee->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_m_employee"].options = <?php echo JsonEncode($sub_process_type_list->m_employee->options(FALSE, TRUE)) ?>;
fsub_process_typelist.lists["x_pao[]"] = <?php echo $sub_process_type_list->pao->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_pao[]"].options = <?php echo JsonEncode($sub_process_type_list->pao->lookupOptions()) ?>;
fsub_process_typelist.lists["x_status"] = <?php echo $sub_process_type_list->status->Lookup->toClientList() ?>;
fsub_process_typelist.lists["x_status"].options = <?php echo JsonEncode($sub_process_type_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fsub_process_typelistsrch = currentSearchForm = new ew.Form("fsub_process_typelistsrch");

// Filters
fsub_process_typelistsrch.filterList = <?php echo $sub_process_type_list->getFilterList() ?>;

// Init search panel as collapsed
fsub_process_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sub_process_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sub_process_type_list->TotalRecs > 0 && $sub_process_type_list->ExportOptions->visible()) { ?>
<?php $sub_process_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sub_process_type_list->ImportOptions->visible()) { ?>
<?php $sub_process_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sub_process_type_list->SearchOptions->visible()) { ?>
<?php $sub_process_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sub_process_type_list->FilterOptions->visible()) { ?>
<?php $sub_process_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sub_process_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sub_process_type->isExport() && !$sub_process_type->CurrentAction) { ?>
<form name="fsub_process_typelistsrch" id="fsub_process_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sub_process_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsub_process_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sub_process_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sub_process_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sub_process_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sub_process_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sub_process_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sub_process_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sub_process_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sub_process_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sub_process_type_list->showPageHeader(); ?>
<?php
$sub_process_type_list->showMessage();
?>
<?php if ($sub_process_type_list->TotalRecs > 0 || $sub_process_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sub_process_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sub_process_type">
<?php if (!$sub_process_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sub_process_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sub_process_type_list->Pager)) $sub_process_type_list->Pager = new PrevNextPager($sub_process_type_list->StartRec, $sub_process_type_list->DisplayRecs, $sub_process_type_list->TotalRecs, $sub_process_type_list->AutoHidePager) ?>
<?php if ($sub_process_type_list->Pager->RecordCount > 0 && $sub_process_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sub_process_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sub_process_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sub_process_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sub_process_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sub_process_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sub_process_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sub_process_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sub_process_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sub_process_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sub_process_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sub_process_type_list->TotalRecs > 0 && (!$sub_process_type_list->AutoHidePageSizeSelector || $sub_process_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sub_process_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sub_process_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sub_process_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sub_process_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sub_process_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sub_process_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sub_process_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sub_process_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsub_process_typelist" id="fsub_process_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sub_process_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sub_process_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sub_process_type">
<div id="gmp_sub_process_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sub_process_type_list->TotalRecs > 0 || $sub_process_type->isGridEdit()) { ?>
<table id="tbl_sub_process_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sub_process_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$sub_process_type_list->renderListOptions();

// Render list options (header, left)
$sub_process_type_list->ListOptions->render("header", "left");
?>
<?php if ($sub_process_type->id->Visible) { // id ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $sub_process_type->id->headerCellClass() ?>"><div id="elh_sub_process_type_id" class="sub_process_type_id"><div class="ew-table-header-caption"><?php echo $sub_process_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sub_process_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->id) ?>',2);"><div id="elh_sub_process_type_id" class="sub_process_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->grp->Visible) { // grp ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $sub_process_type->grp->headerCellClass() ?>"><div id="elh_sub_process_type_grp" class="sub_process_type_grp"><div class="ew-table-header-caption"><?php echo $sub_process_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $sub_process_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->grp) ?>',2);"><div id="elh_sub_process_type_grp" class="sub_process_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->s_grp->Visible) { // s_grp ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $sub_process_type->s_grp->headerCellClass() ?>"><div id="elh_sub_process_type_s_grp" class="sub_process_type_s_grp"><div class="ew-table-header-caption"><?php echo $sub_process_type->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $sub_process_type->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->s_grp) ?>',2);"><div id="elh_sub_process_type_s_grp" class="sub_process_type_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->name->Visible) { // name ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->name) == "") { ?>
		<th data-name="name" class="<?php echo $sub_process_type->name->headerCellClass() ?>"><div id="elh_sub_process_type_name" class="sub_process_type_name"><div class="ew-table-header-caption"><?php echo $sub_process_type->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $sub_process_type->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->name) ?>',2);"><div id="elh_sub_process_type_name" class="sub_process_type_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->type->Visible) { // type ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->type) == "") { ?>
		<th data-name="type" class="<?php echo $sub_process_type->type->headerCellClass() ?>"><div id="elh_sub_process_type_type" class="sub_process_type_type"><div class="ew-table-header-caption"><?php echo $sub_process_type->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $sub_process_type->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->type) ?>',2);"><div id="elh_sub_process_type_type" class="sub_process_type_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->type_cat->Visible) { // type_cat ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->type_cat) == "") { ?>
		<th data-name="type_cat" class="<?php echo $sub_process_type->type_cat->headerCellClass() ?>"><div id="elh_sub_process_type_type_cat" class="sub_process_type_type_cat"><div class="ew-table-header-caption"><?php echo $sub_process_type->type_cat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type_cat" class="<?php echo $sub_process_type->type_cat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->type_cat) ?>',2);"><div id="elh_sub_process_type_type_cat" class="sub_process_type_type_cat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->type_cat->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->type_cat->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->type_cat->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->output_packing->Visible) { // output_packing ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->output_packing) == "") { ?>
		<th data-name="output_packing" class="<?php echo $sub_process_type->output_packing->headerCellClass() ?>"><div id="elh_sub_process_type_output_packing" class="sub_process_type_output_packing"><div class="ew-table-header-caption"><?php echo $sub_process_type->output_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="output_packing" class="<?php echo $sub_process_type->output_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->output_packing) ?>',2);"><div id="elh_sub_process_type_output_packing" class="sub_process_type_output_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->output_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->output_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->output_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->code->Visible) { // code ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->code) == "") { ?>
		<th data-name="code" class="<?php echo $sub_process_type->code->headerCellClass() ?>"><div id="elh_sub_process_type_code" class="sub_process_type_code"><div class="ew-table-header-caption"><?php echo $sub_process_type->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $sub_process_type->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->code) ?>',2);"><div id="elh_sub_process_type_code" class="sub_process_type_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->m_employee->Visible) { // m_employee ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->m_employee) == "") { ?>
		<th data-name="m_employee" class="<?php echo $sub_process_type->m_employee->headerCellClass() ?>"><div id="elh_sub_process_type_m_employee" class="sub_process_type_m_employee"><div class="ew-table-header-caption"><?php echo $sub_process_type->m_employee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_employee" class="<?php echo $sub_process_type->m_employee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->m_employee) ?>',2);"><div id="elh_sub_process_type_m_employee" class="sub_process_type_m_employee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->m_employee->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->m_employee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->m_employee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->pao->Visible) { // pao ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->pao) == "") { ?>
		<th data-name="pao" class="<?php echo $sub_process_type->pao->headerCellClass() ?>"><div id="elh_sub_process_type_pao" class="sub_process_type_pao"><div class="ew-table-header-caption"><?php echo $sub_process_type->pao->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pao" class="<?php echo $sub_process_type->pao->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->pao) ?>',2);"><div id="elh_sub_process_type_pao" class="sub_process_type_pao">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->pao->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->pao->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->pao->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->os->Visible) { // os ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->os) == "") { ?>
		<th data-name="os" class="<?php echo $sub_process_type->os->headerCellClass() ?>"><div id="elh_sub_process_type_os" class="sub_process_type_os"><div class="ew-table-header-caption"><?php echo $sub_process_type->os->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="os" class="<?php echo $sub_process_type->os->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->os) ?>',2);"><div id="elh_sub_process_type_os" class="sub_process_type_os">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->os->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->os->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->os->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->remarks->Visible) { // remarks ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $sub_process_type->remarks->headerCellClass() ?>"><div id="elh_sub_process_type_remarks" class="sub_process_type_remarks"><div class="ew-table-header-caption"><?php echo $sub_process_type->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $sub_process_type->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->remarks) ?>',2);"><div id="elh_sub_process_type_remarks" class="sub_process_type_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->status->Visible) { // status ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $sub_process_type->status->headerCellClass() ?>"><div id="elh_sub_process_type_status" class="sub_process_type_status"><div class="ew-table-header-caption"><?php echo $sub_process_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sub_process_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->status) ?>',2);"><div id="elh_sub_process_type_status" class="sub_process_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->operator->Visible) { // operator ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $sub_process_type->operator->headerCellClass() ?>"><div id="elh_sub_process_type_operator" class="sub_process_type_operator"><div class="ew-table-header-caption"><?php echo $sub_process_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $sub_process_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->operator) ?>',2);"><div id="elh_sub_process_type_operator" class="sub_process_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sub_process_type->datetime->Visible) { // datetime ?>
	<?php if ($sub_process_type->sortUrl($sub_process_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sub_process_type->datetime->headerCellClass() ?>"><div id="elh_sub_process_type_datetime" class="sub_process_type_datetime"><div class="ew-table-header-caption"><?php echo $sub_process_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sub_process_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sub_process_type->SortUrl($sub_process_type->datetime) ?>',2);"><div id="elh_sub_process_type_datetime" class="sub_process_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sub_process_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($sub_process_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sub_process_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sub_process_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sub_process_type->ExportAll && $sub_process_type->isExport()) {
	$sub_process_type_list->StopRec = $sub_process_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sub_process_type_list->TotalRecs > $sub_process_type_list->StartRec + $sub_process_type_list->DisplayRecs - 1)
		$sub_process_type_list->StopRec = $sub_process_type_list->StartRec + $sub_process_type_list->DisplayRecs - 1;
	else
		$sub_process_type_list->StopRec = $sub_process_type_list->TotalRecs;
}
$sub_process_type_list->RecCnt = $sub_process_type_list->StartRec - 1;
if ($sub_process_type_list->Recordset && !$sub_process_type_list->Recordset->EOF) {
	$sub_process_type_list->Recordset->moveFirst();
	$selectLimit = $sub_process_type_list->UseSelectLimit;
	if (!$selectLimit && $sub_process_type_list->StartRec > 1)
		$sub_process_type_list->Recordset->move($sub_process_type_list->StartRec - 1);
} elseif (!$sub_process_type->AllowAddDeleteRow && $sub_process_type_list->StopRec == 0) {
	$sub_process_type_list->StopRec = $sub_process_type->GridAddRowCount;
}

// Initialize aggregate
$sub_process_type->RowType = ROWTYPE_AGGREGATEINIT;
$sub_process_type->resetAttributes();
$sub_process_type_list->renderRow();
while ($sub_process_type_list->RecCnt < $sub_process_type_list->StopRec) {
	$sub_process_type_list->RecCnt++;
	if ($sub_process_type_list->RecCnt >= $sub_process_type_list->StartRec) {
		$sub_process_type_list->RowCnt++;

		// Set up key count
		$sub_process_type_list->KeyCount = $sub_process_type_list->RowIndex;

		// Init row class and style
		$sub_process_type->resetAttributes();
		$sub_process_type->CssClass = "";
		if ($sub_process_type->isGridAdd()) {
		} else {
			$sub_process_type_list->loadRowValues($sub_process_type_list->Recordset); // Load row values
		}
		$sub_process_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sub_process_type->RowAttrs = array_merge($sub_process_type->RowAttrs, array('data-rowindex'=>$sub_process_type_list->RowCnt, 'id'=>'r' . $sub_process_type_list->RowCnt . '_sub_process_type', 'data-rowtype'=>$sub_process_type->RowType));

		// Render row
		$sub_process_type_list->renderRow();

		// Render list options
		$sub_process_type_list->renderListOptions();
?>
	<tr<?php echo $sub_process_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sub_process_type_list->ListOptions->render("body", "left", $sub_process_type_list->RowCnt);
?>
	<?php if ($sub_process_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sub_process_type->id->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_id" class="sub_process_type_id">
<span<?php echo $sub_process_type->id->viewAttributes() ?>>
<?php echo $sub_process_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $sub_process_type->grp->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_grp" class="sub_process_type_grp">
<span<?php echo $sub_process_type->grp->viewAttributes() ?>>
<?php echo $sub_process_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $sub_process_type->s_grp->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_s_grp" class="sub_process_type_s_grp">
<span<?php echo $sub_process_type->s_grp->viewAttributes() ?>>
<?php echo $sub_process_type->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->name->Visible) { // name ?>
		<td data-name="name"<?php echo $sub_process_type->name->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_name" class="sub_process_type_name">
<span<?php echo $sub_process_type->name->viewAttributes() ?>>
<?php echo $sub_process_type->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->type->Visible) { // type ?>
		<td data-name="type"<?php echo $sub_process_type->type->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_type" class="sub_process_type_type">
<span<?php echo $sub_process_type->type->viewAttributes() ?>>
<?php echo $sub_process_type->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->type_cat->Visible) { // type_cat ?>
		<td data-name="type_cat"<?php echo $sub_process_type->type_cat->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_type_cat" class="sub_process_type_type_cat">
<span<?php echo $sub_process_type->type_cat->viewAttributes() ?>>
<?php echo $sub_process_type->type_cat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->output_packing->Visible) { // output_packing ?>
		<td data-name="output_packing"<?php echo $sub_process_type->output_packing->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_output_packing" class="sub_process_type_output_packing">
<span<?php echo $sub_process_type->output_packing->viewAttributes() ?>>
<?php echo $sub_process_type->output_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->code->Visible) { // code ?>
		<td data-name="code"<?php echo $sub_process_type->code->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_code" class="sub_process_type_code">
<span<?php echo $sub_process_type->code->viewAttributes() ?>>
<?php echo $sub_process_type->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->m_employee->Visible) { // m_employee ?>
		<td data-name="m_employee"<?php echo $sub_process_type->m_employee->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_m_employee" class="sub_process_type_m_employee">
<span<?php echo $sub_process_type->m_employee->viewAttributes() ?>>
<?php echo $sub_process_type->m_employee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->pao->Visible) { // pao ?>
		<td data-name="pao"<?php echo $sub_process_type->pao->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_pao" class="sub_process_type_pao">
<span<?php echo $sub_process_type->pao->viewAttributes() ?>>
<?php echo $sub_process_type->pao->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->os->Visible) { // os ?>
		<td data-name="os"<?php echo $sub_process_type->os->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_os" class="sub_process_type_os">
<span<?php echo $sub_process_type->os->viewAttributes() ?>>
<?php echo $sub_process_type->os->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $sub_process_type->remarks->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_remarks" class="sub_process_type_remarks">
<span<?php echo $sub_process_type->remarks->viewAttributes() ?>>
<?php echo $sub_process_type->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sub_process_type->status->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_status" class="sub_process_type_status">
<span<?php echo $sub_process_type->status->viewAttributes() ?>>
<?php echo $sub_process_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $sub_process_type->operator->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_operator" class="sub_process_type_operator">
<span<?php echo $sub_process_type->operator->viewAttributes() ?>>
<?php echo $sub_process_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sub_process_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sub_process_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $sub_process_type_list->RowCnt ?>_sub_process_type_datetime" class="sub_process_type_datetime">
<span<?php echo $sub_process_type->datetime->viewAttributes() ?>>
<?php echo $sub_process_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sub_process_type_list->ListOptions->render("body", "right", $sub_process_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sub_process_type->isGridAdd())
		$sub_process_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sub_process_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sub_process_type_list->Recordset)
	$sub_process_type_list->Recordset->Close();
?>
<?php if (!$sub_process_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sub_process_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sub_process_type_list->Pager)) $sub_process_type_list->Pager = new PrevNextPager($sub_process_type_list->StartRec, $sub_process_type_list->DisplayRecs, $sub_process_type_list->TotalRecs, $sub_process_type_list->AutoHidePager) ?>
<?php if ($sub_process_type_list->Pager->RecordCount > 0 && $sub_process_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sub_process_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sub_process_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sub_process_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sub_process_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sub_process_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sub_process_type_list->pageUrl() ?>start=<?php echo $sub_process_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sub_process_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sub_process_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sub_process_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sub_process_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sub_process_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sub_process_type_list->TotalRecs > 0 && (!$sub_process_type_list->AutoHidePageSizeSelector || $sub_process_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sub_process_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sub_process_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sub_process_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sub_process_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sub_process_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sub_process_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sub_process_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sub_process_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sub_process_type_list->TotalRecs == 0 && !$sub_process_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sub_process_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sub_process_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sub_process_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sub_process_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sub_process_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sub_process_type_list->terminate();
?>