<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_balance_detailed_list = new t_balance_detailed_list();

// Run the page
$t_balance_detailed_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_balance_detailed_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_balance_detailed->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_balance_detailedlist = currentForm = new ew.Form("ft_balance_detailedlist", "list");
ft_balance_detailedlist.formKeyCountName = '<?php echo $t_balance_detailed_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_balance_detailedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_balance_detailedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_balance_detailedlist.lists["x_trip"] = <?php echo $t_balance_detailed_list->trip->Lookup->toClientList() ?>;
ft_balance_detailedlist.lists["x_trip"].options = <?php echo JsonEncode($t_balance_detailed_list->trip->lookupOptions()) ?>;
ft_balance_detailedlist.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_balance_detailedlist.lists["x_name"] = <?php echo $t_balance_detailed_list->name->Lookup->toClientList() ?>;
ft_balance_detailedlist.lists["x_name"].options = <?php echo JsonEncode($t_balance_detailed_list->name->lookupOptions()) ?>;

// Form object for search
var ft_balance_detailedlistsrch = currentSearchForm = new ew.Form("ft_balance_detailedlistsrch");

// Validate function for search
ft_balance_detailedlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_balance_detailed->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_balance_detailedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_balance_detailedlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_balance_detailedlistsrch.lists["x_trip"] = <?php echo $t_balance_detailed_list->trip->Lookup->toClientList() ?>;
ft_balance_detailedlistsrch.lists["x_trip"].options = <?php echo JsonEncode($t_balance_detailed_list->trip->lookupOptions()) ?>;
ft_balance_detailedlistsrch.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_balance_detailedlistsrch.lists["x_name"] = <?php echo $t_balance_detailed_list->name->Lookup->toClientList() ?>;
ft_balance_detailedlistsrch.lists["x_name"].options = <?php echo JsonEncode($t_balance_detailed_list->name->lookupOptions()) ?>;

// Filters
ft_balance_detailedlistsrch.filterList = <?php echo $t_balance_detailed_list->getFilterList() ?>;

// Init search panel as collapsed
ft_balance_detailedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_balance_detailed->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_balance_detailed_list->TotalRecs > 0 && $t_balance_detailed_list->ExportOptions->visible()) { ?>
<?php $t_balance_detailed_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_detailed_list->ImportOptions->visible()) { ?>
<?php $t_balance_detailed_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_detailed_list->SearchOptions->visible()) { ?>
<?php $t_balance_detailed_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_detailed_list->FilterOptions->visible()) { ?>
<?php $t_balance_detailed_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_balance_detailed_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_balance_detailed->isExport() && !$t_balance_detailed->CurrentAction) { ?>
<form name="ft_balance_detailedlistsrch" id="ft_balance_detailedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_balance_detailed_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_balance_detailedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_balance_detailed">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_balance_detailed_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_balance_detailed->RowType = ROWTYPE_SEARCH;

// Render row
$t_balance_detailed->resetAttributes();
$t_balance_detailed_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_balance_detailed->trip->Visible) { // trip ?>
	<div id="xsc_trip" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_balance_detailed->trip->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_balance_detailed->trip->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_balance_detailed->trip->EditAttrs["onchange"] = "";
?>
<span id="as_x_trip" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_trip" id="sv_x_trip" value="<?php echo RemoveHtml($t_balance_detailed->trip->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_balance_detailed->trip->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_balance_detailed->trip->getPlaceHolder()) ?>"<?php echo $t_balance_detailed->trip->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_balance_detailed->trip->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_trip',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($t_balance_detailed->trip->ReadOnly || $t_balance_detailed->trip->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_balance_detailed" data-field="x_trip" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_balance_detailed->trip->displayValueSeparatorAttribute() ?>" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_balance_detailed->trip->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_balance_detailedlistsrch.createAutoSuggest({"id":"x_trip","forceSelect":false});
</script>
<?php echo $t_balance_detailed->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_balance_detailed->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $t_balance_detailed->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_name"><?php echo strval($t_balance_detailed->name->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($t_balance_detailed->name->AdvancedSearch->ViewValue) : $t_balance_detailed->name->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_balance_detailed->name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($t_balance_detailed->name->ReadOnly || $t_balance_detailed->name->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_name',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $t_balance_detailed->name->Lookup->getParamTag("p_x_name") ?>
<input type="hidden" data-table="t_balance_detailed" data-field="x_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_balance_detailed->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo $t_balance_detailed->name->AdvancedSearch->SearchValue ?>"<?php echo $t_balance_detailed->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($t_balance_detailed->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label for="x_ref" class="ew-search-caption ew-label"><?php echo $t_balance_detailed->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="t_balance_detailed" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_balance_detailed->ref->getPlaceHolder()) ?>" value="<?php echo $t_balance_detailed->ref->EditValue ?>"<?php echo $t_balance_detailed->ref->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($t_balance_detailed->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $t_balance_detailed->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($t_balance_detailed->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_balance_detailed" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $t_balance_detailed->dated->EditValue ?>"<?php echo $t_balance_detailed->dated->editAttributes() ?>>
<?php if (!$t_balance_detailed->dated->ReadOnly && !$t_balance_detailed->dated->Disabled && !isset($t_balance_detailed->dated->EditAttrs["readonly"]) && !isset($t_balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_balance_detailedlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="t_balance_detailed" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($t_balance_detailed->dated->getPlaceHolder()) ?>" value="<?php echo $t_balance_detailed->dated->EditValue2 ?>"<?php echo $t_balance_detailed->dated->editAttributes() ?>>
<?php if (!$t_balance_detailed->dated->ReadOnly && !$t_balance_detailed->dated->Disabled && !isset($t_balance_detailed->dated->EditAttrs["readonly"]) && !isset($t_balance_detailed->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_balance_detailedlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_balance_detailed_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_balance_detailed_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_balance_detailed_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_balance_detailed_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_balance_detailed_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_balance_detailed_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_balance_detailed_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_balance_detailed_list->showPageHeader(); ?>
<?php
$t_balance_detailed_list->showMessage();
?>
<?php if ($t_balance_detailed_list->TotalRecs > 0 || $t_balance_detailed->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_balance_detailed_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_balance_detailed">
<?php if (!$t_balance_detailed->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_balance_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_balance_detailed_list->Pager)) $t_balance_detailed_list->Pager = new PrevNextPager($t_balance_detailed_list->StartRec, $t_balance_detailed_list->DisplayRecs, $t_balance_detailed_list->TotalRecs, $t_balance_detailed_list->AutoHidePager) ?>
<?php if ($t_balance_detailed_list->Pager->RecordCount > 0 && $t_balance_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_balance_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_balance_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_balance_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_balance_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_balance_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_balance_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_balance_detailed_list->TotalRecs > 0 && (!$t_balance_detailed_list->AutoHidePageSizeSelector || $t_balance_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_balance_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_balance_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_balance_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_balance_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_balance_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_balance_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_balance_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_balance_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_balance_detailedlist" id="ft_balance_detailedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_balance_detailed_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_balance_detailed_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_balance_detailed">
<div id="gmp_t_balance_detailed" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_balance_detailed_list->TotalRecs > 0 || $t_balance_detailed->isGridEdit()) { ?>
<table id="tbl_t_balance_detailedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_balance_detailed_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_balance_detailed_list->renderListOptions();

// Render list options (header, left)
$t_balance_detailed_list->ListOptions->render("header", "left");
?>
<?php if ($t_balance_detailed->id->Visible) { // id ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_balance_detailed->id->headerCellClass() ?>"><div id="elh_t_balance_detailed_id" class="t_balance_detailed_id"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_balance_detailed->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->id) ?>',2);"><div id="elh_t_balance_detailed_id" class="t_balance_detailed_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->trip->Visible) { // trip ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_balance_detailed->trip->headerCellClass() ?>"><div id="elh_t_balance_detailed_trip" class="t_balance_detailed_trip"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_balance_detailed->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->trip) ?>',2);"><div id="elh_t_balance_detailed_trip" class="t_balance_detailed_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->trip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->name->Visible) { // name ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->name) == "") { ?>
		<th data-name="name" class="<?php echo $t_balance_detailed->name->headerCellClass() ?>"><div id="elh_t_balance_detailed_name" class="t_balance_detailed_name"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $t_balance_detailed->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->name) ?>',2);"><div id="elh_t_balance_detailed_name" class="t_balance_detailed_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->name->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->ref->Visible) { // ref ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $t_balance_detailed->ref->headerCellClass() ?>"><div id="elh_t_balance_detailed_ref" class="t_balance_detailed_ref"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $t_balance_detailed->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->ref) ?>',2);"><div id="elh_t_balance_detailed_ref" class="t_balance_detailed_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->IN->Visible) { // IN ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $t_balance_detailed->IN->headerCellClass() ?>"><div id="elh_t_balance_detailed_IN" class="t_balance_detailed_IN"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $t_balance_detailed->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->IN) ?>',2);"><div id="elh_t_balance_detailed_IN" class="t_balance_detailed_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->IN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->OUT->Visible) { // OUT ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $t_balance_detailed->OUT->headerCellClass() ?>"><div id="elh_t_balance_detailed_OUT" class="t_balance_detailed_OUT"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $t_balance_detailed->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->OUT) ?>',2);"><div id="elh_t_balance_detailed_OUT" class="t_balance_detailed_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->Balance->Visible) { // Balance ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $t_balance_detailed->Balance->headerCellClass() ?>"><div id="elh_t_balance_detailed_Balance" class="t_balance_detailed_Balance"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $t_balance_detailed->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->Balance) ?>',2);"><div id="elh_t_balance_detailed_Balance" class="t_balance_detailed_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->Balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->dated->Visible) { // dated ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_balance_detailed->dated->headerCellClass() ?>"><div id="elh_t_balance_detailed_dated" class="t_balance_detailed_dated"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_balance_detailed->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->dated) ?>',2);"><div id="elh_t_balance_detailed_dated" class="t_balance_detailed_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->remarks->Visible) { // remarks ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_balance_detailed->remarks->headerCellClass() ?>"><div id="elh_t_balance_detailed_remarks" class="t_balance_detailed_remarks"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_balance_detailed->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->remarks) ?>',2);"><div id="elh_t_balance_detailed_remarks" class="t_balance_detailed_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance_detailed->uploads->Visible) { // uploads ?>
	<?php if ($t_balance_detailed->sortUrl($t_balance_detailed->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $t_balance_detailed->uploads->headerCellClass() ?>"><div id="elh_t_balance_detailed_uploads" class="t_balance_detailed_uploads"><div class="ew-table-header-caption"><?php echo $t_balance_detailed->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $t_balance_detailed->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance_detailed->SortUrl($t_balance_detailed->uploads) ?>',2);"><div id="elh_t_balance_detailed_uploads" class="t_balance_detailed_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance_detailed->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance_detailed->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance_detailed->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_balance_detailed_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_balance_detailed->ExportAll && $t_balance_detailed->isExport()) {
	$t_balance_detailed_list->StopRec = $t_balance_detailed_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_balance_detailed_list->TotalRecs > $t_balance_detailed_list->StartRec + $t_balance_detailed_list->DisplayRecs - 1)
		$t_balance_detailed_list->StopRec = $t_balance_detailed_list->StartRec + $t_balance_detailed_list->DisplayRecs - 1;
	else
		$t_balance_detailed_list->StopRec = $t_balance_detailed_list->TotalRecs;
}
$t_balance_detailed_list->RecCnt = $t_balance_detailed_list->StartRec - 1;
if ($t_balance_detailed_list->Recordset && !$t_balance_detailed_list->Recordset->EOF) {
	$t_balance_detailed_list->Recordset->moveFirst();
	$selectLimit = $t_balance_detailed_list->UseSelectLimit;
	if (!$selectLimit && $t_balance_detailed_list->StartRec > 1)
		$t_balance_detailed_list->Recordset->move($t_balance_detailed_list->StartRec - 1);
} elseif (!$t_balance_detailed->AllowAddDeleteRow && $t_balance_detailed_list->StopRec == 0) {
	$t_balance_detailed_list->StopRec = $t_balance_detailed->GridAddRowCount;
}

// Initialize aggregate
$t_balance_detailed->RowType = ROWTYPE_AGGREGATEINIT;
$t_balance_detailed->resetAttributes();
$t_balance_detailed_list->renderRow();
while ($t_balance_detailed_list->RecCnt < $t_balance_detailed_list->StopRec) {
	$t_balance_detailed_list->RecCnt++;
	if ($t_balance_detailed_list->RecCnt >= $t_balance_detailed_list->StartRec) {
		$t_balance_detailed_list->RowCnt++;

		// Set up key count
		$t_balance_detailed_list->KeyCount = $t_balance_detailed_list->RowIndex;

		// Init row class and style
		$t_balance_detailed->resetAttributes();
		$t_balance_detailed->CssClass = "";
		if ($t_balance_detailed->isGridAdd()) {
		} else {
			$t_balance_detailed_list->loadRowValues($t_balance_detailed_list->Recordset); // Load row values
		}
		$t_balance_detailed->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_balance_detailed->RowAttrs = array_merge($t_balance_detailed->RowAttrs, array('data-rowindex'=>$t_balance_detailed_list->RowCnt, 'id'=>'r' . $t_balance_detailed_list->RowCnt . '_t_balance_detailed', 'data-rowtype'=>$t_balance_detailed->RowType));

		// Render row
		$t_balance_detailed_list->renderRow();

		// Render list options
		$t_balance_detailed_list->renderListOptions();
?>
	<tr<?php echo $t_balance_detailed->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_balance_detailed_list->ListOptions->render("body", "left", $t_balance_detailed_list->RowCnt);
?>
	<?php if ($t_balance_detailed->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_balance_detailed->id->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_id" class="t_balance_detailed_id">
<span<?php echo $t_balance_detailed->id->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance_detailed->id->getViewValue())) && $t_balance_detailed->id->linkAttributes() <> "") { ?>
<a<?php echo $t_balance_detailed->id->linkAttributes() ?>><?php echo $t_balance_detailed->id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance_detailed->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_balance_detailed->trip->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_trip" class="t_balance_detailed_trip">
<span<?php echo $t_balance_detailed->trip->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance_detailed->trip->getViewValue())) && $t_balance_detailed->trip->linkAttributes() <> "") { ?>
<a<?php echo $t_balance_detailed->trip->linkAttributes() ?>><?php echo $t_balance_detailed->trip->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance_detailed->trip->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->name->Visible) { // name ?>
		<td data-name="name"<?php echo $t_balance_detailed->name->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_name" class="t_balance_detailed_name">
<span<?php echo $t_balance_detailed->name->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance_detailed->name->getViewValue())) && $t_balance_detailed->name->linkAttributes() <> "") { ?>
<a<?php echo $t_balance_detailed->name->linkAttributes() ?>><?php echo $t_balance_detailed->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance_detailed->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $t_balance_detailed->ref->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_ref" class="t_balance_detailed_ref">
<span<?php echo $t_balance_detailed->ref->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance_detailed->ref->getViewValue())) && $t_balance_detailed->ref->linkAttributes() <> "") { ?>
<a<?php echo $t_balance_detailed->ref->linkAttributes() ?>><?php echo $t_balance_detailed->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance_detailed->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $t_balance_detailed->IN->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_IN" class="t_balance_detailed_IN">
<span<?php echo $t_balance_detailed->IN->viewAttributes() ?>>
<?php echo $t_balance_detailed->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $t_balance_detailed->OUT->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_OUT" class="t_balance_detailed_OUT">
<span<?php echo $t_balance_detailed->OUT->viewAttributes() ?>>
<?php echo $t_balance_detailed->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $t_balance_detailed->Balance->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_Balance" class="t_balance_detailed_Balance">
<span<?php echo $t_balance_detailed->Balance->viewAttributes() ?>>
<?php echo $t_balance_detailed->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_balance_detailed->dated->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_dated" class="t_balance_detailed_dated">
<span<?php echo $t_balance_detailed->dated->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance_detailed->dated->getViewValue())) && $t_balance_detailed->dated->linkAttributes() <> "") { ?>
<a<?php echo $t_balance_detailed->dated->linkAttributes() ?>><?php echo $t_balance_detailed->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance_detailed->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_balance_detailed->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_remarks" class="t_balance_detailed_remarks">
<span<?php echo $t_balance_detailed->remarks->viewAttributes() ?>>
<?php echo $t_balance_detailed->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance_detailed->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $t_balance_detailed->uploads->cellAttributes() ?>>
<span id="el<?php echo $t_balance_detailed_list->RowCnt ?>_t_balance_detailed_uploads" class="t_balance_detailed_uploads">
<span>
<?php echo GetFileViewTag($t_balance_detailed->uploads, $t_balance_detailed->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_balance_detailed_list->ListOptions->render("body", "right", $t_balance_detailed_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_balance_detailed->isGridAdd())
		$t_balance_detailed_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$t_balance_detailed->RowType = ROWTYPE_AGGREGATE;
$t_balance_detailed->resetAttributes();
$t_balance_detailed_list->renderRow();
?>
<?php if ($t_balance_detailed_list->TotalRecs > 0 && !$t_balance_detailed->isGridAdd() && !$t_balance_detailed->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$t_balance_detailed_list->renderListOptions();

// Render list options (footer, left)
$t_balance_detailed_list->ListOptions->render("footer", "left");
?>
	<?php if ($t_balance_detailed->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $t_balance_detailed->id->footerCellClass() ?>"><span id="elf_t_balance_detailed_id" class="t_balance_detailed_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->trip->Visible) { // trip ?>
		<td data-name="trip" class="<?php echo $t_balance_detailed->trip->footerCellClass() ?>"><span id="elf_t_balance_detailed_trip" class="t_balance_detailed_trip">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $t_balance_detailed->name->footerCellClass() ?>"><span id="elf_t_balance_detailed_name" class="t_balance_detailed_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $t_balance_detailed->ref->footerCellClass() ?>"><span id="elf_t_balance_detailed_ref" class="t_balance_detailed_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $t_balance_detailed->IN->footerCellClass() ?>"><span id="elf_t_balance_detailed_IN" class="t_balance_detailed_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance_detailed->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $t_balance_detailed->OUT->footerCellClass() ?>"><span id="elf_t_balance_detailed_OUT" class="t_balance_detailed_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance_detailed->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $t_balance_detailed->Balance->footerCellClass() ?>"><span id="elf_t_balance_detailed_Balance" class="t_balance_detailed_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance_detailed->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $t_balance_detailed->dated->footerCellClass() ?>"><span id="elf_t_balance_detailed_dated" class="t_balance_detailed_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $t_balance_detailed->remarks->footerCellClass() ?>"><span id="elf_t_balance_detailed_remarks" class="t_balance_detailed_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance_detailed->uploads->Visible) { // uploads ?>
		<td data-name="uploads" class="<?php echo $t_balance_detailed->uploads->footerCellClass() ?>"><span id="elf_t_balance_detailed_uploads" class="t_balance_detailed_uploads">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$t_balance_detailed_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_balance_detailed->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_balance_detailed_list->Recordset)
	$t_balance_detailed_list->Recordset->Close();
?>
<?php if (!$t_balance_detailed->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_balance_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_balance_detailed_list->Pager)) $t_balance_detailed_list->Pager = new PrevNextPager($t_balance_detailed_list->StartRec, $t_balance_detailed_list->DisplayRecs, $t_balance_detailed_list->TotalRecs, $t_balance_detailed_list->AutoHidePager) ?>
<?php if ($t_balance_detailed_list->Pager->RecordCount > 0 && $t_balance_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_balance_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_balance_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_balance_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_balance_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_balance_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_balance_detailed_list->pageUrl() ?>start=<?php echo $t_balance_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_balance_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_balance_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_balance_detailed_list->TotalRecs > 0 && (!$t_balance_detailed_list->AutoHidePageSizeSelector || $t_balance_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_balance_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_balance_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_balance_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_balance_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_balance_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_balance_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_balance_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_balance_detailed_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_balance_detailed_list->TotalRecs == 0 && !$t_balance_detailed->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_balance_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_balance_detailed_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_balance_detailed->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_balance_detailed->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_balance_detailed", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_balance_detailed_list->terminate();
?>