<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_balance_list = new t_balance_list();

// Run the page
$t_balance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_balance_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_balance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_balancelist = currentForm = new ew.Form("ft_balancelist", "list");
ft_balancelist.formKeyCountName = '<?php echo $t_balance_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_balancelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_balancelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var ft_balancelistsrch = currentSearchForm = new ew.Form("ft_balancelistsrch");

// Filters
ft_balancelistsrch.filterList = <?php echo $t_balance_list->getFilterList() ?>;

// Init search panel as collapsed
ft_balancelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_balance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_balance_list->TotalRecs > 0 && $t_balance_list->ExportOptions->visible()) { ?>
<?php $t_balance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_list->ImportOptions->visible()) { ?>
<?php $t_balance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_list->SearchOptions->visible()) { ?>
<?php $t_balance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_balance_list->FilterOptions->visible()) { ?>
<?php $t_balance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_balance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_balance->isExport() && !$t_balance->CurrentAction) { ?>
<form name="ft_balancelistsrch" id="ft_balancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_balance_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_balancelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_balance">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_balance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_balance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_balance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_balance_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_balance_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_balance_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_balance_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_balance_list->showPageHeader(); ?>
<?php
$t_balance_list->showMessage();
?>
<?php if ($t_balance_list->TotalRecs > 0 || $t_balance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_balance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_balance">
<?php if (!$t_balance->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_balance_list->Pager)) $t_balance_list->Pager = new PrevNextPager($t_balance_list->StartRec, $t_balance_list->DisplayRecs, $t_balance_list->TotalRecs, $t_balance_list->AutoHidePager) ?>
<?php if ($t_balance_list->Pager->RecordCount > 0 && $t_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_balance_list->TotalRecs > 0 && (!$t_balance_list->AutoHidePageSizeSelector || $t_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_balancelist" id="ft_balancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_balance_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_balance_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_balance">
<div id="gmp_t_balance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_balance_list->TotalRecs > 0 || $t_balance->isGridEdit()) { ?>
<table id="tbl_t_balancelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_balance_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_balance_list->renderListOptions();

// Render list options (header, left)
$t_balance_list->ListOptions->render("header", "left");
?>
<?php if ($t_balance->name->Visible) { // name ?>
	<?php if ($t_balance->sortUrl($t_balance->name) == "") { ?>
		<th data-name="name" class="<?php echo $t_balance->name->headerCellClass() ?>"><div id="elh_t_balance_name" class="t_balance_name"><div class="ew-table-header-caption"><?php echo $t_balance->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $t_balance->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance->SortUrl($t_balance->name) ?>',2);"><div id="elh_t_balance_name" class="t_balance_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance->IN->Visible) { // IN ?>
	<?php if ($t_balance->sortUrl($t_balance->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $t_balance->IN->headerCellClass() ?>"><div id="elh_t_balance_IN" class="t_balance_IN"><div class="ew-table-header-caption"><?php echo $t_balance->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $t_balance->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance->SortUrl($t_balance->IN) ?>',2);"><div id="elh_t_balance_IN" class="t_balance_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance->IN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance->OUT->Visible) { // OUT ?>
	<?php if ($t_balance->sortUrl($t_balance->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $t_balance->OUT->headerCellClass() ?>"><div id="elh_t_balance_OUT" class="t_balance_OUT"><div class="ew-table-header-caption"><?php echo $t_balance->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $t_balance->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance->SortUrl($t_balance->OUT) ?>',2);"><div id="elh_t_balance_OUT" class="t_balance_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance->Balance->Visible) { // Balance ?>
	<?php if ($t_balance->sortUrl($t_balance->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $t_balance->Balance->headerCellClass() ?>"><div id="elh_t_balance_Balance" class="t_balance_Balance"><div class="ew-table-header-caption"><?php echo $t_balance->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $t_balance->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance->SortUrl($t_balance->Balance) ?>',2);"><div id="elh_t_balance_Balance" class="t_balance_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance->Balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_balance->r_from->Visible) { // r_from ?>
	<?php if ($t_balance->sortUrl($t_balance->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $t_balance->r_from->headerCellClass() ?>"><div id="elh_t_balance_r_from" class="t_balance_r_from"><div class="ew-table-header-caption"><?php echo $t_balance->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $t_balance->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_balance->SortUrl($t_balance->r_from) ?>',2);"><div id="elh_t_balance_r_from" class="t_balance_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_balance->r_from->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_balance->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_balance->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_balance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_balance->ExportAll && $t_balance->isExport()) {
	$t_balance_list->StopRec = $t_balance_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_balance_list->TotalRecs > $t_balance_list->StartRec + $t_balance_list->DisplayRecs - 1)
		$t_balance_list->StopRec = $t_balance_list->StartRec + $t_balance_list->DisplayRecs - 1;
	else
		$t_balance_list->StopRec = $t_balance_list->TotalRecs;
}
$t_balance_list->RecCnt = $t_balance_list->StartRec - 1;
if ($t_balance_list->Recordset && !$t_balance_list->Recordset->EOF) {
	$t_balance_list->Recordset->moveFirst();
	$selectLimit = $t_balance_list->UseSelectLimit;
	if (!$selectLimit && $t_balance_list->StartRec > 1)
		$t_balance_list->Recordset->move($t_balance_list->StartRec - 1);
} elseif (!$t_balance->AllowAddDeleteRow && $t_balance_list->StopRec == 0) {
	$t_balance_list->StopRec = $t_balance->GridAddRowCount;
}

// Initialize aggregate
$t_balance->RowType = ROWTYPE_AGGREGATEINIT;
$t_balance->resetAttributes();
$t_balance_list->renderRow();
while ($t_balance_list->RecCnt < $t_balance_list->StopRec) {
	$t_balance_list->RecCnt++;
	if ($t_balance_list->RecCnt >= $t_balance_list->StartRec) {
		$t_balance_list->RowCnt++;

		// Set up key count
		$t_balance_list->KeyCount = $t_balance_list->RowIndex;

		// Init row class and style
		$t_balance->resetAttributes();
		$t_balance->CssClass = "";
		if ($t_balance->isGridAdd()) {
		} else {
			$t_balance_list->loadRowValues($t_balance_list->Recordset); // Load row values
		}
		$t_balance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_balance->RowAttrs = array_merge($t_balance->RowAttrs, array('data-rowindex'=>$t_balance_list->RowCnt, 'id'=>'r' . $t_balance_list->RowCnt . '_t_balance', 'data-rowtype'=>$t_balance->RowType));

		// Render row
		$t_balance_list->renderRow();

		// Render list options
		$t_balance_list->renderListOptions();
?>
	<tr<?php echo $t_balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_balance_list->ListOptions->render("body", "left", $t_balance_list->RowCnt);
?>
	<?php if ($t_balance->name->Visible) { // name ?>
		<td data-name="name"<?php echo $t_balance->name->cellAttributes() ?>>
<span id="el<?php echo $t_balance_list->RowCnt ?>_t_balance_name" class="t_balance_name">
<span<?php echo $t_balance->name->viewAttributes() ?>>
<?php if ((!EmptyString($t_balance->name->getViewValue())) && $t_balance->name->linkAttributes() <> "") { ?>
<a<?php echo $t_balance->name->linkAttributes() ?>><?php echo $t_balance->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $t_balance->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $t_balance->IN->cellAttributes() ?>>
<span id="el<?php echo $t_balance_list->RowCnt ?>_t_balance_IN" class="t_balance_IN">
<span<?php echo $t_balance->IN->viewAttributes() ?>>
<?php echo $t_balance->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $t_balance->OUT->cellAttributes() ?>>
<span id="el<?php echo $t_balance_list->RowCnt ?>_t_balance_OUT" class="t_balance_OUT">
<span<?php echo $t_balance->OUT->viewAttributes() ?>>
<?php echo $t_balance->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $t_balance->Balance->cellAttributes() ?>>
<span id="el<?php echo $t_balance_list->RowCnt ?>_t_balance_Balance" class="t_balance_Balance">
<span<?php echo $t_balance->Balance->viewAttributes() ?>>
<?php echo $t_balance->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_balance->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $t_balance->r_from->cellAttributes() ?>>
<span id="el<?php echo $t_balance_list->RowCnt ?>_t_balance_r_from" class="t_balance_r_from">
<span<?php echo $t_balance->r_from->viewAttributes() ?>>
<?php echo $t_balance->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_balance_list->ListOptions->render("body", "right", $t_balance_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_balance->isGridAdd())
		$t_balance_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$t_balance->RowType = ROWTYPE_AGGREGATE;
$t_balance->resetAttributes();
$t_balance_list->renderRow();
?>
<?php if ($t_balance_list->TotalRecs > 0 && !$t_balance->isGridAdd() && !$t_balance->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$t_balance_list->renderListOptions();

// Render list options (footer, left)
$t_balance_list->ListOptions->render("footer", "left");
?>
	<?php if ($t_balance->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $t_balance->name->footerCellClass() ?>"><span id="elf_t_balance_name" class="t_balance_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($t_balance->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $t_balance->IN->footerCellClass() ?>"><span id="elf_t_balance_IN" class="t_balance_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $t_balance->OUT->footerCellClass() ?>"><span id="elf_t_balance_OUT" class="t_balance_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $t_balance->Balance->footerCellClass() ?>"><span id="elf_t_balance_Balance" class="t_balance_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $t_balance->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($t_balance->r_from->Visible) { // r_from ?>
		<td data-name="r_from" class="<?php echo $t_balance->r_from->footerCellClass() ?>"><span id="elf_t_balance_r_from" class="t_balance_r_from">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$t_balance_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_balance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_balance_list->Recordset)
	$t_balance_list->Recordset->Close();
?>
<?php if (!$t_balance->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_balance_list->Pager)) $t_balance_list->Pager = new PrevNextPager($t_balance_list->StartRec, $t_balance_list->DisplayRecs, $t_balance_list->TotalRecs, $t_balance_list->AutoHidePager) ?>
<?php if ($t_balance_list->Pager->RecordCount > 0 && $t_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_balance_list->pageUrl() ?>start=<?php echo $t_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_balance_list->TotalRecs > 0 && (!$t_balance_list->AutoHidePageSizeSelector || $t_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_balance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_balance_list->TotalRecs == 0 && !$t_balance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_balance_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_balance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_balance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_balance", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_balance_list->terminate();
?>