<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_balance_search = new t_balance_search();

// Run the page
$t_balance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_balance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_balance_search->IsModal) { ?>
var ft_balancesearch = currentAdvancedSearchForm = new ew.Form("ft_balancesearch", "search");
<?php } else { ?>
var ft_balancesearch = currentForm = new ew.Form("ft_balancesearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_balancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_balancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

ft_balancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_balance->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_balance->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_balance->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_balance->r_from->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_balance_search->showPageHeader(); ?>
<?php
$t_balance_search->showMessage();
?>
<form name="ft_balancesearch" id="ft_balancesearch" class="<?php echo $t_balance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_balance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_balance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_balance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_balance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_balance->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $t_balance_search->LeftColumnClass ?>"><span id="elh_t_balance_name"><?php echo $t_balance->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_balance_search->RightColumnClass ?>"><div<?php echo $t_balance->name->cellAttributes() ?>>
			<span id="el_t_balance_name">
<input type="text" data-table="t_balance" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($t_balance->name->getPlaceHolder()) ?>" value="<?php echo $t_balance->name->EditValue ?>"<?php echo $t_balance->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_balance->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $t_balance_search->LeftColumnClass ?>"><span id="elh_t_balance_IN"><?php echo $t_balance->IN->caption() ?></span>
		</label>
		<div class="<?php echo $t_balance_search->RightColumnClass ?>"><div<?php echo $t_balance->IN->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_IN" id="z_IN" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_balance->IN->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_balance_IN">
<input type="text" data-table="t_balance" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($t_balance->IN->getPlaceHolder()) ?>" value="<?php echo $t_balance->IN->EditValue ?>"<?php echo $t_balance->IN->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_IN d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_balance_IN" class="btw1_IN d-none">
<input type="text" data-table="t_balance" data-field="x_IN" name="y_IN" id="y_IN" size="30" placeholder="<?php echo HtmlEncode($t_balance->IN->getPlaceHolder()) ?>" value="<?php echo $t_balance->IN->EditValue2 ?>"<?php echo $t_balance->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_balance->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $t_balance_search->LeftColumnClass ?>"><span id="elh_t_balance_OUT"><?php echo $t_balance->OUT->caption() ?></span>
		</label>
		<div class="<?php echo $t_balance_search->RightColumnClass ?>"><div<?php echo $t_balance->OUT->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_OUT" id="z_OUT" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_balance->OUT->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_balance_OUT">
<input type="text" data-table="t_balance" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($t_balance->OUT->getPlaceHolder()) ?>" value="<?php echo $t_balance->OUT->EditValue ?>"<?php echo $t_balance->OUT->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_OUT d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_balance_OUT" class="btw1_OUT d-none">
<input type="text" data-table="t_balance" data-field="x_OUT" name="y_OUT" id="y_OUT" size="30" placeholder="<?php echo HtmlEncode($t_balance->OUT->getPlaceHolder()) ?>" value="<?php echo $t_balance->OUT->EditValue2 ?>"<?php echo $t_balance->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_balance->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $t_balance_search->LeftColumnClass ?>"><span id="elh_t_balance_Balance"><?php echo $t_balance->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $t_balance_search->RightColumnClass ?>"><div<?php echo $t_balance->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_balance->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_balance_Balance">
<input type="text" data-table="t_balance" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($t_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_balance->Balance->EditValue ?>"<?php echo $t_balance->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_balance_Balance" class="btw1_Balance d-none">
<input type="text" data-table="t_balance" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($t_balance->Balance->getPlaceHolder()) ?>" value="<?php echo $t_balance->Balance->EditValue2 ?>"<?php echo $t_balance->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_balance->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label for="x_r_from" class="<?php echo $t_balance_search->LeftColumnClass ?>"><span id="elh_t_balance_r_from"><?php echo $t_balance->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $t_balance_search->RightColumnClass ?>"><div<?php echo $t_balance->r_from->cellAttributes() ?>>
			<span id="el_t_balance_r_from">
<input type="text" data-table="t_balance" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" placeholder="<?php echo HtmlEncode($t_balance->r_from->getPlaceHolder()) ?>" value="<?php echo $t_balance->r_from->EditValue ?>"<?php echo $t_balance->r_from->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_balance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_balance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_balance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_balance_search->terminate();
?>