<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_daily_km_edit = new t_daily_km_edit();

// Run the page
$t_daily_km_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_daily_km_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_daily_kmedit = currentForm = new ew.Form("ft_daily_kmedit", "edit");

// Validate form
ft_daily_kmedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_daily_km_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->id->caption(), $t_daily_km->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_edit->vehicle_no->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->vehicle_no->caption(), $t_daily_km->vehicle_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->vehicle_no->errorMessage()) ?>");
		<?php if ($t_daily_km_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->trip->caption(), $t_daily_km->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->driver->caption(), $t_daily_km->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_edit->old_km->Required) { ?>
			elm = this.getElements("x" + infix + "_old_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->old_km->caption(), $t_daily_km->old_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_old_km");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->old_km->errorMessage()) ?>");
		<?php if ($t_daily_km_edit->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->km->caption(), $t_daily_km->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->km->errorMessage()) ?>");
		<?php if ($t_daily_km_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->dated->caption(), $t_daily_km->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkShortEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->dated->errorMessage()) ?>");
		<?php if ($t_daily_km_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->remarks->caption(), $t_daily_km->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->operator->caption(), $t_daily_km->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->datetime->caption(), $t_daily_km->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_daily_kmedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_daily_kmedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_daily_kmedit.lists["x_vehicle_no"] = <?php echo $t_daily_km_edit->vehicle_no->Lookup->toClientList() ?>;
ft_daily_kmedit.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_daily_km_edit->vehicle_no->lookupOptions()) ?>;
ft_daily_kmedit.autoSuggests["x_vehicle_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmedit.lists["x_trip"] = <?php echo $t_daily_km_edit->trip->Lookup->toClientList() ?>;
ft_daily_kmedit.lists["x_trip"].options = <?php echo JsonEncode($t_daily_km_edit->trip->lookupOptions()) ?>;
ft_daily_kmedit.lists["x_driver"] = <?php echo $t_daily_km_edit->driver->Lookup->toClientList() ?>;
ft_daily_kmedit.lists["x_driver"].options = <?php echo JsonEncode($t_daily_km_edit->driver->lookupOptions()) ?>;
ft_daily_kmedit.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmedit.lists["x_operator"] = <?php echo $t_daily_km_edit->operator->Lookup->toClientList() ?>;
ft_daily_kmedit.lists["x_operator"].options = <?php echo JsonEncode($t_daily_km_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_daily_km_edit->showPageHeader(); ?>
<?php
$t_daily_km_edit->showMessage();
?>
<form name="ft_daily_kmedit" id="ft_daily_kmedit" class="<?php echo $t_daily_km_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_daily_km_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_daily_km_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_daily_km_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_daily_km->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_daily_km_id" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->id->caption() ?><?php echo ($t_daily_km->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->id->cellAttributes() ?>>
<span id="el_t_daily_km_id">
<span<?php echo $t_daily_km->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_daily_km->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_daily_km->id->CurrentValue) ?>">
<?php echo $t_daily_km->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label id="elh_t_daily_km_vehicle_no" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->vehicle_no->caption() ?><?php echo ($t_daily_km->vehicle_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->vehicle_no->cellAttributes() ?>>
<span id="el_t_daily_km_vehicle_no">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle_no" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle_no" id="sv_x_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x_vehicle_no" id="x_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmedit.createAutoSuggest({"id":"x_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
<?php echo $t_daily_km->vehicle_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_daily_km_trip" for="x_trip" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->trip->caption() ?><?php echo ($t_daily_km->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->trip->cellAttributes() ?>>
<span id="el_t_daily_km_trip">
<?php $t_daily_km->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_daily_km->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x_trip" name="x_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
<?php echo $t_daily_km->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_t_daily_km_driver" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->driver->caption() ?><?php echo ($t_daily_km->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->driver->cellAttributes() ?>>
<span id="el_t_daily_km_driver">
<?php
$wrkonchange = "" . trim(@$t_daily_km->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_daily_km->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>"<?php echo $t_daily_km->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-value-separator="<?php echo $t_daily_km->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_daily_km->driver->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmedit.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_daily_km->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
<?php echo $t_daily_km->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
	<div id="r_old_km" class="form-group row">
		<label id="elh_t_daily_km_old_km" for="x_old_km" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->old_km->caption() ?><?php echo ($t_daily_km->old_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->old_km->cellAttributes() ?>>
<span id="el_t_daily_km_old_km">
<input type="text" data-table="t_daily_km" data-field="x_old_km" name="x_old_km" id="x_old_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->old_km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->old_km->EditValue ?>"<?php echo $t_daily_km->old_km->editAttributes() ?>>
</span>
<?php echo $t_daily_km->old_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label id="elh_t_daily_km_km" for="x_km" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->km->caption() ?><?php echo ($t_daily_km->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->km->cellAttributes() ?>>
<span id="el_t_daily_km_km">
<input type="text" data-table="t_daily_km" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
<?php echo $t_daily_km->km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_daily_km_dated" for="x_dated" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->dated->caption() ?><?php echo ($t_daily_km->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->dated->cellAttributes() ?>>
<span id="el_t_daily_km_dated">
<input type="text" data-table="t_daily_km" data-field="x_dated" data-format="17" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_daily_km->dated->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->dated->EditValue ?>"<?php echo $t_daily_km->dated->editAttributes() ?>>
<?php if (!$t_daily_km->dated->ReadOnly && !$t_daily_km->dated->Disabled && !isset($t_daily_km->dated->EditAttrs["readonly"]) && !isset($t_daily_km->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":17});
</script>
<?php } ?>
</span>
<?php echo $t_daily_km->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_daily_km_remarks" for="x_remarks" class="<?php echo $t_daily_km_edit->LeftColumnClass ?>"><?php echo $t_daily_km->remarks->caption() ?><?php echo ($t_daily_km->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_daily_km_edit->RightColumnClass ?>"><div<?php echo $t_daily_km->remarks->cellAttributes() ?>>
<span id="el_t_daily_km_remarks">
<input type="text" data-table="t_daily_km" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($t_daily_km->remarks->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->remarks->EditValue ?>"<?php echo $t_daily_km->remarks->editAttributes() ?>>
</span>
<?php echo $t_daily_km->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_daily_km_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_daily_km_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_daily_km_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_daily_km_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_daily_km_edit->terminate();
?>