<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_daily_km_list = new t_daily_km_list();

// Run the page
$t_daily_km_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_daily_km_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_daily_km->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_daily_kmlist = currentForm = new ew.Form("ft_daily_kmlist", "list");
ft_daily_kmlist.formKeyCountName = '<?php echo $t_daily_km_list->FormKeyCountName ?>';

// Validate form
ft_daily_kmlist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_daily_km_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->id->caption(), $t_daily_km->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_list->vehicle_no->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->vehicle_no->caption(), $t_daily_km->vehicle_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->vehicle_no->errorMessage()) ?>");
		<?php if ($t_daily_km_list->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->trip->caption(), $t_daily_km->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_list->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->driver->caption(), $t_daily_km->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_list->old_km->Required) { ?>
			elm = this.getElements("x" + infix + "_old_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->old_km->caption(), $t_daily_km->old_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_old_km");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->old_km->errorMessage()) ?>");
		<?php if ($t_daily_km_list->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->km->caption(), $t_daily_km->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->km->errorMessage()) ?>");
		<?php if ($t_daily_km_list->run->Required) { ?>
			elm = this.getElements("x" + infix + "_run");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->run->caption(), $t_daily_km->run->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_run");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->run->errorMessage()) ?>");
		<?php if ($t_daily_km_list->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->dated->caption(), $t_daily_km->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkShortEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_daily_km->dated->errorMessage()) ?>");
		<?php if ($t_daily_km_list->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->remarks->caption(), $t_daily_km->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_list->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->operator->caption(), $t_daily_km->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_daily_km_list->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_daily_km->datetime->caption(), $t_daily_km->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_daily_kmlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_daily_kmlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_daily_kmlist.lists["x_vehicle_no"] = <?php echo $t_daily_km_list->vehicle_no->Lookup->toClientList() ?>;
ft_daily_kmlist.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_daily_km_list->vehicle_no->lookupOptions()) ?>;
ft_daily_kmlist.autoSuggests["x_vehicle_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmlist.lists["x_trip"] = <?php echo $t_daily_km_list->trip->Lookup->toClientList() ?>;
ft_daily_kmlist.lists["x_trip"].options = <?php echo JsonEncode($t_daily_km_list->trip->lookupOptions()) ?>;
ft_daily_kmlist.lists["x_driver"] = <?php echo $t_daily_km_list->driver->Lookup->toClientList() ?>;
ft_daily_kmlist.lists["x_driver"].options = <?php echo JsonEncode($t_daily_km_list->driver->lookupOptions()) ?>;
ft_daily_kmlist.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmlist.lists["x_operator"] = <?php echo $t_daily_km_list->operator->Lookup->toClientList() ?>;
ft_daily_kmlist.lists["x_operator"].options = <?php echo JsonEncode($t_daily_km_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_daily_kmlistsrch = currentSearchForm = new ew.Form("ft_daily_kmlistsrch");

// Validate function for search
ft_daily_kmlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_vehicle_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->vehicle_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_daily_kmlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_daily_kmlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_daily_kmlistsrch.lists["x_vehicle_no"] = <?php echo $t_daily_km_list->vehicle_no->Lookup->toClientList() ?>;
ft_daily_kmlistsrch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_daily_km_list->vehicle_no->lookupOptions()) ?>;
ft_daily_kmlistsrch.autoSuggests["x_vehicle_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmlistsrch.lists["x_trip"] = <?php echo $t_daily_km_list->trip->Lookup->toClientList() ?>;
ft_daily_kmlistsrch.lists["x_trip"].options = <?php echo JsonEncode($t_daily_km_list->trip->lookupOptions()) ?>;

// Filters
ft_daily_kmlistsrch.filterList = <?php echo $t_daily_km_list->getFilterList() ?>;

// Init search panel as collapsed
ft_daily_kmlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_daily_km->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_daily_km_list->TotalRecs > 0 && $t_daily_km_list->ExportOptions->visible()) { ?>
<?php $t_daily_km_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_daily_km_list->ImportOptions->visible()) { ?>
<?php $t_daily_km_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_daily_km_list->SearchOptions->visible()) { ?>
<?php $t_daily_km_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_daily_km_list->FilterOptions->visible()) { ?>
<?php $t_daily_km_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_daily_km_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_daily_km->isExport() && !$t_daily_km->CurrentAction) { ?>
<form name="ft_daily_kmlistsrch" id="ft_daily_kmlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_daily_km_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_daily_kmlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_daily_km">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_daily_km_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_daily_km->RowType = ROWTYPE_SEARCH;

// Render row
$t_daily_km->resetAttributes();
$t_daily_km_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
	<div id="xsc_vehicle_no" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_daily_km->vehicle_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle_no" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle_no" id="sv_x_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x_vehicle_no" id="x_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlistsrch.createAutoSuggest({"id":"x_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_daily_km->trip->Visible) { // trip ?>
	<div id="xsc_trip" class="ew-cell form-group">
		<label for="x_trip" class="ew-search-caption ew-label"><?php echo $t_daily_km->trip->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x_trip" name="x_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_daily_km_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_daily_km_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_daily_km_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_daily_km_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_daily_km_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_daily_km_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_daily_km_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_daily_km_list->showPageHeader(); ?>
<?php
$t_daily_km_list->showMessage();
?>
<?php if ($t_daily_km_list->TotalRecs > 0 || $t_daily_km->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_daily_km_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_daily_km">
<?php if (!$t_daily_km->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_daily_km->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_daily_km_list->Pager)) $t_daily_km_list->Pager = new PrevNextPager($t_daily_km_list->StartRec, $t_daily_km_list->DisplayRecs, $t_daily_km_list->TotalRecs, $t_daily_km_list->AutoHidePager) ?>
<?php if ($t_daily_km_list->Pager->RecordCount > 0 && $t_daily_km_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_daily_km_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_daily_km_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_daily_km_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_daily_km_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_daily_km_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_daily_km_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_daily_km_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_daily_km_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_daily_km_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_daily_km_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_daily_km_list->TotalRecs > 0 && (!$t_daily_km_list->AutoHidePageSizeSelector || $t_daily_km_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_daily_km">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_daily_km_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_daily_km_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_daily_km_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_daily_km_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_daily_km_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_daily_km->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_daily_km_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_daily_kmlist" id="ft_daily_kmlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_daily_km_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_daily_km_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<div id="gmp_t_daily_km" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_daily_km_list->TotalRecs > 0 || $t_daily_km->isGridEdit()) { ?>
<table id="tbl_t_daily_kmlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_daily_km_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_daily_km_list->renderListOptions();

// Render list options (header, left)
$t_daily_km_list->ListOptions->render("header", "left");
?>
<?php if ($t_daily_km->id->Visible) { // id ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_daily_km->id->headerCellClass() ?>"><div id="elh_t_daily_km_id" class="t_daily_km_id"><div class="ew-table-header-caption"><?php echo $t_daily_km->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_daily_km->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->id) ?>',2);"><div id="elh_t_daily_km_id" class="t_daily_km_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->vehicle_no) == "") { ?>
		<th data-name="vehicle_no" class="<?php echo $t_daily_km->vehicle_no->headerCellClass() ?>"><div id="elh_t_daily_km_vehicle_no" class="t_daily_km_vehicle_no"><div class="ew-table-header-caption"><?php echo $t_daily_km->vehicle_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_no" class="<?php echo $t_daily_km->vehicle_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->vehicle_no) ?>',2);"><div id="elh_t_daily_km_vehicle_no" class="t_daily_km_vehicle_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->vehicle_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->vehicle_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->vehicle_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->trip->Visible) { // trip ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->trip) == "") { ?>
		<th data-name="trip" class="<?php echo $t_daily_km->trip->headerCellClass() ?>"><div id="elh_t_daily_km_trip" class="t_daily_km_trip"><div class="ew-table-header-caption"><?php echo $t_daily_km->trip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trip" class="<?php echo $t_daily_km->trip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->trip) ?>',2);"><div id="elh_t_daily_km_trip" class="t_daily_km_trip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->trip->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->trip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->trip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->driver->Visible) { // driver ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_daily_km->driver->headerCellClass() ?>"><div id="elh_t_daily_km_driver" class="t_daily_km_driver"><div class="ew-table-header-caption"><?php echo $t_daily_km->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_daily_km->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->driver) ?>',2);"><div id="elh_t_daily_km_driver" class="t_daily_km_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->driver->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->old_km) == "") { ?>
		<th data-name="old_km" class="<?php echo $t_daily_km->old_km->headerCellClass() ?>"><div id="elh_t_daily_km_old_km" class="t_daily_km_old_km"><div class="ew-table-header-caption"><?php echo $t_daily_km->old_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="old_km" class="<?php echo $t_daily_km->old_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->old_km) ?>',2);"><div id="elh_t_daily_km_old_km" class="t_daily_km_old_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->old_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->old_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->old_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->km->Visible) { // km ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->km) == "") { ?>
		<th data-name="km" class="<?php echo $t_daily_km->km->headerCellClass() ?>"><div id="elh_t_daily_km_km" class="t_daily_km_km"><div class="ew-table-header-caption"><?php echo $t_daily_km->km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="km" class="<?php echo $t_daily_km->km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->km) ?>',2);"><div id="elh_t_daily_km_km" class="t_daily_km_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->km->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->run->Visible) { // run ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->run) == "") { ?>
		<th data-name="run" class="<?php echo $t_daily_km->run->headerCellClass() ?>"><div id="elh_t_daily_km_run" class="t_daily_km_run"><div class="ew-table-header-caption"><?php echo $t_daily_km->run->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="run" class="<?php echo $t_daily_km->run->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->run) ?>',2);"><div id="elh_t_daily_km_run" class="t_daily_km_run">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->run->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->run->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->run->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->dated->Visible) { // dated ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $t_daily_km->dated->headerCellClass() ?>"><div id="elh_t_daily_km_dated" class="t_daily_km_dated"><div class="ew-table-header-caption"><?php echo $t_daily_km->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $t_daily_km->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->dated) ?>',2);"><div id="elh_t_daily_km_dated" class="t_daily_km_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_daily_km->remarks->headerCellClass() ?>"><div id="elh_t_daily_km_remarks" class="t_daily_km_remarks"><div class="ew-table-header-caption"><?php echo $t_daily_km->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_daily_km->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->remarks) ?>',2);"><div id="elh_t_daily_km_remarks" class="t_daily_km_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->operator->Visible) { // operator ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_daily_km->operator->headerCellClass() ?>"><div id="elh_t_daily_km_operator" class="t_daily_km_operator"><div class="ew-table-header-caption"><?php echo $t_daily_km->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_daily_km->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->operator) ?>',2);"><div id="elh_t_daily_km_operator" class="t_daily_km_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_daily_km->datetime->Visible) { // datetime ?>
	<?php if ($t_daily_km->sortUrl($t_daily_km->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_daily_km->datetime->headerCellClass() ?>"><div id="elh_t_daily_km_datetime" class="t_daily_km_datetime"><div class="ew-table-header-caption"><?php echo $t_daily_km->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_daily_km->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_daily_km->SortUrl($t_daily_km->datetime) ?>',2);"><div id="elh_t_daily_km_datetime" class="t_daily_km_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_daily_km->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_daily_km->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_daily_km->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_daily_km_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_daily_km->ExportAll && $t_daily_km->isExport()) {
	$t_daily_km_list->StopRec = $t_daily_km_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_daily_km_list->TotalRecs > $t_daily_km_list->StartRec + $t_daily_km_list->DisplayRecs - 1)
		$t_daily_km_list->StopRec = $t_daily_km_list->StartRec + $t_daily_km_list->DisplayRecs - 1;
	else
		$t_daily_km_list->StopRec = $t_daily_km_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $t_daily_km_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($t_daily_km_list->FormKeyCountName) && ($t_daily_km->isGridAdd() || $t_daily_km->isGridEdit() || $t_daily_km->isConfirm())) {
		$t_daily_km_list->KeyCount = $CurrentForm->getValue($t_daily_km_list->FormKeyCountName);
		$t_daily_km_list->StopRec = $t_daily_km_list->StartRec + $t_daily_km_list->KeyCount - 1;
	}
}
$t_daily_km_list->RecCnt = $t_daily_km_list->StartRec - 1;
if ($t_daily_km_list->Recordset && !$t_daily_km_list->Recordset->EOF) {
	$t_daily_km_list->Recordset->moveFirst();
	$selectLimit = $t_daily_km_list->UseSelectLimit;
	if (!$selectLimit && $t_daily_km_list->StartRec > 1)
		$t_daily_km_list->Recordset->move($t_daily_km_list->StartRec - 1);
} elseif (!$t_daily_km->AllowAddDeleteRow && $t_daily_km_list->StopRec == 0) {
	$t_daily_km_list->StopRec = $t_daily_km->GridAddRowCount;
}

// Initialize aggregate
$t_daily_km->RowType = ROWTYPE_AGGREGATEINIT;
$t_daily_km->resetAttributes();
$t_daily_km_list->renderRow();
if ($t_daily_km->isGridEdit())
	$t_daily_km_list->RowIndex = 0;
while ($t_daily_km_list->RecCnt < $t_daily_km_list->StopRec) {
	$t_daily_km_list->RecCnt++;
	if ($t_daily_km_list->RecCnt >= $t_daily_km_list->StartRec) {
		$t_daily_km_list->RowCnt++;
		if ($t_daily_km->isGridAdd() || $t_daily_km->isGridEdit() || $t_daily_km->isConfirm()) {
			$t_daily_km_list->RowIndex++;
			$CurrentForm->Index = $t_daily_km_list->RowIndex;
			if ($CurrentForm->hasValue($t_daily_km_list->FormActionName) && $t_daily_km_list->EventCancelled)
				$t_daily_km_list->RowAction = strval($CurrentForm->getValue($t_daily_km_list->FormActionName));
			elseif ($t_daily_km->isGridAdd())
				$t_daily_km_list->RowAction = "insert";
			else
				$t_daily_km_list->RowAction = "";
		}

		// Set up key count
		$t_daily_km_list->KeyCount = $t_daily_km_list->RowIndex;

		// Init row class and style
		$t_daily_km->resetAttributes();
		$t_daily_km->CssClass = "";
		if ($t_daily_km->isGridAdd()) {
			$t_daily_km_list->loadRowValues(); // Load default values
		} else {
			$t_daily_km_list->loadRowValues($t_daily_km_list->Recordset); // Load row values
		}
		$t_daily_km->RowType = ROWTYPE_VIEW; // Render view
		if ($t_daily_km->isGridEdit()) { // Grid edit
			if ($t_daily_km->EventCancelled)
				$t_daily_km_list->restoreCurrentRowFormValues($t_daily_km_list->RowIndex); // Restore form values
			if ($t_daily_km_list->RowAction == "insert")
				$t_daily_km->RowType = ROWTYPE_ADD; // Render add
			else
				$t_daily_km->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($t_daily_km->isGridEdit() && ($t_daily_km->RowType == ROWTYPE_EDIT || $t_daily_km->RowType == ROWTYPE_ADD) && $t_daily_km->EventCancelled) // Update failed
			$t_daily_km_list->restoreCurrentRowFormValues($t_daily_km_list->RowIndex); // Restore form values
		if ($t_daily_km->RowType == ROWTYPE_EDIT) // Edit row
			$t_daily_km_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$t_daily_km->RowAttrs = array_merge($t_daily_km->RowAttrs, array('data-rowindex'=>$t_daily_km_list->RowCnt, 'id'=>'r' . $t_daily_km_list->RowCnt . '_t_daily_km', 'data-rowtype'=>$t_daily_km->RowType));

		// Render row
		$t_daily_km_list->renderRow();

		// Render list options
		$t_daily_km_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($t_daily_km_list->RowAction <> "delete" && $t_daily_km_list->RowAction <> "insertdelete" && !($t_daily_km_list->RowAction == "insert" && $t_daily_km->isConfirm() && $t_daily_km_list->emptyRow())) {
?>
	<tr<?php echo $t_daily_km->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_daily_km_list->ListOptions->render("body", "left", $t_daily_km_list->RowCnt);
?>
	<?php if ($t_daily_km->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_daily_km->id->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_daily_km" data-field="x_id" name="o<?php echo $t_daily_km_list->RowIndex ?>_id" id="o<?php echo $t_daily_km_list->RowIndex ?>_id" value="<?php echo HtmlEncode($t_daily_km->id->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_id" class="form-group t_daily_km_id">
<span<?php echo $t_daily_km->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_daily_km->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_id" name="x<?php echo $t_daily_km_list->RowIndex ?>_id" id="x<?php echo $t_daily_km_list->RowIndex ?>_id" value="<?php echo HtmlEncode($t_daily_km->id->CurrentValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_id" class="t_daily_km_id">
<span<?php echo $t_daily_km->id->viewAttributes() ?>>
<?php echo $t_daily_km->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
		<td data-name="vehicle_no"<?php echo $t_daily_km->vehicle_no->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_vehicle_no" class="form-group t_daily_km_vehicle_no">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_vehicle_no") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" name="o<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="o<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_vehicle_no" class="form-group t_daily_km_vehicle_no">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_vehicle_no") ?>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_vehicle_no" class="t_daily_km_vehicle_no">
<span<?php echo $t_daily_km->vehicle_no->viewAttributes() ?>>
<?php echo $t_daily_km->vehicle_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->trip->Visible) { // trip ?>
		<td data-name="trip"<?php echo $t_daily_km->trip->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_trip" class="form-group t_daily_km_trip">
<?php $t_daily_km->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_daily_km->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_daily_km_list->RowIndex ?>_trip" name="x<?php echo $t_daily_km_list->RowIndex ?>_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x<?php echo $t_daily_km_list->RowIndex ?>_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_trip") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_trip" name="o<?php echo $t_daily_km_list->RowIndex ?>_trip" id="o<?php echo $t_daily_km_list->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_daily_km->trip->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_trip" class="form-group t_daily_km_trip">
<?php $t_daily_km->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_daily_km->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_daily_km_list->RowIndex ?>_trip" name="x<?php echo $t_daily_km_list->RowIndex ?>_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x<?php echo $t_daily_km_list->RowIndex ?>_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_trip") ?>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_trip" class="t_daily_km_trip">
<span<?php echo $t_daily_km->trip->viewAttributes() ?>>
<?php echo $t_daily_km->trip->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_daily_km->driver->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_driver" class="form-group t_daily_km_driver">
<?php
$wrkonchange = "" . trim(@$t_daily_km->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_driver" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo RemoveHtml($t_daily_km->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>"<?php echo $t_daily_km->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-value-separator="<?php echo $t_daily_km->driver->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo HtmlEncode($t_daily_km->driver->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_driver","forceSelect":false});
</script>
<?php echo $t_daily_km->driver->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_driver") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" name="o<?php echo $t_daily_km_list->RowIndex ?>_driver" id="o<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo HtmlEncode($t_daily_km->driver->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_driver" class="form-group t_daily_km_driver">
<?php
$wrkonchange = "" . trim(@$t_daily_km->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_driver" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo RemoveHtml($t_daily_km->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>"<?php echo $t_daily_km->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-value-separator="<?php echo $t_daily_km->driver->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo HtmlEncode($t_daily_km->driver->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_driver","forceSelect":false});
</script>
<?php echo $t_daily_km->driver->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_driver") ?>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_driver" class="t_daily_km_driver">
<span<?php echo $t_daily_km->driver->viewAttributes() ?>>
<?php echo $t_daily_km->driver->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
		<td data-name="old_km"<?php echo $t_daily_km->old_km->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_old_km" class="form-group t_daily_km_old_km">
<input type="text" data-table="t_daily_km" data-field="x_old_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->old_km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->old_km->EditValue ?>"<?php echo $t_daily_km->old_km->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_old_km" name="o<?php echo $t_daily_km_list->RowIndex ?>_old_km" id="o<?php echo $t_daily_km_list->RowIndex ?>_old_km" value="<?php echo HtmlEncode($t_daily_km->old_km->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_old_km" class="form-group t_daily_km_old_km">
<input type="text" data-table="t_daily_km" data-field="x_old_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->old_km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->old_km->EditValue ?>"<?php echo $t_daily_km->old_km->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_old_km" class="t_daily_km_old_km">
<span<?php echo $t_daily_km->old_km->viewAttributes() ?>>
<?php echo $t_daily_km->old_km->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->km->Visible) { // km ?>
		<td data-name="km"<?php echo $t_daily_km->km->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_km" class="form-group t_daily_km_km">
<input type="text" data-table="t_daily_km" data-field="x_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_km" name="o<?php echo $t_daily_km_list->RowIndex ?>_km" id="o<?php echo $t_daily_km_list->RowIndex ?>_km" value="<?php echo HtmlEncode($t_daily_km->km->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_km" class="form-group t_daily_km_km">
<input type="text" data-table="t_daily_km" data-field="x_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_km" class="t_daily_km_km">
<span<?php echo $t_daily_km->km->viewAttributes() ?>>
<?php echo $t_daily_km->km->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->run->Visible) { // run ?>
		<td data-name="run"<?php echo $t_daily_km->run->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_run" class="form-group t_daily_km_run">
<input type="text" data-table="t_daily_km" data-field="x_run" name="x<?php echo $t_daily_km_list->RowIndex ?>_run" id="x<?php echo $t_daily_km_list->RowIndex ?>_run" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->run->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->run->EditValue ?>"<?php echo $t_daily_km->run->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_run" name="o<?php echo $t_daily_km_list->RowIndex ?>_run" id="o<?php echo $t_daily_km_list->RowIndex ?>_run" value="<?php echo HtmlEncode($t_daily_km->run->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_run" class="form-group t_daily_km_run">
<input type="text" data-table="t_daily_km" data-field="x_run" name="x<?php echo $t_daily_km_list->RowIndex ?>_run" id="x<?php echo $t_daily_km_list->RowIndex ?>_run" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->run->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->run->EditValue ?>"<?php echo $t_daily_km->run->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_run" class="t_daily_km_run">
<span<?php echo $t_daily_km->run->viewAttributes() ?>>
<?php echo $t_daily_km->run->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $t_daily_km->dated->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_dated" class="form-group t_daily_km_dated">
<input type="text" data-table="t_daily_km" data-field="x_dated" data-format="17" name="x<?php echo $t_daily_km_list->RowIndex ?>_dated" id="x<?php echo $t_daily_km_list->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_daily_km->dated->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->dated->EditValue ?>"<?php echo $t_daily_km->dated->editAttributes() ?>>
<?php if (!$t_daily_km->dated->ReadOnly && !$t_daily_km->dated->Disabled && !isset($t_daily_km->dated->EditAttrs["readonly"]) && !isset($t_daily_km->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmlist", "x<?php echo $t_daily_km_list->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":17});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_dated" name="o<?php echo $t_daily_km_list->RowIndex ?>_dated" id="o<?php echo $t_daily_km_list->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_daily_km->dated->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_dated" class="form-group t_daily_km_dated">
<input type="text" data-table="t_daily_km" data-field="x_dated" data-format="17" name="x<?php echo $t_daily_km_list->RowIndex ?>_dated" id="x<?php echo $t_daily_km_list->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_daily_km->dated->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->dated->EditValue ?>"<?php echo $t_daily_km->dated->editAttributes() ?>>
<?php if (!$t_daily_km->dated->ReadOnly && !$t_daily_km->dated->Disabled && !isset($t_daily_km->dated->EditAttrs["readonly"]) && !isset($t_daily_km->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmlist", "x<?php echo $t_daily_km_list->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":17});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_dated" class="t_daily_km_dated">
<span<?php echo $t_daily_km->dated->viewAttributes() ?>>
<?php echo $t_daily_km->dated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_daily_km->remarks->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_remarks" class="form-group t_daily_km_remarks">
<input type="text" data-table="t_daily_km" data-field="x_remarks" name="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" id="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($t_daily_km->remarks->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->remarks->EditValue ?>"<?php echo $t_daily_km->remarks->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_remarks" name="o<?php echo $t_daily_km_list->RowIndex ?>_remarks" id="o<?php echo $t_daily_km_list->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_daily_km->remarks->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_remarks" class="form-group t_daily_km_remarks">
<input type="text" data-table="t_daily_km" data-field="x_remarks" name="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" id="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($t_daily_km->remarks->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->remarks->EditValue ?>"<?php echo $t_daily_km->remarks->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_remarks" class="t_daily_km_remarks">
<span<?php echo $t_daily_km->remarks->viewAttributes() ?>>
<?php echo $t_daily_km->remarks->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_daily_km->operator->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_daily_km" data-field="x_operator" name="o<?php echo $t_daily_km_list->RowIndex ?>_operator" id="o<?php echo $t_daily_km_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_daily_km->operator->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_operator" class="t_daily_km_operator">
<span<?php echo $t_daily_km->operator->viewAttributes() ?>>
<?php echo $t_daily_km->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($t_daily_km->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_daily_km->datetime->cellAttributes() ?>>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="t_daily_km" data-field="x_datetime" name="o<?php echo $t_daily_km_list->RowIndex ?>_datetime" id="o<?php echo $t_daily_km_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_daily_km->datetime->OldValue) ?>">
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($t_daily_km->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $t_daily_km_list->RowCnt ?>_t_daily_km_datetime" class="t_daily_km_datetime">
<span<?php echo $t_daily_km->datetime->viewAttributes() ?>>
<?php echo $t_daily_km->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_daily_km_list->ListOptions->render("body", "right", $t_daily_km_list->RowCnt);
?>
	</tr>
<?php if ($t_daily_km->RowType == ROWTYPE_ADD || $t_daily_km->RowType == ROWTYPE_EDIT) { ?>
<script>
ft_daily_kmlist.updateLists(<?php echo $t_daily_km_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$t_daily_km->isGridAdd())
		if (!$t_daily_km_list->Recordset->EOF)
			$t_daily_km_list->Recordset->moveNext();
}
?>
<?php
	if ($t_daily_km->isGridAdd() || $t_daily_km->isGridEdit()) {
		$t_daily_km_list->RowIndex = '$rowindex$';
		$t_daily_km_list->loadRowValues();

		// Set row properties
		$t_daily_km->resetAttributes();
		$t_daily_km->RowAttrs = array_merge($t_daily_km->RowAttrs, array('data-rowindex'=>$t_daily_km_list->RowIndex, 'id'=>'r0_t_daily_km', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($t_daily_km->RowAttrs["class"], "ew-template");
		$t_daily_km->RowType = ROWTYPE_ADD;

		// Render row
		$t_daily_km_list->renderRow();

		// Render list options
		$t_daily_km_list->renderListOptions();
		$t_daily_km_list->StartRowCnt = 0;
?>
	<tr<?php echo $t_daily_km->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_daily_km_list->ListOptions->render("body", "left", $t_daily_km_list->RowIndex);
?>
	<?php if ($t_daily_km->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="t_daily_km" data-field="x_id" name="o<?php echo $t_daily_km_list->RowIndex ?>_id" id="o<?php echo $t_daily_km_list->RowIndex ?>_id" value="<?php echo HtmlEncode($t_daily_km->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
		<td data-name="vehicle_no">
<span id="el$rowindex$_t_daily_km_vehicle_no" class="form-group t_daily_km_vehicle_no">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_vehicle_no") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" name="o<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" id="o<?php echo $t_daily_km_list->RowIndex ?>_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->trip->Visible) { // trip ?>
		<td data-name="trip">
<span id="el$rowindex$_t_daily_km_trip" class="form-group t_daily_km_trip">
<?php $t_daily_km->trip->EditAttrs["onchange"] = "ew.autoFill(this);" . @$t_daily_km->trip->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x<?php echo $t_daily_km_list->RowIndex ?>_trip" name="x<?php echo $t_daily_km_list->RowIndex ?>_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x<?php echo $t_daily_km_list->RowIndex ?>_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_trip") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_trip" name="o<?php echo $t_daily_km_list->RowIndex ?>_trip" id="o<?php echo $t_daily_km_list->RowIndex ?>_trip" value="<?php echo HtmlEncode($t_daily_km->trip->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->driver->Visible) { // driver ?>
		<td data-name="driver">
<span id="el$rowindex$_t_daily_km_driver" class="form-group t_daily_km_driver">
<?php
$wrkonchange = "" . trim(@$t_daily_km->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $t_daily_km_list->RowIndex ?>_driver" class="text-nowrap" style="z-index: <?php echo (9000 - $t_daily_km_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="sv_x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo RemoveHtml($t_daily_km->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>"<?php echo $t_daily_km->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-value-separator="<?php echo $t_daily_km->driver->displayValueSeparatorAttribute() ?>" name="x<?php echo $t_daily_km_list->RowIndex ?>_driver" id="x<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo HtmlEncode($t_daily_km->driver->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmlist.createAutoSuggest({"id":"x<?php echo $t_daily_km_list->RowIndex ?>_driver","forceSelect":false});
</script>
<?php echo $t_daily_km->driver->Lookup->getParamTag("p_x" . $t_daily_km_list->RowIndex . "_driver") ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" name="o<?php echo $t_daily_km_list->RowIndex ?>_driver" id="o<?php echo $t_daily_km_list->RowIndex ?>_driver" value="<?php echo HtmlEncode($t_daily_km->driver->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
		<td data-name="old_km">
<span id="el$rowindex$_t_daily_km_old_km" class="form-group t_daily_km_old_km">
<input type="text" data-table="t_daily_km" data-field="x_old_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_old_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->old_km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->old_km->EditValue ?>"<?php echo $t_daily_km->old_km->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_old_km" name="o<?php echo $t_daily_km_list->RowIndex ?>_old_km" id="o<?php echo $t_daily_km_list->RowIndex ?>_old_km" value="<?php echo HtmlEncode($t_daily_km->old_km->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->km->Visible) { // km ?>
		<td data-name="km">
<span id="el$rowindex$_t_daily_km_km" class="form-group t_daily_km_km">
<input type="text" data-table="t_daily_km" data-field="x_km" name="x<?php echo $t_daily_km_list->RowIndex ?>_km" id="x<?php echo $t_daily_km_list->RowIndex ?>_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_km" name="o<?php echo $t_daily_km_list->RowIndex ?>_km" id="o<?php echo $t_daily_km_list->RowIndex ?>_km" value="<?php echo HtmlEncode($t_daily_km->km->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->run->Visible) { // run ?>
		<td data-name="run">
<span id="el$rowindex$_t_daily_km_run" class="form-group t_daily_km_run">
<input type="text" data-table="t_daily_km" data-field="x_run" name="x<?php echo $t_daily_km_list->RowIndex ?>_run" id="x<?php echo $t_daily_km_list->RowIndex ?>_run" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->run->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->run->EditValue ?>"<?php echo $t_daily_km->run->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_run" name="o<?php echo $t_daily_km_list->RowIndex ?>_run" id="o<?php echo $t_daily_km_list->RowIndex ?>_run" value="<?php echo HtmlEncode($t_daily_km->run->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->dated->Visible) { // dated ?>
		<td data-name="dated">
<span id="el$rowindex$_t_daily_km_dated" class="form-group t_daily_km_dated">
<input type="text" data-table="t_daily_km" data-field="x_dated" data-format="17" name="x<?php echo $t_daily_km_list->RowIndex ?>_dated" id="x<?php echo $t_daily_km_list->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($t_daily_km->dated->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->dated->EditValue ?>"<?php echo $t_daily_km->dated->editAttributes() ?>>
<?php if (!$t_daily_km->dated->ReadOnly && !$t_daily_km->dated->Disabled && !isset($t_daily_km->dated->EditAttrs["readonly"]) && !isset($t_daily_km->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmlist", "x<?php echo $t_daily_km_list->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":17});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_dated" name="o<?php echo $t_daily_km_list->RowIndex ?>_dated" id="o<?php echo $t_daily_km_list->RowIndex ?>_dated" value="<?php echo HtmlEncode($t_daily_km->dated->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
		<td data-name="remarks">
<span id="el$rowindex$_t_daily_km_remarks" class="form-group t_daily_km_remarks">
<input type="text" data-table="t_daily_km" data-field="x_remarks" name="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" id="x<?php echo $t_daily_km_list->RowIndex ?>_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($t_daily_km->remarks->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->remarks->EditValue ?>"<?php echo $t_daily_km->remarks->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_remarks" name="o<?php echo $t_daily_km_list->RowIndex ?>_remarks" id="o<?php echo $t_daily_km_list->RowIndex ?>_remarks" value="<?php echo HtmlEncode($t_daily_km->remarks->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->operator->Visible) { // operator ?>
		<td data-name="operator">
<input type="hidden" data-table="t_daily_km" data-field="x_operator" name="o<?php echo $t_daily_km_list->RowIndex ?>_operator" id="o<?php echo $t_daily_km_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($t_daily_km->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($t_daily_km->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<input type="hidden" data-table="t_daily_km" data-field="x_datetime" name="o<?php echo $t_daily_km_list->RowIndex ?>_datetime" id="o<?php echo $t_daily_km_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($t_daily_km->datetime->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_daily_km_list->ListOptions->render("body", "right", $t_daily_km_list->RowIndex);
?>
<script>
ft_daily_kmlist.updateLists(<?php echo $t_daily_km_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($t_daily_km->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $t_daily_km_list->FormKeyCountName ?>" id="<?php echo $t_daily_km_list->FormKeyCountName ?>" value="<?php echo $t_daily_km_list->KeyCount ?>">
<?php echo $t_daily_km_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$t_daily_km->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_daily_km_list->Recordset)
	$t_daily_km_list->Recordset->Close();
?>
<?php if (!$t_daily_km->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_daily_km->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_daily_km_list->Pager)) $t_daily_km_list->Pager = new PrevNextPager($t_daily_km_list->StartRec, $t_daily_km_list->DisplayRecs, $t_daily_km_list->TotalRecs, $t_daily_km_list->AutoHidePager) ?>
<?php if ($t_daily_km_list->Pager->RecordCount > 0 && $t_daily_km_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_daily_km_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_daily_km_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_daily_km_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_daily_km_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_daily_km_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_daily_km_list->pageUrl() ?>start=<?php echo $t_daily_km_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_daily_km_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_daily_km_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_daily_km_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_daily_km_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_daily_km_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_daily_km_list->TotalRecs > 0 && (!$t_daily_km_list->AutoHidePageSizeSelector || $t_daily_km_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_daily_km">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_daily_km_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_daily_km_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_daily_km_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_daily_km_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_daily_km_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_daily_km->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_daily_km_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_daily_km_list->TotalRecs == 0 && !$t_daily_km->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_daily_km_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_daily_km_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_daily_km->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_daily_km->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_daily_km", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_daily_km_list->terminate();
?>