<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_daily_km_search = new t_daily_km_search();

// Run the page
$t_daily_km_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_daily_km_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_daily_km_search->IsModal) { ?>
var ft_daily_kmsearch = currentAdvancedSearchForm = new ew.Form("ft_daily_kmsearch", "search");
<?php } else { ?>
var ft_daily_kmsearch = currentForm = new ew.Form("ft_daily_kmsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_daily_kmsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_daily_kmsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_daily_kmsearch.lists["x_vehicle_no"] = <?php echo $t_daily_km_search->vehicle_no->Lookup->toClientList() ?>;
ft_daily_kmsearch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_daily_km_search->vehicle_no->lookupOptions()) ?>;
ft_daily_kmsearch.autoSuggests["x_vehicle_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmsearch.lists["x_trip"] = <?php echo $t_daily_km_search->trip->Lookup->toClientList() ?>;
ft_daily_kmsearch.lists["x_trip"].options = <?php echo JsonEncode($t_daily_km_search->trip->lookupOptions()) ?>;
ft_daily_kmsearch.lists["x_driver"] = <?php echo $t_daily_km_search->driver->Lookup->toClientList() ?>;
ft_daily_kmsearch.lists["x_driver"].options = <?php echo JsonEncode($t_daily_km_search->driver->lookupOptions()) ?>;
ft_daily_kmsearch.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmsearch.lists["x_operator"] = <?php echo $t_daily_km_search->operator->Lookup->toClientList() ?>;
ft_daily_kmsearch.lists["x_operator"].options = <?php echo JsonEncode($t_daily_km_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_daily_kmsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->vehicle_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_old_km");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->old_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkShortEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_daily_km->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_daily_km_search->showPageHeader(); ?>
<?php
$t_daily_km_search->showMessage();
?>
<form name="ft_daily_kmsearch" id="ft_daily_kmsearch" class="<?php echo $t_daily_km_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_daily_km_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_daily_km_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_daily_km_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_daily_km->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_id"><?php echo $t_daily_km->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->id->cellAttributes() ?>>
			<span id="el_t_daily_km_id">
<input type="text" data-table="t_daily_km" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_daily_km->id->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->id->EditValue ?>"<?php echo $t_daily_km->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_vehicle_no"><?php echo $t_daily_km->vehicle_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->vehicle_no->cellAttributes() ?>>
			<span id="el_t_daily_km_vehicle_no">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$t_daily_km->vehicle_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->vehicle_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle_no" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle_no" id="sv_x_vehicle_no" value="<?php echo RemoveHtml($t_daily_km->vehicle_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->vehicle_no->getPlaceHolder()) ?>"<?php echo $t_daily_km->vehicle_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_daily_km->vehicle_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_daily_km->vehicle_no->ReadOnly || $t_daily_km->vehicle_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_vehicle_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_daily_km->vehicle_no->displayValueSeparatorAttribute() ?>" name="x_vehicle_no" id="x_vehicle_no" value="<?php echo HtmlEncode($t_daily_km->vehicle_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmsearch.createAutoSuggest({"id":"x_vehicle_no","forceSelect":true});
</script>
<?php echo $t_daily_km->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label for="x_trip" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_trip"><?php echo $t_daily_km->trip->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_trip" id="z_trip" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->trip->cellAttributes() ?>>
			<span id="el_t_daily_km_trip">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_trip" data-value-separator="<?php echo $t_daily_km->trip->displayValueSeparatorAttribute() ?>" id="x_trip" name="x_trip"<?php echo $t_daily_km->trip->editAttributes() ?>>
		<?php echo $t_daily_km->trip->selectOptionListHtml("x_trip") ?>
	</select>
</div>
<?php echo $t_daily_km->trip->Lookup->getParamTag("p_x_trip") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_driver"><?php echo $t_daily_km->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->driver->cellAttributes() ?>>
			<span id="el_t_daily_km_driver">
<?php
$wrkonchange = "" . trim(@$t_daily_km->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_daily_km->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_daily_km->driver->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_daily_km->driver->getPlaceHolder()) ?>"<?php echo $t_daily_km->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_daily_km" data-field="x_driver" data-value-separator="<?php echo $t_daily_km->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_daily_km->driver->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_daily_kmsearch.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_daily_km->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
	<div id="r_old_km" class="form-group row">
		<label for="x_old_km" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_old_km"><?php echo $t_daily_km->old_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_old_km" id="z_old_km" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->old_km->cellAttributes() ?>>
			<span id="el_t_daily_km_old_km">
<input type="text" data-table="t_daily_km" data-field="x_old_km" name="x_old_km" id="x_old_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->old_km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->old_km->EditValue ?>"<?php echo $t_daily_km->old_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label for="x_km" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_km"><?php echo $t_daily_km->km->caption() ?></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->km->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_km" id="z_km" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($t_daily_km->km->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_daily_km_km">
<input type="text" data-table="t_daily_km" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_km d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_daily_km_km" class="btw1_km d-none">
<input type="text" data-table="t_daily_km" data-field="x_km" name="y_km" id="y_km" size="30" placeholder="<?php echo HtmlEncode($t_daily_km->km->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->km->EditValue2 ?>"<?php echo $t_daily_km->km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_dated"><?php echo $t_daily_km->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->dated->cellAttributes() ?>>
			<span id="el_t_daily_km_dated">
<input type="text" data-table="t_daily_km" data-field="x_dated" data-format="17" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_daily_km->dated->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->dated->EditValue ?>"<?php echo $t_daily_km->dated->editAttributes() ?>>
<?php if (!$t_daily_km->dated->ReadOnly && !$t_daily_km->dated->Disabled && !isset($t_daily_km->dated->EditAttrs["readonly"]) && !isset($t_daily_km->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":17});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_remarks"><?php echo $t_daily_km->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->remarks->cellAttributes() ?>>
			<span id="el_t_daily_km_remarks">
<input type="text" data-table="t_daily_km" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($t_daily_km->remarks->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->remarks->EditValue ?>"<?php echo $t_daily_km->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_operator"><?php echo $t_daily_km->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->operator->cellAttributes() ?>>
			<span id="el_t_daily_km_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_daily_km" data-field="x_operator" data-value-separator="<?php echo $t_daily_km->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_daily_km->operator->editAttributes() ?>>
		<?php echo $t_daily_km->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_daily_km->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_daily_km->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_daily_km_search->LeftColumnClass ?>"><span id="elh_t_daily_km_datetime"><?php echo $t_daily_km->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_daily_km_search->RightColumnClass ?>"><div<?php echo $t_daily_km->datetime->cellAttributes() ?>>
			<span id="el_t_daily_km_datetime">
<input type="text" data-table="t_daily_km" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_daily_km->datetime->getPlaceHolder()) ?>" value="<?php echo $t_daily_km->datetime->EditValue ?>"<?php echo $t_daily_km->datetime->editAttributes() ?>>
<?php if (!$t_daily_km->datetime->ReadOnly && !$t_daily_km->datetime->Disabled && !isset($t_daily_km->datetime->EditAttrs["readonly"]) && !isset($t_daily_km->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_daily_kmsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_daily_km_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_daily_km_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_daily_km_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_daily_km_search->terminate();
?>