<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_daily_km_view = new t_daily_km_view();

// Run the page
$t_daily_km_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_daily_km_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_daily_km->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_daily_kmview = currentForm = new ew.Form("ft_daily_kmview", "view");

// Form_CustomValidate event
ft_daily_kmview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_daily_kmview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_daily_kmview.lists["x_vehicle_no"] = <?php echo $t_daily_km_view->vehicle_no->Lookup->toClientList() ?>;
ft_daily_kmview.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_daily_km_view->vehicle_no->lookupOptions()) ?>;
ft_daily_kmview.autoSuggests["x_vehicle_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmview.lists["x_trip"] = <?php echo $t_daily_km_view->trip->Lookup->toClientList() ?>;
ft_daily_kmview.lists["x_trip"].options = <?php echo JsonEncode($t_daily_km_view->trip->lookupOptions()) ?>;
ft_daily_kmview.lists["x_driver"] = <?php echo $t_daily_km_view->driver->Lookup->toClientList() ?>;
ft_daily_kmview.lists["x_driver"].options = <?php echo JsonEncode($t_daily_km_view->driver->lookupOptions()) ?>;
ft_daily_kmview.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_daily_kmview.lists["x_operator"] = <?php echo $t_daily_km_view->operator->Lookup->toClientList() ?>;
ft_daily_kmview.lists["x_operator"].options = <?php echo JsonEncode($t_daily_km_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_daily_km->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_daily_km_view->ExportOptions->render("body") ?>
<?php $t_daily_km_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_daily_km_view->showPageHeader(); ?>
<?php
$t_daily_km_view->showMessage();
?>
<form name="ft_daily_kmview" id="ft_daily_kmview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_daily_km_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_daily_km_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_daily_km">
<input type="hidden" name="modal" value="<?php echo (int)$t_daily_km_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_daily_km->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_id"><?php echo $t_daily_km->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_daily_km->id->cellAttributes() ?>>
<span id="el_t_daily_km_id">
<span<?php echo $t_daily_km->id->viewAttributes() ?>>
<?php echo $t_daily_km->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->vehicle_no->Visible) { // vehicle_no ?>
	<tr id="r_vehicle_no">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_vehicle_no"><?php echo $t_daily_km->vehicle_no->caption() ?></span></td>
		<td data-name="vehicle_no"<?php echo $t_daily_km->vehicle_no->cellAttributes() ?>>
<span id="el_t_daily_km_vehicle_no">
<span<?php echo $t_daily_km->vehicle_no->viewAttributes() ?>>
<?php echo $t_daily_km->vehicle_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_trip"><?php echo $t_daily_km->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_daily_km->trip->cellAttributes() ?>>
<span id="el_t_daily_km_trip">
<span<?php echo $t_daily_km->trip->viewAttributes() ?>>
<?php echo $t_daily_km->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->driver->Visible) { // driver ?>
	<tr id="r_driver">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_driver"><?php echo $t_daily_km->driver->caption() ?></span></td>
		<td data-name="driver"<?php echo $t_daily_km->driver->cellAttributes() ?>>
<span id="el_t_daily_km_driver">
<span<?php echo $t_daily_km->driver->viewAttributes() ?>>
<?php echo $t_daily_km->driver->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->old_km->Visible) { // old_km ?>
	<tr id="r_old_km">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_old_km"><?php echo $t_daily_km->old_km->caption() ?></span></td>
		<td data-name="old_km"<?php echo $t_daily_km->old_km->cellAttributes() ?>>
<span id="el_t_daily_km_old_km">
<span<?php echo $t_daily_km->old_km->viewAttributes() ?>>
<?php echo $t_daily_km->old_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_km"><?php echo $t_daily_km->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_daily_km->km->cellAttributes() ?>>
<span id="el_t_daily_km_km">
<span<?php echo $t_daily_km->km->viewAttributes() ?>>
<?php echo $t_daily_km->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->run->Visible) { // run ?>
	<tr id="r_run">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_run"><?php echo $t_daily_km->run->caption() ?></span></td>
		<td data-name="run"<?php echo $t_daily_km->run->cellAttributes() ?>>
<span id="el_t_daily_km_run">
<span<?php echo $t_daily_km->run->viewAttributes() ?>>
<?php echo $t_daily_km->run->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_dated"><?php echo $t_daily_km->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_daily_km->dated->cellAttributes() ?>>
<span id="el_t_daily_km_dated">
<span<?php echo $t_daily_km->dated->viewAttributes() ?>>
<?php echo $t_daily_km->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_remarks"><?php echo $t_daily_km->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_daily_km->remarks->cellAttributes() ?>>
<span id="el_t_daily_km_remarks">
<span<?php echo $t_daily_km->remarks->viewAttributes() ?>>
<?php echo $t_daily_km->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_operator"><?php echo $t_daily_km->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_daily_km->operator->cellAttributes() ?>>
<span id="el_t_daily_km_operator">
<span<?php echo $t_daily_km->operator->viewAttributes() ?>>
<?php echo $t_daily_km->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_daily_km->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_daily_km_view->TableLeftColumnClass ?>"><span id="elh_t_daily_km_datetime"><?php echo $t_daily_km->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_daily_km->datetime->cellAttributes() ?>>
<span id="el_t_daily_km_datetime">
<span<?php echo $t_daily_km->datetime->viewAttributes() ?>>
<?php echo $t_daily_km->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_daily_km_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_daily_km->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_daily_km_view->terminate();
?>