<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_diesal_expenses_edit = new t_diesal_expenses_edit();

// Run the page
$t_diesal_expenses_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_diesal_expenses_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_diesal_expensesedit = currentForm = new ew.Form("ft_diesal_expensesedit", "edit");

// Validate form
ft_diesal_expensesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_diesal_expenses_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->id->caption(), $t_diesal_expenses->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->trip->caption(), $t_diesal_expenses->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->diesal_by->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->diesal_by->caption(), $t_diesal_expenses->diesal_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->diesalreq->Required) { ?>
			elm = this.getElements("x" + infix + "_diesalreq");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->diesalreq->caption(), $t_diesal_expenses->diesalreq->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesalreq");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->diesalreq->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->diesalpaid->Required) { ?>
			elm = this.getElements("x" + infix + "_diesalpaid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->diesalpaid->caption(), $t_diesal_expenses->diesalpaid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diesalpaid");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->diesalpaid->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->litre->Required) { ?>
			elm = this.getElements("x" + infix + "_litre");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->litre->caption(), $t_diesal_expenses->litre->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_litre");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->litre->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->amount->caption(), $t_diesal_expenses->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->amount->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->km->caption(), $t_diesal_expenses->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->km->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->dated->caption(), $t_diesal_expenses->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_diesal_expenses->dated->errorMessage()) ?>");
		<?php if ($t_diesal_expenses_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->remarks->caption(), $t_diesal_expenses->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->uploads->caption(), $t_diesal_expenses->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->operator->caption(), $t_diesal_expenses->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_diesal_expenses_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_diesal_expenses->datetime->caption(), $t_diesal_expenses->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_diesal_expensesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_diesal_expensesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_diesal_expensesedit.lists["x_trip"] = <?php echo $t_diesal_expenses_edit->trip->Lookup->toClientList() ?>;
ft_diesal_expensesedit.lists["x_trip"].options = <?php echo JsonEncode($t_diesal_expenses_edit->trip->lookupOptions()) ?>;
ft_diesal_expensesedit.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_diesal_expensesedit.lists["x_diesal_by"] = <?php echo $t_diesal_expenses_edit->diesal_by->Lookup->toClientList() ?>;
ft_diesal_expensesedit.lists["x_diesal_by"].options = <?php echo JsonEncode($t_diesal_expenses_edit->diesal_by->lookupOptions()) ?>;
ft_diesal_expensesedit.autoSuggests["x_diesal_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_diesal_expenses_edit->showPageHeader(); ?>
<?php
$t_diesal_expenses_edit->showMessage();
?>
<form name="ft_diesal_expensesedit" id="ft_diesal_expensesedit" class="<?php echo $t_diesal_expenses_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_diesal_expenses_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_diesal_expenses_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_diesal_expenses">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_diesal_expenses_edit->IsModal ?>">
<?php if ($t_diesal_expenses->getCurrentMasterTable() == "t_trip_info") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="t_trip_info">
<input type="hidden" name="fk_id" value="<?php echo $t_diesal_expenses->trip->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_diesal_expenses->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_diesal_expenses_id" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->id->caption() ?><?php echo ($t_diesal_expenses->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->id->cellAttributes() ?>>
<span id="el_t_diesal_expenses_id">
<span<?php echo $t_diesal_expenses->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_diesal_expenses->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_diesal_expenses" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_diesal_expenses->id->CurrentValue) ?>">
<?php echo $t_diesal_expenses->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_diesal_expenses_trip" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->trip->caption() ?><?php echo ($t_diesal_expenses->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->trip->cellAttributes() ?>>
<span id="el_t_diesal_expenses_trip">
<span<?php echo $t_diesal_expenses->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_diesal_expenses->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_diesal_expenses" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_diesal_expenses->trip->CurrentValue) ?>">
<?php echo $t_diesal_expenses->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->diesal_by->Visible) { // diesal_by ?>
	<div id="r_diesal_by" class="form-group row">
		<label id="elh_t_diesal_expenses_diesal_by" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->diesal_by->caption() ?><?php echo ($t_diesal_expenses->diesal_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->diesal_by->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesal_by">
<span<?php echo $t_diesal_expenses->diesal_by->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_diesal_expenses->diesal_by->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_diesal_expenses" data-field="x_diesal_by" name="x_diesal_by" id="x_diesal_by" value="<?php echo HtmlEncode($t_diesal_expenses->diesal_by->CurrentValue) ?>">
<?php echo $t_diesal_expenses->diesal_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->diesalreq->Visible) { // diesalreq ?>
	<div id="r_diesalreq" class="form-group row">
		<label id="elh_t_diesal_expenses_diesalreq" for="x_diesalreq" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->diesalreq->caption() ?><?php echo ($t_diesal_expenses->diesalreq->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->diesalreq->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalreq">
<input type="text" data-table="t_diesal_expenses" data-field="x_diesalreq" name="x_diesalreq" id="x_diesalreq" size="30" placeholder="<?php echo HtmlEncode($t_diesal_expenses->diesalreq->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->diesalreq->EditValue ?>"<?php echo $t_diesal_expenses->diesalreq->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->diesalreq->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->diesalpaid->Visible) { // diesalpaid ?>
	<div id="r_diesalpaid" class="form-group row">
		<label id="elh_t_diesal_expenses_diesalpaid" for="x_diesalpaid" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->diesalpaid->caption() ?><?php echo ($t_diesal_expenses->diesalpaid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->diesalpaid->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalpaid">
<input type="text" data-table="t_diesal_expenses" data-field="x_diesalpaid" name="x_diesalpaid" id="x_diesalpaid" size="30" placeholder="<?php echo HtmlEncode($t_diesal_expenses->diesalpaid->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->diesalpaid->EditValue ?>"<?php echo $t_diesal_expenses->diesalpaid->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->diesalpaid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->litre->Visible) { // litre ?>
	<div id="r_litre" class="form-group row">
		<label id="elh_t_diesal_expenses_litre" for="x_litre" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->litre->caption() ?><?php echo ($t_diesal_expenses->litre->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->litre->cellAttributes() ?>>
<span id="el_t_diesal_expenses_litre">
<input type="text" data-table="t_diesal_expenses" data-field="x_litre" name="x_litre" id="x_litre" size="30" placeholder="<?php echo HtmlEncode($t_diesal_expenses->litre->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->litre->EditValue ?>"<?php echo $t_diesal_expenses->litre->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->litre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_diesal_expenses_amount" for="x_amount" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->amount->caption() ?><?php echo ($t_diesal_expenses->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->amount->cellAttributes() ?>>
<span id="el_t_diesal_expenses_amount">
<input type="text" data-table="t_diesal_expenses" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_diesal_expenses->amount->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->amount->EditValue ?>"<?php echo $t_diesal_expenses->amount->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label id="elh_t_diesal_expenses_km" for="x_km" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->km->caption() ?><?php echo ($t_diesal_expenses->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->km->cellAttributes() ?>>
<span id="el_t_diesal_expenses_km">
<input type="text" data-table="t_diesal_expenses" data-field="x_km" name="x_km" id="x_km" placeholder="<?php echo HtmlEncode($t_diesal_expenses->km->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->km->EditValue ?>"<?php echo $t_diesal_expenses->km->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_t_diesal_expenses_dated" for="x_dated" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->dated->caption() ?><?php echo ($t_diesal_expenses->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->dated->cellAttributes() ?>>
<span id="el_t_diesal_expenses_dated">
<input type="text" data-table="t_diesal_expenses" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($t_diesal_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->dated->EditValue ?>"<?php echo $t_diesal_expenses->dated->editAttributes() ?>>
<?php if (!$t_diesal_expenses->dated->ReadOnly && !$t_diesal_expenses->dated->Disabled && !isset($t_diesal_expenses->dated->EditAttrs["readonly"]) && !isset($t_diesal_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_diesal_expensesedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_diesal_expenses->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_diesal_expenses_remarks" for="x_remarks" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->remarks->caption() ?><?php echo ($t_diesal_expenses->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->remarks->cellAttributes() ?>>
<span id="el_t_diesal_expenses_remarks">
<input type="text" data-table="t_diesal_expenses" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_diesal_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $t_diesal_expenses->remarks->EditValue ?>"<?php echo $t_diesal_expenses->remarks->editAttributes() ?>>
</span>
<?php echo $t_diesal_expenses->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_diesal_expenses->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_diesal_expenses_uploads" class="<?php echo $t_diesal_expenses_edit->LeftColumnClass ?>"><?php echo $t_diesal_expenses->uploads->caption() ?><?php echo ($t_diesal_expenses->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_diesal_expenses_edit->RightColumnClass ?>"><div<?php echo $t_diesal_expenses->uploads->cellAttributes() ?>>
<span id="el_t_diesal_expenses_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_diesal_expenses->uploads->title() ? $t_diesal_expenses->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_diesal_expenses->uploads->ReadOnly || $t_diesal_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_diesal_expenses" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_diesal_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_diesal_expenses->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_diesal_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_diesal_expenses->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_diesal_expenses->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_diesal_expenses_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_diesal_expenses_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_diesal_expenses_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_diesal_expenses_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_diesal_expenses_edit->terminate();
?>