<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_diesal_expenses_view = new t_diesal_expenses_view();

// Run the page
$t_diesal_expenses_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_diesal_expenses_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_diesal_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_diesal_expensesview = currentForm = new ew.Form("ft_diesal_expensesview", "view");

// Form_CustomValidate event
ft_diesal_expensesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_diesal_expensesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_diesal_expensesview.lists["x_trip"] = <?php echo $t_diesal_expenses_view->trip->Lookup->toClientList() ?>;
ft_diesal_expensesview.lists["x_trip"].options = <?php echo JsonEncode($t_diesal_expenses_view->trip->lookupOptions()) ?>;
ft_diesal_expensesview.autoSuggests["x_trip"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_diesal_expensesview.lists["x_diesal_by"] = <?php echo $t_diesal_expenses_view->diesal_by->Lookup->toClientList() ?>;
ft_diesal_expensesview.lists["x_diesal_by"].options = <?php echo JsonEncode($t_diesal_expenses_view->diesal_by->lookupOptions()) ?>;
ft_diesal_expensesview.autoSuggests["x_diesal_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_diesal_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_diesal_expenses_view->ExportOptions->render("body") ?>
<?php $t_diesal_expenses_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_diesal_expenses_view->showPageHeader(); ?>
<?php
$t_diesal_expenses_view->showMessage();
?>
<form name="ft_diesal_expensesview" id="ft_diesal_expensesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_diesal_expenses_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_diesal_expenses_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_diesal_expenses">
<input type="hidden" name="modal" value="<?php echo (int)$t_diesal_expenses_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_diesal_expenses->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_id"><?php echo $t_diesal_expenses->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_diesal_expenses->id->cellAttributes() ?>>
<span id="el_t_diesal_expenses_id">
<span<?php echo $t_diesal_expenses->id->viewAttributes() ?>>
<?php echo $t_diesal_expenses->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->trip->Visible) { // trip ?>
	<tr id="r_trip">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_trip"><?php echo $t_diesal_expenses->trip->caption() ?></span></td>
		<td data-name="trip"<?php echo $t_diesal_expenses->trip->cellAttributes() ?>>
<span id="el_t_diesal_expenses_trip">
<span<?php echo $t_diesal_expenses->trip->viewAttributes() ?>>
<?php echo $t_diesal_expenses->trip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->diesal_by->Visible) { // diesal_by ?>
	<tr id="r_diesal_by">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_diesal_by"><?php echo $t_diesal_expenses->diesal_by->caption() ?></span></td>
		<td data-name="diesal_by"<?php echo $t_diesal_expenses->diesal_by->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesal_by">
<span<?php echo $t_diesal_expenses->diesal_by->viewAttributes() ?>>
<?php echo $t_diesal_expenses->diesal_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->diesalreq->Visible) { // diesalreq ?>
	<tr id="r_diesalreq">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_diesalreq"><?php echo $t_diesal_expenses->diesalreq->caption() ?></span></td>
		<td data-name="diesalreq"<?php echo $t_diesal_expenses->diesalreq->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalreq">
<span<?php echo $t_diesal_expenses->diesalreq->viewAttributes() ?>>
<?php echo $t_diesal_expenses->diesalreq->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->diesalpaid->Visible) { // diesalpaid ?>
	<tr id="r_diesalpaid">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_diesalpaid"><?php echo $t_diesal_expenses->diesalpaid->caption() ?></span></td>
		<td data-name="diesalpaid"<?php echo $t_diesal_expenses->diesalpaid->cellAttributes() ?>>
<span id="el_t_diesal_expenses_diesalpaid">
<span<?php echo $t_diesal_expenses->diesalpaid->viewAttributes() ?>>
<?php echo $t_diesal_expenses->diesalpaid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->litre->Visible) { // litre ?>
	<tr id="r_litre">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_litre"><?php echo $t_diesal_expenses->litre->caption() ?></span></td>
		<td data-name="litre"<?php echo $t_diesal_expenses->litre->cellAttributes() ?>>
<span id="el_t_diesal_expenses_litre">
<span<?php echo $t_diesal_expenses->litre->viewAttributes() ?>>
<?php echo $t_diesal_expenses->litre->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_amount"><?php echo $t_diesal_expenses->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_diesal_expenses->amount->cellAttributes() ?>>
<span id="el_t_diesal_expenses_amount">
<span<?php echo $t_diesal_expenses->amount->viewAttributes() ?>>
<?php echo $t_diesal_expenses->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_km"><?php echo $t_diesal_expenses->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_diesal_expenses->km->cellAttributes() ?>>
<span id="el_t_diesal_expenses_km">
<span<?php echo $t_diesal_expenses->km->viewAttributes() ?>>
<?php echo $t_diesal_expenses->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_dated"><?php echo $t_diesal_expenses->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $t_diesal_expenses->dated->cellAttributes() ?>>
<span id="el_t_diesal_expenses_dated">
<span<?php echo $t_diesal_expenses->dated->viewAttributes() ?>>
<?php echo $t_diesal_expenses->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_remarks"><?php echo $t_diesal_expenses->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_diesal_expenses->remarks->cellAttributes() ?>>
<span id="el_t_diesal_expenses_remarks">
<span<?php echo $t_diesal_expenses->remarks->viewAttributes() ?>>
<?php echo $t_diesal_expenses->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_uploads"><?php echo $t_diesal_expenses->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_diesal_expenses->uploads->cellAttributes() ?>>
<span id="el_t_diesal_expenses_uploads">
<span>
<?php echo GetFileViewTag($t_diesal_expenses->uploads, $t_diesal_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_operator"><?php echo $t_diesal_expenses->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_diesal_expenses->operator->cellAttributes() ?>>
<span id="el_t_diesal_expenses_operator">
<span<?php echo $t_diesal_expenses->operator->viewAttributes() ?>>
<?php echo $t_diesal_expenses->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_diesal_expenses->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_diesal_expenses_view->TableLeftColumnClass ?>"><span id="elh_t_diesal_expenses_datetime"><?php echo $t_diesal_expenses->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_diesal_expenses->datetime->cellAttributes() ?>>
<span id="el_t_diesal_expenses_datetime">
<span<?php echo $t_diesal_expenses->datetime->viewAttributes() ?>>
<?php echo $t_diesal_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_diesal_expenses_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_diesal_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_diesal_expenses_view->terminate();
?>