<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_driver_info_edit = new t_driver_info_edit();

// Run the page
$t_driver_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_driver_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_driver_infoedit = currentForm = new ew.Form("ft_driver_infoedit", "edit");

// Validate form
ft_driver_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_driver_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->id->caption(), $t_driver_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->employee_id->caption(), $t_driver_info->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->name->caption(), $t_driver_info->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->licence_no->Required) { ?>
			elm = this.getElements("x" + infix + "_licence_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->licence_no->caption(), $t_driver_info->licence_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->licence_expiry->Required) { ?>
			elm = this.getElements("x" + infix + "_licence_expiry");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->licence_expiry->caption(), $t_driver_info->licence_expiry->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_licence_expiry");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_driver_info->licence_expiry->errorMessage()) ?>");
		<?php if ($t_driver_info_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->mobile->caption(), $t_driver_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->status->caption(), $t_driver_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->remarks->caption(), $t_driver_info->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->operator->caption(), $t_driver_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->datetime->caption(), $t_driver_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_driver_info_edit->r_text->Required) { ?>
			elm = this.getElements("x" + infix + "_r_text");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_driver_info->r_text->caption(), $t_driver_info->r_text->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_driver_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_driver_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_driver_infoedit.lists["x_employee_id"] = <?php echo $t_driver_info_edit->employee_id->Lookup->toClientList() ?>;
ft_driver_infoedit.lists["x_employee_id"].options = <?php echo JsonEncode($t_driver_info_edit->employee_id->lookupOptions()) ?>;
ft_driver_infoedit.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_driver_infoedit.lists["x_status"] = <?php echo $t_driver_info_edit->status->Lookup->toClientList() ?>;
ft_driver_infoedit.lists["x_status"].options = <?php echo JsonEncode($t_driver_info_edit->status->options(FALSE, TRUE)) ?>;
ft_driver_infoedit.lists["x_operator"] = <?php echo $t_driver_info_edit->operator->Lookup->toClientList() ?>;
ft_driver_infoedit.lists["x_operator"].options = <?php echo JsonEncode($t_driver_info_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_driver_info_edit->showPageHeader(); ?>
<?php
$t_driver_info_edit->showMessage();
?>
<form name="ft_driver_infoedit" id="ft_driver_infoedit" class="<?php echo $t_driver_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_driver_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_driver_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_driver_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_driver_info_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_driver_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_driver_info_id" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->id->caption() ?><?php echo ($t_driver_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->id->cellAttributes() ?>>
<span id="el_t_driver_info_id">
<span<?php echo $t_driver_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_driver_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_driver_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_driver_info->id->CurrentValue) ?>">
<?php echo $t_driver_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_t_driver_info_employee_id" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->employee_id->caption() ?><?php echo ($t_driver_info->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->employee_id->cellAttributes() ?>>
<span id="el_t_driver_info_employee_id">
<span<?php echo $t_driver_info->employee_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_driver_info->employee_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_driver_info" data-field="x_employee_id" name="x_employee_id" id="x_employee_id" value="<?php echo HtmlEncode($t_driver_info->employee_id->CurrentValue) ?>">
<?php echo $t_driver_info->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_t_driver_info_name" for="x_name" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->name->caption() ?><?php echo ($t_driver_info->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->name->cellAttributes() ?>>
<span id="el_t_driver_info_name">
<span<?php echo $t_driver_info->name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_driver_info->name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_driver_info" data-field="x_name" name="x_name" id="x_name" value="<?php echo HtmlEncode($t_driver_info->name->CurrentValue) ?>">
<?php echo $t_driver_info->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->licence_no->Visible) { // licence_no ?>
	<div id="r_licence_no" class="form-group row">
		<label id="elh_t_driver_info_licence_no" for="x_licence_no" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->licence_no->caption() ?><?php echo ($t_driver_info->licence_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->licence_no->cellAttributes() ?>>
<span id="el_t_driver_info_licence_no">
<input type="text" data-table="t_driver_info" data-field="x_licence_no" name="x_licence_no" id="x_licence_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_driver_info->licence_no->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->licence_no->EditValue ?>"<?php echo $t_driver_info->licence_no->editAttributes() ?>>
</span>
<?php echo $t_driver_info->licence_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->licence_expiry->Visible) { // licence_expiry ?>
	<div id="r_licence_expiry" class="form-group row">
		<label id="elh_t_driver_info_licence_expiry" for="x_licence_expiry" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->licence_expiry->caption() ?><?php echo ($t_driver_info->licence_expiry->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->licence_expiry->cellAttributes() ?>>
<span id="el_t_driver_info_licence_expiry">
<input type="text" data-table="t_driver_info" data-field="x_licence_expiry" name="x_licence_expiry" id="x_licence_expiry" placeholder="<?php echo HtmlEncode($t_driver_info->licence_expiry->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->licence_expiry->EditValue ?>"<?php echo $t_driver_info->licence_expiry->editAttributes() ?>>
<?php if (!$t_driver_info->licence_expiry->ReadOnly && !$t_driver_info->licence_expiry->Disabled && !isset($t_driver_info->licence_expiry->EditAttrs["readonly"]) && !isset($t_driver_info->licence_expiry->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_driver_infoedit", "x_licence_expiry", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_driver_info->licence_expiry->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_t_driver_info_mobile" for="x_mobile" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->mobile->caption() ?><?php echo ($t_driver_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->mobile->cellAttributes() ?>>
<span id="el_t_driver_info_mobile">
<span<?php echo $t_driver_info->mobile->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_driver_info->mobile->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_driver_info" data-field="x_mobile" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($t_driver_info->mobile->CurrentValue) ?>">
<?php echo $t_driver_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_t_driver_info_status" for="x_status" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->status->caption() ?><?php echo ($t_driver_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->status->cellAttributes() ?>>
<span id="el_t_driver_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_driver_info" data-field="x_status" data-value-separator="<?php echo $t_driver_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_driver_info->status->editAttributes() ?>>
		<?php echo $t_driver_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $t_driver_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_driver_info_remarks" for="x_remarks" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->remarks->caption() ?><?php echo ($t_driver_info->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->remarks->cellAttributes() ?>>
<span id="el_t_driver_info_remarks">
<input type="text" data-table="t_driver_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_driver_info->remarks->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->remarks->EditValue ?>"<?php echo $t_driver_info->remarks->editAttributes() ?>>
</span>
<?php echo $t_driver_info->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->r_text->Visible) { // r_text ?>
	<div id="r_r_text" class="form-group row">
		<label id="elh_t_driver_info_r_text" for="x_r_text" class="<?php echo $t_driver_info_edit->LeftColumnClass ?>"><?php echo $t_driver_info->r_text->caption() ?><?php echo ($t_driver_info->r_text->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_driver_info_edit->RightColumnClass ?>"><div<?php echo $t_driver_info->r_text->cellAttributes() ?>>
<span id="el_t_driver_info_r_text">
<input type="text" data-table="t_driver_info" data-field="x_r_text" name="x_r_text" id="x_r_text" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_driver_info->r_text->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->r_text->EditValue ?>"<?php echo $t_driver_info->r_text->editAttributes() ?>>
</span>
<?php echo $t_driver_info->r_text->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_driver_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_driver_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_driver_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_driver_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_driver_info_edit->terminate();
?>