<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_driver_info_search = new t_driver_info_search();

// Run the page
$t_driver_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_driver_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_driver_info_search->IsModal) { ?>
var ft_driver_infosearch = currentAdvancedSearchForm = new ew.Form("ft_driver_infosearch", "search");
<?php } else { ?>
var ft_driver_infosearch = currentForm = new ew.Form("ft_driver_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_driver_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_driver_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_driver_infosearch.lists["x_employee_id"] = <?php echo $t_driver_info_search->employee_id->Lookup->toClientList() ?>;
ft_driver_infosearch.lists["x_employee_id"].options = <?php echo JsonEncode($t_driver_info_search->employee_id->lookupOptions()) ?>;
ft_driver_infosearch.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_driver_infosearch.lists["x_status"] = <?php echo $t_driver_info_search->status->Lookup->toClientList() ?>;
ft_driver_infosearch.lists["x_status"].options = <?php echo JsonEncode($t_driver_info_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

ft_driver_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_driver_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_employee_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_driver_info->employee_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_licence_expiry");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_driver_info->licence_expiry->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_driver_info_search->showPageHeader(); ?>
<?php
$t_driver_info_search->showMessage();
?>
<form name="ft_driver_infosearch" id="ft_driver_infosearch" class="<?php echo $t_driver_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_driver_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_driver_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_driver_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_driver_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_driver_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_id"><?php echo $t_driver_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->id->cellAttributes() ?>>
			<span id="el_t_driver_info_id">
<input type="text" data-table="t_driver_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_driver_info->id->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->id->EditValue ?>"<?php echo $t_driver_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_employee_id"><?php echo $t_driver_info->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="="></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->employee_id->cellAttributes() ?>>
			<span id="el_t_driver_info_employee_id">
<?php
$wrkonchange = "" . trim(@$t_driver_info->employee_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_driver_info->employee_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?php echo RemoveHtml($t_driver_info->employee_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_driver_info->employee_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_driver_info->employee_id->getPlaceHolder()) ?>"<?php echo $t_driver_info->employee_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_driver_info" data-field="x_employee_id" data-value-separator="<?php echo $t_driver_info->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?php echo HtmlEncode($t_driver_info->employee_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_driver_infosearch.createAutoSuggest({"id":"x_employee_id","forceSelect":true});
</script>
<?php echo $t_driver_info->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_name"><?php echo $t_driver_info->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->name->cellAttributes() ?>>
			<span id="el_t_driver_info_name">
<input type="text" data-table="t_driver_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($t_driver_info->name->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->name->EditValue ?>"<?php echo $t_driver_info->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->licence_no->Visible) { // licence_no ?>
	<div id="r_licence_no" class="form-group row">
		<label for="x_licence_no" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_licence_no"><?php echo $t_driver_info->licence_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_licence_no" id="z_licence_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->licence_no->cellAttributes() ?>>
			<span id="el_t_driver_info_licence_no">
<input type="text" data-table="t_driver_info" data-field="x_licence_no" name="x_licence_no" id="x_licence_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($t_driver_info->licence_no->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->licence_no->EditValue ?>"<?php echo $t_driver_info->licence_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->licence_expiry->Visible) { // licence_expiry ?>
	<div id="r_licence_expiry" class="form-group row">
		<label for="x_licence_expiry" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_licence_expiry"><?php echo $t_driver_info->licence_expiry->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_licence_expiry" id="z_licence_expiry" value="="></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->licence_expiry->cellAttributes() ?>>
			<span id="el_t_driver_info_licence_expiry">
<input type="text" data-table="t_driver_info" data-field="x_licence_expiry" name="x_licence_expiry" id="x_licence_expiry" placeholder="<?php echo HtmlEncode($t_driver_info->licence_expiry->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->licence_expiry->EditValue ?>"<?php echo $t_driver_info->licence_expiry->editAttributes() ?>>
<?php if (!$t_driver_info->licence_expiry->ReadOnly && !$t_driver_info->licence_expiry->Disabled && !isset($t_driver_info->licence_expiry->EditAttrs["readonly"]) && !isset($t_driver_info->licence_expiry->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_driver_infosearch", "x_licence_expiry", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_mobile"><?php echo $t_driver_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->mobile->cellAttributes() ?>>
			<span id="el_t_driver_info_mobile">
<input type="text" data-table="t_driver_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($t_driver_info->mobile->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->mobile->EditValue ?>"<?php echo $t_driver_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_status"><?php echo $t_driver_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->status->cellAttributes() ?>>
			<span id="el_t_driver_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_driver_info" data-field="x_status" data-value-separator="<?php echo $t_driver_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_driver_info->status->editAttributes() ?>>
		<?php echo $t_driver_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_remarks"><?php echo $t_driver_info->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->remarks->cellAttributes() ?>>
			<span id="el_t_driver_info_remarks">
<input type="text" data-table="t_driver_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_driver_info->remarks->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->remarks->EditValue ?>"<?php echo $t_driver_info->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_driver_info->r_text->Visible) { // r_text ?>
	<div id="r_r_text" class="form-group row">
		<label for="x_r_text" class="<?php echo $t_driver_info_search->LeftColumnClass ?>"><span id="elh_t_driver_info_r_text"><?php echo $t_driver_info->r_text->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_r_text" id="z_r_text" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_driver_info_search->RightColumnClass ?>"><div<?php echo $t_driver_info->r_text->cellAttributes() ?>>
			<span id="el_t_driver_info_r_text">
<input type="text" data-table="t_driver_info" data-field="x_r_text" name="x_r_text" id="x_r_text" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_driver_info->r_text->getPlaceHolder()) ?>" value="<?php echo $t_driver_info->r_text->EditValue ?>"<?php echo $t_driver_info->r_text->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_driver_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_driver_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_driver_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_driver_info_search->terminate();
?>