<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_driver_info_view = new t_driver_info_view();

// Run the page
$t_driver_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_driver_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_driver_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_driver_infoview = currentForm = new ew.Form("ft_driver_infoview", "view");

// Form_CustomValidate event
ft_driver_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_driver_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_driver_infoview.lists["x_employee_id"] = <?php echo $t_driver_info_view->employee_id->Lookup->toClientList() ?>;
ft_driver_infoview.lists["x_employee_id"].options = <?php echo JsonEncode($t_driver_info_view->employee_id->lookupOptions()) ?>;
ft_driver_infoview.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_driver_infoview.lists["x_status"] = <?php echo $t_driver_info_view->status->Lookup->toClientList() ?>;
ft_driver_infoview.lists["x_status"].options = <?php echo JsonEncode($t_driver_info_view->status->options(FALSE, TRUE)) ?>;
ft_driver_infoview.lists["x_operator"] = <?php echo $t_driver_info_view->operator->Lookup->toClientList() ?>;
ft_driver_infoview.lists["x_operator"].options = <?php echo JsonEncode($t_driver_info_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_driver_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_driver_info_view->ExportOptions->render("body") ?>
<?php $t_driver_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_driver_info_view->showPageHeader(); ?>
<?php
$t_driver_info_view->showMessage();
?>
<form name="ft_driver_infoview" id="ft_driver_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_driver_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_driver_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_driver_info">
<input type="hidden" name="modal" value="<?php echo (int)$t_driver_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_driver_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_id"><?php echo $t_driver_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_driver_info->id->cellAttributes() ?>>
<span id="el_t_driver_info_id">
<span<?php echo $t_driver_info->id->viewAttributes() ?>>
<?php echo $t_driver_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_employee_id"><?php echo $t_driver_info->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $t_driver_info->employee_id->cellAttributes() ?>>
<span id="el_t_driver_info_employee_id">
<span<?php echo $t_driver_info->employee_id->viewAttributes() ?>>
<?php echo $t_driver_info->employee_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_name"><?php echo $t_driver_info->name->caption() ?></span></td>
		<td data-name="name"<?php echo $t_driver_info->name->cellAttributes() ?>>
<span id="el_t_driver_info_name">
<span<?php echo $t_driver_info->name->viewAttributes() ?>>
<?php echo $t_driver_info->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->licence_no->Visible) { // licence_no ?>
	<tr id="r_licence_no">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_licence_no"><?php echo $t_driver_info->licence_no->caption() ?></span></td>
		<td data-name="licence_no"<?php echo $t_driver_info->licence_no->cellAttributes() ?>>
<span id="el_t_driver_info_licence_no">
<span<?php echo $t_driver_info->licence_no->viewAttributes() ?>>
<?php echo $t_driver_info->licence_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->licence_expiry->Visible) { // licence_expiry ?>
	<tr id="r_licence_expiry">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_licence_expiry"><?php echo $t_driver_info->licence_expiry->caption() ?></span></td>
		<td data-name="licence_expiry"<?php echo $t_driver_info->licence_expiry->cellAttributes() ?>>
<span id="el_t_driver_info_licence_expiry">
<span<?php echo $t_driver_info->licence_expiry->viewAttributes() ?>>
<?php echo $t_driver_info->licence_expiry->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_mobile"><?php echo $t_driver_info->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $t_driver_info->mobile->cellAttributes() ?>>
<span id="el_t_driver_info_mobile">
<span<?php echo $t_driver_info->mobile->viewAttributes() ?>>
<?php echo $t_driver_info->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_status"><?php echo $t_driver_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $t_driver_info->status->cellAttributes() ?>>
<span id="el_t_driver_info_status">
<span<?php echo $t_driver_info->status->viewAttributes() ?>>
<?php echo $t_driver_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_remarks"><?php echo $t_driver_info->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_driver_info->remarks->cellAttributes() ?>>
<span id="el_t_driver_info_remarks">
<span<?php echo $t_driver_info->remarks->viewAttributes() ?>>
<?php echo $t_driver_info->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_operator"><?php echo $t_driver_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_driver_info->operator->cellAttributes() ?>>
<span id="el_t_driver_info_operator">
<span<?php echo $t_driver_info->operator->viewAttributes() ?>>
<?php echo $t_driver_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_datetime"><?php echo $t_driver_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_driver_info->datetime->cellAttributes() ?>>
<span id="el_t_driver_info_datetime">
<span<?php echo $t_driver_info->datetime->viewAttributes() ?>>
<?php echo $t_driver_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_driver_info->r_text->Visible) { // r_text ?>
	<tr id="r_r_text">
		<td class="<?php echo $t_driver_info_view->TableLeftColumnClass ?>"><span id="elh_t_driver_info_r_text"><?php echo $t_driver_info->r_text->caption() ?></span></td>
		<td data-name="r_text"<?php echo $t_driver_info->r_text->cellAttributes() ?>>
<span id="el_t_driver_info_r_text">
<span<?php echo $t_driver_info->r_text->viewAttributes() ?>>
<?php echo $t_driver_info->r_text->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_driver_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_driver_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_driver_info_view->terminate();
?>