<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_expenses_d_edit = new t_expenses_d_edit();

// Run the page
$t_expenses_d_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_expenses_d_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_expenses_dedit = currentForm = new ew.Form("ft_expenses_dedit", "edit");

// Validate form
ft_expenses_dedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_expenses_d_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->id->caption(), $t_expenses_d->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->trip->Required) { ?>
			elm = this.getElements("x" + infix + "_trip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->trip->caption(), $t_expenses_d->trip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->r_from->caption(), $t_expenses_d->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses_d->r_from->errorMessage()) ?>");
		<?php if ($t_expenses_d_edit->expense_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->expense_type->caption(), $t_expenses_d->expense_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->expense_sub_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_sub_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->expense_sub_type->caption(), $t_expenses_d->expense_sub_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->amount->caption(), $t_expenses_d->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_expenses_d->amount->errorMessage()) ?>");
		<?php if ($t_expenses_d_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->remarks->caption(), $t_expenses_d->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->uploads->caption(), $t_expenses_d->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->operator->caption(), $t_expenses_d->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_expenses_d_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_expenses_d->datetime->caption(), $t_expenses_d->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_expenses_dedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_expenses_dedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_expenses_dedit.lists["x_trip"] = <?php echo $t_expenses_d_edit->trip->Lookup->toClientList() ?>;
ft_expenses_dedit.lists["x_trip"].options = <?php echo JsonEncode($t_expenses_d_edit->trip->lookupOptions()) ?>;
ft_expenses_dedit.lists["x_expense_type"] = <?php echo $t_expenses_d_edit->expense_type->Lookup->toClientList() ?>;
ft_expenses_dedit.lists["x_expense_type"].options = <?php echo JsonEncode($t_expenses_d_edit->expense_type->lookupOptions()) ?>;
ft_expenses_dedit.lists["x_expense_sub_type"] = <?php echo $t_expenses_d_edit->expense_sub_type->Lookup->toClientList() ?>;
ft_expenses_dedit.lists["x_expense_sub_type"].options = <?php echo JsonEncode($t_expenses_d_edit->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_expenses_d_edit->showPageHeader(); ?>
<?php
$t_expenses_d_edit->showMessage();
?>
<form name="ft_expenses_dedit" id="ft_expenses_dedit" class="<?php echo $t_expenses_d_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_expenses_d_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_expenses_d_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_expenses_d">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_expenses_d_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_expenses_d->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_expenses_d_id" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->id->caption() ?><?php echo ($t_expenses_d->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->id->cellAttributes() ?>>
<span id="el_t_expenses_d_id">
<span<?php echo $t_expenses_d->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses_d->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses_d" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_expenses_d->id->CurrentValue) ?>">
<?php echo $t_expenses_d->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->trip->Visible) { // trip ?>
	<div id="r_trip" class="form-group row">
		<label id="elh_t_expenses_d_trip" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->trip->caption() ?><?php echo ($t_expenses_d->trip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->trip->cellAttributes() ?>>
<span id="el_t_expenses_d_trip">
<span<?php echo $t_expenses_d->trip->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_expenses_d->trip->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_expenses_d" data-field="x_trip" name="x_trip" id="x_trip" value="<?php echo HtmlEncode($t_expenses_d->trip->CurrentValue) ?>">
<?php echo $t_expenses_d->trip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_t_expenses_d_r_from" for="x_r_from" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->r_from->caption() ?><?php echo ($t_expenses_d->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->r_from->cellAttributes() ?>>
<span id="el_t_expenses_d_r_from">
<input type="text" data-table="t_expenses_d" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" placeholder="<?php echo HtmlEncode($t_expenses_d->r_from->getPlaceHolder()) ?>" value="<?php echo $t_expenses_d->r_from->EditValue ?>"<?php echo $t_expenses_d->r_from->editAttributes() ?>>
</span>
<?php echo $t_expenses_d->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label id="elh_t_expenses_d_expense_type" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->expense_type->caption() ?><?php echo ($t_expenses_d->expense_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->expense_type->cellAttributes() ?>>
<span id="el_t_expenses_d_expense_type">
<?php $t_expenses_d->expense_type->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$t_expenses_d->expense_type->EditAttrs["onclick"]; ?>
<div id="tp_x_expense_type" class="ew-template"><input type="radio" class="form-check-input" data-table="t_expenses_d" data-field="x_expense_type" data-value-separator="<?php echo $t_expenses_d->expense_type->displayValueSeparatorAttribute() ?>" name="x_expense_type" id="x_expense_type" value="{value}"<?php echo $t_expenses_d->expense_type->editAttributes() ?>></div>
<div id="dsl_x_expense_type" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $t_expenses_d->expense_type->radioButtonListHtml(FALSE, "x_expense_type") ?>
</div></div>
<?php echo $t_expenses_d->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
<?php echo $t_expenses_d->expense_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label id="elh_t_expenses_d_expense_sub_type" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->expense_sub_type->caption() ?><?php echo ($t_expenses_d->expense_sub_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->expense_sub_type->cellAttributes() ?>>
<span id="el_t_expenses_d_expense_sub_type">
<div id="tp_x_expense_sub_type" class="ew-template"><input type="radio" class="form-check-input" data-table="t_expenses_d" data-field="x_expense_sub_type" data-value-separator="<?php echo $t_expenses_d->expense_sub_type->displayValueSeparatorAttribute() ?>" name="x_expense_sub_type" id="x_expense_sub_type" value="{value}"<?php echo $t_expenses_d->expense_sub_type->editAttributes() ?>></div>
<div id="dsl_x_expense_sub_type" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $t_expenses_d->expense_sub_type->radioButtonListHtml(FALSE, "x_expense_sub_type") ?>
</div></div>
<?php echo $t_expenses_d->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
<?php echo $t_expenses_d->expense_sub_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_expenses_d_amount" for="x_amount" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->amount->caption() ?><?php echo ($t_expenses_d->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->amount->cellAttributes() ?>>
<span id="el_t_expenses_d_amount">
<input type="text" data-table="t_expenses_d" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_expenses_d->amount->getPlaceHolder()) ?>" value="<?php echo $t_expenses_d->amount->EditValue ?>"<?php echo $t_expenses_d->amount->editAttributes() ?>>
</span>
<?php echo $t_expenses_d->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_expenses_d_remarks" for="x_remarks" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->remarks->caption() ?><?php echo ($t_expenses_d->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->remarks->cellAttributes() ?>>
<span id="el_t_expenses_d_remarks">
<input type="text" data-table="t_expenses_d" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_expenses_d->remarks->getPlaceHolder()) ?>" value="<?php echo $t_expenses_d->remarks->EditValue ?>"<?php echo $t_expenses_d->remarks->editAttributes() ?>>
</span>
<?php echo $t_expenses_d->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_expenses_d->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_expenses_d_uploads" class="<?php echo $t_expenses_d_edit->LeftColumnClass ?>"><?php echo $t_expenses_d->uploads->caption() ?><?php echo ($t_expenses_d->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_expenses_d_edit->RightColumnClass ?>"><div<?php echo $t_expenses_d->uploads->cellAttributes() ?>>
<span id="el_t_expenses_d_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_expenses_d->uploads->title() ? $t_expenses_d->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_expenses_d->uploads->ReadOnly || $t_expenses_d->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_expenses_d" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $t_expenses_d->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_expenses_d->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_expenses_d->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_expenses_d->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_expenses_d->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_expenses_d_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_expenses_d_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_expenses_d_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_expenses_d_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_expenses_d_edit->terminate();
?>